/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.ILocationGroup;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationGroupCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationGroupFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationGroupInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractLocationGroupMoveTreeUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class LocationGroupMoveTreeUI
extends AbstractLocationGroupMoveTreeUI {
    private static final Logger logger = CoreUIObject.getLogger(LocationGroupMoveTreeUI.class);

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiWindow.close();
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.kDTree1.getLastSelectedPathComponent();
        LocationGroupInfo selectNodeInfo = (LocationGroupInfo)node.getUserObject();
        LocationGroupInfo beforeNodeInfo = (LocationGroupInfo)this.getUIContext().get("ParentNode");
        if (!selectNodeInfo.getNumber().toString().equals("location")) {
            WarehouseInfo ware = WarehouseFactory.getRemoteInstance().getWarehouseInfo((IObjectPK)new ObjectUuidPK(selectNodeInfo.getWarehouse().getId().toString()));
            if (selectNodeInfo.getWarehouse().getId().toString().equals(beforeNodeInfo.getWarehouse().getId().toString())) {
                if (!beforeNodeInfo.getId().toString().equals(selectNodeInfo.getId().toString())) {
                    if (beforeNodeInfo.getWarehouse().getId().toString().equals(ware.getId().toString()) && beforeNodeInfo.getLevel() < selectNodeInfo.getLevel()) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.locationGroup_Not_Move_To_Child"));
                        SysUtil.abort();
                    } else {
                        beforeNodeInfo.setParent(selectNodeInfo);
                        beforeNodeInfo.setWarehouse(ware);
                        LocationCollection coll = this.getLocationByGroup(beforeNodeInfo);
                        ILocation iLocation = LocationFactory.getRemoteInstance();
                        for (int i = 0; i < coll.size(); ++i) {
                            LocationInfo lo = coll.get(i);
                            lo.setWarehouse(ware);
                            SelectorItemCollection selector = new SelectorItemCollection();
                            selector.add(new SelectorItemInfo("warehouse"));
                            iLocation.updatePartial((CoreBaseInfo)lo, selector);
                        }
                        LocationGroupCollection groupColl = this.getLocationGroupChildrenByGroup(beforeNodeInfo);
                        ILocationGroup iLocationGroup = LocationGroupFactory.getRemoteInstance();
                        for (int i = 0; i < groupColl.size(); ++i) {
                            LocationGroupInfo lo = groupColl.get(i);
                            lo.setWarehouse(ware);
                            SelectorItemCollection selector = new SelectorItemCollection();
                            selector.add(new SelectorItemInfo("warehouse"));
                            iLocationGroup.updatePartial(lo, selector);
                        }
                        LocationGroupFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(beforeNodeInfo.getId().toString()), beforeNodeInfo);
                        this.uiWindow.close();
                    }
                }
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.locationGroup_Not_Move"));
                SysUtil.abort();
            }
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.WarehouseHasNotLocationGroupManagerAndLock"));
            SysUtil.abort();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kDTreeView1.setShowControlPanel(false);
        this.btnSubmit.setEnabled(true);
        this.buildWarehouseTree();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void buildWarehouseTree() throws Exception {
        try {
            String name = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.Warehouse");
            LocationGroupInfo location = new LocationGroupInfo();
            location.setNumber("location");
            KDTreeNode rootNode = new KDTreeNode((Object)name);
            rootNode.setUserObject((Object)location);
            ((DefaultTreeModel)this.kDTree1.getModel()).setRoot((TreeNode)rootNode);
            this.kDTree1.setSelectionNode((DefaultKingdeeTreeNode)rootNode);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parent.id", null));
            filter.getFilterItems().add(new FilterItemInfo("warehouse.whState", (Object)new Integer(1), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1), CompareType.EQUALS));
            view.getSorter().add(new SorterItemInfo("warehouse.number"));
            view.setFilter(filter);
            LocationGroupCollection colls = LocationGroupFactory.getRemoteInstance().getLocationGroupCollection(view);
            for (int i = 0; i < colls.size(); ++i) {
                LocationGroupInfo lo = colls.get(i);
                KDTreeNode treeNode = new KDTreeNode((Object)lo);
                rootNode.add((MutableTreeNode)treeNode);
                this.getTreeNodeByDefaultNode(lo, (DefaultKingdeeTreeNode)treeNode);
                lo = null;
                treeNode = null;
            }
            this.kDTree1.setSelectionNode((DefaultKingdeeTreeNode)rootNode);
            this.kDTree1.setShowsRootHandles(true);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    private DefaultKingdeeTreeNode getTreeNodeByDefaultNode(LocationGroupInfo locationGroupInfo, DefaultKingdeeTreeNode tree) throws BOSException {
        if (tree == null) {
            return null;
        }
        LocationGroupCollection coll = this.getChildren(locationGroupInfo);
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                LocationGroupInfo lo = coll.get(i);
                DefaultKingdeeTreeNode treeNode = new DefaultKingdeeTreeNode((Object)lo);
                tree.add((MutableTreeNode)treeNode);
                tree = this.getTreeNodeByDefaultNode(lo, treeNode);
            }
        }
        coll = null;
        return (DefaultKingdeeTreeNode)tree.getParent();
    }

    private LocationGroupCollection getChildren(LocationGroupInfo lo) throws BOSException {
        if (lo == null) {
            return null;
        }
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)lo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("warehouse.hasLocationLevel", (Object)new Integer(1)));
        envi.setFilter(filter);
        LocationGroupCollection coll = LocationGroupFactory.getRemoteInstance().getLocationGroupCollection(envi);
        return coll;
    }

    private LocationCollection getLocationByGroup(LocationGroupInfo lo) {
        if (lo == null) {
            return null;
        }
        LocationCollection coll = null;
        try {
            coll = LocationFactory.getRemoteInstance().getLocationCollection("where locationGroup.longnumber like '" + lo.getLongNumber() + "!%' and locationGroup.longnumber='" + lo.getLongNumber() + "'");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return coll;
    }

    private LocationGroupCollection getLocationGroupChildrenByGroup(LocationGroupInfo lo) {
        if (lo == null) {
            return null;
        }
        LocationGroupCollection coll = null;
        try {
            coll = LocationGroupFactory.getRemoteInstance().getLocationGroupCollection("where longnumber like '" + lo.getLongNumber() + "!%'");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return coll;
    }
}

