/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.scm.im.inv.FillSignDirectionEnum;
import com.kingdee.eas.basedata.scm.im.inv.ILotRule;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleEntryCollection;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleInfo;
import com.kingdee.eas.basedata.scm.im.inv.SectTypeEnum;
import com.kingdee.eas.basedata.scm.im.inv.ValueAttributeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;

public class LotRuleClientUtils {
    public static final Color GRAY = new Color(217, 217, 208);

    public static final String getResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.LotRuleResource", (String)resKey);
    }

    public static final void setCellsEnable(KDTable kdTable, int rowIndex, String[] columnNames, boolean enabled) {
        if (rowIndex < -1 || columnNames == null || columnNames.length == 0) {
            return;
        }
        if (rowIndex == -1) {
            for (int i = 0; i < kdTable.getRowCount(); ++i) {
                for (int j = 0; j < columnNames.length; ++j) {
                    ICell cell = kdTable.getCell(i, columnNames[j]);
                    cell.getStyleAttributes().setLocked(!enabled);
                    if (enabled) continue;
                    cell.getStyleAttributes().setBackground(GRAY);
                }
            }
            return;
        }
        for (int i = 0; i < columnNames.length; ++i) {
            ICell cell = kdTable.getCell(rowIndex, columnNames[i]);
            cell.getStyleAttributes().setLocked(!enabled);
            if (enabled) continue;
            cell.getStyleAttributes().setBackground(GRAY);
        }
    }

    public static final void setCellsNull(KDTable table, int rowIndex, String[] columnNames) {
        if (rowIndex < -1 || columnNames == null || columnNames.length == 0) {
            return;
        }
        if (rowIndex == -1) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                for (int j = 0; j < columnNames.length; ++j) {
                    ICell cell = table.getCell(i, columnNames[j]);
                    cell.setValue(null);
                }
            }
            return;
        }
        for (int i = 0; i < columnNames.length; ++i) {
            ICell cell = table.getCell(rowIndex, columnNames[i]);
            cell.setValue(null);
        }
    }

    public static final void setCellsColor(KDTable table, int rowIndex, String[] columnNames, Color color) {
        if (rowIndex < -1 || columnNames == null || columnNames.length == 0 || color == null) {
            return;
        }
        if (rowIndex == -1) {
            for (int i = 0; i < table.getRowCount(); ++i) {
                for (int j = 0; j < columnNames.length; ++j) {
                    ICell cell = table.getCell(i, columnNames[j]);
                    cell.getStyleAttributes().setBackground(color);
                }
            }
            return;
        }
        for (int i = 0; i < columnNames.length; ++i) {
            ICell cell = table.getCell(rowIndex, columnNames[i]);
            cell.getStyleAttributes().setBackground(color);
        }
    }

    public static final KDFormattedTextField getFormatTxtFieldInteger(boolean canMinus) {
        KDFormattedTextField txtField = new KDFormattedTextField(0);
        txtField.setNegatived(canMinus);
        txtField.setHorizontalAlignment(4);
        return txtField;
    }

    public static final String fillSign(String str, int totalLength, Object fillSign, FillSignDirectionEnum direction) {
        if (str == null) {
            str = "";
        }
        if (str.length() >= totalLength || fillSign == null || fillSign.toString().trim().length() == 0) {
            return str;
        }
        StringBuffer sbStr = new StringBuffer();
        StringBuffer sbFill = new StringBuffer();
        sbStr.append(str);
        for (int i = 0; i < totalLength - str.length(); ++i) {
            sbFill.append(fillSign);
        }
        if (direction.equals((Object)FillSignDirectionEnum.FORWARD)) {
            return sbFill.append(sbStr).toString();
        }
        return sbStr.append(sbFill).toString();
    }

    public static final int getRowIndexOfLineData(KDTable table, IObjectValue lineData) {
        if (table == null || lineData == null) {
            return -1;
        }
        int rowIndex = -1;
        for (int i = 0; i < table.getRowCount(); ++i) {
            IObjectValue rowData = (IObjectValue)table.getRow(i).getUserObject();
            if (!rowData.equals(lineData)) continue;
            rowIndex = i;
            break;
        }
        return rowIndex;
    }

    public static boolean checkNumberIsDup(LotRuleInfo editData) throws BOSException, EASBizException {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)editData.getNumber(), CompareType.EQUALS));
        if (editData.getId() != null) {
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)editData.getId().toString(), CompareType.NOTEQUALS));
        }
        ILotRule iLotRule = LotRuleFactory.getRemoteInstance();
        return iLotRule.exists(fi);
    }

    public static boolean containsBillNumber(LotRuleInfo rule) {
        if (rule == null) {
            return false;
        }
        LotRuleEntryCollection entrys = rule.getEntry();
        for (int i = 0; i < entrys.size(); ++i) {
            if (!entrys.get(i).getSectType().equals((Object)SectTypeEnum.ATTRIBUTE) || !entrys.get(i).getValueAttribute().equals((Object)ValueAttributeEnum.BILL_NUMBER)) continue;
            return true;
        }
        return false;
    }
}

