/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewStorageF7;
import com.kingdee.eas.basedata.scm.im.inv.FillSignDirectionEnum;
import com.kingdee.eas.basedata.scm.im.inv.ILotRule;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleEntryInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleInfo;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleStatusEnum;
import com.kingdee.eas.basedata.scm.im.inv.SectTypeEnum;
import com.kingdee.eas.basedata.scm.im.inv.ValueAttributeEnum;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractLotRuleEditUI;
import com.kingdee.eas.basedata.scm.im.inv.client.LotRuleClientUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import com.kingdee.eas.scm.util.uicontrol.SCMClientUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class LotRuleEditUI
extends AbstractLotRuleEditUI {
    private static final long serialVersionUID = -2158006908799181283L;
    static final String TB_SECTNUMBER = "sectNumber";
    static final String TB_SECTTYPE = "sectType";
    static final String TB_VALUEATTRIBUTE = "valueAttribute";
    static final String TB_FORMAT = "format";
    static final String TB_FORMAT_DISPLAY = "format_display";
    static final String TB_CONSTVALUE = "constValue";
    static final String TB_LENGTH = "length";
    static final String TB_INITIAL = "initial";
    static final String TB_STEP = "step";
    static final String TB_FILLSIGN = "fillSign";
    static final String TB_FILLSIGNDIRECTION = "fillSignDirection";
    static final String TB_NEEDSPLIT = "needSplit";
    static final String TB_ISCLASSIFY = "isClassify";
    static final String DEFAULT_SPLITSIGN = "_";
    static final SectTypeEnum DEFAULT_SECTTYPE = SectTypeEnum.CONST;
    static final int DEFAULT_FORMAT = 2;
    static final int DEFAULT_LENGTH = 8;
    static final int DEFAULT_INITIAL = 1;
    static final int DEFAULT_STEP = 1;
    private LotRuleListener listener = new LotRuleListener();
    private String[] timeFormat;
    static final Color NEEDED_COLOR = SCMConstant.NECESSARYCOLOR;
    private static String MAX_LEN = "50";

    public String getUITitle() {
        return LotRuleClientUtils.getResource("LOT_RULE");
    }

    @Override
    protected IObjectValue createNewData() {
        LotRuleInfo rule = new LotRuleInfo();
        rule.setSplitSign(DEFAULT_SPLITSIGN);
        rule.setIsModifiable(true);
        rule.setEnabled(LotRuleStatusEnum.SAVE);
        if (this.getUIContext().get("businessObjectID") != null) {
            rule.setBusinessObjectID(this.getUIContext().get("businessObjectID").toString());
        }
        if (this.getUIContext().get("isMaterial") != null && this.getUIContext().get("isMaterial").toString().equals("true")) {
            rule.setRuleType(1);
        } else {
            rule.setRuleType(2);
        }
        LotRuleEntryInfo entry = (LotRuleEntryInfo)this.createNewDetailData(this.kdtEntry);
        rule.getEntry().add(entry);
        return rule;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LotRuleFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public void onLoad() throws Exception {
        ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getRemoteInstance();
        this.timeFormat = iSCMBillCommonFacade.getServerTimeFormat();
        super.onLoad();
        this.initEditor();
        this.btnAttachment.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAttachment.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.actionAddLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_addline"));
        this.ctnMain.add((Action)this.actionAddLine);
        this.actionInsertLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_insert"));
        this.actionInsertLine.putValue("Name", (Object)"");
        this.ctnMain.add((Action)this.actionInsertLine);
        this.actionRemoveLine.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.ctnMain.add((Action)this.actionRemoveLine);
    }

    private void initControlHead() {
        if (this.editData.getEnabled().equals((Object)LotRuleStatusEnum.ENABLED)) {
            this.actionEnable.setEnabled(false);
            this.actionDisable.setEnabled(true);
            this.actionEdit.setEnabled(false);
        } else {
            this.actionEnable.setEnabled(true);
            this.actionDisable.setEnabled(false);
            this.actionEdit.setEnabled(true);
        }
        if (this.getOprtState().equalsIgnoreCase("ADDNEW") || this.getOprtState().equalsIgnoreCase("EDIT")) {
            this.actionEnable.setEnabled(false);
            this.actionDisable.setEnabled(false);
            this.actionEdit.setEnabled(false);
        }
    }

    private void initControlEntry() {
        for (int i = 0; i < this.kdtEntry.getRowCount(); ++i) {
            SectTypeEnum sectType = (SectTypeEnum)((Object)this.kdtEntry.getCell(i, TB_SECTTYPE).getValue());
            this.initEntryStatusBySectType(i, sectType);
            ValueAttributeEnum valueAttribute = (ValueAttributeEnum)((Object)this.kdtEntry.getCell(i, TB_VALUEATTRIBUTE).getValue());
            if (!sectType.equals((Object)SectTypeEnum.SYSTIME) && !valueAttribute.equals((Object)ValueAttributeEnum.BIZDATE) && !valueAttribute.equals((Object)ValueAttributeEnum.MFG) && !valueAttribute.equals((Object)ValueAttributeEnum.EXP)) continue;
            int format = (Integer)this.kdtEntry.getCell(i, TB_FORMAT).getValue();
            this.kdtEntry.getCell(i, TB_FORMAT_DISPLAY).setValue((Object)this.timeFormat[format]);
            this.kdtEntry.getCell(i, TB_FORMAT_DISPLAY).getStyleAttributes().setLocked(false);
            this.kdtEntry.getCell(i, TB_FORMAT_DISPLAY).getStyleAttributes().setBackground(NEEDED_COLOR);
        }
        if (this.getOprtState().equalsIgnoreCase("ADDNEW")) {
            this.initCellNullBySectType(0, DEFAULT_SECTTYPE);
            this.initEntryDataBySectType(0, DEFAULT_SECTTYPE);
        }
    }

    private void initEditor() {
        NewStorageF7 souF7 = new NewStorageF7((IUIObject)this);
        if (this.getOprtState().equalsIgnoreCase("ADDNEW")) {
            souF7.setPermissionItem("lotRule_addNew");
        } else if (this.getOprtState().equalsIgnoreCase("EDIT")) {
            souF7.setPermissionItem("lotRule_update");
        }
        this.prmtSou.setSelector((KDPromptSelector)souF7);
        try {
            if (this.getUIContext().get("businessObjectID") != null) {
                String materialId = this.getUIContext().get("businessObjectID").toString();
                String sql = "select id, orgUnit.id where material.id = '" + materialId + "' and isLotNumber = 1";
                MaterialInventoryCollection coll = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(sql);
                HashSet<String> souSet = new HashSet<String>();
                if (coll != null && coll.size() > 0) {
                    int count = coll.size();
                    for (int i = 0; i < count; ++i) {
                        souSet.add(coll.get(i).getOrgUnit().getId().toString());
                    }
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("unit.id", souSet, CompareType.INCLUDE));
                    souF7.setOuterFilterInfo(filter);
                }
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        KDComboBox cbxSectType = new KDComboBox();
        cbxSectType.addItems(SectTypeEnum.getEnumList().toArray());
        cbxSectType.removeItem((Object)SectTypeEnum.NULL);
        this.kdtEntry.getColumn(TB_SECTTYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbxSectType));
        KDComboBox cbxValueAttribute = new KDComboBox();
        cbxValueAttribute.addItems(ValueAttributeEnum.getEnumList().toArray());
        cbxValueAttribute.removeItem((Object)ValueAttributeEnum.NULL);
        this.kdtEntry.getColumn(TB_VALUEATTRIBUTE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbxValueAttribute));
        KDComboBox cbxFormatDisplay = new KDComboBox();
        cbxFormatDisplay.addItems((Object[])this.timeFormat);
        this.kdtEntry.getColumn(TB_FORMAT_DISPLAY).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbxFormatDisplay));
        KDFormattedTextField lenghtEditor = LotRuleClientUtils.getFormatTxtFieldInteger(false);
        lenghtEditor.setMaximumValue((Comparable)new Integer(MAX_LEN));
        this.kdtEntry.getColumn(TB_LENGTH).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)lenghtEditor));
        this.kdtEntry.getColumn(TB_LENGTH).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn(TB_INITIAL).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)LotRuleClientUtils.getFormatTxtFieldInteger(false)));
        this.kdtEntry.getColumn(TB_INITIAL).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntry.getColumn(TB_STEP).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)lenghtEditor));
        this.kdtEntry.getColumn(TB_STEP).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        KDTextField txtFillSign = new KDTextField();
        txtFillSign.setMaxLength(1);
        this.kdtEntry.getColumn(TB_FILLSIGN).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtFillSign));
        KDComboBox cbxFillSignDirection = new KDComboBox();
        cbxFillSignDirection.addItems(FillSignDirectionEnum.getEnumList().toArray());
        cbxFillSignDirection.removeItem((Object)FillSignDirectionEnum.NULL);
        this.kdtEntry.getColumn(TB_FILLSIGNDIRECTION).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbxFillSignDirection));
        KDCheckBox chkIsClassify = new KDCheckBox();
        this.kdtEntry.getColumn(TB_ISCLASSIFY).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)chkIsClassify));
        KDCheckBox chkNeedSplit = new KDCheckBox();
        this.kdtEntry.getColumn(TB_NEEDSPLIT).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)chkNeedSplit));
    }

    private void addListners() {
        this.comboBoxSplitSign.addItemListener((ItemListener)this.listener);
        this.kdtEntry.addKDTEditListener((KDTEditListener)this.listener);
    }

    private void removeListeners() {
        this.comboBoxSplitSign.removeItemListener((ItemListener)this.listener);
        this.kdtEntry.removeKDTEditListener((KDTEditListener)this.listener);
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        LotRuleEntryInfo entry = new LotRuleEntryInfo();
        entry.setSectNumber(this.kdtEntry.getRowCount() + 1);
        entry.setSectType(DEFAULT_SECTTYPE);
        entry.setValueAttribute(ValueAttributeEnum.NULL);
        entry.setFormat(2);
        entry.setFillSignDirection(FillSignDirectionEnum.NULL);
        entry.setNeedSplit(true);
        entry.setIsClassify(false);
        return entry;
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntry;
    }

    private void resetSectNumber(KDTable table) {
        int rowCount = table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            table.getCell(i, TB_SECTNUMBER).setValue((Object)new Integer(i + 1));
        }
    }

    @Override
    public void loadFields() {
        this.removeListeners();
        super.loadFields();
        this.initControlHead();
        this.initControlEntry();
        this.addListners();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        int entryCount;
        StorageOrgUnitInfo sou;
        String number = this.txtNumber.getText().trim();
        if (number == null || number.length() == 0) {
            MsgBox.showInfo((String)LotRuleClientUtils.getResource("VERIFY_NUMBER_CANT_NULL"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        } else {
            this.editData.setNumber(number);
            if (LotRuleClientUtils.checkNumberIsDup(this.editData)) {
                MsgBox.showInfo((String)LotRuleClientUtils.getResource("VERIFY_NUMBER_EXSITS"));
                this.txtNumber.requestFocus();
                SysUtil.abort();
            }
        }
        String name = this.txtName.getText();
        if (name == null || name.length() == 0) {
            MsgBox.showInfo((String)LotRuleClientUtils.getResource("VERIFY_NAME_CANT_NULL"));
            this.txtName.requestFocus();
            SysUtil.abort();
        }
        if ((sou = (StorageOrgUnitInfo)this.prmtSou.getValue()) == null || sou.getId() == null) {
            MsgBox.showInfo((String)LotRuleClientUtils.getResource("VERIFY_STORAGE_CANT_NULL"));
            this.prmtSou.requestFocus();
            SysUtil.abort();
        }
        if ((entryCount = this.kdtEntry.getRowCount()) == 0) {
            MsgBox.showInfo((String)LotRuleClientUtils.getResource("VERIFY_ENTRY_CANT_NULL"));
            this.addLine(this.kdtEntry);
            SysUtil.abort();
        }
        int billNumberCount = 0;
        int serialCount = 0;
        for (int i = 0; i < entryCount; ++i) {
            Integer step;
            Integer initial;
            Integer length;
            IRow row = this.kdtEntry.getRow(i);
            SectTypeEnum sectType = (SectTypeEnum)((Object)row.getCell(TB_SECTTYPE).getValue());
            if (sectType.equals((Object)SectTypeEnum.SYSTIME)) {
                Object format = row.getCell(TB_FORMAT).getValue();
                if (format != null) continue;
                MsgBox.showInfo((String)LotRuleClientUtils.getResource(""));
                this.kdtEntry.getEditManager().editCellAt(i, this.kdtEntry.getColumnIndex(TB_FORMAT_DISPLAY));
                SysUtil.abort();
                continue;
            }
            if (sectType.equals((Object)SectTypeEnum.CONST)) {
                Object constValue = row.getCell(TB_CONSTVALUE).getValue();
                if (constValue != null && constValue.toString().trim().length() != 0) continue;
                MsgBox.showInfo((String)LotRuleClientUtils.getResource("VERIFY_CONSTVALUE_CANT_NULL"));
                this.kdtEntry.getEditManager().editCellAt(i, this.kdtEntry.getColumnIndex(TB_CONSTVALUE));
                SysUtil.abort();
                continue;
            }
            if (sectType.equals((Object)SectTypeEnum.ATTRIBUTE)) {
                Integer length2;
                ValueAttributeEnum valueAttribute = (ValueAttributeEnum)((Object)row.getCell(TB_VALUEATTRIBUTE).getValue());
                if (valueAttribute == null) {
                    MsgBox.showInfo((String)LotRuleClientUtils.getResource("VERIFY_FORMAT_CANT_NULL"));
                    this.kdtEntry.getEditManager().editCellAt(i, this.kdtEntry.getColumnIndex(TB_VALUEATTRIBUTE));
                    SysUtil.abort();
                }
                if (valueAttribute.equals((Object)ValueAttributeEnum.BILL_NUMBER)) {
                    ++billNumberCount;
                }
                if (valueAttribute.equals((Object)ValueAttributeEnum.BIZDATE) || valueAttribute.equals((Object)ValueAttributeEnum.MFG) || valueAttribute.equals((Object)ValueAttributeEnum.EXP) || (length2 = (Integer)row.getCell(TB_LENGTH).getValue()) != null && length2 > 0) continue;
                MsgBox.showInfo((String)LotRuleClientUtils.getResource("VERIFY_LENGTH_POSITIVE"));
                this.kdtEntry.getEditManager().editCellAt(i, this.kdtEntry.getColumnIndex(TB_LENGTH));
                SysUtil.abort();
                continue;
            }
            if (!sectType.equals((Object)SectTypeEnum.SERIAL)) continue;
            if (++serialCount > 1) {
                MsgBox.showInfo((String)LotRuleClientUtils.getResource("VERIFY_SERIAL_SO_MUCH"));
                this.kdtEntry.getEditManager().editCellAt(i, this.kdtEntry.getColumnIndex(TB_SECTTYPE));
                SysUtil.abort();
            }
            if ((length = (Integer)row.getCell(TB_LENGTH).getValue()) == null || length <= 0) {
                MsgBox.showInfo((String)LotRuleClientUtils.getResource("VERIFY_LENGTH_POSITIVE"));
                this.kdtEntry.getEditManager().editCellAt(i, this.kdtEntry.getColumnIndex(TB_LENGTH));
                SysUtil.abort();
            }
            if ((initial = (Integer)row.getCell(TB_INITIAL).getValue()) == null || initial <= 0) {
                MsgBox.showInfo((String)LotRuleClientUtils.getResource("VERIFY_INITIAL_POSITIVE"));
                this.kdtEntry.getEditManager().editCellAt(i, this.kdtEntry.getColumnIndex(TB_INITIAL));
                SysUtil.abort();
            }
            if ((step = (Integer)row.getCell(TB_STEP).getValue()) == null || step <= 0) {
                MsgBox.showInfo((String)LotRuleClientUtils.getResource("VERIFY_STEP_POSITIVE"));
                this.kdtEntry.getEditManager().editCellAt(i, this.kdtEntry.getColumnIndex(TB_STEP));
                SysUtil.abort();
            }
            if (String.valueOf(initial + step).length() <= length) continue;
            MsgBox.showInfo((String)LotRuleClientUtils.getResource("VERIFY_INITIAL_STEP_TOO_LONG"));
            this.kdtEntry.getEditManager().editCellAt(i, this.kdtEntry.getColumnIndex(TB_LENGTH));
            SysUtil.abort();
        }
        if (billNumberCount == 0 && serialCount == 0 && MsgBox.isCancel((int)MsgBox.showConfirm2((Component)((Object)this), (String)LotRuleClientUtils.getResource("VERIFY_NO_SERIAL")))) {
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    private void refreshPreview() {
        String splitSign = this.comboBoxSplitSign.getSelectedItem().toString();
        StringBuffer sbPreview = new StringBuffer();
        StringBuffer sbLength = new StringBuffer();
        int entryCount = this.kdtEntry.getRowCount();
        for (int i = 0; i < entryCount; ++i) {
            boolean needSplit;
            SectTypeEnum sectType = (SectTypeEnum)((Object)this.kdtEntry.getCell(i, TB_SECTTYPE).getValue());
            if (sectType.equals((Object)SectTypeEnum.SYSTIME)) {
                String formatDisplay = (String)this.kdtEntry.getCell(i, TB_FORMAT_DISPLAY).getValue();
                sbPreview.append(formatDisplay);
                int length = 0;
                if (formatDisplay != null) {
                    length = formatDisplay.length();
                }
                sbLength.append('\"').append(length).append('\"');
            } else if (sectType.equals((Object)SectTypeEnum.CONST)) {
                String constValue = (String)this.kdtEntry.getCell(i, TB_CONSTVALUE).getValue();
                sbPreview.append(constValue);
                int length = 0;
                if (constValue != null) {
                    length = constValue.trim().length();
                }
                sbLength.append('\"').append(length).append('\"');
            } else if (sectType.equals((Object)SectTypeEnum.ATTRIBUTE)) {
                sbPreview.append("?");
                sbLength.append('\"').append("?").append('\"');
            } else if (sectType.equals((Object)SectTypeEnum.SERIAL)) {
                Integer initial = (Integer)this.kdtEntry.getCell(i, TB_INITIAL).getValue();
                Integer length = (Integer)this.kdtEntry.getCell(i, TB_LENGTH).getValue();
                sbPreview.append(LotRuleClientUtils.fillSign(String.valueOf(initial), length, "0", FillSignDirectionEnum.FORWARD));
                sbLength.append('\"').append(length).append('\"');
            }
            if (i == entryCount - 1 || !(needSplit = ((Boolean)this.kdtEntry.getCell(i, TB_NEEDSPLIT).getValue()).booleanValue())) continue;
            sbPreview.append(splitSign);
            sbLength.append(splitSign);
        }
        this.txtPreview.setText(sbPreview.toString());
        this.txtTotalLength.setText(sbLength.toString());
    }

    private void souChanged(DataChangeEvent e) {
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)e.getNewValue();
        this.initUIMainOrgContext(sou.getId().toString());
    }

    private void initEntryDataBySectType(int selectRow, SectTypeEnum sectType) {
        IRow row = this.kdtEntry.getRow(selectRow);
        if (sectType.equals((Object)SectTypeEnum.SYSTIME)) {
            row.getCell(TB_FORMAT).setValue((Object)new Integer(2));
            row.getCell(TB_FORMAT_DISPLAY).setValue((Object)this.timeFormat[2]);
        } else if (sectType.equals((Object)SectTypeEnum.CONST)) {
            row.getCell(TB_ISCLASSIFY).setValue((Object)Boolean.FALSE);
        } else if (sectType.equals((Object)SectTypeEnum.ATTRIBUTE)) {
            row.getCell(TB_VALUEATTRIBUTE).setValue((Object)ValueAttributeEnum.MAIN_BIZ_ORG);
            row.getCell(TB_LENGTH).setValue((Object)new Integer(8));
            row.getCell(TB_FILLSIGNDIRECTION).setValue((Object)FillSignDirectionEnum.FORWARD);
        } else if (sectType.equals((Object)SectTypeEnum.SERIAL)) {
            row.getCell(TB_LENGTH).setValue((Object)new Integer(8));
            row.getCell(TB_INITIAL).setValue((Object)new Integer(1));
            row.getCell(TB_STEP).setValue((Object)new Integer(1));
            row.getCell(TB_ISCLASSIFY).setValue((Object)Boolean.FALSE);
        }
    }

    private void initEntryStatusBySectType(int selectRow, SectTypeEnum sectType) {
        if (sectType.equals((Object)SectTypeEnum.SYSTIME)) {
            LotRuleClientUtils.setCellsEnable(this.kdtEntry, selectRow, new String[]{TB_VALUEATTRIBUTE, TB_CONSTVALUE, TB_LENGTH, TB_INITIAL, TB_STEP, TB_FILLSIGN, TB_FILLSIGNDIRECTION}, false);
            LotRuleClientUtils.setCellsEnable(this.kdtEntry, selectRow, new String[]{TB_FORMAT_DISPLAY, TB_ISCLASSIFY}, true);
            LotRuleClientUtils.setCellsColor(this.kdtEntry, selectRow, new String[]{TB_VALUEATTRIBUTE, TB_CONSTVALUE, TB_LENGTH, TB_INITIAL, TB_STEP, TB_FILLSIGN, TB_FILLSIGNDIRECTION}, LotRuleClientUtils.GRAY);
            LotRuleClientUtils.setCellsColor(this.kdtEntry, selectRow, new String[]{TB_FORMAT_DISPLAY}, NEEDED_COLOR);
            LotRuleClientUtils.setCellsColor(this.kdtEntry, selectRow, new String[]{TB_ISCLASSIFY}, Color.WHITE);
        } else if (sectType.equals((Object)SectTypeEnum.CONST)) {
            LotRuleClientUtils.setCellsEnable(this.kdtEntry, selectRow, new String[]{TB_VALUEATTRIBUTE, TB_FORMAT, TB_FORMAT_DISPLAY, TB_LENGTH, TB_INITIAL, TB_STEP, TB_FILLSIGN, TB_FILLSIGNDIRECTION, TB_ISCLASSIFY}, false);
            LotRuleClientUtils.setCellsEnable(this.kdtEntry, selectRow, new String[]{TB_CONSTVALUE}, true);
            SCMClientUtil.setEntriesTableStrLength((KDTable)this.kdtEntry, (String[])new String[]{TB_CONSTVALUE}, (int)60);
            LotRuleClientUtils.setCellsColor(this.kdtEntry, selectRow, new String[]{TB_VALUEATTRIBUTE, TB_FORMAT_DISPLAY, TB_LENGTH, TB_INITIAL, TB_STEP, TB_FILLSIGN, TB_FILLSIGNDIRECTION}, LotRuleClientUtils.GRAY);
            LotRuleClientUtils.setCellsColor(this.kdtEntry, selectRow, new String[]{TB_CONSTVALUE}, NEEDED_COLOR);
        } else if (sectType.equals((Object)SectTypeEnum.ATTRIBUTE)) {
            LotRuleClientUtils.setCellsEnable(this.kdtEntry, selectRow, new String[]{TB_FORMAT, TB_FORMAT_DISPLAY, TB_CONSTVALUE, TB_INITIAL, TB_STEP}, false);
            LotRuleClientUtils.setCellsEnable(this.kdtEntry, selectRow, new String[]{TB_VALUEATTRIBUTE, TB_LENGTH, TB_FILLSIGN, TB_FILLSIGNDIRECTION, TB_ISCLASSIFY}, true);
            LotRuleClientUtils.setCellsColor(this.kdtEntry, selectRow, new String[]{TB_FORMAT_DISPLAY, TB_CONSTVALUE, TB_LENGTH, TB_INITIAL, TB_STEP}, LotRuleClientUtils.GRAY);
            LotRuleClientUtils.setCellsColor(this.kdtEntry, selectRow, new String[]{TB_VALUEATTRIBUTE, TB_LENGTH}, NEEDED_COLOR);
            LotRuleClientUtils.setCellsColor(this.kdtEntry, selectRow, new String[]{TB_FILLSIGN, TB_FILLSIGNDIRECTION}, Color.WHITE);
            LotRuleClientUtils.setCellsColor(this.kdtEntry, selectRow, new String[]{TB_ISCLASSIFY}, Color.WHITE);
            ValueAttributeEnum valueAttribute = (ValueAttributeEnum)((Object)this.kdtEntry.getCell(selectRow, TB_VALUEATTRIBUTE).getValue());
            if (valueAttribute.equals((Object)ValueAttributeEnum.BIZDATE) || valueAttribute.equals((Object)ValueAttributeEnum.MFG) || valueAttribute.equals((Object)ValueAttributeEnum.EXP)) {
                LotRuleClientUtils.setCellsEnable(this.kdtEntry, selectRow, new String[]{TB_LENGTH}, false);
                LotRuleClientUtils.setCellsColor(this.kdtEntry, selectRow, new String[]{TB_LENGTH}, LotRuleClientUtils.GRAY);
            }
        } else if (sectType.equals((Object)SectTypeEnum.SERIAL)) {
            LotRuleClientUtils.setCellsEnable(this.kdtEntry, selectRow, new String[]{TB_VALUEATTRIBUTE, TB_FORMAT, TB_FORMAT_DISPLAY, TB_CONSTVALUE, TB_FILLSIGN, TB_FILLSIGNDIRECTION, TB_ISCLASSIFY}, false);
            LotRuleClientUtils.setCellsEnable(this.kdtEntry, selectRow, new String[]{TB_LENGTH, TB_INITIAL, TB_STEP}, true);
            LotRuleClientUtils.setCellsColor(this.kdtEntry, selectRow, new String[]{TB_VALUEATTRIBUTE, TB_FORMAT_DISPLAY, TB_CONSTVALUE, TB_FILLSIGN, TB_FILLSIGNDIRECTION}, LotRuleClientUtils.GRAY);
            LotRuleClientUtils.setCellsColor(this.kdtEntry, selectRow, new String[]{TB_LENGTH, TB_INITIAL, TB_STEP}, NEEDED_COLOR);
        }
    }

    private void initCellNullBySectType(int selectRow, SectTypeEnum sectType) {
        if (sectType.equals((Object)SectTypeEnum.SYSTIME)) {
            LotRuleClientUtils.setCellsNull(this.kdtEntry, selectRow, new String[]{TB_CONSTVALUE, TB_FILLSIGN});
            this.kdtEntry.getCell(selectRow, TB_VALUEATTRIBUTE).setValue((Object)ValueAttributeEnum.NULL);
            this.kdtEntry.getCell(selectRow, TB_FILLSIGNDIRECTION).setValue((Object)FillSignDirectionEnum.NULL);
            this.kdtEntry.getCell(selectRow, TB_LENGTH).setValue((Object)new Integer(0));
            this.kdtEntry.getCell(selectRow, TB_INITIAL).setValue((Object)new Integer(0));
            this.kdtEntry.getCell(selectRow, TB_STEP).setValue((Object)new Integer(0));
            this.kdtEntry.getCell(selectRow, TB_ISCLASSIFY).setValue((Object)Boolean.FALSE);
        } else if (sectType.equals((Object)SectTypeEnum.CONST)) {
            LotRuleClientUtils.setCellsNull(this.kdtEntry, selectRow, new String[]{TB_FORMAT_DISPLAY, TB_FILLSIGN, TB_FILLSIGNDIRECTION});
            this.kdtEntry.getCell(selectRow, TB_FORMAT).setValue((Object)new Integer(0));
            this.kdtEntry.getCell(selectRow, TB_VALUEATTRIBUTE).setValue((Object)ValueAttributeEnum.NULL);
            this.kdtEntry.getCell(selectRow, TB_FILLSIGNDIRECTION).setValue((Object)FillSignDirectionEnum.NULL);
            this.kdtEntry.getCell(selectRow, TB_LENGTH).setValue((Object)new Integer(0));
            this.kdtEntry.getCell(selectRow, TB_INITIAL).setValue((Object)new Integer(0));
            this.kdtEntry.getCell(selectRow, TB_STEP).setValue((Object)new Integer(0));
            this.kdtEntry.getCell(selectRow, TB_ISCLASSIFY).setValue((Object)Boolean.FALSE);
        } else if (sectType.equals((Object)SectTypeEnum.ATTRIBUTE)) {
            LotRuleClientUtils.setCellsNull(this.kdtEntry, selectRow, new String[]{TB_FORMAT_DISPLAY, TB_CONSTVALUE});
            this.kdtEntry.getCell(selectRow, TB_FORMAT).setValue((Object)new Integer(0));
            this.kdtEntry.getCell(selectRow, TB_INITIAL).setValue((Object)new Integer(0));
            this.kdtEntry.getCell(selectRow, TB_STEP).setValue((Object)new Integer(0));
            this.kdtEntry.getCell(selectRow, TB_ISCLASSIFY).setValue((Object)Boolean.FALSE);
        } else if (sectType.equals((Object)SectTypeEnum.SERIAL)) {
            LotRuleClientUtils.setCellsNull(this.kdtEntry, selectRow, new String[]{TB_FORMAT_DISPLAY, TB_CONSTVALUE, TB_FILLSIGN, TB_FILLSIGNDIRECTION});
            this.kdtEntry.getCell(selectRow, TB_FORMAT).setValue((Object)new Integer(0));
            this.kdtEntry.getCell(selectRow, TB_VALUEATTRIBUTE).setValue((Object)ValueAttributeEnum.NULL);
            this.kdtEntry.getCell(selectRow, TB_FILLSIGNDIRECTION).setValue((Object)FillSignDirectionEnum.NULL);
            this.kdtEntry.getCell(selectRow, TB_ISCLASSIFY).setValue((Object)Boolean.FALSE);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (this.getOprtState().equalsIgnoreCase("ADDNEW") || this.getOprtState().equalsIgnoreCase("EDIT")) {
            this.chkIsModifiable.setEnabled(true);
            this.kdtEntry.setEnabled(true);
            this.actionAddLine.setEnabled(true);
            this.actionInsertLine.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
        } else {
            this.chkIsModifiable.setEnabled(false);
            this.kdtEntry.setEnabled(false);
            this.actionAddLine.setEnabled(false);
            this.actionInsertLine.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
        }
    }

    @Override
    public void actionDisable_actionPerformed(ActionEvent e) throws Exception {
        super.actionDisable_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)LotRuleClientUtils.getResource("CONFIRM_DISABLE")))) {
            String ruleID = this.editData.getId().toString();
            ILotRule iLotRule = LotRuleFactory.getRemoteInstance();
            iLotRule.disableRule(ruleID);
            this.refresh();
        }
        this.setSaved(true);
    }

    @Override
    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        super.actionEnable_actionPerformed(e);
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)LotRuleClientUtils.getResource("CONFIRM_ENABLE")))) {
            String ruleID = this.editData.getId().toString();
            ILotRule iLotRule = LotRuleFactory.getRemoteInstance();
            iLotRule.enableRule(ruleID);
            this.refresh();
        }
        this.setSaved(true);
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
    }

    private void refresh() throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
        this.loadFields();
    }

    protected void afterAddLine(KDTable table, IObjectValue lineData) {
        super.afterAddLine(table, lineData);
        this.afterCreateNewDetailData(table, lineData);
        this.resetSectNumber(table);
        this.refreshPreview();
    }

    protected void afterInsertLine(KDTable table, IObjectValue lineData) {
        super.afterInsertLine(table, lineData);
        this.afterCreateNewDetailData(table, lineData);
        this.resetSectNumber(table);
        this.refreshPreview();
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
        super.afterRemoveLine(table, lineData);
        this.resetSectNumber(table);
        this.refreshPreview();
    }

    private void afterCreateNewDetailData(KDTable table, IObjectValue lineData) {
        int rowIndex = LotRuleClientUtils.getRowIndexOfLineData(table, lineData);
        this.initEntryStatusBySectType(rowIndex, DEFAULT_SECTTYPE);
        this.initCellNullBySectType(rowIndex, DEFAULT_SECTTYPE);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.actionEnable.setEnabled(false);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.setOprtState("VIEW");
        this.initDataStatus();
        this.actionEnable.setEnabled(true);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectStringPK pk = null;
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)OrgType.Storage) != null) {
            pk = new ObjectStringPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)OrgType.Storage)).getId().toString());
        }
        return pk;
    }

    private class LotRuleListener
    implements KDTEditListener,
    ItemListener,
    DataChangeListener {
        private LotRuleListener() {
        }

        public void editStarting(KDTEditEvent e) {
        }

        public void editStarted(KDTEditEvent e) {
        }

        public void editValueChanged(KDTEditEvent e) {
        }

        public void editStopping(KDTEditEvent e) {
        }

        public void editStopped(KDTEditEvent e) {
            if (e.getValue() != null && e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() == null) {
                return;
            }
            KDTable table = (KDTable)e.getSource();
            int selectRow = e.getRowIndex();
            int selectCol = e.getColIndex();
            IRow row = table.getRow(selectRow);
            if (selectCol == table.getColumnIndex(LotRuleEditUI.TB_SECTTYPE)) {
                SectTypeEnum sectType = (SectTypeEnum)((Object)row.getCell(selectCol).getValue());
                int serialCount = 0;
                int entryCount = table.getRowCount();
                for (int i = 0; i < entryCount; ++i) {
                    IRow irow = LotRuleEditUI.this.kdtEntry.getRow(i);
                    SectTypeEnum secType = (SectTypeEnum)((Object)irow.getCell(LotRuleEditUI.TB_SECTTYPE).getValue());
                    if (!secType.equals((Object)SectTypeEnum.SERIAL) || ++serialCount <= 1) continue;
                    MsgBox.showInfo((String)LotRuleClientUtils.getResource("VERIFY_SERIAL_SO_MUCH"));
                    row.getCell(LotRuleEditUI.TB_SECTTYPE).setValue((Object)DEFAULT_SECTTYPE);
                    sectType = DEFAULT_SECTTYPE;
                    break;
                }
                LotRuleEditUI.this.initEntryStatusBySectType(selectRow, sectType);
                LotRuleEditUI.this.initEntryDataBySectType(selectRow, sectType);
                LotRuleEditUI.this.initCellNullBySectType(selectRow, sectType);
            }
            if (selectCol == table.getColumnIndex(LotRuleEditUI.TB_VALUEATTRIBUTE)) {
                ValueAttributeEnum valueAttribute = (ValueAttributeEnum)((Object)table.getCell(selectRow, selectCol).getValue());
                if (valueAttribute.equals((Object)ValueAttributeEnum.BIZDATE) || valueAttribute.equals((Object)ValueAttributeEnum.MFG) || valueAttribute.equals((Object)ValueAttributeEnum.EXP)) {
                    LotRuleClientUtils.setCellsEnable(LotRuleEditUI.this.kdtEntry, selectRow, new String[]{LotRuleEditUI.TB_FORMAT_DISPLAY}, true);
                    LotRuleClientUtils.setCellsEnable(LotRuleEditUI.this.kdtEntry, selectRow, new String[]{LotRuleEditUI.TB_LENGTH}, false);
                    LotRuleClientUtils.setCellsColor(LotRuleEditUI.this.kdtEntry, selectRow, new String[]{LotRuleEditUI.TB_FORMAT_DISPLAY}, NEEDED_COLOR);
                    LotRuleClientUtils.setCellsColor(LotRuleEditUI.this.kdtEntry, selectRow, new String[]{LotRuleEditUI.TB_LENGTH}, LotRuleClientUtils.GRAY);
                    LotRuleEditUI.this.kdtEntry.getCell(selectRow, LotRuleEditUI.TB_FORMAT).setValue((Object)new Integer(2));
                    LotRuleEditUI.this.kdtEntry.getCell(selectRow, LotRuleEditUI.TB_FORMAT_DISPLAY).setValue((Object)LotRuleEditUI.this.timeFormat[2]);
                    LotRuleEditUI.this.kdtEntry.getCell(selectRow, LotRuleEditUI.TB_LENGTH).setValue((Object)new Integer(0));
                } else {
                    LotRuleClientUtils.setCellsEnable(LotRuleEditUI.this.kdtEntry, selectRow, new String[]{LotRuleEditUI.TB_FORMAT_DISPLAY}, false);
                    LotRuleClientUtils.setCellsEnable(LotRuleEditUI.this.kdtEntry, selectRow, new String[]{LotRuleEditUI.TB_LENGTH}, true);
                    LotRuleClientUtils.setCellsColor(LotRuleEditUI.this.kdtEntry, selectRow, new String[]{LotRuleEditUI.TB_FORMAT_DISPLAY}, LotRuleClientUtils.GRAY);
                    LotRuleClientUtils.setCellsColor(LotRuleEditUI.this.kdtEntry, selectRow, new String[]{LotRuleEditUI.TB_LENGTH}, NEEDED_COLOR);
                    LotRuleEditUI.this.kdtEntry.getCell(selectRow, LotRuleEditUI.TB_FORMAT).setValue((Object)new Integer(0));
                    LotRuleEditUI.this.kdtEntry.getCell(selectRow, LotRuleEditUI.TB_FORMAT_DISPLAY).setValue(null);
                    LotRuleEditUI.this.kdtEntry.getCell(selectRow, LotRuleEditUI.TB_LENGTH).setValue((Object)new Integer(8));
                }
            }
            if (selectCol == table.getColumnIndex(LotRuleEditUI.TB_FORMAT_DISPLAY) && row.getCell(selectCol).getValue() != null) {
                for (int i = 0; i < LotRuleEditUI.this.timeFormat.length; ++i) {
                    if (!row.getCell(selectCol).getValue().toString().equals(LotRuleEditUI.this.timeFormat[i])) continue;
                    row.getCell(LotRuleEditUI.TB_FORMAT).setValue((Object)new Integer(i));
                    break;
                }
            }
            LotRuleEditUI.this.refreshPreview();
        }

        public void editCanceled(KDTEditEvent e) {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == LotRuleEditUI.this.comboBoxSplitSign) {
                LotRuleEditUI.this.refreshPreview();
            }
        }

        public void dataChanged(DataChangeEvent e) {
            if (e == null) {
                return;
            }
            Object source = e.getSource();
            if (source == null) {
                return;
            }
            if (e.getNewValue() != null && e.getNewValue().equals(e.getOldValue())) {
                return;
            }
            if (source == LotRuleEditUI.this.prmtSou) {
                LotRuleEditUI.this.souChanged(e);
            }
        }
    }
}

