/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewStorageF7;
import com.kingdee.eas.basedata.scm.im.inv.ILotRule;
import com.kingdee.eas.basedata.scm.im.inv.InvException;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleFactory;
import com.kingdee.eas.basedata.scm.im.inv.LotRuleInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractLotRuleListUI;
import com.kingdee.eas.basedata.scm.im.inv.client.LotRuleClientUtils;
import com.kingdee.eas.basedata.scm.im.inv.client.LotRuleEditUI;
import com.kingdee.eas.basedata.scm.im.inv.client.LotRuleMaterialTreeBuilder;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class LotRuleListUI
extends AbstractLotRuleListUI {
    private static final Logger logger = CoreUIObject.getLogger(LotRuleListUI.class);
    LotRuleMaterialTreeBuilder materialTree = new LotRuleMaterialTreeBuilder();
    EventListener event = new EventListener();
    boolean currOrgHasPer = false;

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    public void onLoad() throws Exception {
        super.onLoad();
        NewStorageF7 f7 = new NewStorageF7((IUIObject)this);
        f7.setPermissionItem("lotRule_view");
        this.prmtStorage.setSelector((KDPromptSelector)f7);
        this.prmtStorage.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
        StorageOrgUnitInfo storageOrg = SysContext.getSysContext().getCurrentStorageUnit();
        if (storageOrg != null && this.currOrgHasPer) {
            this.prmtStorage.setValue((Object)storageOrg);
        }
        this.prmtStorage.addDataChangeListener((DataChangeListener)this.event);
        this.treeMain.addTreeSelectionListener((TreeSelectionListener)this.event);
        this.treeMain.addTreeExpansionListener((TreeExpansionListener)this.event);
        this.materialTree.buildGroupTree((JTree)this.treeMain, storageOrg);
        DefaultKingdeeTreeNode rootNodeMaterial = (DefaultKingdeeTreeNode)((DefaultTreeModel)this.treeMain.getModel()).getRoot();
        TreePath pathMaterial = new TreePath(rootNodeMaterial.getPath());
        this.treeMain.setSelectionPath(pathMaterial);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.EnableOrDisEnableRule(true, e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.EnableOrDisEnableRule(false, e);
    }

    private void EnableOrDisEnableRule(boolean enable, ActionEvent e) throws Exception {
        this.checkSelected();
        String selectID = this.getSelectedKeyValue();
        ILotRule ilotRule = (ILotRule)this.getBizInterface();
        String messageRes = null;
        String confirmRes = null;
        confirmRes = enable ? "CONFIRM_ENABLE" : "CONFIRM_DISABLE";
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)LotRuleClientUtils.getResource(confirmRes)))) {
            if (enable) {
                ilotRule.enableRule(selectID);
                messageRes = "Rule_Enable_OK";
            } else {
                ilotRule.disableRule(selectID);
                messageRes = "Rule_DisEnable_OK";
            }
            this.refresh(e);
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.LotRuleResource", (String)messageRes));
            this.showMessage();
        }
    }

    @Override
    protected String getEditUIName() {
        return LotRuleEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LotRuleFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        TreePath path;
        Object obj;
        DefaultKingdeeTreeNode node;
        Object userObject;
        if (this.treeMain.getSelectionPath() == null) {
            DefaultKingdeeTreeNode rootNodeMaterial = (DefaultKingdeeTreeNode)((DefaultTreeModel)this.treeMain.getModel()).getRoot();
            TreePath pathMaterial = new TreePath(rootNodeMaterial.getPath());
            this.treeMain.setSelectionPath(pathMaterial);
        }
        if ((userObject = (node = (DefaultKingdeeTreeNode)(obj = (path = this.treeMain.getSelectionPath()).getLastPathComponent())).getUserObject()) instanceof MaterialGroupInfo || userObject instanceof MaterialInfo) {
            super.actionAddNew_actionPerformed(e);
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.client.InvResource", (String)"Select_Material_OR_Group"));
        }
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.client.InvResource", (String)"LotRule");
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        String storageOrgID = "";
        if (SysContext.getSysContext().getCurrentStorageUnit() != null) {
            storageOrgID = SysContext.getSysContext().getCurrentStorageUnit().getId().toString();
            String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            try {
                this.currOrgHasPer = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectStringPK(userID), (IObjectPK)new ObjectStringPK(storageOrgID), "lotRule_view");
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        if (this.currOrgHasPer) {
            filter.getFilterItems().add(new FilterItemInfo("sou.id", (Object)storageOrgID));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"HAS NO PERMISSION"));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"HAS NO PERMISSION", CompareType.NOTEQUALS));
        }
        return filter;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.panelTree.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 232, 569));
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null) {
            Object obj = path.getLastPathComponent();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)obj;
            Object userObject = node.getUserObject();
            if (userObject instanceof KDTree) {
                return;
            }
            if (userObject instanceof MaterialGroupInfo) {
                uiContext.put((Object)"businessObjectID", (Object)((MaterialGroupInfo)userObject).getId().toString());
                uiContext.put((Object)"isMaterial", (Object)Boolean.FALSE);
            } else if (userObject instanceof MaterialInfo) {
                uiContext.put((Object)"businessObjectID", (Object)((MaterialInfo)userObject).getId().toString());
                uiContext.put((Object)"isMaterial", (Object)Boolean.TRUE);
            }
        }
    }

    private FilterInfo getStorageOrgFilter() {
        FilterInfo filter = new FilterInfo();
        StorageOrgUnitInfo storageInfo = (StorageOrgUnitInfo)this.prmtStorage.getValue();
        if (storageInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("sou.id", (Object)storageInfo.getId().toString()));
        }
        return filter;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checCanEdit();
        super.actionEdit_actionPerformed(e);
    }

    private void checCanEdit() throws BOSException, EASBizException, Exception {
        ObjectUuidPK pk;
        String id = this.getSelectedKeyValue();
        if (id == null) {
            return;
        }
        ILotRule ilotRule = (ILotRule)this.getBizInterface();
        if (!ilotRule.exists((IObjectPK)(pk = new ObjectUuidPK(BOSUuid.read((String)id))))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("enabled");
        LotRuleInfo lotInfo = ilotRule.getLotRuleInfo((IObjectPK)pk, selectors);
        if (lotInfo.getEnabled() != null && lotInfo.getEnabled().getValue() == 2) {
            throw new InvException(InvException.ENABLERULE_CANT_EDIT);
        }
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectStringPK pk = null;
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)OrgType.Storage) != null) {
            pk = new ObjectStringPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)OrgType.Storage)).getId().toString());
        }
        return pk;
    }

    private class EventListener
    implements DataChangeListener,
    TreeSelectionListener,
    TreeExpansionListener {
        private EventListener() {
        }

        public void dataChanged(DataChangeEvent e) {
            Object source = e.getSource();
            if (source.equals(LotRuleListUI.this.prmtStorage)) {
                LotRuleListUI.this.materialTree.clear();
                StorageOrgUnitInfo storageOrg = (StorageOrgUnitInfo)e.getNewValue();
                try {
                    if (storageOrg == null) {
                        LotRuleListUI.this.tblMain.removeRows(false);
                    } else {
                        DefaultKingdeeTreeNode rootNodeMaterial = (DefaultKingdeeTreeNode)((DefaultTreeModel)LotRuleListUI.this.treeMain.getModel()).getRoot();
                        TreePath pathMaterial = new TreePath(rootNodeMaterial.getPath());
                        LotRuleListUI.this.treeMain.setSelectionPath(pathMaterial);
                        LotRuleListUI.this.materialTree.buildGroupTree((JTree)LotRuleListUI.this.treeMain, storageOrg);
                        LotRuleListUI.this.initUIMainOrgContext(storageOrg.getId().toString());
                    }
                }
                catch (Exception e1) {
                    LotRuleListUI.this.handUIException(e1);
                }
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            StorageOrgUnitInfo storageOrg = null;
            if (e == null || LotRuleListUI.this.prmtStorage.getValue() == null) {
                return;
            }
            TreePath path = e.getPath();
            Object obj = path.getLastPathComponent();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)obj;
            Object userObject = node.getUserObject();
            FilterInfo filter = null;
            if (userObject instanceof KDTree) {
                return;
            }
            filter = LotRuleListUI.this.getStorageOrgFilter();
            if (userObject instanceof MaterialGroupInfo) {
                filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)((MaterialGroupInfo)userObject).getId().toString()));
            } else if (userObject instanceof MaterialInfo) {
                filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)((MaterialInfo)userObject).getId().toString()));
            }
            if (filter != null) {
                LotRuleListUI.this.mainQuery.setFilter(filter);
            }
            LotRuleListUI.this.tblMain.removeRows();
            try {
                storageOrg = (StorageOrgUnitInfo)LotRuleListUI.this.prmtStorage.getValue();
                if (storageOrg != null && userObject != null && userObject instanceof MaterialGroupInfo) {
                    MaterialGroupInfo mg = (MaterialGroupInfo)userObject;
                    String longNumber = mg.getLongNumber();
                    LotRuleListUI.this.materialTree.buildGroupTree((JTree)LotRuleListUI.this.treeMain, storageOrg, longNumber, node.getLevel() + 1);
                }
                if (path.getParentPath() == null) {
                    return;
                }
                LotRuleListUI.this.treeMain.expandPath(path);
                LotRuleListUI.this.treeMain.setExpandsSelectedPaths(true);
            }
            catch (Exception es) {
                LotRuleListUI.this.handleException(es);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent ev) {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent ev) {
            if (ev == null || LotRuleListUI.this.prmtStorage.getValue() == null) {
                return;
            }
            TreePath path = ev.getPath();
            Object obj = path.getLastPathComponent();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)obj;
            new TreeSelectionEvent(node.getUserObject(), ev.getPath(), LotRuleListUI.this.currOrgHasPer, null, null);
        }
    }
}

