/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class LotRuleMaterialTreeBuilder {
    Icon groupIcon = EASResource.getIcon((String)"imgTree_businessgroup");
    Icon companyIcon = EASResource.getIcon((String)"imgTree_folder_leaf");
    MaterialGroupTreeNode rootnode = null;
    HashMap nodeMap = new HashMap();
    HashSet set = new HashSet();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.scm.im.inv.client.LotRuleMaterialTreeBuilder");
    DefaultKingdeeTreeNode lastExpandnode = null;
    DefaultKingdeeTreeNode expandnode = null;

    public LotRuleMaterialTreeBuilder() {
    }

    public LotRuleMaterialTreeBuilder(DefaultKingdeeTreeNode Lastnode) {
        this.lastExpandnode = Lastnode;
    }

    public void clear() {
        this.nodeMap.clear();
        this.set.clear();
        this.rootnode = null;
        this.lastExpandnode = null;
        this.expandnode = null;
    }

    public JTree buildGroupTree(JTree tree, StorageOrgUnitInfo orgUnit) throws Exception {
        this.createRootNode(orgUnit);
        tree.setModel(new DefaultTreeModel((TreeNode)((Object)this.rootnode)));
        return tree;
    }

    public JTree buildGroupTree(JTree tree, StorageOrgUnitInfo orgUnit, String longNumber, int level) throws Exception {
        this.createNextNode(orgUnit, longNumber, level);
        return tree;
    }

    public DefaultKingdeeTreeNode getExpandNode() {
        return this.expandnode;
    }

    private void createRootNode(StorageOrgUnitInfo orgUnit) throws Exception {
        DefaultKingdeeTreeNode rootGroupInfo = new DefaultKingdeeTreeNode();
        rootGroupInfo.setText(this.getResource("Msg_MaterialTreeLabel"));
        this.rootnode = new MaterialGroupTreeNode(rootGroupInfo);
        if (orgUnit != null) {
            IRowSet rows = this.getMaterialGroupInfoSet(orgUnit, true);
            logger.info((Object)"--------test--------155");
            logger.info((Object)("rows.size(0=" + rows.size()));
            this.buildTreeByRowSet(rows, orgUnit);
        }
    }

    private void createNextNode(StorageOrgUnitInfo orgUnit, String longNumber, int level) throws Exception {
        DefaultKingdeeTreeNode rootGroupInfo = new DefaultKingdeeTreeNode();
        rootGroupInfo.setText(this.getResource("Msg_MaterialTreeLabel"));
        if (orgUnit != null) {
            if (this.set.contains(longNumber)) {
                return;
            }
            if (longNumber == null) {
                return;
            }
            if (!this.set.contains(longNumber)) {
                if (!this.set.contains(longNumber)) {
                    IRowSet rows = this.getMaterialGroupInfoSet(orgUnit, longNumber, level);
                    logger.info((Object)"--------test--------");
                    logger.info((Object)("rows.size(0=" + rows.size()));
                    this.buildTreeByRowSet(rows, orgUnit, longNumber);
                }
                this.buildLeafNodes(orgUnit, longNumber);
                this.set.add(longNumber);
            }
        }
    }

    private IRowSet getMaterialGroupInfoSet(StorageOrgUnitInfo orgUnit) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("longnumber"));
        coll.add("name");
        CtrlUnitInfo cu = null;
        if (orgUnit != null) {
            cu = orgUnit.getCU();
            cu = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectStringPK(cu.getId().toString()), coll);
        } else {
            cu = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cu.getId().toString(), (String)cu.getLongNumber());
        viewInfo.setFilter(filterInfoCU);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private IRowSet getMaterialGroupInfoSet(StorageOrgUnitInfo orgUnit, boolean isOnLoad) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("longnumber"));
        coll.add("name");
        CtrlUnitInfo cu = null;
        if (orgUnit != null) {
            cu = orgUnit.getCU();
            cu = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectStringPK(cu.getId().toString()), coll);
        } else {
            cu = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cu.getId().toString(), (String)cu.getLongNumber());
        if (isOnLoad) {
            filterInfoCU.getFilterItems().add(new FilterItemInfo("level", (Object)"1"));
            if (filterInfoCU.getMaskString() != null && filterInfoCU.getMaskString().indexOf("1") != -1) {
                filterInfoCU.setMaskString("(#0 or #1) and #2 ");
            } else if (filterInfoCU.getMaskString() != null && filterInfoCU.getMaskString().indexOf("1") == -1) {
                filterInfoCU.setMaskString("(#0) and #1 and #2");
            } else {
                filterInfoCU.setMaskString("#0 and #1");
            }
        }
        logger.info((Object)"-----test------247");
        logger.info((Object)("filter msk is :" + filterInfoCU.getMaskString()));
        viewInfo.setFilter(filterInfoCU);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private IRowSet getMaterialGroupInfoSet(StorageOrgUnitInfo orgUnit, String longNumber, int level) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("longnumber"));
        coll.add("name");
        CtrlUnitInfo cu = null;
        if (orgUnit != null) {
            cu = orgUnit.getCU();
            cu = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectStringPK(cu.getId().toString()), coll);
        } else {
            cu = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cu.getId().toString(), (String)cu.getLongNumber());
        if (longNumber != null && !longNumber.equals("")) {
            filterInfoCU.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
            filterInfoCU.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber, CompareType.NOTEQUALS));
            filterInfoCU.getFilterItems().add(new FilterItemInfo("level", (Object)String.valueOf(level)));
            if (filterInfoCU.getMaskString() != null && filterInfoCU.getMaskString().indexOf("1") != -1) {
                filterInfoCU.setMaskString("(#0 or #1) and #2 and #3 and #4");
            } else {
                filterInfoCU.setMaskString("#0 and #1 and #2 and #3");
            }
        }
        viewInfo.setFilter(filterInfoCU);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private void buildTreeByRowSet(IRowSet rowset, StorageOrgUnitInfo orgUnit) throws Exception {
        if (rowset == null) {
            return;
        }
        if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)this.rootnode)) {
            this.expandnode = this.rootnode;
        }
        this.nodeMap.put("root", this.rootnode);
        while (rowset.next()) {
            MaterialGroupInfo materialGroupInfo = this.getMaterialBrowseGroupInfo(rowset);
            MaterialGroupTreeNode subTreeNode = new MaterialGroupTreeNode(materialGroupInfo);
            if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)subTreeNode)) {
                this.expandnode = subTreeNode;
            }
            if (materialGroupInfo.getParent() == null) {
                ((MaterialGroupTreeNode)((Object)this.nodeMap.get("root"))).add((MutableTreeNode)((Object)subTreeNode));
            } else if (this.nodeMap.containsKey(materialGroupInfo.getParent().getId().toString())) {
                ((MaterialGroupTreeNode)((Object)this.nodeMap.get(materialGroupInfo.getParent().getId().toString()))).add((MutableTreeNode)((Object)subTreeNode));
            }
            if (this.nodeMap.containsKey(materialGroupInfo.getId().toString())) continue;
            this.nodeMap.put(materialGroupInfo.getId().toString(), subTreeNode);
        }
    }

    private void buildTreeByRowSet(IRowSet rowset, StorageOrgUnitInfo orgUnit, String longNumber) throws Exception {
        if (rowset == null) {
            return;
        }
        if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)this.rootnode)) {
            this.expandnode = this.rootnode;
        }
        this.nodeMap.put("root", this.rootnode);
        while (rowset.next()) {
            MaterialGroupInfo materialGroupInfo = this.getMaterialBrowseGroupInfo(rowset);
            MaterialGroupTreeNode subTreeNode = new MaterialGroupTreeNode(materialGroupInfo);
            if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)subTreeNode)) {
                this.expandnode = subTreeNode;
            }
            if (materialGroupInfo.getParent() == null) {
                ((MaterialGroupTreeNode)((Object)this.nodeMap.get("root"))).add((MutableTreeNode)((Object)subTreeNode));
            } else if (this.nodeMap.containsKey(materialGroupInfo.getParent().getId().toString())) {
                ((MaterialGroupTreeNode)((Object)this.nodeMap.get(materialGroupInfo.getParent().getId().toString()))).add((MutableTreeNode)((Object)subTreeNode));
            }
            if (this.nodeMap.containsKey(materialGroupInfo.getId().toString())) continue;
            this.nodeMap.put(materialGroupInfo.getId().toString(), subTreeNode);
        }
    }

    private void buildLeafNodes(StorageOrgUnitInfo orgUnit) throws Exception {
        MaterialGroupTreeNode node2 = null;
        if (this.rootnode != null) {
            ArrayList trees = this.getMaterialTrees(orgUnit);
            for (MaterialGroupTreeNode node2 : trees) {
                MaterialInfo materialInfo = (MaterialInfo)node2.getUserObject();
                if (materialInfo == null || materialInfo.getMaterialGroup() == null) continue;
                if (this.nodeMap.containsKey(materialInfo.getMaterialGroup().getId().toString())) {
                    ((MaterialGroupTreeNode)((Object)this.nodeMap.get(materialInfo.getMaterialGroup().getId().toString()))).add((MutableTreeNode)((Object)node2));
                }
                this.nodeMap.put(materialInfo.getId().toString(), node2);
            }
        }
    }

    private void buildLeafNodes(StorageOrgUnitInfo orgUnit, String longNumber) throws Exception {
        MaterialGroupTreeNode node2 = null;
        if (this.rootnode != null) {
            ArrayList trees = this.getMaterialTrees(orgUnit, longNumber);
            for (MaterialGroupTreeNode node2 : trees) {
                MaterialInfo materialInfo = (MaterialInfo)node2.getUserObject();
                if (materialInfo == null || materialInfo.getMaterialGroup() == null) continue;
                if (this.nodeMap.containsKey(materialInfo.getMaterialGroup().getId().toString())) {
                    ((MaterialGroupTreeNode)((Object)this.nodeMap.get(materialInfo.getMaterialGroup().getId().toString()))).add((MutableTreeNode)((Object)node2));
                }
                this.nodeMap.put(materialInfo.getId().toString(), node2);
            }
        }
    }

    private ArrayList getMaterialTrees(StorageOrgUnitInfo orgUnit) throws Exception {
        ArrayList<MaterialGroupTreeNode> materialTrees = new ArrayList<MaterialGroupTreeNode>();
        IRowSet rows = this.getMaterialRowSet(orgUnit);
        if (rows == null) {
            return null;
        }
        while (rows.next()) {
            MaterialInfo materialInfo = this.getMaterialInfo(rows);
            MaterialGroupTreeNode node = new MaterialGroupTreeNode(materialInfo);
            if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)node)) {
                this.expandnode = node;
            }
            materialTrees.add(node);
        }
        return materialTrees;
    }

    private ArrayList getMaterialTrees(StorageOrgUnitInfo orgUnit, String longNumber) throws Exception {
        ArrayList<MaterialGroupTreeNode> materialTrees = new ArrayList<MaterialGroupTreeNode>();
        IRowSet rows = this.getMaterialRowSet(orgUnit, longNumber);
        if (rows == null) {
            return null;
        }
        while (rows.next()) {
            MaterialInfo materialInfo = this.getMaterialInfo(rows);
            MaterialGroupTreeNode node = new MaterialGroupTreeNode(materialInfo);
            node.setText(materialInfo.getNumber() + "(" + materialInfo.getName() + ")");
            if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)node)) {
                this.expandnode = node;
            }
            materialTrees.add(node);
        }
        return materialTrees;
    }

    private MaterialGroupInfo getMaterialBrowseGroupInfo(IRowSet row) throws Exception {
        MaterialGroupInfo orginfo = new MaterialGroupInfo();
        orginfo.setId(BOSUuid.read((String)row.getString("id")));
        orginfo.setName(row.getString("name"));
        orginfo.setNumber(row.getString("number"));
        orginfo.setIsLeaf(row.getBoolean("isLeaf"));
        orginfo.setLongNumber(row.getString("longNumber"));
        MaterialGroupInfo parentInfo = new MaterialGroupInfo();
        if (row.getString("parent.id") == null || row.getString("parent.id").equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        orginfo.setParent(parentInfo);
        return orginfo;
    }

    private IRowSet getMaterialRowSet(StorageOrgUnitInfo orgUnit) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (orgUnit.isIsBizUnit()) {
            fi.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)orgUnit.getId().toString()));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("storageOrg.longNumber", (Object)(orgUnit.getLongNumber() + "%"), CompareType.LIKE));
        }
        logger.info((Object)"-----------test-------428");
        logger.info((Object)("query material msk:" + fi.getMaskString()));
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.scm.im.inv.app.MaterialAndGroupLotListQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private IRowSet getMaterialRowSet(StorageOrgUnitInfo orgUnit, String longNumber) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (orgUnit.isIsBizUnit()) {
            fi.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)orgUnit.getId().toString()));
        } else {
            fi.getFilterItems().add(new FilterItemInfo("storageOrg.longNumber", (Object)(orgUnit.getLongNumber() + "%"), CompareType.LIKE));
        }
        if (longNumber != null && longNumber.length() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("materialGroup.longNumber", (Object)longNumber));
            fi.setMaskString("#0 and #1");
        }
        logger.info((Object)"-----------test-------428");
        logger.info((Object)("query material msk:" + fi.getMaskString()));
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.scm.im.inv.app.MaterialAndGroupLotListQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private MaterialInfo getMaterialInfo(IRowSet row) throws Exception {
        MaterialInfo materialInfo = new MaterialInfo();
        materialInfo.setId(BOSUuid.read((String)row.getString("id")));
        materialInfo.setName(row.getString("name"));
        materialInfo.setNumber(row.getString("number"));
        materialInfo.setLongNumber(row.getString("longNumber"));
        MaterialGroupInfo orginfo = new MaterialGroupInfo();
        if (row.getString("MaterialGroup.id") == null || row.getString("MaterialGroup.id").equals("")) {
            orginfo = null;
        } else {
            orginfo.setId(BOSUuid.read((String)row.getString("MaterialGroup.id")));
        }
        materialInfo.setMaterialGroup(orginfo);
        return materialInfo;
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)key);
    }

    private class MaterialGroupTreeNode
    extends KDTreeNode {
        public MaterialGroupTreeNode(Object o) {
            super(o);
        }

        public boolean equals(Object obj) {
            if (obj != null && !(obj instanceof DefaultKingdeeTreeNode)) {
                return false;
            }
            MaterialGroupTreeNode node = (MaterialGroupTreeNode)((Object)obj);
            if (obj != null && node.getUserObject() != null && node.getUserObject() instanceof MaterialGroupInfo && this.getUserObject() != null && this.getUserObject() instanceof MaterialGroupInfo) {
                MaterialGroupInfo materialGroupInfo = (MaterialGroupInfo)this.getUserObject();
                MaterialGroupInfo objMaterialInfo = (MaterialGroupInfo)node.getUserObject();
                if (materialGroupInfo.getId().toString().equals(objMaterialInfo.getId().toString())) {
                    return true;
                }
            } else if (obj != null && node.getUserObject() != null && node.getUserObject() instanceof MaterialInfo && this.getUserObject() != null && this.getUserObject() instanceof MaterialInfo) {
                MaterialInfo info = (MaterialInfo)this.getUserObject();
                MaterialInfo objinfo = (MaterialInfo)node.getUserObject();
                if (info.getId().toString().equals(objinfo.getId().toString())) {
                    return true;
                }
            }
            return false;
        }
    }
}

