/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocationListFacade;
import com.kingdee.eas.basedata.scm.im.inv.LocationListFacadeFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractMaterialDefaultWarehHouseUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.util.uicontrol.SCMClientUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class MaterialDefaultWarehHouseUI
extends AbstractMaterialDefaultWarehHouseUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialDefaultWarehHouseUI.class);
    private static final String permItem = "materialstorage_new";
    private Set authorizedStorageSet = new LinkedHashSet();

    public MaterialDefaultWarehHouseUI() throws Exception {
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void prmtMaterial_stateChanged(ChangeEvent e) throws Exception {
        super.prmtMaterial_stateChanged(e);
    }

    @Override
    protected void prmtStorageOrg_stateChanged(ChangeEvent e) throws Exception {
        super.prmtStorageOrg_stateChanged(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkInput();
        MaterialInfo materialInfo = (MaterialInfo)this.prmtMaterial.getData();
        StorageOrgUnitInfo storageInfo = (StorageOrgUnitInfo)this.prmtDefaultWare.getData();
        WarehouseInfo warehouseinfo = (WarehouseInfo)this.prmtNewOrgUnit.getData();
        ILocationListFacade iLocationListFacade = LocationListFacadeFactory.getRemoteInstance();
        iLocationListFacade.upDataDefaultWareHouse(storageInfo.getId().toString(), materialInfo.getId().toString(), warehouseinfo.getId().toString());
        iLocationListFacade.addMaterialStorageAssign(materialInfo, storageInfo, warehouseinfo);
        this.setOldDefaultWareHouse();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getAuthorizedStorageSet();
        this.prmtMaterial.setEnabled(false);
        this.prmtOldOrgUnit.setEnabled(false);
        this.prmtNewOrgUnit.setEnabled(false);
        this.addListen();
        this.setStorageOrgFilter();
    }

    private void addListen() {
        this.StorageListen();
        this.MaterialListen();
    }

    private void StorageListen() {
        this.prmtDefaultWare.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                StorageOrgUnitInfo storageInfoListen = (StorageOrgUnitInfo)MaterialDefaultWarehHouseUI.this.prmtDefaultWare.getData();
                String storageOrgNumberListen = null;
                BOSUuid storageOrgNumberIdListen = null;
                if (storageInfoListen != null) {
                    storageOrgNumberListen = storageInfoListen.getNumber();
                    storageOrgNumberIdListen = storageInfoListen.getId();
                }
                if (storageOrgNumberListen != null && storageOrgNumberIdListen != null) {
                    MaterialDefaultWarehHouseUI.this.prmtNewOrgUnit.setEditable(true);
                    MaterialDefaultWarehHouseUI.this.prmtNewOrgUnit.setEnabled(true);
                    MaterialDefaultWarehHouseUI.this.prmtNewOrgUnit.setData((Object)"");
                    MaterialDefaultWarehHouseUI.this.prmtMaterial.setEditable(true);
                    MaterialDefaultWarehHouseUI.this.prmtMaterial.setEnabled(true);
                    MaterialDefaultWarehHouseUI.this.prmtMaterial.setData((Object)"");
                    MaterialDefaultWarehHouseUI.this.prmtOldOrgUnit.setData((Object)"");
                    MaterialDefaultWarehHouseUI.this.defualtNewWareHouseF7(storageOrgNumberListen);
                    MaterialDefaultWarehHouseUI.this.setMaterialF7(storageOrgNumberIdListen.toString());
                } else {
                    MaterialDefaultWarehHouseUI.this.prmtNewOrgUnit.setEnabled(false);
                    MaterialDefaultWarehHouseUI.this.prmtMaterial.setEnabled(false);
                }
            }
        });
    }

    private void MaterialListen() {
        this.prmtMaterial.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                MaterialInfo materialInfo = null;
                if (MaterialDefaultWarehHouseUI.this.prmtMaterial.getData() != null && MaterialDefaultWarehHouseUI.this.prmtMaterial.getData().toString().trim().length() > 0) {
                    materialInfo = (MaterialInfo)MaterialDefaultWarehHouseUI.this.prmtMaterial.getData();
                }
                if (materialInfo != null) {
                    try {
                        MaterialDefaultWarehHouseUI.this.setOldDefaultWareHouse();
                    }
                    catch (Exception e) {
                        MaterialDefaultWarehHouseUI.this.handUIException(e);
                    }
                }
            }

            public void afterDataChanged(DataChangeEvent eventObj) {
                MaterialInfo materialInfo = (MaterialInfo)MaterialDefaultWarehHouseUI.this.prmtMaterial.getData();
                if (materialInfo != null) {
                    try {
                        MaterialDefaultWarehHouseUI.this.setOldDefaultWareHouse();
                    }
                    catch (Exception e) {
                        MaterialDefaultWarehHouseUI.this.handUIException(e);
                    }
                }
            }
        });
    }

    private void defualtNewWareHouseF7(String sotrageNum) {
        EntityViewInfo view = this.prmtNewOrgUnit.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filterinfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("storageOrgUnit.number", (Object)sotrageNum, CompareType.EQUALS);
        filterinfo.getFilterItems().add(filterItemInfo);
        if (view.getFilter() != null) {
            try {
                boolean isHasRowTypeFilter = false;
                FilterItemInfo tmpFilter = null;
                int c = view.getFilter().getFilterItems().size();
                for (int i = 0; i < c; ++i) {
                    tmpFilter = view.getFilter().getFilterItems().get(i);
                    if (tmpFilter.getPropertyName().indexOf("storageOrgUnit.number") < 0) continue;
                    isHasRowTypeFilter = true;
                    view.getFilter().getFilterItems().set(i, filterItemInfo);
                    break;
                }
                if (!isHasRowTypeFilter) {
                    view.getFilter().mergeFilter(filterinfo, "and");
                }
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        } else {
            view.setFilter(filterinfo);
        }
        this.prmtNewOrgUnit.setEntityViewInfo(view);
    }

    private void setMaterialF7(String sotrageOrgId) {
        EntityViewInfo view = this.prmtMaterial.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        FilterInfo filterinfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("StorageOrgUnit.id", (Object)sotrageOrgId, CompareType.EQUALS);
        filterinfo.getFilterItems().add(filterItemInfo);
        if (view.getFilter() != null) {
            try {
                boolean isHasRowTypeFilter = false;
                FilterItemInfo tmpFilter = null;
                int c = view.getFilter().getFilterItems().size();
                for (int i = 0; i < c; ++i) {
                    tmpFilter = view.getFilter().getFilterItems().get(i);
                    if (tmpFilter.getPropertyName().indexOf("StorageOrgUnit.id") < 0) continue;
                    isHasRowTypeFilter = true;
                    view.getFilter().getFilterItems().set(i, filterItemInfo);
                    break;
                }
                if (!isHasRowTypeFilter) {
                    view.getFilter().mergeFilter(filterinfo, "and");
                }
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
        } else {
            view.setFilter(filterinfo);
        }
        this.prmtMaterial.setEntityViewInfo(view);
    }

    private String getOldDefaultWareHouse(StorageOrgUnitInfo storageinfo, MaterialInfo materialinfo) throws EASBizException, BOSException {
        return LocationListFacadeFactory.getRemoteInstance().getDefaultWareHouse(storageinfo.getId().toString(), materialinfo.getId().toString());
    }

    private void setOldDefaultWareHouse() throws EASBizException, BOSException {
        StorageOrgUnitInfo storageInfo = (StorageOrgUnitInfo)this.prmtDefaultWare.getData();
        MaterialInfo materialInfo = (MaterialInfo)this.prmtMaterial.getData();
        String defaultWareHouse = null;
        if (storageInfo != null && materialInfo != null) {
            defaultWareHouse = this.getOldDefaultWareHouse(storageInfo, materialInfo);
        }
        if (defaultWareHouse == null || defaultWareHouse.length() < 1) {
            this.prmtOldOrgUnit.setData((Object)"");
            return;
        }
        this.prmtOldOrgUnit.setData((Object)defaultWareHouse);
    }

    private void checkInput() {
        String message = null;
        if (this.prmtNewOrgUnit.getText().trim().equals("") || this.prmtNewOrgUnit.getValue() == null || this.prmtNewOrgUnit.getText().trim().length() < 1) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.MaterialStorageAssignEditUI_WarehouseIsNull");
            this.prmtNewOrgUnit.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        if (this.prmtDefaultWare.getText().trim().equals("") || this.prmtDefaultWare.getValue() == null || this.prmtDefaultWare.getText().trim().length() < 1) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.WarehouseEditUI_StorageOrgIsNull");
            this.prmtDefaultWare.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        if (this.prmtMaterial.getText().trim().equals("") || this.prmtMaterial.getValue() == null || this.prmtMaterial.getText().trim().length() < 1) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.MaterialStorageAssignEditUI_MaterialIsNull");
            this.prmtMaterial.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
    }

    protected void getAuthorizedStorageSet() {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        Object[] storageOrgs = null;
        try {
            FullOrgUnitCollection coll = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, OrgType.Storage, null, permItem);
            storageOrgs = coll.toArray();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        int count = storageOrgs.length;
        if (count > 0) {
            OrgUnitInfo orgUnit = null;
            String number = null;
            for (int i = 0; i < count; ++i) {
                orgUnit = (OrgUnitInfo)storageOrgs[i];
                if (orgUnit == null || (number = orgUnit.getNumber()) == null) continue;
                this.authorizedStorageSet.add(number);
            }
        }
    }

    protected void setStorageOrgFilter() throws Exception {
        SCMClientUtil.setSotrageOrgF7((KDBizPromptBox)this.prmtDefaultWare);
    }
}

