/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.IMaterialStorageAssign;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignCollection;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignFactory;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignInfo;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignTypeEnum;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHCollection;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractMaterialStorageAssignEditUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.LineResult;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.constants.QueryInfoConstants;
import com.kingdee.eas.scm.im.inv.client.InvClientUtils;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class MaterialStorageAssignEditUI
extends AbstractMaterialStorageAssignEditUI
implements DataChangeListener {
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final Color NECESSARYCOLOR = new Color(252, 255, 206);
    private int f7DisplayMode = 0;
    public WarehouseInfo warehouseInfo;
    private MaterialStorageAssignInfo cacheInfo;
    boolean isFirst = true;
    private static final Logger logger = CoreUIObject.getLogger(MaterialStorageAssignEditUI.class);

    public String getUITitle() {
        String strTitle = null;
        if ("ADDNEW".equals(this.getOprtState())) {
            strTitle = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.MaterialStorageAssignAddNew");
        } else if ("EDIT".equals(this.getOprtState())) {
            strTitle = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.MaterialStorageAssignEdit");
        } else if ("VIEW".equals(this.getOprtState())) {
            strTitle = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.MaterialStorageAssignView");
        }
        return strTitle;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtWarehouse.getEditor().setBackground(SCMClientUtils.necessaryColor);
        this.prmtStorageOrg.getEditor().setBackground(SCMClientUtils.necessaryColor);
        this.prmtMaterial.getEditor().setBackground(SCMClientUtils.necessaryColor);
        this.f7DisplayMode = SCMGroupClientUtils.getF7DisplayMode((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        if (this.f7DisplayMode == 0) {
            SCMUtil.setBizMaterialF7((KDBizPromptBox)this.prmtMaterial, (Component)((Object)this), (OrgType)OrgType.Storage, (boolean)true, null);
        } else {
            this.prmtMaterial.setQueryInfo(QueryInfoConstants.getMaterialNoGroupQueryInfo((OrgType)OrgType.Storage));
            this.prmtMaterial.setEnabledMultiSelection(true);
        }
        this.prmtMaterial.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                if (MaterialStorageAssignEditUI.this.prmtStorageOrg.getValue() == null) {
                    MsgBox.showConfirm2((String)InvClientUtils.getResource((String)"STORAGEORGNOTSELECT"));
                    e.setCanceled(true);
                    return;
                }
            }
        });
        this.setPrecision();
        this.prmtLocation.setEnabledMultiSelection(true);
        this.prmtLocation.addDataChangeListener((DataChangeListener)this);
        this.prmtMaterialGroup.setEnabledMultiSelection(true);
        this.prmtLocation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (MaterialStorageAssignEditUI.this.prmtLocation.getValue() == null) {
                    MaterialStorageAssignEditUI.this.chkIsDefaultLocation.setSelected(false);
                }
            }
        });
    }

    private void setMaxStorageQty() {
        this.txtMaxStorageQty.setMaximumValue((Comparable)InvClientUtils.MAXVAL);
        this.txtMaxStorageQty.setMinimumValue((Comparable)ZERO);
        this.txtMaxStorageQty.setNegatived(false);
        this.txtMaxStorageQty.setRemoveingZeroInDispaly(false);
        this.txtMaxStorageQty.setHorizontalAlignment(4);
        this.txtMaxStorageQty.setSupportedEmpty(true);
        this.txtMaxStorageQty.setPrecision(10);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setFilterData();
        this.setLocationEnable((WarehouseInfo)this.prmtWarehouse.getValue());
        this.prmtWarehouse.setEnabled(false);
        if (this.editData.getLocation() == null) {
            this.chkIsDefaultLocation.setEnabled(false);
        }
        this.changeStorageAssignType(this.getStorageAssignType());
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        if (this.getUIContext().get("warehouse") == null) {
            this.prmtWarehouse.setValue((Object)this.warehouseInfo);
        } else {
            this.warehouseInfo = (WarehouseInfo)this.getUIContext().get("warehouse");
        }
        this.editData.setWarehouse(this.warehouseInfo);
        this.setLocationEnable(this.warehouseInfo);
        this.prmtWarehouse.setEnabled(false);
    }

    @Override
    public void loadFields() {
        ChangeListener cl = this.prmtStorageOrg.getChangeListeners()[0];
        ChangeListener clm = this.prmtMaterial.getChangeListeners()[0];
        this.prmtStorageOrg.removeChangeListener(cl);
        this.prmtMaterial.removeChangeListener(clm);
        this.setMaxStorageQty();
        super.loadFields();
        this.prmtWarehouse.setEnabled(false);
        this.btnPageSetup.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        if ("EDIT".equals(this.getOprtState())) {
            if (this.editData.getStorageOrg() != null) {
                this.setMaterialFilter(this.editData.getStorageOrg());
            }
            this.warehouseInfo = this.editData.getWarehouse();
        }
        this.setFilterData();
        this.setLocationEnable(this.editData.getWarehouse());
        if (this.editData.getLocation() == null) {
            this.chkIsDefaultLocation.setEnabled(false);
        }
        this.changeStorageAssignType(this.editData.getStorageAssignType());
        this.prmtStorageOrg.addChangeListener(cl);
        this.prmtMaterial.addChangeListener(clm);
    }

    private void changeStorageAssignType(MaterialStorageAssignTypeEnum storageAssignType) {
        if (null != storageAssignType && MaterialStorageAssignTypeEnum.BYMATERIALGROUP.equals((Object)storageAssignType)) {
            this.radSettingByMaterialGroup.setSelected(true);
            this.prmtMaterialGroup.setEnabled(true);
            this.prmtMaterial.setEnabled(false);
            this.prmtMaterial.setValue(null);
        } else {
            this.radSettingByMaterial.setSelected(true);
            this.prmtMaterialGroup.setEnabled(false);
            this.prmtMaterial.setEnabled(true);
            this.prmtMaterialGroup.setValue(null);
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if ("ADDNEW".equals(this.getOprtState())) {
            dataObject.put("warehouse", this.getUIContext().get("warehouse"));
            this.setLocationEnable((WarehouseInfo)this.getUIContext().get("warehouse"));
        }
        super.setDataObject(dataObject);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setStorageAssignType(this.getStorageAssignType());
    }

    protected IObjectValue createNewData() {
        MaterialStorageAssignInfo objectValue = new MaterialStorageAssignInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setStorageAssignType(MaterialStorageAssignTypeEnum.BYMATERIAL);
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialStorageAssignFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return MaterialStorageAssignEditUI.class.getName();
    }

    private void setLocationEnable(WarehouseInfo warehouseInfo) {
        if (warehouseInfo != null) {
            if (warehouseInfo.isHasLocation()) {
                this.prmtLocation.setEnabled(true);
                this.prmtLocation.setRequired(false);
                this.chkIsDefaultLocation.setEnabled(true);
            } else {
                this.prmtLocation.setRequired(false);
                this.prmtLocation.setEnabled(false);
                this.chkIsDefaultLocation.setEnabled(false);
            }
        } else {
            this.prmtLocation.setRequired(false);
            this.prmtLocation.setEnabled(false);
            this.chkIsDefaultLocation.setEnabled(true);
        }
    }

    private void setFilterData() {
        WarehouseInfo warehouseInfo = (WarehouseInfo)this.prmtWarehouse.getData();
        if (warehouseInfo == null) {
            return;
        }
        this.setLocationEnable(warehouseInfo);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo storageFilterItemInfo = new FilterItemInfo("WAREHOUSE.ID", (Object)warehouseInfo.getId().toString());
        filterInfo.getFilterItems().add(storageFilterItemInfo);
        viewInfo.setFilter(filterInfo);
        this.prmtStorageOrg.setEntityViewInfo(this.getSOUFilter(warehouseInfo));
        this.prmtLocation.setEntityViewInfo(viewInfo);
    }

    private EntityViewInfo getSOUFilter(WarehouseInfo warehouseInfo) {
        try {
            ISOAccreditWH iso = SOAccreditWHFactory.getRemoteInstance();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("WAREHOUSE", (Object)warehouseInfo.getId().toString()));
            viewInfo.setFilter(filterInfo);
            SOAccreditWHCollection sows = iso.getSOAccreditWHCollection(viewInfo);
            int recs = sows.size();
            EntityViewInfo viewInfo2 = new EntityViewInfo();
            FilterInfo filterInfo2 = new FilterInfo();
            StringBuffer masking = new StringBuffer("#0");
            if (recs <= 0) {
                filterInfo2.getFilterItems().add(new FilterItemInfo("ID", (Object)"-1", CompareType.EQUALS));
            } else {
                for (int i = 0; i < recs; ++i) {
                    filterInfo2.getFilterItems().add(new FilterItemInfo("ID", (Object)sows.get(i).getStorageOrg(), CompareType.EQUALS));
                    masking.append(" or #" + String.valueOf(i) + " ");
                }
                filterInfo2.setMaskString(masking.toString());
            }
            viewInfo2.setFilter(filterInfo2);
            return viewInfo2;
        }
        catch (BOSException e) {
            this.handUIException(e);
            return null;
        }
    }

    @Override
    protected void prmtMaterial_stateChanged(ChangeEvent e) throws Exception {
        Object o = this.prmtMaterial.getValue();
        if (o instanceof MaterialInfo) {
            this.setPrecision();
        } else if (o instanceof MaterialInfo[]) {
            MaterialInfo[] materialInfoArray = (MaterialInfo[])o;
        } else {
            return;
        }
    }

    private void setPrecision() {
        MeasureUnitInfo mui;
        MaterialInfo mi = null;
        if (this.prmtMaterial.getValue() instanceof MaterialInfo) {
            mi = (MaterialInfo)this.prmtMaterial.getValue();
        } else if (this.prmtMaterial.getValue() instanceof Object[]) {
            Object[] materials = (Object[])this.prmtMaterial.getValue();
            if (materials.length == 0) {
                return;
            }
            mi = (MaterialInfo)materials[0];
        }
        if (mi != null && (mui = mi.getBaseUnit()) != null) {
            try {
                IMultiMeasureUnit imm = MultiMeasureUnitFactory.getRemoteInstance();
                MultiMeasureUnitInfo mmui = imm.getMultiUnit(mi.getId().toString(), mui.getId().toString());
                if (mmui != null) {
                    int prc = mmui.getQtyPrecision();
                    this.txtMaxStorageQty.setPrecision(prc);
                }
            }
            catch (BOSException e1) {
                this.handUIException(e1);
            }
            catch (EASBizException e1) {
                this.handUIException(e1);
            }
        }
    }

    @Override
    protected void prmtStorageOrg_stateChanged(ChangeEvent e) throws Exception {
        if (this.prmtStorageOrg.getValue() == null) {
            return;
        }
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)this.prmtStorageOrg.getValue();
        this.prmtMaterial.setValue(null);
        this.setMaterialFilter(sou);
    }

    private void setMaterialFilter(StorageOrgUnitInfo sou) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (sou != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", (Object)sou.getId().toString()));
        }
        viewInfo.setFilter(filterInfo);
        this.prmtMaterial.setEntityViewInfo(viewInfo);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String message = null;
        if (this.prmtWarehouse.getText().trim().equals("") || this.prmtWarehouse.getValue() == null) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.MaterialStorageAssignEditUI_WarehouseIsNull");
            this.prmtWarehouse.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        if (this.prmtStorageOrg.getText().trim().equals("") || this.prmtStorageOrg.getValue() == null) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.WarehouseEditUI_StorageOrgIsNull");
            this.prmtStorageOrg.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        if (MaterialStorageAssignTypeEnum.BYMATERIALGROUP.equals((Object)this.getStorageAssignType())) {
            if (this.prmtMaterialGroup.getText().trim().equals("") || this.prmtMaterialGroup.getValue() == null) {
                message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.MaterialStorageAssignEditUI_MaterialGroupIsNull");
                this.prmtMaterialGroup.requestFocus();
                MsgBox.showInfo((Component)((Object)this), (String)message);
                SysUtil.abort();
            }
        } else if (this.prmtMaterial.getText().trim().equals("") || this.prmtMaterial.getValue() == null) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.MaterialStorageAssignEditUI_MaterialIsNull");
            this.prmtMaterial.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isFirst) {
            String tips = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.DATA_MODYFY");
            MsgBox.showInfo((String)tips);
            SysUtil.abort();
        }
        this.beforeStoreFields(e);
        this.storeFields();
        if (MaterialStorageAssignTypeEnum.BYMATERIALGROUP.equals((Object)this.getStorageAssignType())) {
            this.submitObjectByMaterialGroup();
        } else {
            this.submitObjectByMaterial();
        }
        this.initOldData((IObjectValue)this.editData);
        this.setOprtState("EDIT");
        this.showMessageForStatus();
        this.showSubmitSuccess();
        this.setSave(true);
        this.setSaved(true);
        if (this.chkMenuItemSubmitAndAddNew.isSelected()) {
            this.afterSubmitAddNew();
            this.isFirst = true;
        }
        this.loadFields();
    }

    private void submitObjectByMaterialGroup() throws BOSException, EASBizException {
        Object o = this.prmtMaterialGroup.getValue();
        Object[] materialGroups = null;
        if (o instanceof MaterialGroupInfo) {
            materialGroups = new MaterialGroupInfo[]{(MaterialGroupInfo)o};
        } else if (o instanceof MaterialGroupInfo[]) {
            materialGroups = (MaterialGroupInfo[])o;
        } else if (o instanceof Object[]) {
            materialGroups = (Object[])o;
        }
        Object oLocation = this.prmtLocation.getValue();
        Object[] locations = null;
        if (oLocation instanceof Object[]) {
            locations = (Object[])oLocation;
        } else if (oLocation == null || oLocation instanceof LocationInfo) {
            locations = new LocationInfo[]{oLocation};
        }
        IMaterialStorageAssign imas = MaterialStorageAssignFactory.getRemoteInstance();
        if (this.getOprtState().equals("EDIT") && this.isFirst && this.editData.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            this.cacheInfo = imas.getMaterialStorageAssignInfo((IObjectPK)pk);
            imas.delete((IObjectPK)pk);
            this.isFirst = false;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        LocationInfo location = null;
        MaterialGroupInfo materialGroup = null;
        if (this.editData == null || this.editData.getStorageOrg() == null || this.editData.getStorageOrg().getId() == null) {
            return;
        }
        filterInfo.appendFilterItem("storageOrg.id", (Object)this.editData.getStorageOrg().getId().toString());
        filterInfo.appendFilterItem("warehouse", (Object)this.editData.getWarehouse().getId().toString());
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (locations != null) {
            for (int i = 0; i < locations.length; ++i) {
                location = (LocationInfo)locations[i];
                if (location == null || location.getId() == null) continue;
                set.add(location.getId().toString());
            }
        }
        if (set.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("location.id", set, CompareType.INCLUDE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("location.id", null, CompareType.EQUALS));
        }
        set = new LinkedHashSet();
        if (materialGroups != null) {
            for (int j = 0; j < materialGroups.length; ++j) {
                materialGroup = materialGroups[j];
                if (materialGroup == null || materialGroup.getId() == null) continue;
                set.add(materialGroup.getId().toString());
            }
        }
        if (set.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.id", set, CompareType.INCLUDE));
        }
        filterInfo.setMaskString("#0 and #1 and #2 and #3");
        view.setFilter(filterInfo);
        MaterialStorageAssignCollection coll = imas.getMaterialStorageAssignCollection(view);
        MaterialStorageAssignInfo matStoAssinInfo = null;
        HashMap<String, MaterialStorageAssignInfo> map = new HashMap<String, MaterialStorageAssignInfo>();
        StringBuffer key = new StringBuffer();
        for (int k = 0; k < coll.size(); ++k) {
            key.setLength(0);
            matStoAssinInfo = coll.get(k);
            if (matStoAssinInfo.getStorageOrg() != null) {
                key.append(matStoAssinInfo.getStorageOrg().getId().toString());
            }
            if (matStoAssinInfo.getWarehouse() != null) {
                key.append(matStoAssinInfo.getWarehouse().getId().toString());
            }
            if (matStoAssinInfo.getLocation() != null) {
                key.append(matStoAssinInfo.getLocation().getId().toString());
            }
            if (matStoAssinInfo.getMaterialGroup() == null) continue;
            key.append(matStoAssinInfo.getMaterialGroup().getId().toString());
            if (map.containsKey(key.toString())) continue;
            map.put(key.toString(), matStoAssinInfo);
        }
        CoreBaseCollection updateColl = new CoreBaseCollection();
        CoreBaseCollection addNewColl = new CoreBaseCollection();
        MaterialStorageAssignInfo msa = null;
        StringBuffer storageOrgAndWarehsId = new StringBuffer();
        if (this.editData.getStorageOrg() == null) {
            return;
        }
        storageOrgAndWarehsId.append(this.editData.getStorageOrg().getId().toString());
        if (this.editData.getWarehouse() == null) {
            return;
        }
        storageOrgAndWarehsId.append(this.editData.getWarehouse().getId().toString());
        StringBuffer tempKey = new StringBuffer();
        if (locations == null || materialGroups == null) {
            return;
        }
        for (int i = 0; i < locations.length; ++i) {
            key.setLength(0);
            key.append(storageOrgAndWarehsId);
            location = (LocationInfo)locations[i];
            this.editData.setLocation(location);
            if (location != null) {
                key.append(String.valueOf(location.getId()));
            }
            tempKey.append(key);
            for (int j = 0; j < materialGroups.length; ++j) {
                materialGroup = materialGroups[j];
                this.editData.setMaterialGroup(materialGroup);
                key.setLength(0);
                key.append(tempKey);
                if (materialGroup != null) {
                    key.append(materialGroup.getId().toString());
                }
                msa = (MaterialStorageAssignInfo)this.editData.clone();
                if (map.containsKey(key.toString())) {
                    matStoAssinInfo = (MaterialStorageAssignInfo)map.get(key.toString());
                    msa.setId(matStoAssinInfo.getId());
                    updateColl.add((CoreBaseInfo)msa);
                    continue;
                }
                msa.setId(null);
                addNewColl.add((CoreBaseInfo)msa);
            }
        }
        Result result = null;
        if (updateColl.size() > 0 && (result = imas.update(updateColl)) != null && result.size() > 0) {
            LineResult line = result.getLineResult(0);
            if (null != line.getException()) {
                line.getException().printStackTrace();
                this.handUIExceptionAndAbort(line.getException());
                return;
            }
            if (null != line.getPk()) {
                this.editData.setId(BOSUuid.read((String)line.getPk().toString()));
            }
        }
        if (addNewColl.size() > 0 && (result = imas.addnew(addNewColl)) != null && result.size() > 0) {
            LineResult line = result.getLineResult(0);
            if (null != line.getException()) {
                this.saveCacheInfo();
                this.handUIExceptionAndAbort(line.getException());
                return;
            }
            if (null != line.getPk()) {
                this.editData.setId(BOSUuid.read((String)line.getPk().toString()));
            }
        }
    }

    private void submitObjectByMaterial() throws BOSException, EASBizException {
        IMaterialStorageAssign imas = MaterialStorageAssignFactory.getRemoteInstance();
        Object o = this.prmtMaterial.getValue();
        Object[] materials = null;
        if (o instanceof MaterialInfo) {
            materials = new MaterialInfo[]{(MaterialInfo)o};
        } else if (o instanceof MaterialInfo[]) {
            materials = (MaterialInfo[])o;
        } else if (o instanceof Object[]) {
            materials = (Object[])o;
        }
        Object oLocation = this.prmtLocation.getValue();
        Object[] locations = null;
        if (oLocation instanceof Object[]) {
            locations = (Object[])oLocation;
        } else if (oLocation == null || oLocation instanceof LocationInfo) {
            locations = new LocationInfo[]{oLocation};
        }
        if (this.getOprtState().equals("EDIT") && this.isFirst && this.editData.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            this.cacheInfo = imas.getMaterialStorageAssignInfo((IObjectPK)pk);
            imas.delete((IObjectPK)pk);
            this.isFirst = false;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        LocationInfo location = null;
        MaterialInfo material = null;
        if (this.editData == null || this.editData.getStorageOrg() == null || this.editData.getStorageOrg().getId() == null) {
            return;
        }
        filterInfo.appendFilterItem("storageOrg.id", (Object)this.editData.getStorageOrg().getId().toString());
        filterInfo.appendFilterItem("warehouse", (Object)this.editData.getWarehouse().getId().toString());
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (locations != null) {
            for (int i = 0; i < locations.length; ++i) {
                location = (LocationInfo)locations[i];
                if (location == null || location.getId() == null) continue;
                set.add(location.getId().toString());
            }
        }
        if (set.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("location.id", set, CompareType.INCLUDE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("location.id", null, CompareType.EQUALS));
        }
        set = new LinkedHashSet();
        if (materials != null) {
            for (int j = 0; j < materials.length; ++j) {
                material = materials[j];
                if (material == null || material.getId() == null) continue;
                set.add(material.getId().toString());
            }
        }
        if (set.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", set, CompareType.INCLUDE));
        }
        filterInfo.setMaskString("#0 and #1 and #2 and #3");
        view.setFilter(filterInfo);
        MaterialStorageAssignCollection coll = imas.getMaterialStorageAssignCollection(view);
        MaterialStorageAssignInfo matStoAssinInfo = null;
        HashMap<String, MaterialStorageAssignInfo> map = new HashMap<String, MaterialStorageAssignInfo>();
        StringBuffer key = new StringBuffer();
        for (int k = 0; k < coll.size(); ++k) {
            key.setLength(0);
            matStoAssinInfo = coll.get(k);
            if (matStoAssinInfo.getStorageOrg() != null) {
                key.append(matStoAssinInfo.getStorageOrg().getId().toString());
            }
            if (matStoAssinInfo.getLocation() != null) {
                key.append(matStoAssinInfo.getLocation().getId().toString());
            }
            if (matStoAssinInfo.getMaterial() == null) continue;
            key.append(matStoAssinInfo.getMaterial().getId().toString());
            if (map.containsKey(key.toString())) continue;
            map.put(key.toString(), matStoAssinInfo);
        }
        CoreBaseCollection updateColl = new CoreBaseCollection();
        CoreBaseCollection addNewColl = new CoreBaseCollection();
        MaterialStorageAssignInfo msa = null;
        key.setLength(0);
        if (this.editData.getStorageOrg() == null) {
            return;
        }
        key.append(this.editData.getStorageOrg().getId().toString());
        StringBuffer tempKey = new StringBuffer();
        tempKey.append(key);
        StringBuffer tempKey2 = new StringBuffer();
        if (locations == null || materials == null) {
            return;
        }
        for (int i = 0; i < locations.length; ++i) {
            key.setLength(0);
            key.append(tempKey);
            location = (LocationInfo)locations[i];
            this.editData.setLocation(location);
            if (location != null) {
                key.append(location.getId().toString());
            }
            tempKey2.append(key);
            for (int j = 0; j < materials.length; ++j) {
                material = materials[j];
                this.editData.setMaterial(material);
                key.setLength(0);
                key.append(tempKey2);
                if (material != null) {
                    key.append(material.getId().toString());
                }
                msa = (MaterialStorageAssignInfo)this.editData.clone();
                if (map.containsKey(key.toString())) {
                    matStoAssinInfo = (MaterialStorageAssignInfo)map.get(key.toString());
                    msa.setId(matStoAssinInfo.getId());
                    updateColl.add((CoreBaseInfo)msa);
                    continue;
                }
                msa.setId(null);
                addNewColl.add((CoreBaseInfo)msa);
            }
        }
        Result result = null;
        if (updateColl.size() > 0) {
            result = imas.update(updateColl);
        }
        if (addNewColl.size() > 0) {
            result = imas.addnew(addNewColl);
        }
        if (result != null && result.size() > 0) {
            LineResult line = result.getLineResult(0);
            if (null != line.getException()) {
                this.saveCacheInfo();
                this.handUIExceptionAndAbort(line.getException());
                return;
            }
            if (null != line.getPk()) {
                this.editData.setId(BOSUuid.read((String)line.getPk().toString()));
            } else {
                return;
            }
        }
    }

    private void saveCacheInfo() {
        if (null != this.cacheInfo) {
            try {
                this.getBizInterface().addnew((CoreBaseInfo)this.cacheInfo);
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
    }

    public void dataChanged(DataChangeEvent e) {
        Object source = e.getSource();
        if (source == this.prmtLocation) {
            this.locationChange(e);
        }
    }

    @Override
    public void actionChangeStorageAssignType_actionPerformed(ActionEvent e) throws Exception {
        super.actionChangeStorageAssignType_actionPerformed(e);
        this.changeStorageAssignType(this.getStorageAssignType());
    }

    private MaterialStorageAssignTypeEnum getStorageAssignType() {
        if (this.radSettingByMaterialGroup.isSelected()) {
            return MaterialStorageAssignTypeEnum.BYMATERIALGROUP;
        }
        return MaterialStorageAssignTypeEnum.BYMATERIAL;
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
        if ("ADDNEW".equals(this.oprtState) || "EDIT".equals(this.oprtState)) {
            this.radSettingByMaterial.setEnabled(true);
            this.radSettingByMaterialGroup.setEnabled(true);
        } else if ("VIEW".equals(this.oprtState)) {
            this.radSettingByMaterial.setEnabled(false);
            this.radSettingByMaterialGroup.setEnabled(false);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("storageAssignType"));
        return sic;
    }

    private void locationChange(DataChangeEvent e) {
        Object o = e.getNewValue();
        if (o == null) {
            this.chkIsDefaultLocation.setEnabled(false);
            return;
        }
        if (o instanceof LocationInfo) {
            this.chkIsDefaultLocation.setEnabled(true);
            this.chkIsFixStorage.setEnabled(true);
            this.chkIsOnlyStorage.setEnabled(true);
        } else if (o instanceof Object[]) {
            Object[] locations = (Object[])o;
            if (locations == null || locations.length <= 1) {
                this.chkIsDefaultLocation.setEnabled(true);
                this.chkIsFixStorage.setEnabled(true);
                this.chkIsOnlyStorage.setEnabled(true);
            } else {
                this.chkIsDefaultLocation.setEnabled(false);
                this.chkIsFixStorage.setEnabled(false);
                this.chkIsOnlyStorage.setEnabled(false);
                this.chkIsDefaultLocation.setSelected(false);
                this.chkIsFixStorage.setSelected(false);
                this.chkIsOnlyStorage.setSelected(false);
            }
        }
    }
}

