/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.basedata.scm.im.inv.RecIssueTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.RecIssueTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.RecIssueTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractRecIssueTypeListUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class RecIssueTypeListUI
extends AbstractRecIssueTypeListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(RecIssueTypeListUI.class);
    private final String res = "com.kingdee.eas.basedata.scm.im.inv.InvAddResource";
    private String currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();

    public RecIssueTypeListUI() throws Exception {
        logger.info((Object)"");
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String strId = this.getSelectedKeyValue();
        if (strId != null && strId.length() > 0) {
            RecIssueTypeInfo info = RecIssueTypeFactory.getRemoteInstance().getRecIssueTypeInfo((IObjectPK)new ObjectUuidPK(strId));
            String cuid = info.getCU().getId().toString();
            if (cuid != null) {
                EntityControlTypeUtil.checkCanEdit((String)"S3", (String)this.currentCUID, (String)cuid);
            }
            if (info.isIsSysInit()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"sysnotedit"));
                this.abort();
            }
            if (info.getStatus().getValue() == 1) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"enablenotedit"));
                this.abort();
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.check4Remove(e);
    }

    private void check4Remove(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.confirmRemove()) {
            return;
        }
        ArrayList pks = this.getSelectedIdValues();
        if (pks.size() > 0) {
            int i;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            HashSet ids = new HashSet(pks);
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("status"));
            view.getSelector().add(new SelectorItemInfo("cu.id"));
            RecIssueTypeCollection col = RecIssueTypeFactory.getRemoteInstance().getRecIssueTypeCollection(view);
            RecIssueTypeInfo info = null;
            ArrayList<ObjectUuidPK> delIDs = new ArrayList<ObjectUuidPK>();
            StringBuffer errorMsg = new StringBuffer();
            int size = col.size();
            for (i = 0; i < size; ++i) {
                info = col.get(i);
                if (info.getStatus().getValue() != 0) {
                    errorMsg.append(ResourceUtil.getMessage((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"UnSaveRecIssueType_Cannt_Remove", (String[])new String[]{info.getNumber()}));
                    errorMsg.append("\n");
                    continue;
                }
                if (!this.currentCUID.equals(info.getCU().getId().toString())) {
                    errorMsg.append(ResourceUtil.getMessage((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"CANNOTDELETE_CU", (String[])new String[]{info.getNumber()}));
                    errorMsg.append("\n");
                    continue;
                }
                delIDs.add(new ObjectUuidPK(info.getId()));
            }
            size = delIDs.size();
            for (i = 0; i < size; ++i) {
                this.getBizInterface().delete((IObjectPK)delIDs.get(i));
            }
            if (errorMsg.length() > 0) {
                String msg = ResourceUtil.getMessage((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"Msg_DeleteError");
                MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errorMsg.toString(), (int)8188);
            }
        }
        this.refresh(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setStatus(UseStatusEnum.INACTIVE);
        this.refresh(e);
    }

    private void setStatus(UseStatusEnum status) throws Exception {
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        StringBuffer errMsg = new StringBuffer();
        ArrayList errors = RecIssueTypeFactory.getRemoteInstance().setStatus(pks, status);
        String msg = null;
        boolean isSuccess = true;
        if (errors != null && errors.size() > 0) {
            Iterator iter = errors.iterator();
            EASBizException ex = null;
            while (iter.hasNext()) {
                ex = (EASBizException)((Object)iter.next());
                if (ex == null) continue;
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
            isSuccess = false;
        }
        if (UseStatusEnum.ACTIVE.equals((Object)status)) {
            msg = isSuccess ? EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"EnableSuccess") : EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"Msg_EnableError");
        } else {
            String string = msg = isSuccess ? EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"DisableSuccess") : EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"Msg_DisableError");
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errMsg.toString(), (int)8188);
        }
        this.refresh(null);
        this.setMessageText(msg);
        this.showMessage();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setStatus(UseStatusEnum.ACTIVE);
        this.refresh(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RecIssueTypeFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.basedata.scm.im.inv.client.RecIssueTypeEditUI";
    }
}

