/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.basedata.scm.im.inv.IStoreState;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractStoreStateEditUI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class StoreStateEditUI
extends AbstractStoreStateEditUI {
    private static final long serialVersionUID = 1L;
    public static final Color NECESSARYCOLOR = new Color(252, 255, 206);
    private static final String res = "com.kingdee.eas.basedata.scm.im.inv.InvAddResource";
    private String currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddNew.setEnabled(false);
        this.txtNumber.setBackground(NECESSARYCOLOR);
        this.txtName.setBackground(NECESSARYCOLOR);
        this.menuItemAddNew.setVisible(false);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        StoreStateInfo storeStateInfo = (StoreStateInfo)newData;
        storeStateInfo.setId(null);
        storeStateInfo.setNumber(null);
        storeStateInfo.setName(null);
        storeStateInfo.setLastUpdateTime(null);
        UserInfo aUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        storeStateInfo.setCreator(aUserInfo);
        storeStateInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        storeStateInfo.setStatus(UseStatusEnum.SAVED);
        storeStateInfo.setDescription(null);
        storeStateInfo.setScheduled(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return StoreStateEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return StoreStateFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        StoreStateInfo objectValue = new StoreStateInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        return objectValue;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String message = null;
        IStoreState iFactory = StoreStateFactory.getRemoteInstance();
        if (this.editData.isScheduled()) {
            String msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource.SystemSettingEdit");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource.NumberBlank");
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setNumber(this.txtNumber.getText().trim());
            this.txtNumber.requestFocus();
            iFactory.checkNumberDup(this.editData);
        }
        if (this.txtName.getText() == null || this.txtName.getText().trim().length() == 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.NameNotNull");
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setName(this.txtName.getText().trim());
            this.txtName.requestFocus();
            iFactory.checkNameDup(this.editData);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        StoreStateInfo info = (StoreStateInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        String cuid = info.getCU().getId().toString();
        if (cuid != null) {
            EntityControlTypeUtil.checkCanEdit((String)"S3", (String)this.currentCUID, (String)cuid);
        }
        if (info.isScheduled()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource.SystemSettingEdit"));
            return;
        }
        if (UseStatusEnum.ACTIVE.equals((Object)this.editData.getStatus())) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"ActiveStoreState_Cannt_Modify"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        StoreStateInfo info = (StoreStateInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        String cuid = info.getCU().getId().toString();
        if (cuid != null) {
            EntityControlTypeUtil.checkCanRemove((String)"S3", (String)this.currentCUID, (String)cuid);
        }
        if (this.editData.getStatus().getValue() != 0) {
            MsgBox.showInfo((String)ResourceUtil.getMessage((String)res, (String)"UnSaveStoreState_Cannt_Remove", (String[])new String[]{""}));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    protected void initDataStatus() {
        this.cbBoxStatus.setEnabled(false);
        super.initDataStatus();
    }
}

