/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.basedata.scm.im.inv.IStoreType;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractStoreTypeEditUI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class StoreTypeEditUI
extends AbstractStoreTypeEditUI {
    private static final long serialVersionUID = 1L;
    public static final Color NECESSARYCOLOR = new Color(252, 255, 206);
    private static final String res = "com.kingdee.eas.basedata.scm.im.inv.InvAddResource";
    private String currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnSave.setEnabled(false);
        this.btnAddNew.setEnabled(false);
        this.txtNumber.setBackground(NECESSARYCOLOR);
        this.txtName.setBackground(NECESSARYCOLOR);
        this.comboStoreFlag.setBackground(NECESSARYCOLOR);
        this.menuItemAddNew.setVisible(false);
        this.menuItemSave.setVisible(false);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        StoreTypeInfo info = StoreTypeFactory.getRemoteInstance().getStoreTypeInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        String cuid = info.getCU().getId().toString();
        if (cuid != null) {
            EntityControlTypeUtil.checkCanEdit((String)"S3", (String)this.currentCUID, (String)cuid);
        }
        if (info.isScheduled()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource.SystemSettingEdit"));
            return;
        }
        if (UseStatusEnum.ACTIVE.equals((Object)this.editData.getStatus())) {
            MsgBox.showInfo((String)EASResource.getString((String)res, (String)"ActiveStoreType_Cannt_Modify"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        StoreTypeInfo info = StoreTypeFactory.getRemoteInstance().getStoreTypeInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        String cuid = info.getCU().getId().toString();
        if (cuid != null) {
            EntityControlTypeUtil.checkCanRemove((String)"S3", (String)this.currentCUID, (String)cuid);
        }
        if (this.editData.getStatus().getValue() != 0) {
            MsgBox.showInfo((String)ResourceUtil.getMessage((String)res, (String)"UnSaveStoreState_Cannt_Remove", (String[])new String[]{""}));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        StoreTypeInfo storeTypeInfo = (StoreTypeInfo)newData;
        storeTypeInfo.setId(null);
        storeTypeInfo.setNumber(null);
        storeTypeInfo.setName(null);
        storeTypeInfo.setLastUpdateTime(null);
        UserInfo aUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        storeTypeInfo.setCreator(aUserInfo);
        storeTypeInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        storeTypeInfo.setStatus(UseStatusEnum.SAVED);
        storeTypeInfo.setDescription(null);
        storeTypeInfo.setScheduled(false);
    }

    protected void initDataStatus() {
        this.chkSchedule.setEnabled(false);
        this.cbBoxStatus.setEnabled(false);
        super.initDataStatus();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.StoreType");
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.btnSubmit.setEnabled(false);
        this.btnAddNew.setEnabled(false);
    }

    @Override
    protected String getEditUIName() {
        return StoreTypeEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return StoreTypeFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        StoreTypeInfo objectValue = new StoreTypeInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        return objectValue;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        StoreTypeInfo ea;
        String message = null;
        IStoreType iFactory = StoreTypeFactory.getRemoteInstance();
        if (this.editData.isScheduled()) {
            String msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource.SystemSettingEdit");
            MsgBox.showInfo((Component)((Object)this), (String)msg);
            SysUtil.abort();
        }
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.NumberNotNull");
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            ea = this.editData;
            ea.setNumber(this.txtNumber.getText().trim());
            this.txtNumber.requestFocus();
            iFactory.checkNumberDup(ea);
        }
        if (this.txtName.getText() == null || this.txtName.getText().trim().length() == 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.NameNotNull");
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            ea = this.editData;
            ea.setName(this.txtName.getText().trim());
            this.txtName.requestFocus();
            iFactory.checkNameDup(ea);
        }
        if (this.comboStoreFlag.getSelectedIndex() < 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.StoreFlagIsNull");
            this.comboStoreFlag.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
    }
}

