/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.basedata.scm.im.inv.IStoreType;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractStoreTypeListUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class StoreTypeListUI
extends AbstractStoreTypeListUI {
    private static final long serialVersionUID = 1L;
    private String currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    private final String resource = "com.kingdee.eas.basedata.scm.im.inv.InvAddResource";
    private final String bdScmRes = "com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource";

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.StoreType");
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setStatus(UseStatusEnum.INACTIVE);
        this.refresh(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setStatus(UseStatusEnum.ACTIVE);
        this.refresh(e);
    }

    private void setStatus(UseStatusEnum status) throws Exception {
        this.checkSelected();
        ArrayList pks = this.getSelectedIdValues();
        ArrayList errors = StoreTypeFactory.getRemoteInstance().setStatus(pks, status);
        StringBuffer errMsg = new StringBuffer();
        String msg = null;
        boolean isSuccess = true;
        if (errors != null && errors.size() > 0) {
            Iterator iter = errors.iterator();
            EASBizException ex = null;
            while (iter.hasNext()) {
                ex = (EASBizException)((Object)iter.next());
                if (ex == null) continue;
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
            isSuccess = false;
        }
        if (UseStatusEnum.ACTIVE.equals((Object)status)) {
            msg = isSuccess ? EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource", (String)"EnableSuccess") : EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"Msg_EnableError");
        } else {
            String string = msg = isSuccess ? EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource", (String)"DisableSuccess") : EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"Msg_DisableError");
        }
        if (errMsg.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errMsg.toString(), (int)8188);
        }
        this.setMessageText(msg);
        this.showMessage();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.check4Remove(e);
    }

    private void check4Remove(ActionEvent e) throws Exception {
        this.checkSelected();
        if (!this.confirmRemove()) {
            return;
        }
        ArrayList pks = this.getSelectedIdValues();
        if (pks.size() > 0) {
            int i;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            HashSet ids = new HashSet(pks);
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            view.setFilter(filter);
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("status"));
            view.getSelector().add(new SelectorItemInfo("cu.id"));
            StoreTypeCollection col = StoreTypeFactory.getRemoteInstance().getStoreTypeCollection(view);
            StoreTypeInfo info = null;
            ArrayList<ObjectUuidPK> delIDs = new ArrayList<ObjectUuidPK>();
            StringBuffer errorMsg = new StringBuffer();
            int size = col.size();
            for (i = 0; i < size; ++i) {
                info = col.get(i);
                if (info.getStatus().getValue() != 0) {
                    errorMsg.append(ResourceUtil.getMessage((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"UnSaveStoreType_Cannt_Remove", (String[])new String[]{info.getNumber()}));
                    errorMsg.append("\n");
                    continue;
                }
                if (!this.currentCUID.equals(info.getCU().getId().toString())) {
                    errorMsg.append(ResourceUtil.getMessage((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"CANNOTDELETE_CU", (String[])new String[]{info.getNumber()}));
                    errorMsg.append("\n");
                    continue;
                }
                delIDs.add(new ObjectUuidPK(info.getId()));
            }
            size = delIDs.size();
            for (i = 0; i < size; ++i) {
                this.getBizInterface().delete((IObjectPK)delIDs.get(i));
            }
            if (errorMsg.length() > 0) {
                String msg = ResourceUtil.getMessage((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"Msg_DeleteError");
                MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errorMsg.toString(), (int)8188);
            }
        }
        this.refresh(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String strId = this.getSelectedKeyValue();
        if (strId != null && strId.length() > 0) {
            IStoreType iStoreType = StoreTypeFactory.getRemoteInstance();
            StoreTypeInfo info = iStoreType.getStoreTypeInfo((IObjectPK)new ObjectUuidPK(strId));
            String cuid = info.getCU().getId().toString();
            if (cuid != null) {
                EntityControlTypeUtil.checkCanEdit((String)"S3", (String)this.currentCUID, (String)cuid);
            }
            if (info.isScheduled()) {
                String msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource.SystemSettingEdit");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                return;
            }
            if (UseStatusEnum.ACTIVE.equals((Object)info.getStatus())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.InvAddResource", (String)"ActiveStoreType_Cannt_Modify"));
                return;
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isLazyMode() {
        return true;
    }
}

