/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.basedata.scm.common.client.BDInvClientUtils;
import com.kingdee.eas.basedata.scm.common.util.DataBaseCheckPermissionUtil;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.WHStateEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractWarehouseEditUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class WarehouseEditUI
extends AbstractWarehouseEditUI {
    public static final Color NECESSARYCOLOR = SCMConstant.NECESSARYCOLOR;
    private String currentCUID;
    private boolean isCopy = false;
    private static final Logger logger = CoreUIObject.getLogger(WarehouseEditUI.class);

    public String getUITitle() {
        String strTitle = null;
        if ("ADDNEW".equals(this.getOprtState())) {
            strTitle = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.WarehouseAddNew");
        } else if ("EDIT".equals(this.getOprtState())) {
            strTitle = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.WarehouseEdit");
        } else if ("VIEW".equals(this.getOprtState())) {
            strTitle = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.WarehouseView");
        }
        return strTitle;
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        WarehouseInfo wi = (WarehouseInfo)newData;
        wi.setNumber(null);
        wi.setDefaultLocationGroup(null);
        this.isCopy = true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtstorageOrg.getEditor().setBackground(NECESSARYCOLOR);
        this.prmtregion.getEditor().setBackground(NECESSARYCOLOR);
        this.txtNumber.setBackground(NECESSARYCOLOR);
        this.txtName.setBackground(NECESSARYCOLOR);
        this.txtName.setMaxLength(80);
        this.transState.setBackground(NECESSARYCOLOR);
        this.txtaddress.setMaxLength(80);
        WarehouseEditUI.setStorageOrgF7(this.prmtstorageOrg);
        this.prmtstorageOrg.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                WarehouseEditUI.this.storageOrgChange(e);
            }
        });
        this.prmtwhman.setEditable(true);
        this.prmtwhman.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        this.prmtwhman.setDisplayFormat("$name$");
        this.prmtwhman.setEditFormat("$number$");
        this.prmtwhman.setCommitFormat("$number$;$idNum$");
        this.prmtwhman.setHasCUDefaultFilter(false);
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("0", "1");
        hash.put("DEFAULT_SHOW_ALL", "YES");
        hash.put("IS_SINGLE_SELECT", new Boolean(true));
        hash.put("0", "2");
        String adminUnitId = null;
        if (this.editData != null && this.editData.getStorageOrg() != null) {
            adminUnitId = WarehouseEditUI.getAdminOrgUnitInfo(this.editData.getStorageOrg().getId().toString());
        }
        if (adminUnitId == null && SysContext.getSysContext().getCurrentAdminUnit() != null) {
            adminUnitId = SysContext.getSysContext().getCurrentAdminUnit().getId().toString();
        }
        if (adminUnitId != null) {
            hash.put("ADMIN_ID", adminUnitId);
        }
        PersonPromptBox box = new PersonPromptBox((IUIObject)this, hash);
        box.showAllAdmin();
        this.prmtwhman.setSelector((KDPromptSelector)box);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        IWarehouse iFactory;
        StorageOrgUnitInfo sou;
        String message = null;
        if (this.prmtstorageOrg.getValue() == null) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.WarehouseEditUI_StorageOrgIsNull");
            this.prmtstorageOrg.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        if (this.prmtstorageOrg.getText() != null && this.prmtstorageOrg.getText().trim().length() > 0 && this.prmtstorageOrg.getValue() != null && !(sou = (StorageOrgUnitInfo)this.prmtstorageOrg.getValue()).isIsBizUnit()) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.StorageOrgUnitNotIsBizUnit");
            this.prmtstorageOrg.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0 && this.isCheckNumber()) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.WarehouseEditUI_WarehouseNumberIsNull");
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            iFactory = WarehouseFactory.getRemoteInstance();
            this.editData.setNumber(this.txtNumber.getText().trim());
            this.txtNumber.requestFocus();
            iFactory.checkNumberDup((DataBaseInfo)this.editData);
        }
        if (this.txtName.getEditor().getItem() == null || this.txtName.getEditor().getItem().toString().trim().length() == 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.WarehouseEditUI_WarehouseNameIsNull");
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            iFactory = WarehouseFactory.getRemoteInstance();
            this.editData.setName(this.txtName.getEditor().getItem().toString().trim());
            this.editData.setStorageOrg((StorageOrgUnitInfo)this.prmtstorageOrg.getValue());
            this.txtName.requestFocus();
            iFactory.checkNameDup((DataBaseInfo)this.editData);
        }
        if (this.prmtregion.getText() == null || this.prmtregion.getText().trim().length() == 0 || this.prmtregion.getValue() == null) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.WarehouseEditUI_RegionIsNull");
            this.prmtregion.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        if (this.transState.getSelectedIndex() < 0) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.WarehouseEditUI_TransStateIsNull");
            this.transState.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("storageOrg.id"));
        sic.add(new SelectorItemInfo("storageOrg.name"));
        sic.add(new SelectorItemInfo("storageOrg.number"));
        sic.add(new SelectorItemInfo("defaultLocationGroup.*"));
        return sic;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setControlState();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        this.setNumberEnabled();
    }

    private void setControlState() {
        boolean isEditable = false;
        try {
            isEditable = WarehouseFactory.getRemoteInstance().checkIsEditable((IObjectValue)this.editData);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (UuidException e) {
            this.handUIException(e);
        }
        if (this.editData.getWhState().equals((Object)WHStateEnum.ACTIVE) && !this.isCopy) {
            this.transState.setEnabled(false);
            this.chkhasLocation.setEnabled(false);
            if (this.chkhasLocation.isSelected()) {
                this.chkhasLocationLevel.setEnabled(true);
            } else {
                this.chkhasLocationLevel.setEnabled(false);
            }
            this.txtNumber.setEnabled(false);
            this.prmtstorageOrg.setEnabled(false);
        } else if (this.editData.getWhState().equals((Object)WHStateEnum.INACTIVE)) {
            this.transState.setEnabled(true);
            this.chkhasLocation.setEnabled(isEditable);
            this.txtNumber.setEnabled(isEditable);
            this.prmtstorageOrg.setEnabled(isEditable);
        } else {
            this.transState.setEnabled(true);
            this.chkhasLocation.setEnabled(true);
            if (this.chkhasLocation.isSelected()) {
                this.chkhasLocationLevel.setEnabled(true);
            } else {
                this.chkhasLocationLevel.setEnabled(false);
            }
            this.txtNumber.setEnabled(true);
            this.prmtstorageOrg.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if ("ADDNEW".equals(this.getOprtState()) && dataObject.get("id") == null) {
            dataObject.put("storageOrg", this.getUIContext().get("storageOrg"));
            dataObject.put("whState", this.getUIContext().get("whState"));
        }
        super.setDataObject(dataObject);
    }

    @Override
    protected String getEditUIName() {
        return WarehouseEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return WarehouseFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        WarehouseInfo objectValue = new WarehouseInfo();
        objectValue.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return objectValue;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        StorageOrgUnitInfo sou;
        DataBaseCheckPermissionUtil.checkCanAddnew("S3", this.currentCUID);
        super.actionAddNew_actionPerformed(e);
        String message = null;
        if (this.prmtstorageOrg.getText() != null && this.prmtstorageOrg.getText().trim().length() > 0 && this.prmtstorageOrg.getValue() != null && !(sou = (StorageOrgUnitInfo)this.prmtstorageOrg.getValue()).isIsBizUnit()) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.StorageOrgUnitNotIsBizUnit");
            this.prmtstorageOrg.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
        this.setNumberEnabled();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        IWarehouse iw = WarehouseFactory.getRemoteInstance();
        WarehouseInfo wi = iw.getWarehouseInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        String cuid = wi.getCU().getId().toString();
        if (cuid != null) {
            DataBaseCheckPermissionUtil.checkCanEdit("S3", this.currentCUID, cuid);
        }
        super.actionEdit_actionPerformed(e);
        this.setControlState();
        this.setNumberEnabled();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        IWarehouse iw = WarehouseFactory.getRemoteInstance();
        WarehouseInfo wi = iw.getWarehouseInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        String cuid = BDInvClientUtils.getCUID((DataBaseInfo)wi);
        if (cuid != null) {
            DataBaseCheckPermissionUtil.checkCanRemove("S3", this.currentCUID, cuid);
        }
        if (!this.editData.getWhState().equals((Object)WHStateEnum.SAVED)) {
            String message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.DelActiveWH");
            MsgBox.showInfo((Component)((Object)this), (String)message);
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    public static String getAdminOrgUnitInfo(String orgID) throws Exception {
        ObjectUuidPK pk;
        if (orgID == null || orgID.length() == 0) {
            return null;
        }
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        FullOrgUnitInfo aFullOrgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)(pk = new ObjectUuidPK(orgID)));
        if (aFullOrgUnitInfo.isIsAdminOrgUnit()) {
            return orgID;
        }
        String parentID = aFullOrgUnitInfo.getParent().getId().toString();
        return WarehouseEditUI.getAdminOrgUnitInfo(parentID);
    }

    private static void setStorageOrgF7(KDBizPromptBox f7) throws Exception {
        NewOrgUnitFilterInfoProducer oufip = new NewOrgUnitFilterInfoProducer(OrgType.Storage);
        oufip.getModel().setIsCUFilter(false);
        f7.setFilterInfoProducer((IFilterInfoProducer)oufip);
    }

    public void storageOrgChange(DataChangeEvent e) {
        try {
            HashMap<String, Object> hash = new HashMap<String, Object>();
            hash.put("0", "1");
            hash.put("DEFAULT_SHOW_ALL", "YES");
            hash.put("IS_SINGLE_SELECT", new Boolean(true));
            hash.put("0", "2");
            String adminUnitId = null;
            if (e.getNewValue() != null) {
                adminUnitId = WarehouseEditUI.getAdminOrgUnitInfo(((StorageOrgUnitInfo)e.getNewValue()).getId().toString());
            }
            if (adminUnitId == null && SysContext.getSysContext().getCurrentAdminUnit() != null) {
                adminUnitId = SysContext.getSysContext().getCurrentAdminUnit().getId().toString();
            }
            if (adminUnitId != null) {
                hash.put("ADMIN_ID", adminUnitId);
            }
            PersonPromptBox box = new PersonPromptBox((IUIObject)this, hash);
            box.showAllAdmin();
            this.prmtwhman.setSelector((KDPromptSelector)box);
        }
        catch (Exception e2) {
            this.handUIException(e2);
        }
    }

    @Override
    protected void chkhasLocation_stateChanged(ChangeEvent e) throws Exception {
        if ("ADDNEW".equals(this.getOprtState())) {
            this.chkhasLocationLevel.setEnabled(this.chkhasLocation.isSelected());
            if (!this.chkhasLocation.isSelected()) {
                this.chkhasLocationLevel.setSelected(false);
            }
        } else if ("EDIT".equals(this.getOprtState())) {
            this.chkhasLocationLevel.setEnabled(this.chkhasLocation.isSelected());
            if (!this.chkhasLocation.isSelected()) {
                this.chkhasLocationLevel.setSelected(false);
            }
        }
    }

    public void setNumberEnabled() {
        if (this.editData == null) {
            return;
        }
        try {
            boolean isAddView;
            boolean isAutoNumber = this.isAutoNumber();
            if (this.getOprtState().equals("ADDNEW") && isAutoNumber && (isAddView = this.isAddView()) && StringUtils.isEmpty((String)this.txtNumber.getText())) {
                this.txtNumber.setText(FrameWorkUtils.getCodeRuleClient((CoreBaseInfo)this.editData, (String)this.editData.getCU().getId().toString()));
                this.editData.setNumber(this.txtNumber.getText());
                this.initOldData((IObjectValue)this.editData);
            }
            this.txtNumber.setEditable(!isAutoNumber);
            this.txtNumber.setRequired(!isAutoNumber);
            if (isAutoNumber) {
                this.txtNumber.requestFocus();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected boolean isAutoNumber() throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        return iCodingRuleManager.isExist((IObjectValue)this.editData, this.currentCUID.toString());
    }

    protected boolean isAddView() throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        return iCodingRuleManager.isAddView((IObjectValue)this.editData, this.currentCUID);
    }

    private boolean isCheckNumber() throws CodingRuleException, EASBizException, BOSException {
        return !this.isAutoNumber() || this.isAddView();
    }
}

