/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.im.inv.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.client.BDInvClientUtils;
import com.kingdee.eas.basedata.scm.common.util.DataBaseCheckPermissionUtil;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.WHStateEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.im.inv.client.AbstractWarehouseListUI;
import com.kingdee.eas.basedata.scm.im.inv.client.WarehouseEditUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WarehouseListUI
extends AbstractWarehouseListUI
implements TreeSelectionListener {
    private String currentCUID;
    private static final String ACTION_ACTIVEWH = "ACTION_ACTIVEWH";
    private static final String ACTION_INACTIVEWH = "ACTION_INACTIVEWH";
    private static final String res = "com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.";
    private static final String TB_State = "whState";
    private String cuUnisTable = "";
    FullOrgUnitInfo parentInfo = null;

    public String getUITitle() {
        String strTitle = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.Warehouse");
        return strTitle;
    }

    @Override
    public void initUIContentLayout() {
        this.setBounds(new Rectangle(0, 0, 620, 270));
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, 620, 270));
        this.kDSplitPane1.setBounds(new Rectangle(10, 10, 600, 250));
        this.add((Component)this.kDSplitPane1, new KDLayout.Constraints(10, 10, 600, 250, 15));
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                int selectRow = e.getSelectBlock().getBeginRow();
                if ("1".equals(((BizEnumValueDTO)WarehouseListUI.this.tblMain.getRow(selectRow).getCell(WarehouseListUI.TB_State).getValue()).getValue())) {
                    WarehouseListUI.this.btnEdit.setEnabled(false);
                } else {
                    WarehouseListUI.this.btnEdit.setEnabled(true);
                }
            }
        });
        this.kDSplitPane1.add((Component)this.tblMain, (Object)"right");
        this.kDSplitPane1.add((Component)this.pnlStorageOrg, (Object)"left");
        this.pnlStorageOrg.setLayout((LayoutManager)new KDLayout());
        this.pnlStorageOrg.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 215, 250));
        this.kDTreeView1.setBounds(new Rectangle(0, 0, 215, 250));
        this.pnlStorageOrg.add((Component)this.kDTreeView1, (Object)new KDLayout.Constraints(0, 0, 215, 250, 15));
        this.kDTreeView1.setTree(this.treeMain);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        DefaultKingdeeTreeNode treeNode = NewOrgViewFacadeFactory.getRemoteInstance().getViewDirectChildNodesByMultiCondition(OrgViewType.STORAGE, null, false, false, null, true, true, null, null, null);
        ((OrgStructureInfo)treeNode.getUserObject()).put("alreadyLoad", (Object)true);
        this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)treeNode){

            @Override
            public boolean isLeaf(Object node) {
                DefaultKingdeeTreeNode tmpNode = (DefaultKingdeeTreeNode)node;
                OrgStructureInfo info = (OrgStructureInfo)tmpNode.getUserObject();
                if (tmpNode.getChildCount() > 0) {
                    return false;
                }
                return info == null || info.get("isleaf") != null && (Boolean)info.get("isleaf") == true;
            }
        });
        this.treeMain.setShowsRootHandles(true);
        this.treeMain.addTreeSelectionListener((TreeSelectionListener)this);
        this.treeMain.setSelectionNode(treeNode);
        this.addRootNode();
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        if (!this.btnAttachment.isVisible()) {
            this.separatorFile1.setVisible(false);
        }
        this.onload_stepAddTreeData();
        this.menuItemImportData.setVisible(true);
        this.menuItemExportData.setVisible(true);
    }

    private void addRootNode() throws Exception {
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot();
        DefaultKingdeeTreeNode rootTreeNode = null;
        StorageOrgUnitInfo sou = WarehouseListUI.createRootSouInfo();
        rootTreeNode = new DefaultKingdeeTreeNode((Object)sou);
        this.treeMain.addNodeInto((MutableTreeNode)rootNode, (MutableTreeNode)rootTreeNode);
        this.treeMain.setModel((TreeModel)new DefaultTreeModel((TreeNode)rootTreeNode){

            @Override
            public boolean isLeaf(Object node) {
                DefaultKingdeeTreeNode tmpNode = (DefaultKingdeeTreeNode)node;
                CoreBaseInfo info = (CoreBaseInfo)tmpNode.getUserObject();
                if (tmpNode.getChildCount() > 0) {
                    return false;
                }
                return info == null || info.get("isleaf") != null && (Boolean)info.get("isleaf") == true;
            }
        });
        this.treeMain.setSelectionNode(rootTreeNode);
    }

    private static StorageOrgUnitInfo createRootSouInfo() throws Exception {
        StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
        sou.setId(BOSUuid.read((String)"111111111111111111111111111="));
        sou.setName(EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.ShowAll"));
        sou.setNumber("$all$");
        sou.setLevel(0);
        return sou;
    }

    @Override
    public void valueChanged(TreeSelectionEvent arg0) {
        if (arg0.getNewLeadSelectionPath() != null) {
            try {
                this.refresh(null);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        try {
            if (this.treeMain.getSelectionPath() == null) {
                return exec;
            }
            TreePath treePath = this.treeMain.getSelectionPath();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
            FilterInfo filter = viewInfo.getFilter();
            boolean isAuthorized = false;
            int no = 0;
            int row = 0;
            if (filter != null) {
                int i;
                FilterItemCollection sic = filter.getFilterItems();
                boolean hasSouFilter = false;
                boolean hasLongNumberFilter = false;
                for (i = 0; i < sic.size(); ++i) {
                    FilterItemInfo itemInfo = sic.get(i);
                    if (!itemInfo.getPropertyName().equals("storageOrg.id")) continue;
                    if (CompareType.INNER.equals((Object)itemInfo.getCompareType())) {
                        isAuthorized = true;
                        continue;
                    }
                    hasSouFilter = true;
                    no = i;
                }
                if (hasSouFilter) {
                    filter.getFilterItems().removeObject(no);
                    String mask = filter.getMaskString();
                    if (mask != null) {
                        int point = mask.lastIndexOf("#");
                        if (point > 4) {
                            mask = mask.substring(0, point - 4);
                        }
                        filter.setMaskString(mask);
                    }
                }
                for (i = 0; i < sic.size(); ++i) {
                    if (!sic.get(i).getPropertyName().equals("storageOrg.longNumber")) continue;
                    hasLongNumberFilter = true;
                    row = i;
                    break;
                }
                if (hasLongNumberFilter) {
                    filter.getFilterItems().removeObject(row);
                    String mask = filter.getMaskString();
                    if (mask != null) {
                        int point = mask.lastIndexOf("#");
                        if (point > 4) {
                            mask = mask.substring(0, point - 4);
                        }
                        filter.setMaskString(mask);
                    }
                }
            }
            Object o = node.getUserObject();
            if (!isAuthorized) {
                this.cuUnisTable = this.getAuthorizedOrgsNew();
            }
            if (o instanceof StorageOrgUnitInfo) {
                if (filter == null) {
                    filter = new FilterInfo();
                }
                if (!isAuthorized) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("select fstorageorgunitid from ").append(this.cuUnisTable);
                    filter.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)sql.toString(), CompareType.INNER));
                }
                viewInfo.setFilter(filter);
            } else {
                OrgStructureInfo sou = (OrgStructureInfo)node.getUserObject();
                if (sou != null) {
                    FullOrgUnitInfo foui = (FullOrgUnitInfo)sou.get("Unit");
                    ObjectUuidPK pk = new ObjectUuidPK(foui.getBOSUuid("id"));
                    IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getRemoteInstance();
                    StorageOrgUnitInfo storageOrgUnitInfo = iStorageOrgUnit.getStorageOrgUnitInfo((IObjectPK)pk);
                    if (sou.getLevel() > 1) {
                        if (filter == null) {
                            filter = new FilterInfo();
                        }
                        if (storageOrgUnitInfo.isIsLeaf()) {
                            filter.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)storageOrgUnitInfo.getId(), CompareType.EQUALS));
                        } else {
                            String longNumer = storageOrgUnitInfo.getLongNumber();
                            if (!StringUtil.isEmpty((String)longNumer)) {
                                filter.getFilterItems().add(new FilterItemInfo("storageOrg.longNumber", (Object)(longNumer + "%"), CompareType.LIKE));
                            }
                        }
                    }
                    if (filter != null) {
                        int size;
                        if (!isAuthorized) {
                            StringBuffer sql = new StringBuffer();
                            sql.append("select fstorageorgunitid from ").append(this.cuUnisTable);
                            filter.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)sql.toString(), CompareType.INNER));
                        }
                        if ((size = filter.getFilterItems().size()) > 1) {
                            String mask = filter.getMaskString();
                            if (mask == null) {
                                mask = "#0";
                            }
                            mask = mask + " and #" + (size - 1);
                            filter.setMaskString(mask);
                        }
                        viewInfo.setFilter(filter);
                    }
                }
            }
            exec = super.getQueryExecutor(queryPK, viewInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return exec;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return WarehouseEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return WarehouseFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    protected IObjectValue createNewData() {
        WarehouseInfo objectValue = new WarehouseInfo();
        return objectValue;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        dataObject.containsKey("storageOrg");
        super.setDataObject(dataObject);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (node != null) {
            try {
                OrgStructureInfo sou = (OrgStructureInfo)node.getUserObject();
                FullOrgUnitInfo foui = (FullOrgUnitInfo)sou.get("Unit");
                ObjectUuidPK pk = new ObjectUuidPK(foui.getBOSUuid("id"));
                IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getRemoteInstance();
                StorageOrgUnitInfo storageOrgUnitInfo = iStorageOrgUnit.getStorageOrgUnitInfo((IObjectPK)pk);
                uiContext.put((Object)"storageOrg", (Object)storageOrgUnitInfo);
            }
            catch (Exception exception) {}
        } else {
            uiContext.put((Object)"storageOrg", null);
        }
        uiContext.put((Object)TB_State, (Object)"0");
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    private void checkObjectExists(IObjectPK pk) throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists(pk)) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    public static void checkCanActiveWh(String controlType, String currentCUID, String dataCUID) throws Exception {
        WarehouseListUI.checkPermission(ACTION_ACTIVEWH, controlType, currentCUID, dataCUID);
    }

    public static void checkCanInActiveWh(String controlType, String currentCUID, String dataCUID) throws Exception {
        WarehouseListUI.checkPermission(ACTION_INACTIVEWH, controlType, currentCUID, dataCUID);
    }

    private static void checkPermission(String action, String controlType, String currentCUID, String dataCUID) throws Exception {
        if ((controlType.equalsIgnoreCase("S3") || controlType.equalsIgnoreCase("S4")) && !currentCUID.equals(dataCUID)) {
            WarehouseListUI.throwsExceptionForNoPermission(action);
        }
    }

    private static void throwsExceptionForNoPermission(String action) throws Exception {
        String msg = new String();
        if (action.equals(ACTION_ACTIVEWH)) {
            msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.CAN_NOT_ACTIVEWH");
        } else if (action.equals(ACTION_INACTIVEWH)) {
            msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.CAN_NOT_INACTIVEWH");
        }
        if (msg.length() > 0) {
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    public void actionActiveWh_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.btnEdit.setEnabled(false);
        ArrayList ids = super.getSelectedIdValues();
        IWarehouse iWarehouse = WarehouseFactory.getRemoteInstance();
        StringBuffer errMsg = new StringBuffer();
        String s1 = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Delete_0");
        String s2 = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Delete_1");
        String forbidError = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.Msg_Start_Error");
        int num = ids.size();
        for (int i = 0; i < num; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)ids.get(i).toString()));
            this.checkObjectExists((IObjectPK)pk);
            WarehouseInfo aWarehouseInfo = iWarehouse.getWarehouseInfo((IObjectPK)pk);
            String cuid = BDInvClientUtils.getCUID((DataBaseInfo)aWarehouseInfo);
            if (cuid != null) {
                WarehouseListUI.checkCanActiveWh("S3", this.currentCUID, cuid);
            }
            try {
                iWarehouse.setActiveWh((IObjectPK)pk);
                continue;
            }
            catch (EASBizException ex) {
                errMsg.append(s1);
                errMsg.append(i + 1);
                errMsg.append(s2);
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
        }
        try {
            HashSet pkList = new HashSet();
            pkList.addAll(ids);
            iWarehouse.setDefaultLocationGroup(pkList);
        }
        catch (EASBizException easExc) {
            this.handUIException(easExc);
        }
        if (errMsg.toString().length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)forbidError, (String)errMsg.toString(), (int)8188);
        }
        this.refresh(null);
    }

    public void actionINActiveWh_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.btnEdit.setEnabled(true);
        ArrayList ids = super.getSelectedIdValues();
        IWarehouse iWarehouse = WarehouseFactory.getRemoteInstance();
        StringBuffer errMsg = new StringBuffer();
        String s1 = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Delete_0");
        String s2 = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Delete_1");
        String forbidError = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.Msg_Forbid_Error");
        int num = ids.size();
        for (int i = 0; i < num; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)ids.get(i).toString()));
            this.checkObjectExists((IObjectPK)pk);
            WarehouseInfo aWarehouseInfo = iWarehouse.getWarehouseInfo((IObjectPK)pk);
            String cuid = BDInvClientUtils.getCUID((DataBaseInfo)aWarehouseInfo);
            if (cuid != null) {
                WarehouseListUI.checkCanInActiveWh("S3", this.currentCUID, cuid);
            }
            try {
                iWarehouse.setINActiveWh((IObjectPK)pk);
                continue;
            }
            catch (EASBizException ex) {
                errMsg.append(s1);
                errMsg.append(i + 1);
                errMsg.append(s2);
                errMsg.append(ex.getMessage());
                errMsg.append("\n");
            }
        }
        if (errMsg.toString().length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)forbidError, (String)errMsg.toString(), (int)8188);
        }
        this.refresh(null);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        DataBaseCheckPermissionUtil.checkCanAddnew("S3", this.currentCUID);
        if (this.treeMain.getSelectionPath() != null) {
            TreePath treePath = this.treeMain.getSelectionPath();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
            String message = null;
            Object o = node.getUserObject();
            if (o instanceof StorageOrgUnitInfo) {
                StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)o;
                if (storageOrgUnitInfo != null && !storageOrgUnitInfo.isIsBizUnit()) {
                    message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.StorageOrgUnitNotIsBizUnit");
                    MsgBox.showInfo((Component)((Object)this), (String)message);
                    SysUtil.abort();
                }
            } else {
                OrgStructureInfo sou = (OrgStructureInfo)node.getUserObject();
                if (sou != null) {
                    FullOrgUnitInfo foui = (FullOrgUnitInfo)sou.get("Unit");
                    ObjectUuidPK pk = new ObjectUuidPK(foui.getBOSUuid("id"));
                    IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getRemoteInstance();
                    StorageOrgUnitInfo storageOrgUnitInfo = iStorageOrgUnit.getStorageOrgUnitInfo((IObjectPK)pk);
                    if (!storageOrgUnitInfo.isIsBizUnit()) {
                        message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.StorageOrgUnitNotIsBizUnit");
                        MsgBox.showInfo((Component)((Object)this), (String)message);
                        SysUtil.abort();
                    }
                }
            }
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        IWarehouse iw = WarehouseFactory.getRemoteInstance();
        WarehouseInfo wi = iw.getWarehouseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())));
        String cuid = BDInvClientUtils.getCUID((DataBaseInfo)wi);
        if (cuid != null) {
            DataBaseCheckPermissionUtil.checkCanEdit("S3", this.currentCUID, cuid);
        }
        super.actionEdit_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            ArrayList ids = super.getSelectedIdValues();
            IWarehouse iWarehouse = WarehouseFactory.getRemoteInstance();
            int num = ids.size();
            for (int i = 0; i < num; ++i) {
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)ids.get(i).toString()));
                this.checkObjectExists((IObjectPK)pk);
                WarehouseInfo aWarehouseInfo = iWarehouse.getWarehouseInfo((IObjectPK)pk);
                String cuid = BDInvClientUtils.getCUID((DataBaseInfo)aWarehouseInfo);
                if (cuid != null) {
                    DataBaseCheckPermissionUtil.checkCanRemove("S3", this.currentCUID, cuid);
                }
                if (!aWarehouseInfo.getWhState().equals((Object)WHStateEnum.SAVED)) {
                    String message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.DelActiveWH");
                    MsgBox.showWarning((String)message);
                    return;
                }
                String selectID = null;
                try {
                    this.setOprtState("REMOVE");
                    selectID = ids.get(i).toString();
                    this.pubFireVOChangeListener(selectID);
                }
                catch (Throwable ex) {
                    this.handUIException(ex);
                    this.abort();
                }
                try {
                    iWarehouse.delete((IObjectPK)pk);
                    this.pubFireVOChangeListener(selectID);
                    continue;
                }
                catch (Throwable e1) {
                    this.handUIException(e1);
                    this.abort();
                    continue;
                }
                finally {
                    try {
                        this.setOprtState("RELEASEALL");
                        this.pubFireVOChangeListener(selectID);
                    }
                    catch (Throwable e1) {
                        this.handUIException(e1);
                        this.abort();
                    }
                }
            }
        }
        this.refresh(null);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionINActiveWh_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionActiveWh_actionPerformed(e);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private void onload_stepAddTreeData() {
        this.treeMain.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode tmp = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (tmp == null || tmp.getLevel() == 0 && EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.ShowAll").equals(tmp.getText())) {
                    return;
                }
                try {
                    WarehouseListUI.this.loadNode(tmp);
                }
                catch (Exception e) {
                    WarehouseListUI.this.handUIException(e);
                }
            }
        });
    }

    private void loadNode(DefaultKingdeeTreeNode tmp) throws Exception {
        OrgStructureInfo unitInfo;
        if (tmp != null && tmp.getUserObject() != null && (unitInfo = (OrgStructureInfo)tmp.getUserObject()).get("alreadyLoad") == null) {
            List orgCol = NewOrgViewFacadeFactory.getRemoteInstance().getViewDirectChildNodes(this.getTreeID(), unitInfo, false, false, false);
            ArrayList<OrgStructureInfo> authorizedOrgsList = new ArrayList<OrgStructureInfo>();
            Set authorizedOrgSet = this.getAuthorizedOrgs();
            OrgStructureInfo info = null;
            int size = orgCol.size();
            for (int i = 0; i < size; ++i) {
                if (orgCol.get(i) == null || (info = (OrgStructureInfo)orgCol.get(i)).getUnit() == null || !authorizedOrgSet.contains(info.getUnit().getId().toString())) continue;
                authorizedOrgsList.add(info);
            }
            this.insertNodeIntoRoot(tmp, authorizedOrgsList);
            unitInfo.put("alreadyLoad", (Object)true);
        }
    }

    private String getTreeID() {
        return NewOrgViewHelper.convert2TreeId((OrgViewType)OrgViewType.STORAGE);
    }

    private void insertNodeIntoRoot(DefaultKingdeeTreeNode root, List orgCol) {
        for (int i = 0; i < orgCol.size(); ++i) {
            OrgStructureInfo info = (OrgStructureInfo)orgCol.get(i);
            KDTreeNode treeNode = new KDTreeNode((Object)info);
            root.add((MutableTreeNode)treeNode);
        }
    }

    private Set getAuthorizedOrgs() throws EASBizException, BOSException {
        Set orgUnitSet = new HashSet();
        try {
            orgUnitSet = ((IWarehouse)this.getBizInterface()).getAuthorizedOrgs();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return orgUnitSet;
    }

    private String getAuthorizedOrgsNew() throws EASBizException, BOSException {
        String temptable = null;
        try {
            temptable = ((IWarehouse)this.getBizInterface()).getAuthorizedOrgsNew();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return temptable;
    }

    protected void disposeUIWindow() {
        try {
            ((IWarehouse)this.getBizInterface()).releaseTempTable(this.cuUnisTable);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        super.disposeUIWindow();
    }

    protected boolean isShowAttachmentAction() {
        return true;
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "scm.im.Warehouse";
        param.datataskMode = 1;
        param.varList = new ArrayList();
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "scm.im.Warehouse";
        param.alias = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.Warehouse");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }
}

