/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.channel.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.client.CSSPGroupPrompt;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.sd.channel.CustomersMRDimensionEnum;
import com.kingdee.eas.basedata.scm.sd.channel.client.AbstractCustomersMaterialsRelationQueryUI;
import com.kingdee.eas.basedata.scm.sd.channel.client.MaterialGroupPrompt;
import com.kingdee.eas.basedata.scm.sd.channel.client.support.customersmr.CustomersMRDimension;
import com.kingdee.eas.basedata.scm.sd.channel.common.CustomersMaterialsRelationUtils;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CustomersMaterialsRelationQueryUI
extends AbstractCustomersMaterialsRelationQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(CustomersMaterialsRelationQueryUI.class);
    private boolean isMaterialDimension = true;
    private CustomersMRDimensionEnum currentDimensionEnum;
    private ChangeListener promptGroupChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            CustomersMaterialsRelationQueryUI.this.promptGroup_stateChanged(e);
        }
    };
    private ChangeListener promptBizBoxChangeListener;

    public CustomersMaterialsRelationQueryUI() throws Exception {
        this.promptGroup.addChangeListener(this.promptGroupChangeListener);
        this.promptBizBoxChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CustomersMaterialsRelationQueryUI.this.promptBizBox_stateChanged(e);
            }
        };
        this.promptBizBox.addChangeListener(this.promptBizBoxChangeListener);
    }

    public void initData(CustomersMRDimension currentDimension, KDComboBox comboDimensions) {
        CustomersMRDimensionEnum customersMRDimensionEnum = (CustomersMRDimensionEnum)((Object)comboDimensions.getSelectedItem());
        if (null == this.currentDimensionEnum || this.currentDimensionEnum.getValue() != customersMRDimensionEnum.getValue()) {
            this.isMaterialDimension = 1 != customersMRDimensionEnum.getValue();
            this.clear();
            this.initComponents(comboDimensions, this.isMaterialDimension);
            this.currentDimensionEnum = customersMRDimensionEnum;
        }
    }

    private void promptGroup_stateChanged(ChangeEvent e) {
        this.promptBizBox.removeChangeListener(this.promptBizBoxChangeListener);
        this.promptBizBox.setValue(null);
        this.promptBizBox.addChangeListener(this.promptBizBoxChangeListener);
    }

    private void promptBizBox_stateChanged(ChangeEvent e) {
        this.promptGroup.removeChangeListener(this.promptGroupChangeListener);
        this.promptGroup.setValue(null);
        this.promptGroup.addChangeListener(this.promptGroupChangeListener);
    }

    private void initComponents(KDComboBox comboDimensions, boolean isMaterialDimension) {
        if (isMaterialDimension) {
            this.initCustomerGroupF7();
            this.initBizCustomerBox();
            this.setCustomerFilter();
            this.setCustomerText();
        } else {
            this.initBizMaterialGroup();
            this.initBizMaterialBox();
            this.setMaterialFilter();
            this.setMaterialText();
        }
    }

    private void setCustomerText() {
        this.kDLabelGroup.setBoundLabelText(CustomersMaterialsRelationUtils.getUICommonResource(null, "CUSTOMERGROUP"));
        this.kDLabelBizBox.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"customer"));
    }

    private void setMaterialText() {
        this.kDLabelGroup.setBoundLabelText(CustomersMaterialsRelationUtils.getUICommonResource(null, "MATERIALGROUP"));
        this.kDLabelBizBox.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"material"));
    }

    private void setCustomerFilter() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleFilterElement("customerGroup.number", (Component)this.promptGroup));
        elements.add((FilterElement)new SingleFilterElement("customer.number", (Component)this.promptBizBox));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    private void setMaterialFilter() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        elements.add((FilterElement)new SingleFilterElement("materialGroup.number", (Component)this.promptGroup));
        elements.add((FilterElement)new SingleFilterElement("material.number", (Component)this.promptBizBox));
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.isMaterialDimension) {
            CSSPGroupInfo info;
            if (this.promptGroup.getValue() != null) {
                info = (CSSPGroupInfo)this.promptGroup.getValue();
                filterInfo.getFilterItems().add(new FilterItemInfo("customerGroup.longnumber", (Object)(info.getLongNumber() + "!" + "%"), CompareType.LIKE));
                filterInfo.getFilterItems().add(new FilterItemInfo("customerGroup.longnumber", (Object)info.getLongNumber()));
                filterInfo.setMaskString("(#0 OR #1)");
            }
            if (this.promptBizBox.getValue() != null && this.promptBizBox.getValue() instanceof CustomerInfo) {
                info = (CustomerInfo)this.promptBizBox.getValue();
                filterInfo.getFilterItems().add(new FilterItemInfo("customer.number", (Object)info.getNumber()));
            }
            if (this.promptBizBox.getValue() != null && this.promptBizBox.getValue() instanceof CustomerInfo[]) {
                CustomerInfo[] infos = (CustomerInfo[])this.promptBizBox.getValue();
                HashSet<String> customerNumbers = new HashSet<String>();
                int len = infos.length;
                for (int i = 0; i < len; ++i) {
                    customerNumbers.add(infos[i].getNumber());
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("customer.number", customerNumbers, CompareType.INCLUDE));
            }
        } else {
            MaterialGroupInfo info;
            if (this.promptGroup.getValue() != null) {
                info = (MaterialGroupInfo)this.promptGroup.getValue();
                filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.longnumber", (Object)(info.getLongNumber() + "!" + "%"), CompareType.LIKE));
                filterInfo.getFilterItems().add(new FilterItemInfo("materialGroup.longnumber", (Object)info.getLongNumber()));
                filterInfo.setMaskString("(#0 OR #1)");
            }
            if (this.promptBizBox.getValue() != null && this.promptBizBox.getValue() instanceof MaterialInfo) {
                info = (MaterialInfo)this.promptBizBox.getValue();
                filterInfo.getFilterItems().add(new FilterItemInfo("material.number", (Object)info.getNumber()));
            }
            if (this.promptBizBox.getValue() != null && this.promptBizBox.getValue() instanceof MaterialInfo[]) {
                MaterialInfo[] infos = (MaterialInfo[])this.promptBizBox.getValue();
                HashSet<String> materialNumbers = new HashSet<String>();
                int len = infos.length;
                for (int i = 0; i < len; ++i) {
                    materialNumbers.add(infos[i].getNumber());
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("material.number", materialNumbers, CompareType.INCLUDE));
            }
        }
        return filterInfo;
    }

    private void initCustomerGroupF7() {
        this.promptGroup.setEditFormat("$number$");
        this.promptGroup.setDisplayFormat("$number$");
        this.promptGroup.setCommitFormat("$number$;$code$");
        this.promptGroup.setEnabledMultiSelection(false);
        CSSPGroupPrompt selectorLisenterCustomerGroup = new CSSPGroupPrompt((IUIObject)this, 1);
        this.promptGroup.setSelector((KDPromptSelector)selectorLisenterCustomerGroup);
    }

    private void initBizMaterialGroup() {
        this.promptGroup.setEditFormat("$number$");
        this.promptGroup.setDisplayFormat("$number$");
        this.promptGroup.setCommitFormat("$number$;$code$");
        this.promptGroup.setEnabledMultiSelection(false);
        MaterialGroupPrompt groupBox = new MaterialGroupPrompt((IUIObject)this);
        this.promptGroup.setSelector((KDPromptSelector)groupBox);
    }

    private void initBizMaterialBox() {
        this.promptBizBox.setEditFormat("$number$");
        this.promptBizBox.setDisplayFormat("$number$");
        this.promptBizBox.setCommitFormat("$number$;$code$");
        this.promptBizBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialQuery");
        GeneralKDPromptSelectorAdaptor selectorLisenterMaterial = new GeneralKDPromptSelectorAdaptor((KDPromptBox)this.promptBizBox, "com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI", (Object)this, MaterialGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.material.app.F7MaterialQuery", "materialGroup.id", "");
        selectorLisenterMaterial.setIsMultiSelect(true);
        this.promptBizBox.setSelector((KDPromptSelector)selectorLisenterMaterial);
        this.promptBizBox.addSelectorListener((SelectorListener)selectorLisenterMaterial);
    }

    private void initBizCustomerBox() {
        this.promptBizBox.setEditFormat("$number$");
        this.promptBizBox.setDisplayFormat("$number$");
        this.promptBizBox.setCommitFormat("$number$;$code$");
        this.promptBizBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerQueryWithDefaultStandard");
        GeneralKDPromptSelectorAdaptor selectorLisenterCustomer = new GeneralKDPromptSelectorAdaptor((KDPromptBox)this.promptBizBox, "com.kingdee.eas.basedata.master.cssp.client.F7CustomerTreeDetailListUI", (Object)this, CSSPGroupInfo.getBosType(), "com.kingdee.eas.basedata.master.cssp.app.F7CustomerQueryWithDefaultStandard", "browseGroup.id", "");
        selectorLisenterCustomer.setIsMultiSelect(true);
        this.promptBizBox.setSelector((KDPromptSelector)selectorLisenterCustomer);
        this.promptBizBox.addSelectorListener((SelectorListener)selectorLisenterCustomer);
    }
}

