/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.channel.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDImageIcon;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfo;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialBaseException;
import com.kingdee.eas.basedata.master.material.client.PictureFilter;
import com.kingdee.eas.basedata.scm.sd.channel.ExhibitStandStateEnum;
import com.kingdee.eas.basedata.scm.sd.channel.ExhibitStandardFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ExhibitStandardInfo;
import com.kingdee.eas.basedata.scm.sd.channel.client.AbstractExhibitStandardEditUI;
import com.kingdee.eas.basedata.scm.sd.channel.util.ImageUtil;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.sql.Timestamp;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ExhibitStandardEditUI
extends AbstractExhibitStandardEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ExhibitStandardEditUI.class);
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.basedata.assistant.client.AssistantDavidResource";
    private static final String RESOURCE_CHANNEL = "com.kingdee.eas.basedata.scm.sd.channel.ChannelResource";
    BufferedImage exImage;
    private String pictureId = "";
    private File pictureFile;
    private boolean isNeedSave = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.clearImage();
        super.actionCopy_actionPerformed(e);
        this.txtNumber.setText("");
        ExhibitStandardInfo info = this.editData;
        info.setState(ExhibitStandStateEnum.INACTIVE);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.clearImage();
        super.actionAddNew_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        this.clearImage();
        super.actionNext_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        this.clearImage();
        super.actionPre_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        this.clearImage();
        super.actionLast_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        this.clearImage();
        super.actionFirst_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.editData.setAvailable(true);
        this.initOldData((IObjectValue)this.editData);
    }

    protected IObjectValue createNewData() {
        ExhibitStandardInfo info = new ExhibitStandardInfo();
        try {
            Timestamp createTime = SCMClientUtils.getServerDate();
            info.setCreateTime(createTime);
            UserInfo aUserInfo = SysContext.getSysContext().getCurrentUserInfo();
            info.setCreator(aUserInfo);
            info.setState(ExhibitStandStateEnum.INACTIVE);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ExhibitStandardFactory.getRemoteInstance();
    }

    KDPopupMenu CreatePopuMenu() {
        KDPopupMenu popuMenu = new KDPopupMenu();
        KDMenuItem mItemAdd = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"ADD_Image"));
        ActionListener lstAdd = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ExhibitStandardEditUI.this.showAddImageDialog();
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        };
        mItemAdd.addActionListener(lstAdd);
        popuMenu.add((JMenuItem)mItemAdd);
        if (this.exImage != null) {
            KDMenuItem mItemSave = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"SAVE_Image"));
            ActionListener lstSave = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ExhibitStandardEditUI.this.showSaveDialog();
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            };
            mItemSave.addActionListener(lstSave);
            popuMenu.add((JMenuItem)mItemSave);
            KDMenuItem mItemDelete = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"DELETE_Image"));
            ActionListener lstDelete = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ExhibitStandardEditUI.this.showdeleteImage();
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            };
            mItemDelete.addActionListener(lstDelete);
            popuMenu.add((JMenuItem)mItemDelete);
            KDMenuItem mItemShowOriginaSize = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialAddResource", (String)"ShowAsOriginaSize"));
            ActionListener lstShowOriginaSize = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ExhibitStandardEditUI.this.showAsOriginaSize();
                    }
                    catch (Exception e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            };
            mItemShowOriginaSize.addActionListener(lstShowOriginaSize);
            popuMenu.add((JMenuItem)mItemShowOriginaSize);
        }
        return popuMenu;
    }

    private void showdeleteImage() throws Exception {
        if (this.editData == null || this.editData.getId() == null || this.editData.getId().toString().equals("")) {
            SysUtil.abort();
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        if (this.confirmRemove()) {
            if (this.pictureId != null && !this.pictureId.equals("")) {
                this.deleteImage();
            }
            this.clearImage();
        }
    }

    private void clearImage() throws Exception {
        this.exImage = null;
        this.pictureFile = null;
        this.pictureId = "";
        this.labPicShow.setIcon(null);
    }

    private void deleteImage() throws Exception {
        String boid = this.editData.getId().toString();
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String[] attid = acm.getAttachmentIDsByBoIDAndCode(this.editData.getId().toString(), "picture");
        if (attid.length >= 1) {
            acm.deleteOneAssociation(boid, attid[0]);
        }
    }

    private void showAddImageDialog() throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"msgBox_noBaseInfo"));
            SysUtil.abort();
        }
        if (this.getOprtState().equals(OprtState.VIEW)) {
            return;
        }
        File file = this.chooseFileByDialog((Component)((Object)this));
        if (file != null) {
            this.showImage(file);
            if (this.pictureFile != null) {
                String boid = this.editData.getId().toString();
                AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
                String[] attid = acm.getAttachmentIDsByBoIDAndCode(this.editData.getId().toString(), "picture");
                if (attid.length >= 1) {
                    acm.deleteOneAssociation(boid, attid[0]);
                }
                this.pictureId = acm.addNewAttachment(boid, this.pictureFile, "picture");
                this.pictureFile = null;
            }
        }
    }

    private File chooseFileByDialog(Component owner) {
        File retFile = null;
        boolean isRetFileValid = false;
        KDFileChooser fc = new KDFileChooser(System.getProperty("user.home"));
        fc.setFileFilter((FileFilter)new PictureFilter());
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        while (!isRetFileValid) {
            int retVal = fc.showOpenDialog(owner);
            if (retVal == 1) {
                return retFile;
            }
            retFile = fc.getSelectedFile();
            if (retFile.exists()) {
                if (retFile.length() < 0x3200000L) {
                    isRetFileValid = true;
                    continue;
                }
                MsgBox.showInfo((String)Resrcs.getString((String)"FileSizeNotAllowed"));
                retFile = null;
                continue;
            }
            MsgBox.showInfo((String)Resrcs.getString((String)"FileNotExisted"));
            retFile = null;
        }
        return retFile;
    }

    private void showImage(File file) throws Exception {
        BufferedImage img = ImageIO.read(file);
        if (img == null) {
            throw new MaterialBaseException(MaterialBaseException.INVALID_IMAGE);
        }
        KDImageIcon icon = new KDImageIcon((Image)img);
        this.labPicShow.setIcon((Icon)icon);
        this.exImage = img;
        this.pictureFile = file;
    }

    private void showImage(byte[] data) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedImage img = ImageIO.read(bais);
        KDImageIcon icon = new KDImageIcon((Image)img);
        this.labPicShow.setIcon((Icon)icon);
        this.exImage = img;
        this.pictureFile = null;
        bais.close();
    }

    private void getPicture() throws Exception {
        if (this.editData == null) {
            return;
        }
        if (this.editData.getId() == null || this.editData.getId().toString().equals("")) {
            return;
        }
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String[] attid = acm.getAttachmentIDsByBoIDAndCode(this.editData.getId().toString(), "picture");
        if (attid.length >= 1) {
            ComplexAttachmentInfo attinfo = acm.getComplexAttachmentInfo(attid[0]);
            if (attinfo != null) {
                byte[] data = attinfo.getContent();
                this.showImage(data);
                this.pictureId = attid[0];
            } else {
                this.pictureId = "";
            }
        } else {
            this.pictureId = "";
        }
    }

    private void showSaveDialog() {
        KDFileChooser m_chooserSave = new KDFileChooser();
        m_chooserSave.setFileFilter((FileFilter)new PictureFilter());
        int result = m_chooserSave.showSaveDialog((Component)((Object)this));
        if (result != 0) {
            return;
        }
        File f = m_chooserSave.getSelectedFile();
        ImageUtil.saveImage(this.exImage, f.getAbsolutePath() + f.getName() + ".jpg", "JPG");
    }

    private void showAsOriginaSize() {
        if (this.exImage != null) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int width = this.exImage.getWidth();
            int height = this.exImage.getHeight();
            if (width + 15 > dimension.width) {
                width = dimension.width - 15;
            }
            if (height + 35 > dimension.height) {
                height = dimension.height - 55;
            }
            JLabel picLabel = new JLabel();
            ImageIcon imageIcon = new ImageIcon(this.exImage);
            picLabel.setIcon(imageIcon);
            JScrollPane picScrollPane = new JScrollPane(picLabel, 20, 30);
            JFrame picFrame = new JFrame();
            picFrame.getContentPane().setLayout(new BorderLayout());
            picFrame.getContentPane().add((Component)picScrollPane, "Center");
            picFrame.setSize(width + 15, height + 35);
            picFrame.show();
        }
    }

    @Override
    protected void labPicShow_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.showAsOriginaSize();
        } else if (e.getButton() == 3) {
            KDPopupMenu popupMenu = this.CreatePopuMenu();
            this.add((Component)popupMenu);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setInit();
    }

    private void setInit() {
        this.btnPicture.setIcon(EASResource.getIcon((String)"imgTbtn_showpicture"));
        this.btnPicture.setEnabled(true);
        this.txtNumber.setMaxLength(80);
        this.txtName.setMaxLength(50);
        this.txtExhibitPrinciple.setMaxLength(200);
        this.menuBiz.setVisible(false);
    }

    @Override
    public void actionPicture_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"msgBox_noBaseInfo"));
            SysUtil.abort();
        }
        this.getPicture();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.editData != null && ExhibitStandStateEnum.ACTIVE.equals((Object)this.editData.getState())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_CHANNEL, (String)"activeNotSave"));
            SysUtil.abort();
        }
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"numberIsNull"));
            this.txtNumber.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.txtName.getEditor().getItem() == null || this.txtName.getEditor().getItem().toString().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"nameIsNull"));
            this.txtName.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.prmtMarketType.getValue() == null || this.prmtMarketType.getValue().toString() == null || this.prmtMarketType.getValue().toString().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_CHANNEL, (String)"marketTypeNotNull"));
            this.prmtMarketType.requestFocusInWindow();
            SysUtil.abort();
        }
        if (this.prmtShopType.getValue() == null || this.prmtShopType.getValue().toString() == null || this.prmtShopType.getValue().toString().trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_CHANNEL, (String)"shopTypeNotNull"));
            this.prmtShopType.requestFocusInWindow();
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("EDIT".equals(this.getOprtState())) {
            ExhibitStandardInfo exhibitStandardInfo;
            if (this.editData != null && ExhibitStandStateEnum.ACTIVE.equals((Object)this.editData.getState())) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_CHANNEL, (String)"activeNotSave"));
                SysUtil.abort();
            } else if (this.getDataObject("editData") != null && (exhibitStandardInfo = (ExhibitStandardInfo)this.getDataObject("editData")) != null && ExhibitStandStateEnum.ACTIVE.equals((Object)exhibitStandardInfo.getState())) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_CHANNEL, (String)"activeNotSave"));
                SysUtil.abort();
            }
        }
    }
}

