/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.channel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.IMaterialGroupStandard;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.scm.sd.channel.client.AbstractMaterialGroupF7UI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MaterialGroupF7UI
extends AbstractMaterialGroupF7UI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialGroupF7UI.class);
    private ITreeBuilder treeBuilder;
    private boolean isCanceled = true;
    private MaterialGroupInfo materialGroupInfo = null;
    private CtrlUnitInfo curCtrlUnitInfo = null;
    private MaterialGroupStandardCollection materialGroupStandardCollection = null;
    private String groupStandardID;

    public MaterialGroupF7UI() throws Exception {
        this.initMaterialGroupStandardCollection();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.tGroupTree.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof MaterialGroupInfo) {
            this.materialGroupInfo = (MaterialGroupInfo)treeNode.getUserObject();
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    @Override
    protected void tGroupTree_mouseClicked(MouseEvent e) throws Exception {
        KDTreeNode treeNode;
        if (e.getClickCount() == 2 && (treeNode = (KDTreeNode)this.tGroupTree.getLastSelectedPathComponent()) != null && treeNode.getUserObject() instanceof MaterialGroupInfo) {
            this.materialGroupInfo = (MaterialGroupInfo)treeNode.getUserObject();
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    @Override
    protected void comboGroupStandard_itemStateChanged(ItemEvent e) throws Exception {
        if (1 == e.getStateChange()) {
            MaterialGroupStandardInfo materialGroupStandardInfo = (MaterialGroupStandardInfo)this.comboGroupStandard.getSelectedItem();
            this.groupStandardID = materialGroupStandardInfo.getId().toString();
            this.initTree();
            this.tGroupTree.setSelectionRow(0);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.curCtrlUnitInfo = (CtrlUnitInfo)this.getUIContext().get("CU");
        if (this.curCtrlUnitInfo == null) {
            this.curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        this.initGroupStandard();
        this.initTree();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public MaterialGroupInfo getMaterialGroupInfo() {
        return this.materialGroupInfo;
    }

    private void initTree() throws Exception {
        this.treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(), (int)this.getTreeInitialLevel(), (int)this.getTreeExpandLevel(), (FilterInfo)this.getFilterForTree());
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode((Object)this.getRootName());
            ((DefaultTreeModel)this.tGroupTree.getModel()).setRoot((TreeNode)rootNode);
        } else {
            ((DefaultTreeModel)this.tGroupTree.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.tGroupTree);
        this.tGroupTree.setShowPopMenuDefaultItem(true);
    }

    private String getRootName() {
        return EASResource.getString((String)"com.kingdee.eas.basedata.master.material.MaterialResource", (String)"material");
    }

    private ILNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new DefaultLNTreeNodeCtrl(this.getTreeInterface());
    }

    private ITreeBase getTreeInterface() throws Exception {
        return MaterialGroupFactory.getRemoteInstance();
    }

    private int getTreeInitialLevel() {
        return 3;
    }

    private int getTreeExpandLevel() {
        return 3;
    }

    private void initGroupStandard() {
        this.comboGroupStandard.removeAllItems();
        if (null != this.materialGroupStandardCollection && 0 < this.materialGroupStandardCollection.size()) {
            this.comboGroupStandard.addItems(this.materialGroupStandardCollection.toArray());
            this.comboGroupStandard.setSelectedItem((Object)this.materialGroupStandardCollection.getObject(0));
        }
    }

    private void initMaterialGroupStandardCollection() {
        CtrlUnitInfo currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)currentCtrlUnit.getId().toString(), (String)currentCtrlUnit.getLongNumber());
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfoCU);
        try {
            IMaterialGroupStandard iMaterialGroupStandard = MaterialGroupStandardFactory.getRemoteInstance();
            this.materialGroupStandardCollection = iMaterialGroupStandard.getMaterialGroupStandardCollection(viewInfo);
            MaterialGroupStandardInfo materialGroupStandardInfo = null;
            int length = this.materialGroupStandardCollection.size();
            for (int i = 0; i < length; ++i) {
                materialGroupStandardInfo = this.materialGroupStandardCollection.get(i);
                if (1 != materialGroupStandardInfo.getStandardType().getValue()) continue;
                if (i != 0) {
                    this.materialGroupStandardCollection.swap(0, i);
                }
                this.groupStandardID = materialGroupStandardInfo.getId().toString();
                break;
            }
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
    }

    private FilterInfo getFilterForTree() {
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)this.curCtrlUnitInfo.getId().toString(), (String)this.curCtrlUnitInfo.getLongNumber());
        if (StringUtils.isNotBlank((String)this.groupStandardID)) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("groupStandard", (Object)this.groupStandardID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1), CompareType.EQUALS));
            try {
                filterInfoCU.mergeFilter(filterInfo, "and");
            }
            catch (BOSException e) {
                throw new RuntimeException(e);
            }
        }
        return filterInfoCU;
    }
}

