/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.channel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.channel.IPeriodType;
import com.kingdee.eas.basedata.scm.sd.channel.IPeriodTypeToBill;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodTypeCollection;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodTypeFactory;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodTypeInfo;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodTypeToBillCollection;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodTypeToBillFactory;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodTypeToBillInfo;
import com.kingdee.eas.basedata.scm.sd.channel.client.AbstractPeriodAllotOrgEditUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.sd.channel.PermissionFacadeFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComboBoxItem;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class PeriodAllotOrgEditUI
extends AbstractPeriodAllotOrgEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PeriodAllotOrgEditUI.class);
    private IPeriodType iPeriodType = null;
    private IPeriodTypeToBill iPeriodTypeToBill = null;
    private ArrayList removeList = null;
    private ISaleOrgUnit iSaleOrgUnit = null;
    Set saleOrgUnits = null;
    Set saleOrgIDs = null;

    private IPeriodType getIPeriodType() throws BOSException {
        if (this.iPeriodType == null) {
            this.iPeriodType = PeriodTypeFactory.getRemoteInstance();
        }
        return this.iPeriodType;
    }

    private IPeriodTypeToBill getIPeriodTypeToBill() throws BOSException {
        if (this.iPeriodTypeToBill == null) {
            this.iPeriodTypeToBill = PeriodTypeToBillFactory.getRemoteInstance();
        }
        return this.iPeriodTypeToBill;
    }

    private ISaleOrgUnit getISaleOrgUnit() throws BOSException {
        if (this.iSaleOrgUnit == null) {
            this.iSaleOrgUnit = SaleOrgUnitFactory.getRemoteInstance();
        }
        return this.iSaleOrgUnit;
    }

    public ArrayList getRemoveList() {
        if (this.removeList == null) {
            this.removeList = new ArrayList();
        }
        return this.removeList;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadTypes(this.getIPeriodType().getPeriodTypeCollection());
        this.setSelectPeriodType();
        this.initButtonState();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.loadOrgEntry();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        IObjectPK[] list = null;
        if (this.removeList != null && this.removeList.size() > 0) {
            list = new IObjectPK[this.removeList.size()];
            for (int i = 0; i < this.removeList.size(); ++i) {
                list[i] = new ObjectUuidPK(BOSUuid.read((String)this.removeList.get(i).toString()));
            }
        }
        PeriodTypeToBillCollection periodTypeToBillCol = this.getSaveCollection();
        if (list != null && list.length > 0 || periodTypeToBillCol != null && periodTypeToBillCol.size() > 0) {
            this.getIPeriodTypeToBill().updateAllotOrgCollection(periodTypeToBillCol, list);
        }
        this.loadOrgEntry();
        this.saleOrgIDs = null;
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"saleOrgSaveSuccess"));
    }

    private PeriodTypeToBillCollection getSaveCollection() {
        PeriodTypeToBillCollection pCollection = new PeriodTypeToBillCollection();
        PeriodTypeInfo typeInfo = new PeriodTypeInfo();
        typeInfo.setId(BOSUuid.read((String)((ComboBoxItem)this.ctType.getSelectedItem()).getValue().toString()));
        PeriodTypeToBillInfo info = null;
        IRow row = null;
        for (int i = 0; i < this.kdtOrg.getRowCount(); ++i) {
            row = this.kdtOrg.getRow(i);
            if (row.getCell("isEdit").getValue().equals(Boolean.FALSE)) continue;
            info = new PeriodTypeToBillInfo();
            if (row.getCell("id").getValue() != null) {
                info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            }
            info.setPeriodType(typeInfo);
            SaleOrgUnitInfo saleInfo = (SaleOrgUnitInfo)row.getCell("orgNumber").getValue();
            if (saleInfo != null) {
                info.setSaleOrg(saleInfo);
            }
            info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
            info.setApplyBill("VnuqmgEhEADgAAAMwKgPZ7dsPo0=");
            pCollection.add(info);
        }
        return pCollection;
    }

    protected IObjectValue createNewData() {
        PeriodTypeToBillInfo info = new PeriodTypeToBillInfo();
        try {
            Timestamp createTime = SCMClientUtils.getServerDate();
            info.setCreateTime(createTime);
            UserInfo aUserInfo = SysContext.getSysContext().getCurrentUserInfo();
            info.setCreator(aUserInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PeriodTypeToBillFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        for (int i = 0; i < this.kdtOrg.getRowCount(); ++i) {
            if (this.kdtOrg.getCell(i, "orgNumber").getValue() != null && !"".equals(this.kdtOrg.getCell(i, "orgNumber").getValue())) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"orgNotNull"));
            SysUtil.abort();
        }
        IRow currentRow = null;
        IRow nextRow = null;
        Object currentTempObj = null;
        Object nextTempObj = null;
        int i = 0;
        int j = 0;
        for (i = 0; i < this.kdtOrg.getRowCount(); ++i) {
            currentRow = this.kdtOrg.getRow(i);
            currentTempObj = currentRow.getCell("orgNumber").getValue();
            for (j = i + 1; j < this.kdtOrg.getRowCount(); ++j) {
                nextRow = this.kdtOrg.getRow(j);
                nextTempObj = nextRow.getCell("orgNumber").getValue();
                if (currentTempObj != nextTempObj && !currentTempObj.equals(nextTempObj)) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"orgNotRepeat"));
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void kdtOrg_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.kdtOrg.getColumnIndex("orgNumber") == colIndex) {
            Object userObject = this.kdtOrg.getCell(rowIndex, "orgNumber").getValue();
            if (userObject == null) {
                return;
            }
            Object[] saleOrgInfos = null;
            SaleOrgUnitInfo saleOrginfo = null;
            if (userObject instanceof SaleOrgUnitInfo) {
                saleOrginfo = (SaleOrgUnitInfo)userObject;
                this.kdtOrg.getCell(rowIndex, "orgNumber").setValue((Object)saleOrginfo);
                this.kdtOrg.getCell(rowIndex, "orgName").setValue((Object)saleOrginfo.getName());
                this.kdtOrg.getCell(rowIndex, "isEdit").setValue((Object)Boolean.TRUE);
            } else {
                saleOrgInfos = (Object[])userObject;
                IRow row = null;
                if (saleOrgInfos != null && saleOrgInfos.length > 0) {
                    for (int i = 0; i < saleOrgInfos.length; ++i) {
                        saleOrginfo = (SaleOrgUnitInfo)saleOrgInfos[i];
                        if (i == 0) {
                            this.kdtOrg.getCell(rowIndex, "orgNumber").setValue((Object)saleOrginfo);
                            this.kdtOrg.getCell(rowIndex, "orgName").setValue((Object)saleOrginfo.getName());
                            this.kdtOrg.getCell(rowIndex, "isEdit").setValue((Object)Boolean.TRUE);
                            continue;
                        }
                        row = this.kdtOrg.addRow(rowIndex + i);
                        this.setF7Format(row.getCell("orgNumber"));
                        row.getCell("orgNumber").setValue((Object)saleOrginfo);
                        row.getCell("orgName").setValue((Object)saleOrginfo.getName());
                        row.getCell("isEdit").setValue((Object)Boolean.TRUE);
                    }
                }
            }
        }
    }

    @Override
    protected void kdtOrg_editStarted(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (this.kdtOrg.getColumnIndex("orgNumber") == colIndex) {
            EntityViewInfo view = this.getEntityViewInfo();
            ((KDBizPromptBox)this.kdtOrg.getCell(rowIndex, colIndex).getEditor().getComponent()).setEntityViewInfo(view);
        }
    }

    private void loadTypes(PeriodTypeCollection c) {
        this.ctType.removeAllItems();
        PeriodTypeInfo info = null;
        ComboBoxItem item = null;
        for (int i = 0; i < c.size(); ++i) {
            info = c.get(i);
            item = new ComboBoxItem();
            item.setKey(info.getName() + " - " + info.getNumber());
            item.setValue((Object)info.getId().toString());
            this.ctType.addItem((Object)item);
        }
    }

    private void setSelectPeriodType() {
        String periodTypeId = "";
        if (this.getUIContext().get("PeriodType") != null) {
            periodTypeId = ((ComboBoxItem)this.getUIContext().get("PeriodType")).getValue().toString();
        }
        for (int i = 0; i < this.ctType.getItemCount() && !StringUtil.isEmpty((String)periodTypeId); ++i) {
            if (!((ComboBoxItem)this.ctType.getItemAt(i)).getValue().toString().equals(periodTypeId)) continue;
            this.ctType.setSelectedIndex(i);
        }
    }

    private void loadOrgEntry() throws BOSException {
        if (this.kdtOrg.getRowCount() > 0) {
            for (int i = this.kdtOrg.getRowCount() - 1; i >= 0; --i) {
                this.kdtOrg.removeRow(i);
            }
        }
        ComboBoxItem itemType = (ComboBoxItem)this.ctType.getSelectedItem();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("periodType.id", itemType.getValue());
        view.setFilter(filter);
        PeriodTypeToBillCollection col = this.getIPeriodTypeToBill().getPeriodTypeToBillCollection(view);
        if (col != null && col.size() > 0) {
            IRow row = null;
            PeriodTypeToBillInfo info = null;
            SaleOrgUnitInfo saleInfo = null;
            for (int i = 0; i < col.size(); ++i) {
                info = col.get(i);
                row = this.kdtOrg.addRow();
                row.getCell("id").setValue((Object)info.getId());
                row.getCell("isEdit").setValue((Object)Boolean.FALSE);
                this.setF7Format(row.getCell("orgNumber"));
                if (info.getSaleOrg() == null || info.getSaleOrg().getId() == null) continue;
                try {
                    saleInfo = this.getISaleOrgUnit().getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getSaleOrg().getId().toString()));
                }
                catch (EASBizException e) {
                    throw new BOSException(e.getMessage());
                }
                row.getCell("orgNumber").setValue((Object)saleInfo);
                row.getCell("orgName").setValue((Object)saleInfo.getName());
            }
        }
    }

    private void initButtonState() {
        this.btnAddLine.setEnabled(true);
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setEnabled(true);
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnDelLine.setEnabled(true);
        this.btnDelLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.kdtOrg.addRow();
        this.setF7Format(row.getCell("orgNumber"));
        row.getCell("isEdit").setValue((Object)Boolean.TRUE);
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        int rowIndex = this.kdtOrg.getSelectManager().getActiveRowIndex();
        IRow row = null;
        row = rowIndex == -1 ? this.kdtOrg.addRow() : this.kdtOrg.addRow(rowIndex);
        this.setF7Format(row.getCell("orgNumber"));
        row.getCell("isEdit").setValue((Object)Boolean.TRUE);
    }

    @Override
    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        int[] row = KDTableUtil.getSelectedRows((KDTable)this.kdtOrg);
        if (row.length != 0) {
            this.removeList = this.getRemoveList();
            String id = null;
            for (int i = row.length - 1; i >= 0; --i) {
                if (this.kdtOrg.getRow(row[i]).getCell("id").getValue() == null) {
                    this.kdtOrg.removeRow(row[i]);
                    continue;
                }
                id = this.kdtOrg.getRow(row[i]).getCell("id").getValue().toString();
                this.removeList.add(id);
                this.kdtOrg.removeRow(row[i]);
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"checkDelete"));
            SysUtil.abort();
        }
    }

    private void setF7Format(ICell cell) throws BOSException {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setQueryInfo("com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery");
        promptBox.setVisible(true);
        promptBox.setEditable(true);
        promptBox.setDisplayFormat("$number$");
        promptBox.setEditFormat("$number$");
        promptBox.setCommitFormat("$number$");
        promptBox.setEnabledMultiSelection(true);
        EntityViewInfo view = this.getEntityViewInfo();
        promptBox.setEntityViewInfo(view);
        KDTDefaultCellEditor kdtEntry_COA_CellEditor = new KDTDefaultCellEditor((IKDEditor)promptBox);
        cell.setEditor((ICellEditor)kdtEntry_COA_CellEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        cell.setRenderer((IBasicRender)avr);
    }

    private void getSaleOrgIDs() throws BOSException {
        if (this.saleOrgIDs != null) {
            return;
        }
        this.saleOrgIDs = new HashSet();
        PeriodTypeToBillCollection periodTypeToBillCol = this.getIPeriodTypeToBill().getPeriodTypeToBillCollection();
        if (periodTypeToBillCol != null && periodTypeToBillCol.size() > 0) {
            PeriodTypeToBillInfo periodTypeToBillInfo = null;
            for (int i = 0; i < periodTypeToBillCol.size(); ++i) {
                periodTypeToBillInfo = periodTypeToBillCol.get(i);
                if (periodTypeToBillInfo == null || periodTypeToBillInfo.getSaleOrg() == null || periodTypeToBillInfo.getSaleOrg().getId() == null) continue;
                this.saleOrgIDs.add(periodTypeToBillInfo.getSaleOrg().getId().toString());
            }
        }
    }

    private Set cloneSet(Set set) {
        HashSet cloneSet = new HashSet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            cloneSet.add(it.next());
        }
        return cloneSet;
    }

    private EntityViewInfo getEntityViewInfo() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (this.saleOrgUnits == null) {
            try {
                this.saleOrgUnits = PermissionFacadeFactory.getRemoteInstance().getAuthorizedSaleOrgIds(userID);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        Set saleOrgFilterIDs = this.cloneSet(this.saleOrgUnits);
        this.getSaleOrgIDs();
        Iterator it = this.saleOrgIDs.iterator();
        while (it.hasNext()) {
            saleOrgFilterIDs.remove(it.next());
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)saleOrgFilterIDs, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        return view;
    }

    public boolean checkBeforeWindowClosing() {
        return super.checkBeforeWindowClosing();
    }
}

