/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.channel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.scm.sd.channel.IPeriodType;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodTypeCollection;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodTypeFactory;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodTypeInfo;
import com.kingdee.eas.basedata.scm.sd.channel.client.AbstractPeriodEditUI;
import com.kingdee.eas.basedata.scm.sd.channel.util.ChannelCalendarUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.ComboBoxItem;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableColumnItem;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class PeriodEditUI
extends AbstractPeriodEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PeriodEditUI.class);
    private IPeriodType iPeriodType = null;
    boolean isCancel = true;

    public IPeriodType getIPeriodType() throws BOSException {
        if (this.iPeriodType == null) {
            this.iPeriodType = PeriodTypeFactory.getRemoteInstance();
        }
        return this.iPeriodType;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodEditUI");
    }

    public void onLoad() throws EASBizException, BOSException {
        this.cbType.setEnabled(false);
        try {
            this.loadTypes(this.getIPeriodType().getPeriodTypeCollection());
            this.setSelectPeriodType();
            this.setGeneratWayState();
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
        this.addPeriodHeader();
        Icon bg = EASResource.getIcon((String)"imgGuide_pic338");
        this.lblFirstImg.setIcon(bg);
        this.lblSecondImg.setIcon(bg);
    }

    private void loadTypes(PeriodTypeCollection col) {
        this.cbType.removeAllItems();
        PeriodTypeInfo info = null;
        ComboBoxItem item = null;
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                info = col.get(i);
                item = new ComboBoxItem();
                item.setKey(info.getName() + " - " + info.getNumber());
                item.setValue((Object)info.getId().toString());
                this.cbType.addItem((Object)item);
            }
        }
    }

    private void setSelectPeriodType() {
        if (this.getUIContext().get("PeriodType") != null) {
            String periodTypeId = ((ComboBoxItem)this.getUIContext().get("PeriodType")).getValue().toString();
            for (int i = 0; i < this.cbType.getItemCount(); ++i) {
                if (!((ComboBoxItem)this.cbType.getItemAt(i)).getValue().toString().equals(periodTypeId)) continue;
                this.cbType.setSelectedIndex(i);
            }
        }
    }

    private void setGeneratWayState() throws EASBizException, BOSException {
        ComboBoxItem itemType = (ComboBoxItem)this.cbType.getSelectedItem();
        PeriodTypeInfo periodTypeInfo = this.getIPeriodType().getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(itemType.getValue().toString()));
        if (periodTypeInfo != null && periodTypeInfo.getNumber() != null && !"".equals(periodTypeInfo.getNumber())) {
            if ("ZQ001".equals(periodTypeInfo.getNumber())) {
                this.rdNature.setEnabled(true);
                this.rdQuarter.setEnabled(false);
                this.rdMonth.setEnabled(false);
                this.rdWeek.setEnabled(false);
                this.rdNature.setSelected(true);
            } else if ("ZQ002".equals(periodTypeInfo.getNumber())) {
                this.rdNature.setEnabled(false);
                this.rdQuarter.setEnabled(true);
                this.rdMonth.setEnabled(false);
                this.rdWeek.setEnabled(false);
                this.rdQuarter.setSelected(true);
            } else if ("ZQ003".equals(periodTypeInfo.getNumber())) {
                this.rdNature.setEnabled(false);
                this.rdQuarter.setEnabled(false);
                this.rdMonth.setEnabled(true);
                this.rdWeek.setEnabled(false);
                this.rdMonth.setSelected(true);
            } else if ("ZQ004".equals(periodTypeInfo.getNumber())) {
                this.rdNature.setEnabled(false);
                this.rdQuarter.setEnabled(false);
                this.rdMonth.setEnabled(false);
                this.rdWeek.setEnabled(true);
                this.rdWeek.setSelected(true);
            }
        }
    }

    private void addPeriodHeader() {
        KDTableUtil.addHeaderRow((KDTable)this.kdtPeriod, (KDTableColumnItem[])this.createPeriodHeaderItems());
        String formatString = CtrlFormatUtilities.getDateFormatString();
        this.kdtPeriod.getColumn("beginDate").getStyleAttributes().setNumberFormat(formatString);
        this.kdtPeriod.getColumn("endDate").getStyleAttributes().setNumberFormat(formatString);
    }

    private KDTableColumnItem[] createPeriodHeaderItems() {
        KDTableColumnItem[] items = new KDTableColumnItem[]{new KDTableColumnItem("periodNum", EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodNum")), new KDTableColumnItem("beginDate", EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodBeginDate")), new KDTableColumnItem("endDate", EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodEndDate"))};
        return items;
    }

    @Override
    protected void btnYearNext_actionPerformed(ActionEvent e) throws Exception {
        super.btnYearNext_actionPerformed(e);
        if (!this.CheckPnlYear()) {
            return;
        }
        this.setPnlPeriod();
        this.pnlYear.setVisible(false);
        this.pnlPeriod.setVisible(true);
        this.kdtPeriod.updateUI();
    }

    private boolean CheckPnlYear() {
        if (DateTimeUtils.dateDiff((Date)((Date)this.dtBeginDate.getValue()), (Date)((Date)this.dtEndDate.getValue())) < 0L) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"beginDateEarlierThanEndDate"));
            return false;
        }
        return true;
    }

    private void setPnlPeriod() {
        for (int i = this.kdtPeriod.getRowCount() - 1; i >= 0; --i) {
            this.kdtPeriod.removeRow(i);
        }
        if (this.rdNature.isSelected()) {
            this.natureSetValue();
        } else if (this.rdQuarter.isSelected()) {
            this.quarterSetValue();
        } else if (this.rdMonth.isSelected()) {
            this.monthSetValue();
        } else if (this.rdWeek.isSelected()) {
            this.weekSetValue();
        }
        this.setKdtPeriodCellLocked();
    }

    private void setKdtPeriodCellLocked() {
        for (int i = 0; i < this.kdtPeriod.getRowCount(); ++i) {
            IRow row = this.kdtPeriod.getRow(i);
            row.getCell("periodNum").getStyleAttributes().setLocked(true);
        }
    }

    private void natureSetValue() {
        IRow row = null;
        Date beginDate = (Date)this.dtBeginDate.getValue();
        Date endDate = (Date)this.dtEndDate.getValue();
        long rowCount = ChannelCalendarUtil.getSpansNum(beginDate, endDate, "ZQ001");
        int i = 0;
        while ((long)i < rowCount) {
            row = this.kdtPeriod.addRow();
            row.getCell("periodNum").setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"period"), new Integer(i + 1).toString()));
            if (i == 0) {
                row.getCell("beginDate").setValue((Object)((Date)this.dtBeginDate.getValue()));
            } else {
                beginDate = DateTimeUtils.addDay((Date)endDate, (long)1L);
                row.getCell("beginDate").setValue((Object)beginDate);
            }
            if ((long)i == rowCount - 1L) {
                row.getCell("endDate").setValue((Object)((Date)this.dtEndDate.getValue()));
            } else {
                endDate = ChannelCalendarUtil.getLastDate(beginDate, "ZQ001");
                row.getCell("endDate").setValue((Object)endDate);
            }
            ++i;
        }
    }

    private void quarterSetValue() {
        IRow row = null;
        Date beginDate = (Date)this.dtBeginDate.getValue();
        Date endDate = (Date)this.dtEndDate.getValue();
        long rowCount = ChannelCalendarUtil.getSpansNum(beginDate, endDate, "ZQ002");
        int i = 0;
        while ((long)i <= rowCount) {
            row = this.kdtPeriod.addRow();
            row.getCell("periodNum").setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"period"), new Integer(i + 1).toString()));
            if (i == 0) {
                row.getCell("beginDate").setValue((Object)((Date)this.dtBeginDate.getValue()));
            } else {
                beginDate = DateTimeUtils.addDay((Date)endDate, (long)1L);
                row.getCell("beginDate").setValue((Object)beginDate);
            }
            if ((long)i == rowCount) {
                row.getCell("endDate").setValue((Object)((Date)this.dtEndDate.getValue()));
            } else {
                endDate = ChannelCalendarUtil.getLastDate(beginDate, "ZQ002");
                row.getCell("endDate").setValue((Object)endDate);
            }
            ++i;
        }
    }

    private void monthSetValue() {
        IRow row = null;
        Date beginDate = (Date)this.dtBeginDate.getValue();
        Date endDate = (Date)this.dtEndDate.getValue();
        long rowCount = ChannelCalendarUtil.getSpansNum(beginDate, endDate, "ZQ003");
        int i = 0;
        while ((long)i <= rowCount) {
            row = this.kdtPeriod.addRow();
            row.getCell("periodNum").setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"period"), new Integer(i + 1).toString()));
            if (i == 0) {
                row.getCell("beginDate").setValue((Object)((Date)this.dtBeginDate.getValue()));
            } else {
                beginDate = DateTimeUtils.addDay((Date)endDate, (long)1L);
                row.getCell("beginDate").setValue((Object)beginDate);
            }
            if ((long)i == rowCount) {
                row.getCell("endDate").setValue((Object)((Date)this.dtEndDate.getValue()));
            } else {
                endDate = ChannelCalendarUtil.getLastDate(beginDate, "ZQ003");
                row.getCell("endDate").setValue((Object)endDate);
            }
            ++i;
        }
    }

    private void weekSetValue() {
        IRow row = null;
        Date beginDate = (Date)this.dtBeginDate.getValue();
        Date endDate = (Date)this.dtEndDate.getValue();
        Calendar calendar = Calendar.getInstance();
        long rowCount = ChannelCalendarUtil.getSpansNum(beginDate, endDate, "ZQ004");
        int i = 0;
        while ((long)i <= rowCount) {
            row = this.kdtPeriod.addRow();
            row.getCell("periodNum").setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"period"), new Integer(i + 1).toString()));
            if (i == 0) {
                row.getCell("beginDate").setValue((Object)((Date)this.dtBeginDate.getValue()));
            } else {
                calendar.clear();
                beginDate = DateTimeUtils.addDay((Date)endDate, (long)1L);
                row.getCell("beginDate").setValue((Object)beginDate);
            }
            if ((long)i == rowCount) {
                row.getCell("endDate").setValue((Object)((Date)this.dtEndDate.getValue()));
            } else {
                endDate = ChannelCalendarUtil.getLastDate(beginDate, "ZQ004");
                row.getCell("endDate").setValue((Object)endDate);
            }
            ++i;
        }
    }

    private boolean checkPeriodContinous() {
        int i;
        Date beginDate = null;
        Date endDate = null;
        IRow currentRow = null;
        IRow nextRow = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        int rowCount = this.kdtPeriod.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            currentRow = this.kdtPeriod.getRow(i);
            endDate = (Date)currentRow.getCell("endDate").getValue();
            beginDate = (Date)currentRow.getCell("beginDate").getValue();
            if (beginDate == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodBeginDateNotNull"));
                return false;
            }
            if (endDate == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodEndDateNotNull"));
                return false;
            }
            if (endDate.compareTo(beginDate) >= 0) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"beginDateEarlierThanEndDate"));
            return false;
        }
        for (i = 0; i < this.kdtPeriod.getRowCount() - 1; ++i) {
            currentRow = this.kdtPeriod.getRow(i);
            nextRow = this.kdtPeriod.getRow(i + 1);
            endDate = (Date)currentRow.getCell("endDate").getValue();
            beginDate = (Date)nextRow.getCell("beginDate").getValue();
            if (sdf.format(endDate = ChannelCalendarUtil.changeDate(endDate, 1)).equals(sdf.format(beginDate))) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"DateNotSeries"));
            return false;
        }
        return true;
    }

    @Override
    protected void btnYearCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.uiWindow.close();
    }

    @Override
    protected void btnPeriodPrevious_actionPerformed(ActionEvent e) throws Exception {
        super.btnPeriodPrevious_actionPerformed(e);
        this.pnlYear.setVisible(true);
        this.pnlPeriod.setVisible(false);
    }

    @Override
    protected void btnPeriodCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.uiWindow.close();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkPeriodContinous()) {
            this.isCancel = false;
            this.uiWindow.close();
        }
    }
}

