/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.channel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.scm.sd.channel.IPeriod;
import com.kingdee.eas.basedata.scm.sd.channel.IPeriodType;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodCollection;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodException;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodFactory;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodInfo;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodTypeCollection;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodTypeFactory;
import com.kingdee.eas.basedata.scm.sd.channel.PeriodTypeInfo;
import com.kingdee.eas.basedata.scm.sd.channel.client.AbstractPeriodListUI;
import com.kingdee.eas.basedata.scm.sd.channel.client.PeriodEditUI;
import com.kingdee.eas.basedata.scm.sd.channel.util.ChannelCalendarUtil;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.scm.sd.channel.RequirementPlanCollection;
import com.kingdee.eas.scm.sd.channel.RequirementPlanFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComboBoxItem;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableColumnItem;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PeriodListUI
extends AbstractPeriodListUI {
    private static final Logger logger = CoreUIObject.getLogger(PeriodListUI.class);
    private IPeriodType iPeriodType = null;
    private IPeriod iPeriod = null;
    private Set removeSet = null;
    private ArrayList removeCUList = null;
    private CtrlUnitInfo cuInfo = null;

    public PeriodListUI() throws Exception {
        this.kdtPeriod.setFormatXml("");
    }

    public Set getRemoveSet() {
        if (this.removeSet == null) {
            this.removeSet = new HashSet();
        }
        return this.removeSet;
    }

    public ArrayList getRemoveCUList() {
        if (this.removeCUList == null) {
            this.removeCUList = new ArrayList();
        }
        return this.removeCUList;
    }

    public IPeriod getIPeriod() throws BOSException {
        if (this.iPeriod == null) {
            this.iPeriod = PeriodFactory.getRemoteInstance();
        }
        return this.iPeriod;
    }

    public IPeriodType getIPeriodType() throws BOSException {
        if (this.iPeriodType == null) {
            this.iPeriodType = PeriodTypeFactory.getRemoteInstance();
        }
        return this.iPeriodType;
    }

    public void onLoad() throws Exception {
        try {
            super.onLoad();
            this.loadTypes(this.getIPeriodType().getPeriodTypeCollection());
            this.loadList();
            this.initWorkButton();
            this.lblYear.setVisible(false);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void setFocus() {
        DefaultKeyboardFocusManager myFocusmgr = new DefaultKeyboardFocusManager();
        myFocusmgr.getFocusOwner();
        myFocusmgr.focusNextComponent();
        myFocusmgr.downFocusCycle();
        myFocusmgr.downFocusCycle();
        myFocusmgr.getFocusOwner();
        this.cbType.dispatchEvent((AWTEvent)new FocusEvent((Component)this.cbType, 1004, true));
        this.cbType.requestFocusInWindow();
    }

    public void onShow() {
        this.setFocus();
    }

    private void loadTypes(PeriodTypeCollection c) {
        this.cbType.removeAllItems();
        PeriodTypeInfo info = null;
        ComboBoxItem item = null;
        for (int i = 0; i < c.size(); ++i) {
            info = c.get(i);
            item = new ComboBoxItem();
            item.setKey(info.getName() + " - " + info.getNumber());
            item.setValue((Object)info.getId().toString());
            this.cbType.addItem((Object)item);
            if (!info.getNumber().equals("ZQ003")) continue;
            this.cbType.setSelectedIndex(i);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuEdit.setVisible(false);
        this.btnTypeMaintenance.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.menPeriodTypeMaintenance.setIcon(EASResource.getIcon((String)"imgTbtn_maintenance"));
        this.btnAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.menuAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnAddNew.setText(this.resHelper.getString("btnAddNew.text"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSave.setText(this.resHelper.getString("btnSave.text"));
        this.btnAddNewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.menuAddNewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddNewLine.setText(this.resHelper.getString("btnAddNewLine.text"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.menuRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnRemove.setText(this.resHelper.getString("btnRemove.text"));
        this.btnRemoveAll.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.menuRemoveAll.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.btnRemoveAll.setText(this.resHelper.getString("btnRemoveAll.text"));
        this.btnRemoveAll.setVisible(false);
        this.menuRemoveAll.setVisible(false);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnRefresh.setText(this.resHelper.getString("btnRefresh.text"));
        this.btnAllotOrg.setIcon(EASResource.getIcon((String)"imgTbtn_distributebatch"));
        this.btnAllotOrg.setText(this.resHelper.getString("btnAllotOrg.text"));
    }

    private void loadList() throws BOSException, PeriodException {
        ComboBoxItem itemType = (ComboBoxItem)this.cbType.getSelectedItem();
        PeriodCollection c = null;
        this.addTableHeader();
        if (this.kdtPeriod.getRowCount() > 0) {
            for (int i = this.kdtPeriod.getRowCount() - 1; i >= 0; --i) {
                this.kdtPeriod.removeRow(i);
            }
        }
        c = itemType == null ? this.getPeriodCollection(null) : this.getPeriodCollection(itemType.getValue().toString());
        IRow row = null;
        PeriodInfo info = null;
        for (int j = 0; j < c.size(); ++j) {
            info = c.get(j);
            row = this.kdtPeriod.addRow();
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("number").setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"period"), info.getNumber()));
            row.getCell("periodName").setValue((Object)info.getName());
            row.getCell("beginDate").setValue((Object)info.getBeginDate());
            row.getCell("endDate").setValue((Object)info.getEndDate());
            row.getCell("periodCU").setValue((Object)info.getCU());
            row.getCell("remark").setValue((Object)(info.getDescription() == null ? "" : info.getDescription()));
            row.getCell("isEdit").setValue((Object)Boolean.FALSE);
        }
        if (this.removeSet != null) {
            this.removeSet.clear();
            this.removeCUList.clear();
        }
        if (this.kdtPeriod.getRowCount() > 0) {
            this.kdtPeriod.getSelectManager().select(0, 0);
        }
    }

    private PeriodCollection getPeriodCollection(String typeId) throws BOSException {
        FilterInfo periodFilter = new FilterInfo();
        if (typeId != null) {
            periodFilter.getFilterItems().add(new FilterItemInfo("type", (Object)typeId, CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(periodFilter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("description"));
        evi.getSelector().add(new SelectorItemInfo("beginDate"));
        evi.getSelector().add(new SelectorItemInfo("endDate"));
        evi.getSelector().add(new SelectorItemInfo("CU.id"));
        evi.getSelector().add(new SelectorItemInfo("CU.number"));
        evi.getSelector().add(new SelectorItemInfo("CU.name"));
        evi.getSorter().add(new SorterItemInfo("beginDate"));
        return this.getIPeriod().getPeriodCollection(evi);
    }

    private void addTableHeader() {
        if (this.kdtPeriod.getHeadRowCount() == 0) {
            KDTableUtil.addHeaderRow((KDTable)this.kdtPeriod, (KDTableColumnItem[])this.createHeaderItems());
            String formatString = CtrlFormatUtilities.getDateFormatString();
            this.kdtPeriod.getColumn("beginDate").getStyleAttributes().setNumberFormat(formatString);
            this.kdtPeriod.getColumn("endDate").getStyleAttributes().setNumberFormat(formatString);
        }
        this.setTableState();
    }

    private void setTableState() {
        this.kdtPeriod.getColumn("id").setWidth(100);
        this.kdtPeriod.getColumn("id").getStyleAttributes().setHided(true);
        this.kdtPeriod.getColumn("id").getStyleAttributes().setLocked(true);
        this.kdtPeriod.getColumn("id").setResizeable(false);
        this.kdtPeriod.getColumn("isEdit").getStyleAttributes().setHided(true);
        this.kdtPeriod.getColumn("isEdit").getStyleAttributes().setLocked(true);
        this.kdtPeriod.getColumn("isEdit").setResizeable(false);
        this.kdtPeriod.getColumn("number").getStyleAttributes().setLocked(true);
        this.kdtPeriod.getColumn("number").setWidth(150);
        this.kdtPeriod.getColumn("periodCU").getStyleAttributes().setLocked(true);
        this.kdtPeriod.getColumn("periodCU").setWidth(150);
        this.kdtPeriod.getColumn("periodName").setWidth(150);
        this.kdtPeriod.getColumn("periodName").setRequired(true);
        this.kdtPeriod.getColumn("beginDate").setWidth(180);
        this.kdtPeriod.getColumn("beginDate").setRequired(true);
        this.kdtPeriod.getColumn("endDate").setWidth(180);
        this.kdtPeriod.getColumn("endDate").setRequired(true);
        this.kdtPeriod.getColumn("remark").setWidth(180);
        this.kdtPeriod.getSelectManager().setSelectMode(10);
    }

    private KDTableColumnItem[] createHeaderItems() {
        KDTableColumnItem[] items = new KDTableColumnItem[]{new KDTableColumnItem("id", EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"ID")), new KDTableColumnItem("number", EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodNumber")), new KDTableColumnItem("periodName", EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodName")), new KDTableColumnItem("beginDate", EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodBeginDate")), new KDTableColumnItem("endDate", EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodEndDate")), new KDTableColumnItem("periodCU", EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodCU")), new KDTableColumnItem("remark", EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodRemark")), new KDTableColumnItem("isEdit", EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"isEdit"))};
        return items;
    }

    @Override
    public void addNewAction_actionPerformed(ActionEvent e) throws Exception {
        try {
            if (this.cbType.getSelectedItem() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"PleaseAddPeriodType"));
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"Owner", (Object)this);
            uiContext.put((Object)"PeriodType", (Object)((ComboBoxItem)this.cbType.getSelectedItem()));
            IUIWindow uiWindow = null;
            PeriodEditUI periodEditUI = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.basedata.scm.sd.channel.client.PeriodEditUI", (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
                periodEditUI = (PeriodEditUI)uiWindow.getUIObject();
            }
            catch (UIException ex) {
                this.handUIException(ex);
            }
            this.loadList();
            if (!periodEditUI.isCancel) {
                this.addNewData(periodEditUI);
            }
        }
        catch (Exception err) {
            this.handUIException(err);
        }
    }

    private void addNewData(PeriodEditUI periodEditUI) {
        IRow lastRow = this.kdtPeriod.getRow(this.kdtPeriod.getRowCount() - 1);
        int number = 1;
        int post = -1;
        if (this.kdtPeriod.getRowCount() > 0) {
            String num = (String)lastRow.getCell("number").getValue();
            Locale L1 = new Locale("L1");
            String period = EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"period").trim();
            if (SysContext.getSysContext().getLocale().equals(L1) && period != null && period.toString().length() > 0 && period.indexOf("{") > 1) {
                period = period.substring(0, period.indexOf("{")).trim();
                num = num.substring(period.length()).trim();
            } else {
                post = num.trim().indexOf(EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"period1").trim());
                num = post > 0 ? num.substring(0, post) : num.substring(0, num.length() - 1);
            }
            number += Integer.parseInt(num);
        }
        IRow row = null;
        for (int i = 0; i < periodEditUI.kdtPeriod.getRowCount(); ++i) {
            row = this.kdtPeriod.addRow();
            row.getCell("number").setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"period"), new Integer(number + i).toString()));
            row.getCell("periodCU").setValue((Object)SysContext.getSysContext().getCurrentCtrlUnit());
            row.getCell("isEdit").setValue((Object)Boolean.TRUE);
            String formatString = CtrlFormatUtilities.getDateFormatString();
            row.getCell("beginDate").getStyleAttributes().setNumberFormat(formatString);
            row.getCell("endDate").getStyleAttributes().setNumberFormat(formatString);
            row.getCell("periodName").setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"period"), new Integer(number + i).toString()));
            row.getCell("beginDate").setValue(periodEditUI.kdtPeriod.getCell(i, "beginDate").getValue());
            row.getCell("endDate").setValue(periodEditUI.kdtPeriod.getCell(i, "endDate").getValue());
        }
    }

    @Override
    public void addNewLineAction_actionPerformed(ActionEvent e) throws Exception {
        IRow lastRow = this.kdtPeriod.getRow(this.kdtPeriod.getRowCount() - 1);
        IRow row = this.kdtPeriod.addRow();
        row.getCell("beginDate").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        row.getCell("endDate").setEditor((ICellEditor)new KDTDefaultCellEditor(new KDDatePicker()));
        String formatString = CtrlFormatUtilities.getDateFormatString();
        row.getCell("beginDate").getStyleAttributes().setNumberFormat(formatString);
        row.getCell("endDate").getStyleAttributes().setNumberFormat(formatString);
        row.getCell("periodCU").setValue((Object)SysContext.getSysContext().getCurrentCtrlUnit());
        row.getCell("isEdit").setValue((Object)Boolean.TRUE);
        if (lastRow != null) {
            String number = lastRow.getCell("number").getValue().toString();
            Locale L1 = new Locale("L1");
            String period = EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"period").trim();
            if (SysContext.getSysContext().getLocale().equals(L1) && period != null && period.toString().length() > 0 && period.indexOf("{") > 1) {
                period = period.substring(0, period.indexOf("{")).trim();
                number = number.substring(period.length()).trim();
            } else {
                int post = -1;
                post = number.trim().indexOf(EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"period1").trim());
                number = post > 0 ? number.substring(0, post) : number.substring(0, number.length() - 1);
            }
            row.getCell("number").setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"period"), new Integer(Integer.parseInt(number) + 1).toString()));
            Date lastRowEndDate = (Date)lastRow.getCell("endDate").getValue();
            if (lastRowEndDate != null) {
                lastRowEndDate = DateTimeUtils.addDay((Date)lastRowEndDate, (long)1L);
            }
            row.getCell("beginDate").setValue((Object)lastRowEndDate);
        } else {
            row.getCell("number").setValue((Object)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"period"), "1"));
            row.getCell("beginDate").setValue((Object)new Date());
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int[] row = KDTableUtil.getSelectedRows((KDTable)this.kdtPeriod);
        if (row.length != 0) {
            this.removeSet = this.getRemoveSet();
            this.removeCUList = this.getRemoveCUList();
            String id = null;
            Object cu = null;
            for (int i = row.length - 1; i >= 0; --i) {
                if (this.kdtPeriod.getRow(row[i]).getCell("id").getValue() == null) {
                    this.kdtPeriod.removeRow(row[i]);
                    continue;
                }
                id = this.kdtPeriod.getRow(row[i]).getCell("id").getValue().toString();
                cu = this.kdtPeriod.getRow(row[i]).getCell("periodCU").getValue();
                this.removeSet.add(id);
                this.removeCUList.add(cu);
                this.kdtPeriod.removeRow(row[i]);
            }
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"checkDelete"));
            SysUtil.abort();
        }
    }

    @Override
    public void refreshAction_actionPerformed(ActionEvent e) throws Exception {
        this.loadList();
    }

    @Override
    public void saveAction_actionPerformed(ActionEvent e) throws Exception {
        if (this.cbType.getSelectedItem() != null) {
            this.checkAllPeriod();
            try {
                this.updateAllPeriod();
                CacheServiceFactory.getInstance().discardType(new BOSObjectType("8F1B8397"));
            }
            catch (Exception ex1) {
                this.handUIException(ex1);
            }
            this.loadList();
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"SaveSuccess"));
            this.showMessage();
        } else {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"notFullPeriodData"));
            SysUtil.abort();
        }
    }

    @Override
    public void typeMaintenanceAction_actionPerformed(ActionEvent e) throws Exception {
        try {
            HashMap<String, PeriodListUI> ctx = new HashMap<String, PeriodListUI>();
            ctx.put("Owner", this);
            IUIFactory f = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow w = f.create("com.kingdee.eas.basedata.scm.sd.channel.client.PeriodTypeListUI", ctx);
            w.show();
            this.loadTypes(this.getIPeriodType().getPeriodTypeCollection());
            this.loadList();
        }
        catch (Exception err) {
            this.handUIException(err);
        }
    }

    @Override
    public void allotOrgAction_actionPerformed(ActionEvent e) throws Exception {
        try {
            if (this.cbType.getSelectedItem() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"PleaseAddPeriodType"));
                return;
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"Owner", (Object)this);
            uiContext.put((Object)"PeriodType", (Object)((ComboBoxItem)this.cbType.getSelectedItem()));
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.basedata.scm.sd.channel.client.PeriodAllotOrgEditUI", (Map)uiContext, null, OprtState.ADDNEW);
                uiWindow.show();
            }
            catch (UIException ex) {
                this.handUIException(ex);
            }
            this.loadList();
        }
        catch (Exception err) {
            this.handUIException(err);
        }
    }

    private void checkAllPeriod() throws Exception {
        if (this.kdtPeriod.getRowCount() > 0) {
            this.checkPeriodContinous();
        }
        this.checkCUIsEqualsWhenEdit();
        this.checkCUIsEqualsWhenDelete();
    }

    private void checkCUIsEqualsWhenDelete() throws Exception {
        if (this.cuInfo == null) {
            this.cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        if (this.removeCUList != null && this.removeCUList.size() > 0) {
            CtrlUnitInfo info = null;
            for (int i = 0; i < this.removeCUList.size(); ++i) {
                info = (CtrlUnitInfo)this.removeCUList.get(i);
                if (info == null || this.cuInfo.getId().equals((Object)info.getId())) continue;
                this.throwsExceptionForNoPermission("ACTION_DELETE", info);
            }
        }
        if (this.removeSet != null && this.removeSet.size() > 0 && this.getPeriodRelations(this.removeSet).size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"usingDataNotDelete"));
            SysUtil.abort();
        }
    }

    private void checkCUIsEqualsWhenEdit() throws Exception {
        PeriodCollection col;
        if (this.cuInfo == null) {
            this.cuInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        }
        if ((col = this.getUpdatedPeriodCollection()) != null && col.size() > 0) {
            PeriodInfo periodInfo = null;
            for (int i = 0; i < col.size(); ++i) {
                periodInfo = col.get(i);
                if (this.cuInfo.getId().equals((Object)periodInfo.getCU().getId())) continue;
                this.throwsExceptionForNoPermission("ACTION_MODIFY", periodInfo.getCU());
            }
        }
    }

    private void checkPeriodContinous() {
        int i;
        String currentPeriodName = null;
        String nextPeriodName = null;
        Date beginDate = null;
        Date endDate = null;
        IRow currentRow = null;
        IRow nextRow = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        int rowCount = this.kdtPeriod.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            currentRow = this.kdtPeriod.getRow(i);
            endDate = (Date)currentRow.getCell("endDate").getValue();
            beginDate = (Date)currentRow.getCell("beginDate").getValue();
            if (currentRow.getCell("periodName").getValue() == null || "".equals(currentRow.getCell("periodName").getValue())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodNameNotNull"));
                SysUtil.abort();
            }
            if (currentRow.getCell("periodName").getValue().toString().length() > 100) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodNameLengthNotGreaterThan100"));
                SysUtil.abort();
            }
            if (beginDate == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodBeginDateNotNull"));
                SysUtil.abort();
            }
            if (endDate == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodEndDateNotNull"));
                SysUtil.abort();
            }
            if (endDate.compareTo(beginDate) < 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"beginDateEarlierThanEndDate"));
                SysUtil.abort();
            }
            if (currentRow.getCell("remark").getValue() == null || "".equals(currentRow.getCell("remark").getValue()) || currentRow.getCell("remark").getValue().toString().length() <= 255) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"remarkLengthNotGreaterThan255"));
            SysUtil.abort();
        }
        for (i = 0; i < this.kdtPeriod.getRowCount() - 1; ++i) {
            currentRow = this.kdtPeriod.getRow(i);
            nextRow = this.kdtPeriod.getRow(i + 1);
            currentPeriodName = currentRow.getCell("periodName").getValue().toString();
            if (currentPeriodName.equals(nextPeriodName = nextRow.getCell("periodName").getValue().toString())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"periodNameNotRepeat"));
                SysUtil.abort();
            }
            endDate = (Date)currentRow.getCell("endDate").getValue();
            beginDate = (Date)nextRow.getCell("beginDate").getValue();
            if (sdf.format(endDate = ChannelCalendarUtil.changeDate(endDate, 1)).equals(sdf.format(beginDate))) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"DateNotSeries"));
            SysUtil.abort();
        }
    }

    private RequirementPlanCollection getPeriodRelations(Set id) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("requirementPlanPeriod.id", (Object)id, CompareType.INCLUDE));
        view.setFilter(filter);
        RequirementPlanCollection col = null;
        try {
            col = RequirementPlanFactory.getRemoteInstance().getRequirementPlanCollection(view);
        }
        catch (BOSException e) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"dataIsUsingError"));
        }
        return col;
    }

    private void updateAllPeriod() throws Exception {
        IObjectPK[] list = null;
        if (this.removeSet != null && this.removeSet.size() > 0) {
            list = new IObjectPK[this.removeSet.size()];
            int listSize = 0;
            Iterator it = this.removeSet.iterator();
            while (it.hasNext()) {
                list[listSize] = new ObjectUuidPK(BOSUuid.read((String)it.next().toString()));
                ++listSize;
            }
        }
        PeriodCollection pecol = this.getUpdatedPeriodCollection();
        if (list != null && list.length > 0 || pecol != null && pecol.size() > 0) {
            this.iPeriod.updatePeriodCollection(pecol, list);
        }
    }

    private PeriodCollection getUpdatedPeriodCollection() {
        String period;
        PeriodCollection pCollection = new PeriodCollection();
        PeriodTypeInfo typeInfo = new PeriodTypeInfo();
        typeInfo.setId(BOSUuid.read((String)((ComboBoxItem)this.cbType.getSelectedItem()).getValue().toString()));
        PeriodInfo periodInfo = null;
        IRow row = null;
        int post = -1;
        Locale L1 = new Locale("L1");
        String periodOld = period = EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"period").trim();
        period = period.substring(0, period.indexOf("{")).trim();
        for (int i = 0; i < this.kdtPeriod.getRowCount(); ++i) {
            row = this.kdtPeriod.getRow(i);
            if (row.getCell("isEdit").getValue().equals(Boolean.FALSE)) continue;
            periodInfo = new PeriodInfo();
            if (row.getCell("id").getValue() != null) {
                periodInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            }
            periodInfo.setType(typeInfo);
            if (SysContext.getSysContext().getLocale().equals(L1) && periodOld != null && periodOld.toString().length() > 0 && periodOld.indexOf("{") > 1) {
                periodInfo.setNumber(row.getCell("number").getValue().toString().trim().substring(period.length()).toString().trim());
            } else {
                post = row.getCell("number").getValue().toString().trim().indexOf(EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.client.PeriodResource", (String)"period1"));
                periodInfo.setNumber(row.getCell("number").getValue().toString().trim().substring(0, post).toString().trim());
            }
            periodInfo.setName(row.getCell("periodName").getValue().toString());
            try {
                periodInfo.setBeginDate((Date)row.getCell("beginDate").getValue());
                periodInfo.setEndDate((Date)row.getCell("endDate").getValue());
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
            periodInfo.setCU((CtrlUnitInfo)row.getCell("periodCU").getValue());
            if (row.getCell("remark").getValue() != null) {
                periodInfo.setDescription(row.getCell("remark").getValue().toString());
            }
            pCollection.add(periodInfo);
        }
        return pCollection;
    }

    @Override
    protected void cbType_itemStateChanged(ItemEvent e) throws Exception {
        super.cbType_itemStateChanged(e);
        try {
            this.kdtPeriod.removeRows();
            this.loadList();
            this.removeSet = new HashSet();
            this.removeCUList = new ArrayList();
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    @Override
    protected void kdtPeriod_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        this.kdtPeriod.getCell(rowIndex, "isEdit").setValue((Object)Boolean.TRUE);
    }

    private void throwsExceptionForNoPermission(String action, CtrlUnitInfo info) throws Exception {
        if (action.equals("ACTION_ADDNEW")) {
            throw new PeriodException(PeriodException.CAN_NOT_ADD, new Object[]{info.getName()});
        }
        if (action.equals("ACTION_DELETE")) {
            throw new PeriodException(PeriodException.CAN_NOT_DELETE, new Object[]{info.getName()});
        }
        if (action.equals("ACTION_MODIFY")) {
            throw new PeriodException(PeriodException.CAN_NOT_UPDATE, new Object[]{info.getName()});
        }
    }
}

