/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.channel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.agent.AgentUtility;
import com.kingdee.bos.framework.agent.IObjectValueAgent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CityCollection;
import com.kingdee.eas.basedata.assistant.CityFactory;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.ICity;
import com.kingdee.eas.basedata.assistant.IProvince;
import com.kingdee.eas.basedata.assistant.ProvinceCollection;
import com.kingdee.eas.basedata.assistant.ProvinceFactory;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.scm.sd.channel.AutoAuditEnum;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBrowseGroupInfo;
import com.kingdee.eas.basedata.scm.sd.channel.DataCollectionTypeEnum;
import com.kingdee.eas.basedata.scm.sd.channel.IChannelBase;
import com.kingdee.eas.basedata.scm.sd.channel.NetOrderCollectManagerEnum;
import com.kingdee.eas.basedata.scm.sd.channel.NetOrderInvControlEnum;
import com.kingdee.eas.basedata.scm.sd.channel.SaleChannelInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ShowStorageEnum;
import com.kingdee.eas.basedata.scm.sd.channel.TerminalChannelStatusEnum;
import com.kingdee.eas.basedata.scm.sd.channel.TerminalChannelTypeEnum;
import com.kingdee.eas.basedata.scm.sd.channel.UpdataStorageEnum;
import com.kingdee.eas.basedata.scm.sd.channel.client.AbstractSaleChannelEditUI;
import com.kingdee.eas.basedata.scm.sd.channel.client.ChannelSaleInfoEditUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.util.StringUtils;
import com.kingdee.eas.framework.client.TabEditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SaleChannelEditUI
extends AbstractSaleChannelEditUI {
    private static final String RESOURCE_CHANNEL = "com.kingdee.eas.basedata.scm.sd.channel.ChannelResource";
    private EventsListener event = new EventsListener();
    private SelectItemListener selectChangeEvent = new SelectItemListener();
    private String copyChannelBaseID = null;
    private String copyChannelBaseNum = null;
    private String copyChannelBaseName = null;
    private boolean isUsedCodingRule = false;
    private boolean isCodingRuleModifiable = false;
    private boolean isAddNewCodingRule = false;
    private boolean isAddNoBreakCodingRule = false;

    protected IObjectValue createNewData() {
        super.createNewData();
        ChannelBaseInfo info = new ChannelBaseInfo();
        try {
            Timestamp createTime = SCMClientUtils.getServerDate();
            info.setCreateTime(createTime);
            info.setIsCollectManager(NetOrderCollectManagerEnum.YES);
            info.setIsControlInven(NetOrderInvControlEnum.NOTSUBMIT);
            info.setIsControlWeight(NetOrderInvControlEnum.NOTSUBMIT);
            info.setIsAutoAudit(AutoAuditEnum.YES);
            this.kDLabelContainer10.setEnabled(true);
            this.kDLabelContainer11.setEnabled(true);
            info.setIsControlBalance(NetOrderInvControlEnum.WARNING);
            info.setLeastWeight(new BigDecimal("0.0"));
            if (this.getUIContext().containsKey("ParentNode")) {
                ChannelBrowseGroupInfo defaultGroupInfo;
                ChannelBrowseGroupInfo groupInfo = defaultGroupInfo = (ChannelBrowseGroupInfo)this.getUIContext().get("ParentNode");
                info.setBrowseGroup(groupInfo);
            }
            UserInfo aUserInfo = SysContext.getSysContext().getCurrentUserInfo();
            info.setCreator(aUserInfo);
            SaleChannelInfo saleChannelInfo = new SaleChannelInfo();
            info.setSaleChannel(saleChannelInfo);
            info.setTerminalChannelStatus(TerminalChannelStatusEnum.UNAPPROVE);
            info.setTerminalChannelType(TerminalChannelTypeEnum.CHANNEL);
            info.setDataCollectionType(DataCollectionTypeEnum.REPORTINSALE);
            info.setIsUpdataStorage(UpdataStorageEnum.NO);
            info.setIsShowStorage(ShowStorageEnum.NOTSHOWIMV);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ChannelBaseFactory.getRemoteInstance();
    }

    public void registerTabInfo() {
        TabEditUI.TabInfo tabBaseInfo = new TabEditUI.TabInfo((TabEditUI)this, this.kdTMain, 0, false, ((Object)((Object)this)).getClass());
        TabEditUI.TabInfo tabSaleInfo = new TabEditUI.TabInfo((TabEditUI)this, this.kdTMain, 1, true, ChannelSaleInfoEditUI.class);
        this.registerUI.add(tabBaseInfo);
        this.registerUI.add(tabSaleInfo);
    }

    public KDTabbedPane[] getKDTabs() {
        KDTabbedPane[] tabs = new KDTabbedPane[]{this.kdTMain};
        return tabs;
    }

    public void setCurrentInterface() {
        super.setCurrentInterface();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.activeTabbedPane = this.kdTMain;
        this.activeUI = this;
        this.activeVOInfo = this.editData;
        this.activeTabIndex = 0;
        this.initF7Control();
        this.setSaleChannelInfoContext();
        this.initControl();
    }

    private void initControl() {
        this.kDDataCollectType.setEnabled(true);
        this.btnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnApprove.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnCancelCancel.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnCancel.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnMultiPageCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copyall"));
        this.menuItemMultiPageCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copyall"));
        this.btnMultiSave.setIcon(EASResource.getIcon((String)"imgTbtn_saveall"));
        this.btnMultiPageCopy.setEnabled(true);
        this.menuItemMultiPageCopy.setEnabled(true);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCopy.setVisible(false);
        this.txtNumber.setMaxLength(80);
        this.mulName.setMaxLength(120);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.btnApprove.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.btnCancel.setEnabled(false);
        } else {
            this.btnApprove.setEnabled(true);
            this.btnUnApprove.setEnabled(true);
            this.btnCancelCancel.setEnabled(true);
            this.btnCancel.setEnabled(true);
        }
        if (this.editData.getTerminalChannelStatus().equals((Object)TerminalChannelStatusEnum.UNAPPROVE)) {
            this.btnApprove.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.btnUnApprove.setEnabled(false);
            this.btnCancel.setEnabled(true);
            this.btnApprove.setVisible(true);
            this.btnCancelCancel.setVisible(false);
            this.btnUnApprove.setVisible(false);
            this.btnCancel.setVisible(true);
        } else if (this.editData.getTerminalChannelStatus().equals((Object)TerminalChannelStatusEnum.APPROVE)) {
            this.btnApprove.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.btnUnApprove.setEnabled(true);
            this.btnCancel.setEnabled(true);
            this.btnApprove.setVisible(false);
            this.btnCancelCancel.setVisible(false);
            this.btnUnApprove.setVisible(true);
            this.btnCancel.setVisible(true);
        } else if (this.editData.getTerminalChannelStatus().equals((Object)TerminalChannelStatusEnum.FORBIDDEN)) {
            this.btnApprove.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.btnUnApprove.setEnabled(true);
            this.btnCancel.setEnabled(false);
            this.btnApprove.setVisible(false);
            this.btnCancelCancel.setVisible(true);
            this.btnUnApprove.setVisible(true);
            this.btnCancel.setVisible(false);
        }
        if (!this.getOprtState().equals(OprtState.VIEW) && this.editData.getId() != null) {
            this.btnRemove.setEnabled(true);
        } else {
            this.btnRemove.setEnabled(false);
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.btnCopy.setEnabled(false);
            this.menuItemCopy.setEnabled(false);
            this.btnMultiPageCopy.setEnabled(false);
            this.menuItemMultiPageCopy.setEnabled(false);
        }
        if (this.editData != null && this.editData.getCustomer() != null) {
            this.btnMultiPageCopy.setEnabled(false);
            this.menuItemMultiPageCopy.setEnabled(false);
        }
        this.menuItemCancel.setEnabled(true);
        this.menuItemCancelCancel.setEnabled(true);
        this.prmtAddress.setMaxLength(200);
        if (this.editData.getId() == null) {
            this.btnApprove.setEnabled(false);
            this.btnCancel.setEnabled(false);
        }
    }

    private void initCodeRuleControl() {
        try {
            if (this.isChannelBaseUsedCodingRule() && this.editData != null && this.editData.getNumber() == null) {
                this.getNumberByRule((IObjectValue)this.editData);
            }
            if (!OprtState.ADDNEW.equals(this.getOprtState())) {
                this.initTxtNumber(this.editData);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void setSaleChannelInfoContext() {
        if (this.editData != null && this.editData.getId() != null) {
            this.getUIContext().put("channelInfoID", this.editData.getId().toString());
            this.getUIContext().put("channelInfo", this.editData);
        }
    }

    private void initF7Control() {
        this.initF7ChannelGroup();
        this.initF7Customer();
    }

    private void initF7ChannelGroup() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), (String)SysContext.getSysContext().getCurrentCtrlUnit().getLongNumber());
        evi.setFilter(filterInfoCU);
        this.prtmtChannelGroup.setEntityViewInfo(evi);
    }

    private void initF7Customer() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)new Integer(1), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isInternalCompany", (Object)new Boolean(false), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.prmtCustomer.setEntityViewInfo(viewInfo);
    }

    protected boolean isAllowTabChange() {
        if (this.activeTabIndex == 0) {
            boolean re = this.checkHasBaseInfo();
            if (!re) {
                this.setAllowTabChange(false);
                return false;
            }
            AbstractObjectValue oldValue = null;
            oldValue = this.activeUI.getDataObject() instanceof IObjectValueAgent ? (AbstractObjectValue)AgentUtility.deepCopyAgentValue((IObjectValueAgent)((IObjectValueAgent)this.activeUI.getDataObject())) : (AbstractObjectValue)((AbstractObjectValue)this.activeUI.getDataObject()).clone();
            if (this.isModify()) {
                int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
                switch (result) {
                    case 0: {
                        try {
                            ActionEvent event = new ActionEvent(this.btnSubmit, 1001, this.btnSubmit.getActionCommand());
                            this.activeUI.actionSubmit_actionPerformed(event);
                        }
                        catch (Exception e) {
                            this.handUIException(e);
                            return false;
                        }
                        this.setAllowTabChange(true);
                        break;
                    }
                    case 1: {
                        ArrayList list;
                        boolean tag = false;
                        ArrayList<String> arr1 = new ArrayList<String>();
                        arr1.add(new String("tagState"));
                        if (this.activeUI.getUIContext().get(arr1) != null && (list = (ArrayList)this.activeUI.getUIContext().get(arr1)).get(0) != null) {
                            tag = (Boolean)list.get(0);
                        }
                        if (!tag) {
                            this.activeUI.getUIContext().put("InitDataObject", oldValue);
                        }
                        this.setAllowTabChange(true);
                        break;
                    }
                    default: {
                        this.setAllowTabChange(false);
                        return false;
                    }
                }
            } else {
                this.setAllowTabChange(true);
            }
            if (this.activeUI.getOprtState().equalsIgnoreCase("ADDNEW")) {
                this.activeUI.setOprtState(this.getOprtState());
            }
        }
        return true;
    }

    public boolean checkHasBaseInfo() {
        if (this.editData == null || this.editData.getId() == null) {
            MsgBox.showError((String)EASResource.getString((String)RESOURCE_CHANNEL, (String)"NoSaceBaseInfo"));
            return false;
        }
        return true;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.setSaleChannelInfoContext();
    }

    protected void doBeforeSubmit(ActionEvent e) throws Exception {
        super.doBeforeSubmit(e);
    }

    private void addEventsListener() {
        this.prmtCustomer.addChangeListener((ChangeListener)this.event);
        this.kDIsWeightControl.addItemListener((ItemListener)this.selectChangeEvent);
    }

    private void removeEventsListerner() {
        this.prmtCustomer.removeChangeListener((ChangeListener)this.event);
        this.kDIsWeightControl.removeItemListener((ItemListener)this.selectChangeEvent);
    }

    @Override
    public void loadFields() {
        this.removeEventsListerner();
        super.loadFields();
        this.addEventsListener();
        this.initControl();
        this.initCodeRuleControl();
        this.setSaleChannelInfoContext();
        if (this.editData != null && this.editData.getIsCollectManager() != null) {
            if (NetOrderCollectManagerEnum.YES.equals((Object)this.editData.getIsCollectManager())) {
                this.kDIsCollect.setSelectedItem((Object)NetOrderCollectManagerEnum.NO);
            } else if (NetOrderCollectManagerEnum.NO.equals((Object)this.editData.getIsCollectManager())) {
                this.kDIsCollect.setSelectedItem((Object)NetOrderCollectManagerEnum.YES);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData != null && this.kDIsCollect.getSelectedItem() != null) {
            if (NetOrderCollectManagerEnum.YES.equals(this.kDIsCollect.getSelectedItem())) {
                this.editData.setIsCollectManager(NetOrderCollectManagerEnum.NO);
            } else if (NetOrderCollectManagerEnum.NO.equals(this.kDIsCollect.getSelectedItem())) {
                this.editData.setIsCollectManager(NetOrderCollectManagerEnum.YES);
            }
        }
    }

    public void prmtCustomer_stateChanged(ChangeEvent e) throws BOSException {
        CustomerInfo customerInfo = (CustomerInfo)this.prmtCustomer.getValue();
        Object info = null;
        if (customerInfo != null) {
            this.btnMultiPageCopy.setEnabled(false);
            this.menuItemMultiPageCopy.setEnabled(false);
            this.mulName.setSelectedItemData((Object)customerInfo.getName());
            this.txtNumber.setText(customerInfo.getNumber());
            this.prmtProvince.setValue((Object)customerInfo.getProvince());
            CityInfo cityInfo = null;
            if (customerInfo.getCity() != null && customerInfo.getCity().getId() != null) {
                cityInfo = this.getCityInfo(customerInfo.getCity().getId().toString());
            }
            if (cityInfo != null) {
                this.prmtCity.setValue(cityInfo);
            }
            ProvinceInfo provinceInfo = null;
            if (customerInfo.getProvince() != null && customerInfo.getProvince().getId() != null) {
                provinceInfo = this.getProvinceInfo(customerInfo.getProvince().getId().toString());
            }
            if (provinceInfo != null) {
                this.prmtProvince.setValue(provinceInfo);
            }
            this.prmtAddress.setText(customerInfo.getAddress());
        } else {
            this.btnMultiPageCopy.setEnabled(true);
            this.menuItemMultiPageCopy.setEnabled(true);
        }
    }

    protected void kDIsWeightControl_itemStateChanged(ItemEvent e) throws Exception {
        if (this.kDIsWeightControl.getShowSelectedItem().equals((Object)NetOrderInvControlEnum.NOCONTROL)) {
            this.kDleastWeight.setValue((Object)new BigDecimal("0.00"));
            this.prmtWeightUnit.setValue(null);
            this.kDLabelContainer10.setEnabled(false);
            this.kDLabelContainer11.setEnabled(false);
        } else {
            this.kDLabelContainer10.setEnabled(true);
            this.kDLabelContainer11.setEnabled(true);
        }
    }

    private CityInfo getCityInfo(String id) throws BOSException {
        if (id != null && id.length() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            viewInfo.setFilter(filterInfo);
            ICity iCity = CityFactory.getRemoteInstance();
            CityCollection cityCollection = iCity.getCityCollection(viewInfo);
            if (cityCollection != null && cityCollection.size() > 0) {
                return cityCollection.get(0);
            }
        }
        return null;
    }

    private ProvinceInfo getProvinceInfo(String id) throws BOSException {
        if (id != null && id.length() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            viewInfo.setFilter(filterInfo);
            IProvince iProvince = ProvinceFactory.getRemoteInstance();
            ProvinceCollection provinceCollection = iProvince.getProvinceCollection(viewInfo);
            if (provinceCollection != null && provinceCollection.size() > 0) {
                return provinceCollection.get(0);
            }
        }
        return null;
    }

    @Override
    public void multiPageCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getId() != null) {
            this.copyChannelBaseID = this.editData.getId().toString();
            this.copyChannelBaseName = this.editData.getName();
            this.copyChannelBaseNum = this.editData.getNumber();
        }
        this.updateForCopy();
        this.editData.setIsMultiCopy(true);
        this.editData.setAvailable(false);
        super.actionCopy_actionPerformed(e);
        this.editData.setAvailable(true);
        this.btnSubmit.setEnabled(false);
        this.txtNumber.setText(this.copyChannelBaseNum + "COPY");
        this.mulName.setSelectedItemData((Object)(this.copyChannelBaseName + "COPY"));
        this.editData.setString("copyOldChannelBaseId", this.copyChannelBaseID);
        this.btnEdit.setEnabled(true);
        this.btnMultiSave.setEnabled(true);
    }

    @Override
    public void actionSubmitAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.setSaleChannelInfoContext();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String str;
        super.beforeStoreFields(e);
        StringBuffer sb = new StringBuffer();
        if (this.prtmtChannelGroup.getData() == null) {
            str = EASResource.getString((String)RESOURCE_CHANNEL, (String)"channelGroupNotNull");
            sb.append(str);
            this.prtmtChannelGroup.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)sb.toString());
            sb.setLength(0);
            SysUtil.abort();
        }
        if (this.kDDataCollectType.getSelectedItem() == null) {
            str = EASResource.getString((String)RESOURCE_CHANNEL, (String)"dataCollectTypeNotNull");
            sb.append(str);
            this.kDDataCollectType.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)sb.toString());
            sb.setLength(0);
            SysUtil.abort();
        }
        if (this.kDCAssistByLot.getSelectedItem() == null) {
            str = EASResource.getString((String)RESOURCE_CHANNEL, (String)"channelLotAssistNotNull");
            sb.append(str);
            this.kDCAssistByLot.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)sb.toString());
            sb.setLength(0);
            SysUtil.abort();
        }
        if (this.mulName.getEditor().getItem() == null || this.mulName.getEditor().getItem().toString().trim().length() < 1) {
            str = EASResource.getString((String)RESOURCE_CHANNEL, (String)"channelNameNotNull");
            sb.append(str);
            this.kDCAssistByLot.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)sb.toString());
            sb.setLength(0);
            SysUtil.abort();
        }
        if (!this.kDIsWeightControl.getSelectedItem().equals((Object)NetOrderInvControlEnum.NOCONTROL) && this.kDleastWeight.getBigDecimalValue().compareTo(new BigDecimal("0.0")) < 0) {
            this.kDleastWeight.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.CHANNELAutoGenerateResource", (String)"0_SaleChannelEditUI"));
            SysUtil.abort();
        }
    }

    private void updateForCopy() throws Exception {
        this.editData.setLastUpdateTime(null);
        this.editData.setLastUpdateUser(null);
        this.editData.setTerminalChannelStatus(TerminalChannelStatusEnum.UNAPPROVE);
        Timestamp createTime = SCMClientUtils.getServerDate();
        this.editData.setCreateTime(createTime);
        UserInfo aUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        this.editData.setCreator(aUserInfo);
        CtrlUnitInfo ctrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        this.editData.setCU(ctrlUnitInfo);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.updateForCopy();
        super.actionCopy_actionPerformed(e);
    }

    @Override
    public void actionApprove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            IChannelBase iChanneBase = ChannelBaseFactory.getRemoteInstance();
            try {
                this.pubFireVOChangeListener(this.editData.getId().toString());
            }
            catch (Throwable e1) {
                Logger.error((Throwable)e1);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request"));
                return;
            }
            iChanneBase.audit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.editData.getId().toString())));
            try {
                this.setOprtState("RELEASEALL");
                this.pubFireVOChangeListener(this.editData.getId().toString());
                this.setSaved(true);
            }
            catch (Throwable e2) {
                this.handUIException(e2);
            }
            this.refreshInterface();
        }
    }

    @Override
    public void actionUnApprove_actionPerformed(ActionEvent e) throws Exception {
        IChannelBase iChanneBase = ChannelBaseFactory.getRemoteInstance();
        iChanneBase.unAudit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.editData.getId().toString())));
        this.setSaved(true);
        this.refreshInterface();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        IChannelBase iChanneBase = ChannelBaseFactory.getRemoteInstance();
        iChanneBase.forbidden((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.editData.getId().toString())));
        this.refreshInterface();
    }

    @Override
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        IChannelBase iChanneBase = ChannelBaseFactory.getRemoteInstance();
        iChanneBase.unForbidden((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.editData.getId().toString())));
        this.refreshInterface();
    }

    private void refreshInterface() {
        try {
            IChannelBase iChannelBase = (IChannelBase)this.getBizInterface();
            if (this.editData.getId() != null) {
                ObjectUuidPK iObjectPk = new ObjectUuidPK(this.editData.getId());
                this.editData = iChannelBase.getChannelBaseInfo((IObjectPK)iObjectPk, this.getSelectors());
            }
        }
        catch (Exception e) {
            super.handleException(e);
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("terminalChannelType"));
        return sic;
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setSaleChannelInfoContext();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.setSaleChannelInfoContext();
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.setSaleChannelInfoContext();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setSaleChannelInfoContext();
    }

    private void getNumberByRule(IObjectValue caller) {
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.COPYADDNEW)) {
            if (this.isUsedCodingRule) {
                this.txtNumber.setEditable(false);
                this.txtNumber.setEnabled(false);
                if (this.isAddNewCodingRule) {
                    this.getNumberByCodingRule(caller, SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
                } else if (this.isAddNoBreakCodingRule) {
                    try {
                        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                        String number = iCodingRuleManager.readNumber(caller, SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
                        this.prepareNumber(caller, number);
                    }
                    catch (Exception e) {
                        this.handUIException(e);
                    }
                }
            }
        } else {
            this.setNumberTextEnabled();
        }
    }

    private boolean isChannelBaseUsedCodingRule() throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        String strCompanyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)new ChannelBaseInfo());
        ChannelBaseInfo channelBaseInfo = new ChannelBaseInfo();
        this.isUsedCodingRule = iCodingRuleManager.isExist((IObjectValue)channelBaseInfo, strCompanyID);
        if (this.isUsedCodingRule) {
            this.isCodingRuleModifiable = iCodingRuleManager.isModifiable((IObjectValue)channelBaseInfo, strCompanyID);
            this.isAddNewCodingRule = iCodingRuleManager.isAddView((IObjectValue)channelBaseInfo, strCompanyID);
            this.isAddNoBreakCodingRule = iCodingRuleManager.getRuleStatus((IObjectValue)channelBaseInfo, strCompanyID).isAddNoBreak();
        }
        return this.isUsedCodingRule;
    }

    protected void setNumberTextEnabled() {
        this.txtNumber.setEditable(true);
        this.txtNumber.setEnabled(true);
    }

    protected void prepareNumber(IObjectValue caller, String number) {
        this.txtNumber.setStringValue(number);
    }

    private void initTxtNumber(ChannelBaseInfo channelBaseInfo) {
        if (channelBaseInfo != null && channelBaseInfo.getId() != null) {
            boolean isModify = false;
            try {
                if (this.isUsedCodingRule) {
                    if (this.isCodingRuleModifiable) {
                        isModify = true;
                    }
                } else {
                    isModify = true;
                }
                if (isModify) {
                    this.setNumberTextEnabled();
                } else {
                    this.txtNumber.setEditable(false);
                    this.txtNumber.setEnabled(false);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initTxtNumber(this.editData);
        this.btnRemove.setEnabled(true);
    }

    public boolean isModify() {
        String channelName = (String)this.mulName.getSelectedItemData();
        if (StringUtils.isEmpty((String)channelName) || this.chkMenuItemSubmitAndAddNew.isSelected() && this.chkMenuItemSubmitAndAddNew.isVisible() && StringUtils.isEmpty((String)channelName)) {
            return false;
        }
        return super.isModify();
    }

    private class SelectItemListener
    implements ItemListener {
        private SelectItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (source.equals(SaleChannelEditUI.this.kDIsWeightControl)) {
                // empty if block
            }
            try {
                SaleChannelEditUI.this.kDIsWeightControl_itemStateChanged(e);
            }
            catch (Exception e1) {
                Logger.error((Throwable)e1);
            }
        }
    }

    private class EventsListener
    implements ChangeListener {
        private EventsListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            try {
                if (source.equals(SaleChannelEditUI.this.prmtCustomer)) {
                    SaleChannelEditUI.this.prmtCustomer_stateChanged(e);
                }
            }
            catch (Exception ex) {
                SaleChannelEditUI.this.handUIException(ex);
            }
        }
    }
}

