/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.channel.client.support.customersmr;

import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseCollection;
import com.kingdee.eas.basedata.scm.sd.channel.CustomersMRDimensionEnum;
import com.kingdee.eas.basedata.scm.sd.channel.CustomersMaterialsRelationInfo;
import com.kingdee.eas.basedata.scm.sd.channel.client.support.customersmr.CustomersMRDimension;
import com.kingdee.eas.basedata.scm.sd.channel.client.support.customersmr.CustomersMRTreeNodeInfo;
import com.kingdee.eas.basedata.scm.sd.channel.client.support.customersmr.CustomersMaterialsRelationListUISupport;
import com.kingdee.eas.basedata.scm.sd.channel.common.CustomersMaterialsRelationUtils;
import java.util.HashSet;
import java.util.List;

public abstract class BizPromptBoxDataProcessStrategy {
    private CustomersMRDimension currentDimension;

    public BizPromptBoxDataProcessStrategy(CustomersMRDimension currentDimension) {
        this.currentDimension = currentDimension;
    }

    public BizPromptBoxDataProcessStrategy() {
    }

    public void process(CustomersMaterialsRelationInfo detailData, KDTree treeMain, KDTable kdtEntries, DataBinder dataBinder) {
        IObjectValue[] objectValues;
        KDPromptSelector promptSelector = this.getCurrentDimension().getBizPromptBox().getSelector();
        if (promptSelector.isCanceled()) {
            return;
        }
        Object data = promptSelector.getData();
        List treeNodeInfoList = this.getTreeNodeInfoList(treeMain);
        CustomersMRTreeNodeInfo customersMRTreeNodeInfo = null;
        CustomersMaterialsRelationInfo insertData = null;
        if (null != treeNodeInfoList && 0 < treeNodeInfoList.size() && null != (objectValues = this.getObjectValues(data))) {
            ChannelBaseCollection channelColl = this.getCurrentChannelCollection(treeNodeInfoList, objectValues);
            int length = objectValues.length;
            for (int i = 0; i < length; ++i) {
                int size = treeNodeInfoList.size();
                for (int j = 0; j < size; ++j) {
                    customersMRTreeNodeInfo = (CustomersMRTreeNodeInfo)((Object)treeNodeInfoList.get(j));
                    insertData = (CustomersMaterialsRelationInfo)detailData.clone();
                    this.initDetailData(insertData, customersMRTreeNodeInfo, objectValues[i], channelColl);
                    if (this.isExistInTable(kdtEntries, insertData)) continue;
                    IRow iRow = kdtEntries.addRow(0);
                    dataBinder.loadLineFields(kdtEntries, iRow, (IObjectValue)insertData);
                }
            }
            try {
                CustomersMaterialsRelationListUISupport.setEditableTableStyleAttributes(kdtEntries);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private ChannelBaseCollection getCurrentChannelCollection(List treeNodeInfoList, IObjectValue[] objectValues) {
        HashSet<BOSUuid> customerIdSet = new HashSet<BOSUuid>();
        if (this.getCurrentDimensionValue() == CustomersMRDimensionEnum.MATERIAL) {
            int length = objectValues.length;
            for (int i = 0; i < length; ++i) {
                customerIdSet.add(((CustomerInfo)objectValues[i]).getId());
            }
        } else {
            int size = treeNodeInfoList.size();
            for (int j = 0; j < size; ++j) {
                customerIdSet.add(((CustomersMRTreeNodeInfo)((Object)treeNodeInfoList.get(j))).newCustomerInfoByTreeNode().getId());
            }
        }
        return CustomersMaterialsRelationUtils.getChannelCollectionOfCustomerIDs(null, customerIdSet);
    }

    protected abstract List getTreeNodeInfoList(KDTree var1);

    protected abstract IObjectValue[] getObjectValues(Object var1);

    protected abstract void initDetailData(CustomersMaterialsRelationInfo var1, CustomersMRTreeNodeInfo var2, IObjectValue var3, ChannelBaseCollection var4);

    protected abstract CustomersMRDimensionEnum getCurrentDimensionValue();

    public CustomersMRDimension getCurrentDimension() {
        return this.currentDimension;
    }

    public void setCurrentDimension(CustomersMRDimension currentDimension) {
        this.currentDimension = currentDimension;
    }

    private boolean isExistInTable(KDTable kdtEntries, CustomersMaterialsRelationInfo insertData) {
        CustomersMaterialsRelationInfo customersMaterialsRelationInfo = null;
        int rows = kdtEntries.getRowCount();
        for (int index = 0; index < rows; ++index) {
            customersMaterialsRelationInfo = (CustomersMaterialsRelationInfo)kdtEntries.getRow(index).getUserObject();
            if (!insertData.equals(customersMaterialsRelationInfo)) continue;
            return true;
        }
        return false;
    }
}

