/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.channel.client.support.customersmr;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.channel.client.support.customersmr.CustomersMRDimension;
import com.kingdee.eas.basedata.scm.sd.channel.client.support.customersmr.CustomersMRTreeNodeInfo;
import com.kingdee.eas.basedata.scm.sd.channel.common.CustomersMaterialsRelationUtils;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.util.FilterUtility;

public abstract class CustomersMRQueryStrategy {
    private CustomersMRDimension currentDimension;
    private String queryFieldName;
    private String queryGroupFieldName;
    private String queryStandardFieldName;
    private boolean isBaseStardarGroupStandard = true;
    private FilterInfo databaseDFilter = null;
    private FilterInfo saleOrgUnitFilter = null;

    public CustomersMRQueryStrategy(CustomersMRDimension currentDimension, String queryStandardFieldName, String queryGroupFieldName, String queryFieldName) {
        this.currentDimension = currentDimension;
        this.queryFieldName = queryFieldName;
        this.queryGroupFieldName = queryGroupFieldName;
        this.queryStandardFieldName = queryStandardFieldName;
    }

    public CustomersMRQueryStrategy() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIncludeChildFilter(EntityViewInfo mainQuery, KDTreeNode currentNode, KDCheckBox chkIncludeChild) {
        FilterItemCollection cols = mainQuery.getFilter().getFilterItems();
        Object userObject = currentNode.getUserObject();
        if (userObject instanceof CustomersMRTreeNodeInfo) {
            CustomersMRTreeNodeInfo customersMRTreeNodeInfo = (CustomersMRTreeNodeInfo)((Object)currentNode.getUserObject());
            if (null == customersMRTreeNodeInfo.getId()) return;
            cols.add(new FilterItemInfo(this.getQueryFieldName(), (Object)customersMRTreeNodeInfo.getId().toString()));
            cols.add(new FilterItemInfo(this.getQueryStandardFieldName(), (Object)this.getCurrentDimension().getGroupStandardId()));
            return;
        } else if (chkIncludeChild.isSelected()) {
            FilterInfo tempFilter = new FilterInfo();
            if (userObject instanceof TreeBaseInfo) {
                String longNumber;
                TreeBaseInfo treeBaseInfo = (TreeBaseInfo)userObject;
                String string = longNumber = treeBaseInfo == null ? "" : treeBaseInfo.getLongNumber();
                if (longNumber != null && longNumber.length() > 0) {
                    if (this.isBaseStardarGroupStandard()) {
                        this.setChildFilterForBaseStandard(tempFilter, longNumber);
                    } else {
                        this.setChildFilterForNoBaseStandard(cols, longNumber);
                    }
                }
            } else {
                this.setChildFilterForRoot(cols);
            }
            if (cols.size() > 0) {
                try {
                    if (tempFilter == null || tempFilter.getFilterItems().size() <= 0) return;
                    mainQuery.getFilter().mergeFilter(tempFilter, "AND");
                    return;
                }
                catch (BOSException e) {
                    throw new RuntimeException(e);
                }
            } else {
                mainQuery.setFilter((FilterInfo)tempFilter.clone());
            }
            return;
        } else {
            cols.add(new FilterItemInfo(this.getQueryFieldName(), (Object)"null"));
        }
    }

    public FilterInfo getDataBaseDFilter() {
        if (null == this.databaseDFilter || !FilterUtility.hasFilterItem((FilterInfo)this.databaseDFilter)) {
            this.initDatabaseDFilter();
        }
        return (FilterInfo)this.databaseDFilter.clone();
    }

    public FilterInfo getSaleOrgUnitFilter() {
        if (null == this.saleOrgUnitFilter || !FilterUtility.hasFilterItem((FilterInfo)this.saleOrgUnitFilter)) {
            this.initSaleOrgUnitFilter();
        }
        return (FilterInfo)this.saleOrgUnitFilter.clone();
    }

    protected abstract void setChildFilterForRoot(FilterItemCollection var1);

    protected abstract void setChildFilterForNoBaseStandard(FilterItemCollection var1, String var2);

    protected abstract void setChildFilterForBaseStandard(FilterInfo var1, String var2);

    public String getQueryFieldName() {
        return this.queryFieldName;
    }

    public void setQueryFieldName(String queryFieldName) {
        this.queryFieldName = queryFieldName;
    }

    public String getQueryGroupFieldName() {
        return this.queryGroupFieldName;
    }

    public void setQueryGroupFieldName(String queryGroupFieldName) {
        this.queryGroupFieldName = queryGroupFieldName;
    }

    public String getQueryStandardFieldName() {
        return this.queryStandardFieldName;
    }

    public void setQueryStandardFieldName(String queryStandardFieldName) {
        this.queryStandardFieldName = queryStandardFieldName;
    }

    public CustomersMRDimension getCurrentDimension() {
        return this.currentDimension;
    }

    public void setCurrentDimension(CustomersMRDimension currentDimension) {
        this.currentDimension = currentDimension;
    }

    public boolean isBaseStardarGroupStandard() {
        return this.isBaseStardarGroupStandard;
    }

    public void setBaseStardarGroupStandard(boolean isBaseStardarGroupStandard) {
        this.isBaseStardarGroupStandard = isBaseStardarGroupStandard;
    }

    public abstract void setBaseStardarGroupStandard(DataBaseInfo var1);

    public void initDatabaseDFilter() {
        CtrlUnitInfo currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
        this.databaseDFilter = null;
        ObjectUuidPK ctrlUnitPK = new ObjectUuidPK(currentCtrlUnit.getId());
        try {
            FilterInfo customerDataBaseDFilter = CustomerFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)ctrlUnitPK, "customer.id", "customerCU.id");
            FilterInfo materialDataBaseDFilter = MaterialFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)ctrlUnitPK, "material.id", "materialCU.id");
            this.databaseDFilter = (FilterInfo)customerDataBaseDFilter.clone();
            this.databaseDFilter.mergeFilter(materialDataBaseDFilter, "AND");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void initSaleOrgUnitFilter() {
        CtrlUnitInfo currentCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
        UserInfo currentUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        SaleOrgUnitInfo saleOrgUnitInfo = this.currentDimension.getCurrentSaleOrgUnit();
        this.saleOrgUnitFilter = CustomersMaterialsRelationUtils.getSaleOrgUnitFilter(currentCtrlUnit, currentUserInfo, saleOrgUnitInfo);
    }
}

