/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.channel.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseCollection;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.CustomersMRStateEnum;
import com.kingdee.eas.basedata.scm.sd.channel.CustomersMaterialsRelationCollection;
import com.kingdee.eas.basedata.scm.sd.channel.CustomersMaterialsRelationFacadeFactory;
import com.kingdee.eas.basedata.scm.sd.channel.CustomersMaterialsRelationFactory;
import com.kingdee.eas.basedata.scm.sd.channel.IChannelBase;
import com.kingdee.eas.basedata.scm.sd.channel.ICustomersMaterialsRelation;
import com.kingdee.eas.basedata.scm.sd.channel.ICustomersMaterialsRelationFacade;
import com.kingdee.eas.basedata.scm.sd.channel.util.BosUtil;
import com.kingdee.eas.basedata.scm.sd.channel.util.CollectionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;

public final class CustomersMaterialsRelationUtils {
    public static String getUICommonResource(Context ctx, String key) {
        if (null != ctx) {
            return ResourceBase.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.ChannelResource", (String)key, (Locale)ctx.getLocale());
        }
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.channel.ChannelResource", (String)key);
    }

    public static CustomerCollection getCustomerCollection(Context ctx, Map paramMap) {
        CustomerCollection customerCollection = null;
        try {
            ICustomersMaterialsRelationFacade iCustomersMaterialsRelationFacade = (ICustomersMaterialsRelationFacade)CustomersMaterialsRelationUtils.getBizInterface(ctx, CustomersMaterialsRelationFacadeFactory.class);
            customerCollection = iCustomersMaterialsRelationFacade.getCustomerCollection(paramMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return customerCollection;
    }

    public static MaterialCollection getMaterialCollection(Context ctx, Map paramMap) {
        MaterialCollection materialCollection = null;
        try {
            ICustomersMaterialsRelationFacade iCustomersMaterialsRelationFacade = (ICustomersMaterialsRelationFacade)CustomersMaterialsRelationUtils.getBizInterface(ctx, CustomersMaterialsRelationFacadeFactory.class);
            materialCollection = iCustomersMaterialsRelationFacade.getMaterialCollection(paramMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return materialCollection;
    }

    public static IBizCtrl getBizInterface(Context ctx, Class clzFactory) throws BOSException {
        boolean isLocal = ctx != null;
        IBizCtrl iBiz = null;
        try {
            if (isLocal) {
                Class[] parameterTypes = new Class[]{Context.class};
                Method mGetInstance = clzFactory.getMethod("getLocalInstance", parameterTypes);
                iBiz = (IBizCtrl)mGetInstance.invoke(null, ctx);
            } else {
                Method mGetInstance = clzFactory.getMethod("getRemoteInstance", null);
                iBiz = (IBizCtrl)mGetInstance.invoke(null, null);
            }
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return iBiz;
    }

    public static CustomersMaterialsRelationCollection getCustomersMaterialsRelationCollection(Context ctx, String[] ids) throws BOSException {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return null;
        }
        CustomersMaterialsRelationCollection customersMaterialsRelationCollection = null;
        ICustomersMaterialsRelation iCustomersMaterialsRelation = (ICustomersMaterialsRelation)CustomersMaterialsRelationUtils.getBizInterface(ctx, CustomersMaterialsRelationFactory.class);
        String strIdLists = StringUtils.arrayToString((Object[])ids, (String)",");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(new FilterInfo());
        FilterItemCollection cols = entityViewInfo.getFilter().getFilterItems();
        cols.add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("customer.id"));
        entityViewInfo.setSelector(sic);
        customersMaterialsRelationCollection = iCustomersMaterialsRelation.getCustomersMaterialsRelationCollection(entityViewInfo);
        return customersMaterialsRelationCollection;
    }

    public static CustomersMRStateEnum getCustomersMRStateEnum(Object bizEnumValue) {
        CustomersMRStateEnum customersMRStateEnum = CustomersMRStateEnum.NULL;
        if (bizEnumValue instanceof BizEnumValueDTO) {
            BizEnumValueDTO bizEnumValueDTO = (BizEnumValueDTO)bizEnumValue;
            customersMRStateEnum = CustomersMRStateEnum.getEnum(bizEnumValueDTO.getInt());
        }
        return customersMRStateEnum;
    }

    public static String getAuthorizedSaleOrgIds(Context ctx, CtrlUnitInfo currentCtrlUnit, UserInfo currentUserInfo) throws BOSException, EASBizException {
        ObjectUuidPK ctrlUnitPK = new ObjectUuidPK(currentCtrlUnit.getId());
        ObjectUuidPK userPK = new ObjectUuidPK(currentUserInfo.getId());
        StringBuffer saleOrgUnitSBuffer = new StringBuffer();
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)OrgType.Sale));
        IPermission iPermission = (IPermission)CustomersMaterialsRelationUtils.getBizInterface(ctx, PermissionFactory.class);
        FullOrgUnitCollection saleOrgUnitCollection = iPermission.getAuthorizedOrgOfCU((IObjectPK)ctrlUnitPK, (IObjectPK)userPK, OrgType.Sale, (IObjectPK)treePK, null);
        FullOrgUnitInfo fullOrgUnitInfo = null;
        if (null != saleOrgUnitCollection && !saleOrgUnitCollection.isEmpty()) {
            int length = saleOrgUnitCollection.size();
            for (int i = 0; i < length; ++i) {
                fullOrgUnitInfo = saleOrgUnitCollection.get(i);
                saleOrgUnitSBuffer.append("'").append(fullOrgUnitInfo.getId()).append("',");
            }
            saleOrgUnitSBuffer.deleteCharAt(saleOrgUnitSBuffer.lastIndexOf(","));
        }
        return saleOrgUnitSBuffer.toString();
    }

    public static FilterInfo getSaleOrgUnitFilter(CtrlUnitInfo currentCtrlUnit, UserInfo currentUserInfo, SaleOrgUnitInfo saleOrgUnitInfo) {
        FilterInfo saleOrgUnitFilter = new FilterInfo();
        String saleOrgUnitInfoIds = null;
        boolean isSingle = true;
        if (null == saleOrgUnitInfo) {
            try {
                saleOrgUnitInfoIds = CustomersMaterialsRelationUtils.getAuthorizedSaleOrgIds(null, currentCtrlUnit, currentUserInfo);
                isSingle = false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            saleOrgUnitInfoIds = saleOrgUnitInfo.getId().toString();
        }
        CustomersMaterialsRelationUtils.setCustomerSaleInfoFilter(isSingle, saleOrgUnitFilter, saleOrgUnitInfoIds);
        CustomersMaterialsRelationUtils.setMaterialSaleInfoFilter(isSingle, saleOrgUnitFilter, saleOrgUnitInfoIds);
        return saleOrgUnitFilter;
    }

    public static void setMaterialSaleInfoFilter(boolean isSingle, FilterInfo saleOrgUnitFilter, String saleOrgUnitInfoIds) {
        StringBuffer materialSBuffer = new StringBuffer();
        materialSBuffer.append("select ms.FMaterialID from T_BD_MaterialSales ms where ");
        if (!isSingle) {
            materialSBuffer.append(" ms.FOrgUnit in (select fid from T_ORG_Sale so where so.fid in(" + saleOrgUnitInfoIds + ") and so.FIsBizUnit =1 )");
        } else {
            materialSBuffer.append(" ms.FOrgUnit='" + saleOrgUnitInfoIds + "'");
        }
        saleOrgUnitFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialSBuffer.toString(), CompareType.INNER));
    }

    public static void setCustomerSaleInfoFilter(boolean isSingle, FilterInfo saleOrgUnitFilter, String saleOrgUnitInfoIds) {
        StringBuffer customerSBuffer = new StringBuffer();
        customerSBuffer.append("select cs.FCustomerID from T_BD_CustomerSaleInfo cs where ");
        if (!isSingle) {
            customerSBuffer.append(" cs.FSaleOrgID in (select fid from T_ORG_Sale so where so.fid in(" + saleOrgUnitInfoIds + ") and so.FIsBizUnit =1 )");
        } else {
            customerSBuffer.append(" cs.FSaleOrgID='" + saleOrgUnitInfoIds + "'");
        }
        saleOrgUnitFilter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customerSBuffer.toString(), CompareType.INNER));
    }

    public static MeasureUnitInfo getBaseUnitOfMaterial(Context ctx, MaterialInfo material) {
        MeasureUnitInfo baseUnit = null;
        if (BosUtil.isNotEmptyEntity((IObjectValue)material) && BosUtil.isEmptyEntity((IObjectValue)(baseUnit = material.getBaseUnit()))) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("baseUnit.id"));
            selectors.add(new SelectorItemInfo("baseUnit.number"));
            selectors.add(new SelectorItemInfo("baseUnit.name"));
            try {
                IMaterial iMaterial = (IMaterial)CustomersMaterialsRelationUtils.getBizInterface(ctx, MaterialFactory.class);
                MaterialInfo mat = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId()), selectors);
                baseUnit = mat.getBaseUnit();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return baseUnit;
    }

    public static ChannelBaseInfo getChannelOfCustomer(Context ctx, CustomerInfo customer) {
        ChannelBaseInfo channel = null;
        if (BosUtil.isNotEmptyEntity((IObjectValue)customer)) {
            try {
                IChannelBase iChannel = (IChannelBase)CustomersMaterialsRelationUtils.getBizInterface(ctx, ChannelBaseFactory.class);
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("id"));
                view.getSelector().add(new SelectorItemInfo("number"));
                view.getSelector().add(new SelectorItemInfo("name"));
                view.setFilter(new FilterInfo());
                view.getFilter().appendFilterItem("customer.id", (Object)customer.getId().toString());
                ChannelBaseCollection col = iChannel.getChannelBaseCollection(view);
                channel = col.get(0);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return channel;
    }

    public static ChannelBaseCollection getChannelCollectionOfCustomerIDs(Context ctx, Set customerIdSet) {
        ChannelBaseCollection channelColl = null;
        if (!CollectionUtil.isEmptyCollection(customerIdSet)) {
            try {
                IChannelBase iChannel = (IChannelBase)CustomersMaterialsRelationUtils.getBizInterface(ctx, ChannelBaseFactory.class);
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("id"));
                view.getSelector().add(new SelectorItemInfo("number"));
                view.getSelector().add(new SelectorItemInfo("name"));
                view.getSelector().add(new SelectorItemInfo("customer.id"));
                view.setFilter(new FilterInfo());
                view.getFilter().getFilterItems().add(new FilterItemInfo("customer.id", (Object)customerIdSet, CompareType.INCLUDE));
                channelColl = iChannel.getChannelBaseCollection(view);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return channelColl;
    }
}

