/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.channel.common;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public final class FMClientHelper {
    public static final Color KDTABLE_TOTAL_BG_COLOR = new Color(0xF6F6B6);
    public static final Color KDTABLE_SUBTOTAL_BG_COLOR = new Color(16119270);
    public static final String KDTABLE_NUMBER_FTM = "%-.2n";
    public static final String KDTABLE_PERCENT_FTM = "%r{0.00}p";
    public static final String KDTABLE_DATE_FMT = "%{yyyy-MM-dd}t";
    public static final String ACTUAL_DIGIT_FMT = "#,##0.###########";
    public static final HashMap mapPrecOfCurrency = new HashMap(32);
    private static final Map mapPrecOfExRate = new HashMap(32);
    public static final int SUBTOTAL = 16119270;
    public static final int TOTAL = 0xF6F6B6;
    public static final int PASTRECORD = 16771687;
    public static final String RES = "com.kingdee.eas.fm.common.client.FMCommonClientResource";
    public static final int DEFAULT_EXCHANGERATE_PREC = 3;
    private static Logger logger = Logger.getLogger((String)FMClientHelper.class.getName());

    public static String getNumberFtm(int precision) {
        StringBuffer numberFormate = new StringBuffer("##,###,###,###,###,##0");
        if (precision > 0) {
            numberFormate.append(".");
        }
        for (int i = 0; i < precision; ++i) {
            numberFormate.append("0");
        }
        return numberFormate.toString();
    }

    public static void setSelectObject(KDComboBox cbo, Object anObject) {
        if (CoreBaseInfo.class.isInstance(anObject)) {
            CoreBaseInfo newObject = (CoreBaseInfo)anObject;
            for (int i = 0; i < cbo.getItemCount(); ++i) {
                Object obj = cbo.getItemAt(i);
                if (!(obj instanceof CoreBaseInfo)) continue;
                CoreBaseInfo info = (CoreBaseInfo)cbo.getItemAt(i);
                if (obj == null || !newObject.getId().equals((Object)info.getId())) continue;
                cbo.setSelectedIndex(i);
                break;
            }
        } else {
            cbo.setSelectedItem(anObject);
        }
    }

    public static void clearTable(KDTable kdTable) {
        kdTable.removeHeadRows();
        kdTable.removeRows();
        kdTable.removeColumns();
    }

    public static boolean verifyIsNumber(String value) {
        boolean result = true;
        try {
            new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            result = false;
        }
        return result;
    }

    public static void showSuccessInfo(Component ui, Component component) {
        if (!(component instanceof KDWorkButton)) {
            return;
        }
        String text = ((KDWorkButton)component).getText();
        MsgBox.showInfo((Component)ui, (String)(text + EASResource.getString((String)RES, (String)"SUCCESS")));
    }

    public static void showCanNotInfo(Component ui, ItemAction action) {
        if (action == null) {
            return;
        }
        MsgBox.showWarning((Component)ui, (String)(EASResource.getString((String)"com.kingdee.eas.qm.common.COMMONAutoGenerateResource", (String)"30_FMClientHelper") + action.getExtendProperty("Name")));
        SysUtil.abort();
    }

    public static void showSuccessInfo(CoreUI ui, ItemAction action) {
        if (action == null) {
            return;
        }
        ui.setMessageText(action.getExtendProperty("Name") + EASResource.getString((String)RES, (String)"SUCCESS"));
        ui.showMessage();
    }

    public static void showSuccessMessage(CoreUI ui, ActionEvent e) {
        if (e == null || !(e.getSource() instanceof Component)) {
            return;
        }
        String actionCommand = e.getActionCommand();
        if (e.getSource() instanceof AbstractButton) {
            AbstractButton btn = (AbstractButton)e.getSource();
            String txt = btn.getText();
            try {
                actionCommand = txt.replaceAll("\\(+[A-Z]+\\)", "");
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
                actionCommand = "";
            }
        }
        if (!EmptyUtil.isEmpty((String)actionCommand)) {
            ui.setMessageText(actionCommand + EASResource.getString((String)RES, (String)"SUCCESS"));
            ui.showMessage();
            return;
        }
        Component component = (Component)e.getSource();
        FMClientHelper.showSuccessInfo((Component)ui, component);
    }

    public static void showSuccessMessageBox(CoreUI ui, ActionEvent e) {
        if (e == null || !(e.getSource() instanceof Component)) {
            return;
        }
        String actionCommand = e.getActionCommand();
        if (e.getSource() instanceof AbstractButton) {
            AbstractButton btn = (AbstractButton)e.getSource();
            String txt = btn.getText();
            try {
                actionCommand = txt.replaceAll("\\(+[A-Z]+\\)", "");
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
                actionCommand = "";
            }
        }
        if (!EmptyUtil.isEmpty((String)actionCommand)) {
            MsgBox.showInfo((Component)ui, (String)(actionCommand + EASResource.getString((String)RES, (String)"SUCCESS")));
            return;
        }
        Component component = (Component)e.getSource();
        FMClientHelper.showSuccessMessageBox(ui, component);
    }

    public static void showSuccessMessage(CoreUI ui, ActionEvent e, int successCounts) {
        if (e == null || !(e.getSource() instanceof Component)) {
            return;
        }
        String actionCommand = e.getActionCommand();
        if (e.getSource() instanceof AbstractButton) {
            AbstractButton btn = (AbstractButton)e.getSource();
            String txt = btn.getText();
            try {
                actionCommand = txt.replaceAll("\\(+[A-Z]+\\)", "");
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
                actionCommand = "";
            }
        }
        if (!EmptyUtil.isEmpty((String)actionCommand)) {
            String msg = MessageFormat.format(EASResource.getString((String)RES, (String)"successCounts"), actionCommand, new Integer(successCounts));
            ui.setMessageText(msg);
            ui.showMessage();
            return;
        }
        Component component = (Component)e.getSource();
        FMClientHelper.showSuccessInfo((Component)ui, component);
    }

    public static void showSuccessMessage(CoreUI ui, Component component) {
        if (!(component instanceof AbstractButton)) {
            return;
        }
        String text = ((AbstractButton)component).getText();
        if (EmptyUtil.isEmpty((String)text)) {
            text = ((AbstractButton)component).getToolTipText();
        }
        ui.setMessageText(text + EASResource.getString((String)RES, (String)"SUCCESS"));
        ui.showMessage();
    }

    public static void showSuccessMessageBox(CoreUI ui, Component component) {
        if (!(component instanceof AbstractButton)) {
            return;
        }
        String text = ((AbstractButton)component).getText();
        if (EmptyUtil.isEmpty((String)text)) {
            text = ((AbstractButton)component).getToolTipText();
        }
        MsgBox.showInfo((Component)ui, (String)(text + EASResource.getString((String)RES, (String)"SUCCESS")));
    }
}

