/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyEntryCollection;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyEntryFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyEntryInfo;
import com.kingdee.eas.basedata.scm.sd.sale.client.AbstractAssignPricePolicyForResultView;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;

public class AssignPricePolicyForResultView
extends AbstractAssignPricePolicyForResultView {
    protected int numericPrecision = 6;

    public AssignPricePolicyForResultView() throws Exception {
        this.kDTable1.checkParsed();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
    }

    private void initTable() throws Exception {
        HashSet billIDList = new HashSet((List)this.getUIContext().get("entryIds"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", billIDList, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("oriSaleOrg.name"));
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("customerGroup.number"));
        sic.add(new SelectorItemInfo("customerGroup.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("measureUnit.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("priceType.name"));
        sic.add(new SelectorItemInfo("price"));
        sic.add(new SelectorItemInfo("discountMode"));
        sic.add(new SelectorItemInfo("discount"));
        sic.add(new SelectorItemInfo("parent.saleOrgUnit.name"));
        sic.add(new SelectorItemInfo("parent.saleOrgUnit.number"));
        sic.add(new SelectorItemInfo("material.pricePrecision"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        PricePolicyEntryCollection result = PricePolicyEntryFactory.getRemoteInstance().getPricePolicyEntryCollection(view);
        IRow row = null;
        int pricePrecision = 4;
        for (int i = 0; i < result.size(); ++i) {
            PricePolicyEntryInfo info = result.get(i);
            row = this.kDTable1.addRow();
            if (info.getMaterial().getPricePrecision() > 0) {
                pricePrecision = info.getMaterial().getPricePrecision();
            }
            row.getCell("saleOrg").setValue((Object)info.getOriSaleOrg().getName());
            row.getCell("customerNum").setValue((Object)info.getCustomer().getNumber());
            row.getCell("customerName").setValue((Object)info.getCustomer().getName());
            row.getCell("customerGroupNum").setValue((Object)info.getCustomerGroup().getNumber());
            row.getCell("customerGroupName").setValue((Object)info.getCustomerGroup().getName());
            row.getCell("materialNum").setValue((Object)info.getMaterial().getNumber());
            row.getCell("materialName").setValue((Object)info.getMaterial().getName());
            row.getCell("measureUnit").setValue((Object)info.getMeasureUnit().getName());
            row.getCell("currency").setValue((Object)info.getCurrency().getName());
            if (info.getPriceType() != null) {
                row.getCell("priceType").setValue((Object)info.getPriceType().getName());
            }
            row.getCell("price").setValue((Object)(info.getPrice() == null ? info.getPrice() : info.getPrice().setScale(pricePrecision, 4)));
            if (info.getDiscountMode() != null) {
                row.getCell("discountType").setValue((Object)info.getDiscountMode().getAlias());
            }
            BigDecimal discount = info.getDiscount();
            row.getCell("discount").setValue(discount == null ? null : discount.setScale(this.numericPrecision, 4));
            BigDecimal discountPrice = null;
            if (null == discount) {
                discountPrice = info.getPrice();
            } else {
                BigDecimal divide = discount.divide(new BigDecimal(100));
                if (info.getDiscountMode().getValue() == 0) {
                    if (null != info.getPrice()) {
                        discountPrice = info.getPrice().multiply(BigDecimal.ONE.subtract(divide));
                    }
                } else if (info.getDiscountMode().getValue() == 1 && null != info.getPrice()) {
                    discountPrice = info.getPrice().subtract(discount);
                }
            }
            row.getCell("discountPrice").setValue(discountPrice == null ? null : discountPrice.setScale(pricePrecision, 4));
            row.getCell("assignSaleOrgNum").setValue((Object)info.getParent().getSaleOrgUnit().getNumber());
            row.getCell("assignSaleOrgName").setValue((Object)info.getParent().getSaleOrgUnit().getName());
            row.getCell("id").setValue((Object)info.getId());
        }
    }
}

