/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ImportCompayFieldsEnum;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyEntryFactory;
import com.kingdee.eas.basedata.scm.sd.sale.client.AbstractAssignPricePolicySelectMultiOrgsUi;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class AssignPricePolicySelectMultiOrgsUi
extends AbstractAssignPricePolicySelectMultiOrgsUi {
    private final TreeSet<String> selectedNumbers = new TreeSet();
    NumberCellInfo[] cachedCellInfo = null;

    public AssignPricePolicySelectMultiOrgsUi() throws Exception {
        this.doInitWhenConstructing();
    }

    private void doInitWhenConstructing() {
        this.kDContainer1.setContainerType(2);
        this.kDContainer2.setContainerType(2);
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnRemoveAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignPricePolicySelectMultiOrgsUi.this.onClickForBtnOK();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignPricePolicySelectMultiOrgsUi.this.onClickForBtnCancel();
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignPricePolicySelectMultiOrgsUi.this.onClickForBtnAdd();
            }
        });
        this.btnAddAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignPricePolicySelectMultiOrgsUi.this.onClickForBtnAddAll();
            }
        });
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignPricePolicySelectMultiOrgsUi.this.onClickForBtnRemove();
            }
        });
        this.btnRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignPricePolicySelectMultiOrgsUi.this.onClickForBtnRemoveAll();
            }
        });
        this.providedTable.checkParsed();
        this.selectedTable.checkParsed();
        this.providedTable.getSelectManager().setSelectMode(10);
        this.selectedTable.getSelectManager().setSelectMode(10);
        this.providedTable.getStyleAttributes().setLocked(true);
        this.selectedTable.getStyleAttributes().setLocked(true);
        this.providedTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                AssignPricePolicySelectMultiOrgsUi.this.onClickForProvidedTable(e);
            }
        });
        this.btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.comboField.addItem((Object)ImportCompayFieldsEnum.NUMBER);
        this.comboField.addItem((Object)ImportCompayFieldsEnum.NAME);
        this.comboField.setSelectedIndex(0);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignPricePolicySelectMultiOrgsUi.this.doQuerying();
            }
        });
    }

    private void doQuerying() {
        String value = this.txtFieldValue.getText();
        if (!StringUtils.isEmpty((String)value)) {
            value = value.trim();
            boolean isBlurred = this.checkBlured.isSelected();
            int field = ((ImportCompayFieldsEnum)this.comboField.getSelectedItem()).getValue();
            String fieldStr = null;
            switch (field) {
                case 1: {
                    fieldStr = "number";
                    break;
                }
                case 2: {
                    fieldStr = "name";
                }
            }
            ArrayList<NumberCellInfo> filteredCellInfoList = new ArrayList<NumberCellInfo>();
            for (int i = 0; i < this.cachedCellInfo.length; ++i) {
                NumberCellInfo cellInfo = this.cachedCellInfo[i];
                boolean isTheWanted = false;
                String obj = cellInfo.get(fieldStr);
                if (isBlurred) {
                    isTheWanted = obj != null && obj.toString().indexOf(value) != -1;
                } else {
                    boolean bl = isTheWanted = obj != null && obj.toString().equals(value);
                }
                if (!isTheWanted) continue;
                filteredCellInfoList.add(cellInfo);
            }
            Object[] array = new NumberCellInfo[filteredCellInfoList.size()];
            filteredCellInfoList.toArray(array);
            Arrays.sort(array);
            this.fillTable((NumberCellInfo[])array);
        } else {
            this.fillTable(this.cachedCellInfo);
        }
        this.setBackGroundColorBySelectedNumber();
    }

    private void onClickForProvidedTable(KDTMouseEvent e) {
        if (this.providedTable.getSelectManager().get() != null && e.getClickCount() == 2) {
            this.onClickForBtnAdd();
        }
    }

    private void onClickForBtnRemoveAll() {
        this.selectedNumbers.clear();
        this.selectedTable.removeRows();
        this.setBackGroundColorBySelectedNumber();
    }

    private void onClickForBtnRemove() {
        RowRange[] rowRanges;
        for (RowRange range : rowRanges = this.getSortedRowRanges(this.selectedTable)) {
            int begin = range.beginRow;
            int end = range.endRow;
            this.remove(begin, end);
        }
        this.setBackGroundColorBySelectedNumber();
    }

    private void remove(int begin, int end) {
        for (int i = end; i >= begin; --i) {
            String number = this.selectedTable.getCell(i, "number").getValue().toString();
            this.selectedNumbers.remove(number);
            this.selectedTable.removeRow(i);
        }
    }

    private void onClickForBtnAddAll() {
        this.insertRow(0, this.providedTable.getRowCount() - 1);
        this.setBackGroundColorBySelectedNumber();
    }

    private void onClickForBtnAdd() {
        RowRange[] rowRanges;
        for (RowRange rowRange : rowRanges = this.getSortedRowRanges(this.providedTable)) {
            int begin = rowRange.beginRow;
            int end = rowRange.endRow;
            this.insertRow(begin, end);
        }
        this.setBackGroundColorBySelectedNumber();
    }

    private void insertRow(int begin, int end) {
        for (int i = begin; i <= end; ++i) {
            int insertRowIndex = this.selectedNumbers.size();
            String number = this.providedTable.getCell(i, "number").getValue().toString();
            if (this.selectedNumbers.contains(number)) continue;
            for (String next : this.selectedNumbers) {
                if (next.compareTo(number) <= 0) continue;
                insertRowIndex = this.selectedNumbers.headSet(next).size();
                break;
            }
            this.selectedNumbers.add(number);
            IRow row = this.selectedTable.addRow(insertRowIndex);
            row.getCell("id").setValue(this.providedTable.getCell(i, "id").getValue());
            row.getCell("number").setValue((Object)number);
            row.getCell("name").setValue(this.providedTable.getCell(i, "name").getValue());
        }
    }

    private void setBackGroundColorBySelectedNumber() {
        int len = this.providedTable.getRowCount();
        for (int i = 0; i < len; ++i) {
            String number = this.providedTable.getCell(i, "number").getValue().toString();
            if (this.selectedNumbers.contains(number)) {
                this.providedTable.getRow(i).getStyleAttributes().setBackground(new Color(0xD9D9D2));
                continue;
            }
            this.providedTable.getRow(i).getStyleAttributes().setBackground(new Color(0xFFFFFF));
        }
    }

    private RowRange[] getSortedRowRanges(KDTable table) {
        if (table.getSelectManager().get() == null) {
            return new RowRange[0];
        }
        ArrayList blocks = table.getSelectManager().getBlocks();
        int size = blocks.size();
        Object[] rowRanges = new RowRange[size];
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            rowRanges[i] = new RowRange(block.getTop(), block.getBottom());
        }
        Arrays.sort(rowRanges);
        return rowRanges;
    }

    private void onClickForBtnCancel() {
        this.disposeUIWindow();
    }

    private void onClickForBtnOK() {
        List billIDList = (List)this.getUIContext().get("billIDList");
        String saleOrg = this.getUIContext().get("saleOrg").toString();
        try {
            if (this.selectedNumbers.size() > 0) {
                Map result = PricePolicyEntryFactory.getRemoteInstance().assign(billIDList, this.selectedNumbers, saleOrg);
                int sum = billIDList.size() * this.selectedNumbers.size();
                HashMap material = (HashMap)result.get("material");
                HashMap customer = (HashMap)result.get("customer");
                HashMap policy = (HashMap)result.get("policy");
                int assignQuantity = (Integer)result.get("assignQuantity");
                String resClassName = "com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicy";
                String msg = EASResource.getString((String)resClassName, (String)"assign_Quantity", (Object[])new Object[]{assignQuantity, sum - assignQuantity});
                StringBuilder detailMsg = new StringBuilder(1024);
                if (policy.size() > 0) {
                    detailMsg.append(EASResource.getString((String)resClassName, (String)"ASSIGNFORSAMESALEORG")).append("\n");
                    for (Map.Entry entry : policy.entrySet()) {
                        String key = (String)entry.getKey();
                        HashSet value = (HashSet)entry.getValue();
                        detailMsg.append(key).append(":\n");
                        for (String s : value) {
                            detailMsg.append(s + "\n");
                        }
                    }
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)detailMsg.toString(), (int)1);
                } else if (material.size() > 0 || customer.size() > 0) {
                    HashSet value;
                    String key;
                    if (material.size() > 0) {
                        detailMsg.append(EASResource.getString((String)resClassName, (String)"ASSINFORMATERIAL")).append("\n");
                        for (Map.Entry entry : material.entrySet()) {
                            key = (String)entry.getKey();
                            value = (HashSet)entry.getValue();
                            detailMsg.append(key).append(":\n");
                            for (String s : value) {
                                detailMsg.append(s + "\n");
                            }
                        }
                    }
                    if (customer.size() > 0) {
                        detailMsg.append(EASResource.getString((String)resClassName, (String)"ASSIGNFORCUSTOMER")).append("\n");
                        for (Map.Entry entry : customer.entrySet()) {
                            key = (String)entry.getKey();
                            value = (HashSet)entry.getValue();
                            detailMsg.append(key).append(":\n");
                            for (String s : value) {
                                detailMsg.append(s + "\n");
                            }
                        }
                    }
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)detailMsg.toString(), (int)1);
                } else {
                    MsgBox.showInfo((String)msg);
                }
            }
        }
        catch (BOSException | EASBizException e) {
            this.handUIException(e);
        }
        this.disposeUIWindow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() throws Exception {
        this.initByGavenData();
    }

    private void initByGavenData() throws Exception {
        this.txtFieldValue.setText(null);
        this.initProvidedTable();
    }

    private void initProvidedTable() throws Exception {
        String saleOrg = (String)this.getUIContext().get("saleOrg");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> saleOrgSet = new HashSet<String>();
        saleOrgSet.add(saleOrg);
        filter.getFilterItems().add(new FilterItemInfo("id", saleOrgSet, CompareType.NOTINCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        SaleOrgUnitCollection saleOrgUnitCollection = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitCollection(view);
        IPermission permission = PermissionFactory.getRemoteInstance();
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)OrgType.Sale));
        FullOrgUnitCollection orgUnitColl = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), OrgType.Sale, (IObjectPK)treePK, "pricepolicy_view");
        if (saleOrgUnitCollection == null || saleOrgUnitCollection.size() == 0 || orgUnitColl == null || orgUnitColl.size() == 0) {
            NumberCellInfo[] info = new NumberCellInfo[]{};
            this.cachedCellInfo = info;
            this.fillTable(info);
            return;
        }
        HashMap<String, FullOrgUnitInfo> unitMap = new HashMap<String, FullOrgUnitInfo>();
        for (int i = 0; i < orgUnitColl.size(); ++i) {
            FullOrgUnitInfo fullOrgUnitInfo = orgUnitColl.get(i);
            unitMap.put(fullOrgUnitInfo.getId().toString(), fullOrgUnitInfo);
        }
        SaleOrgUnitCollection newOrgUnitCollection = new SaleOrgUnitCollection();
        for (int i = 0; i < saleOrgUnitCollection.size(); ++i) {
            if (!unitMap.containsKey(saleOrgUnitCollection.get(i).getId().toString())) continue;
            newOrgUnitCollection.add(saleOrgUnitCollection.get(i));
        }
        int size = newOrgUnitCollection.size();
        Object[] info = new NumberCellInfo[size];
        for (int i = 0; i < size; ++i) {
            info[i] = new NumberCellInfo(newOrgUnitCollection.get(i));
        }
        Arrays.sort(info);
        this.cachedCellInfo = info;
        this.fillTable((NumberCellInfo[])info);
    }

    private void fillTable(NumberCellInfo[] info) {
        this.providedTable.removeRows(false);
        for (int i = 0; i < info.length; ++i) {
            IRow row = this.providedTable.addRow();
            row.getCell("id").setValue((Object)info[i].id);
            row.getCell("number").setValue((Object)info[i].number);
            row.getCell("name").setValue((Object)info[i].name);
        }
    }

    private static class RowRange
    implements Comparable<RowRange> {
        private int beginRow;
        private int endRow;

        public RowRange(int row1, int row2) {
            this.beginRow = row1;
            this.endRow = row2;
            if (row2 < row1) {
                this.beginRow = row2;
                this.endRow = row1;
            }
        }

        @Override
        public int compareTo(RowRange o) {
            return Integer.compare(this.beginRow, o.beginRow);
        }
    }

    private static class NumberCellInfo
    implements Comparable {
        private String id;
        private String number;
        private String name;
        private SaleOrgUnitInfo saleOrgUnitInfo;

        public NumberCellInfo(SaleOrgUnitInfo unitInfo) {
            this.id = unitInfo.getId().toString();
            this.number = unitInfo.getNumber();
            this.name = unitInfo.getName();
            this.saleOrgUnitInfo = unitInfo;
        }

        public int compareTo(Object o) {
            return this.number.compareTo(((NumberCellInfo)o).number);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NumberCellInfo that = (NumberCellInfo)o;
            return this.number.equals(that.number);
        }

        public String getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.number.hashCode();
        }

        public String get(String key) {
            return "name".equals(key) ? this.name : this.number;
        }
    }
}

