/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.scm.sd.sale.client.AbstractBasePriceQueryPanelUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BasePriceQueryPanelUI
extends AbstractBasePriceQueryPanelUI {
    public static final Color NECESSARYCOLOR = SCMClientUtils.necessaryColor;
    private static String RES = "com.kingdee.eas.basedata.scm.sd.sale.BDScmSaleResource";
    private static final Logger logger = CoreUIObject.getLogger(BasePriceQueryPanelUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        this.prmtOrgUnit.setRequired(true);
        this.prmtMaterial.setRequired(true);
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.ControlUnit);
        FilterInfo filter = iProducer.getFilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        this.prmtOrgUnit.setEntityViewInfo(viewInfo);
        this.prmtOrgUnit.setSelector((KDPromptSelector)iProducer.getModel());
        this.prmtOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.FullOrgUnitQuery");
        this.prmtMaterial.setCommitFormat("$number$");
        this.prmtOrgUnit.setCommitFormat("$number$");
    }

    protected HashMap getQueryConditions() throws Exception {
        ArrayList keyList = this.getKeySequence();
        HashMap map = new HashMap();
        if (this.prmtMaterial.getData() != null) {
            MaterialInfo materialInfo = (MaterialInfo)this.prmtMaterial.getData();
            String customerNumber = materialInfo.getNumber();
            map.put(keyList.get(0), customerNumber);
        }
        if (this.prmtOrgUnit.getData() != null) {
            CtrlUnitInfo ctrlInfo = (CtrlUnitInfo)this.prmtOrgUnit.getData();
            String companyNumber = ctrlInfo.getNumber();
            map.put(keyList.get(1), companyNumber);
        }
        return map;
    }

    protected void loadQueryConditions(HashMap conditionMap) throws Exception {
        String companyNumber;
        MaterialCollection col;
        FilterInfo filterInfo;
        EntityViewInfo viewInfo;
        String customerNumber;
        ArrayList keyList = this.getKeySequence();
        if (conditionMap.containsKey(keyList.get(0)) && (customerNumber = (String)conditionMap.get(keyList.get(0))) != null) {
            viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)customerNumber, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            IMaterial iCustomer = MaterialFactory.getRemoteInstance();
            col = iCustomer.getMaterialCollection(viewInfo);
            if (col.size() > 0) {
                this.prmtMaterial.setData((Object)col.get(0));
            }
        }
        if (conditionMap.containsKey(keyList.get(1)) && (companyNumber = (String)conditionMap.get(keyList.get(1))) != null) {
            viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumber, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            ICtrlUnit iCompany = CtrlUnitFactory.getRemoteInstance();
            col = iCompany.getCtrlUnitCollection(viewInfo);
            if (col.size() > 0) {
                this.prmtOrgUnit.setData((Object)col.get(0));
            }
        }
    }

    protected void verify() throws Exception {
        if (this.prmtMaterial.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("MATERIALNOTNULL"));
            SysUtil.abort();
        }
        if (this.prmtOrgUnit.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("ORGNOTNULL"));
            SysUtil.abort();
        }
    }

    protected void clear() {
        this.prmtMaterial.setData(null);
        this.prmtOrgUnit.setData(null);
    }

    public ArrayList getKeySequence() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("material");
        list.add("orgunit");
        return list;
    }

    private String getResource(String key) {
        return EASResource.getString((String)RES, (String)key);
    }
}

