/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.client.AbstractBatchUpdatePriceStep1UI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.EntityViewInfoUtil;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BatchUpdatePriceStep1UI
extends AbstractBatchUpdatePriceStep1UI {
    private static final Logger logger = CoreUIObject.getLogger(BatchUpdatePriceStep1UI.class);
    protected F7ContextManager f7Manager = new F7ContextManager((Component)((Object)this), OrgType.Sale, 1);
    private DataChangeListener mainOrgListener;
    private static final String RESOURCE = "com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicy";
    private Set saleOrgInfoSet = null;

    public void onLoad() throws Exception {
        this.setMainSaleOrgPrmt(this.getMainBizOrgF7());
        this.checkPermission();
        super.onLoad();
        if (this.getMainBizOrgF7() != null) {
            this.setSaleOrgUnitF7(this.getMainBizOrgF7());
        }
        this.initCustomerListener();
        if (this.getMainBizOrgF7() != null) {
            this.getMainBizOrgF7().setRequired(true);
            this.getMainBizOrgF7().addDataChangeListener(this.mainOrgListener);
        }
        this.initUI();
    }

    private void initCustomerListener() {
        this.mainOrgListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BatchUpdatePriceStep1UI.this.mainOrgChanged();
            }
        };
    }

    private void mainOrgChanged() {
        this.setPricePolicyF7(this.prmtPricePolicy);
        this.setBizMaterialF7(this.prmtMaterial, true, null);
    }

    private void initUI() {
        this.getMainBizOrgF7().setEnabledMultiSelection(true);
        this.setPricePolicyF7(this.prmtPricePolicy);
        this.setBizMaterialF7(this.prmtMaterial, true, null);
        this.setBizCustomerF7(this.prmtCustomer, true, null);
        this.setCustomerGroupF7(this.prmtCustomerGroup, true);
        this.setMaterialGroupF7(this.prmtMaterialGroup, true);
        KDBizPromptBox[] prmtBoxs = new KDBizPromptBox[]{this.prmtSaleOrgUnit, this.prmtPricePolicy, this.prmtMaterial, this.prmtCustomer, this.prmtCustomerGroup, this.prmtMaterialGroup};
        int length = prmtBoxs.length;
        for (int i = 0; i < length; ++i) {
            this.formatF7(prmtBoxs[i]);
        }
    }

    private void setSaleOrgUnitF7(KDBizPromptBox bizSaleOrgUnitBox) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getPermissionSaleOrg(this.getViewPermission()), CompareType.INCLUDE));
        view.setFilter(filter);
        bizSaleOrgUnitBox.setEntityViewInfo(view);
    }

    private void setMainSaleOrgPrmt(KDBizPromptBox bizSaleOrgUnitBox) throws Exception {
        OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        Set saleOrgSet = this.getPermissionSaleOrgInfos(this.getViewPermission());
        if (orgUnitInfo.isIsSaleOrgUnit() && saleOrgSet.contains(orgUnitInfo.getId().toString())) {
            bizSaleOrgUnitBox.setValue((Object)orgUnitInfo);
        } else {
            try {
                if (saleOrgSet != null && saleOrgSet.size() > 0) {
                    OrgUnitInfo[] orgUnitInfos = new OrgUnitInfo[saleOrgSet.size()];
                    Iterator it = saleOrgSet.iterator();
                    for (int i = 0; it.hasNext() && i < saleOrgSet.size(); ++i) {
                        orgUnitInfos[i] = (OrgUnitInfo)it.next();
                        if (!orgUnitInfo.getId().toString().equals(orgUnitInfos[i].getId().toString())) continue;
                        String orgId = orgUnitInfos[i].getId().toString();
                        SaleOrgUnitInfo orgInfo = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), this.getSelector());
                        bizSaleOrgUnitBox.setValue((Object)orgInfo);
                        return;
                    }
                    orgUnitInfos = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])orgUnitInfos, (boolean)true);
                    String orgId = orgUnitInfos[0].getId().toString();
                    SaleOrgUnitInfo orgInfo = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), this.getSelector());
                    bizSaleOrgUnitBox.setValue((Object)orgInfo);
                }
            }
            catch (EASBizException e) {
                bizSaleOrgUnitBox.setValue(null);
                logger.error((Object)e);
            }
            catch (BOSException e) {
                bizSaleOrgUnitBox.setValue(null);
                logger.error((Object)e);
            }
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    private void setPricePolicyF7(KDBizPromptBox bizPricePolicyBox) {
        EntityViewInfo view = new EntityViewInfo();
        this.prmtPricePolicy.setQueryInfo("com.kingdee.eas.basedata.scm.sd.sale.app.F7PricePolicyAllQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        this.prmtPricePolicy.setSelectorCollection(sic);
        FilterInfo filterinfo = new FilterInfo();
        Set<String> saleOrgSet = new HashSet();
        if (this.prmtSaleOrgUnit != null && this.prmtSaleOrgUnit.getValue() != null) {
            Object orgObj = this.prmtSaleOrgUnit.getValue();
            if (orgObj instanceof Object[]) {
                Object[] saleOrgs = (Object[])orgObj;
                int length = saleOrgs.length;
                for (int i = 0; i < length; ++i) {
                    saleOrgSet.add(((OrgUnitInfo)saleOrgs[i]).getId().toString());
                }
            } else if (orgObj instanceof OrgUnitInfo) {
                saleOrgSet.add(((OrgUnitInfo)orgObj).getId().toString());
            }
        } else {
            try {
                saleOrgSet = this.getPermissionSaleOrg(this.getViewPermission());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (saleOrgSet.size() > 0) {
            filterinfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", saleOrgSet, CompareType.INCLUDE));
        } else {
            filterinfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)"-1", CompareType.INCLUDE));
        }
        view.setFilter(filterinfo);
        EntityViewInfoUtil.setBaseOnSelector((EntityViewInfo)view);
        this.prmtPricePolicy.setEntityViewInfo(view);
        this.prmtPricePolicy.setEnabledMultiSelection(true);
    }

    private Set getPermissionSaleOrg(String permItem) throws Exception {
        HashSet<String> saleOrgIdSet = new HashSet<String>();
        Set saleOrgSet = this.getPermissionSaleOrgInfos(permItem);
        Iterator it = saleOrgSet.iterator();
        while (it.hasNext()) {
            saleOrgIdSet.add(((OrgUnitInfo)it.next()).getId().toString());
        }
        return saleOrgIdSet;
    }

    private Set getPermissionSaleOrgInfos(String permItem) throws Exception {
        if (this.saleOrgInfoSet != null && this.saleOrgInfoSet.size() > 0) {
            return this.saleOrgInfoSet;
        }
        this.saleOrgInfoSet = new HashSet();
        IPermission permission = PermissionFactory.getRemoteInstance();
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)OrgType.Sale));
        FullOrgUnitCollection orgUnitColl = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), OrgType.Sale, (IObjectPK)treePK, permItem);
        for (int i = 0; i < orgUnitColl.size(); ++i) {
            this.saleOrgInfoSet.add(orgUnitColl.get(i));
        }
        return this.saleOrgInfoSet;
    }

    private void checkPermission() throws Exception {
        if (this.getPermissionSaleOrgInfos(this.getViewPermission()).size() > 0) {
            return;
        }
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        ObjectUuidPK orgPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)userPK, OrgType.Sale, (IObjectPK)orgPK, this.getViewPermission());
    }

    protected void setBizMaterialF7(KDBizPromptBox bizMaterialBox, boolean isMulSelect, String queryInfo) {
        this.f7Manager.registerBizMaterialF7(bizMaterialBox, null, queryInfo, null, isMulSelect);
        HashSet<String> saleOrgSet = new HashSet<String>();
        if (this.prmtSaleOrgUnit != null && this.prmtSaleOrgUnit.getValue() != null) {
            Object orgObj = this.prmtSaleOrgUnit.getValue();
            if (orgObj instanceof Object[]) {
                Object[] saleOrgs = (Object[])orgObj;
                int length = saleOrgs.length;
                for (int i = 0; i < length; ++i) {
                    saleOrgSet.add(((OrgUnitInfo)saleOrgs[i]).getId().toString());
                }
            } else if (orgObj instanceof OrgUnitInfo) {
                saleOrgSet.add(((OrgUnitInfo)orgObj).getId().toString());
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("SaleOrgUnit.id", saleOrgSet, CompareType.INCLUDE));
        view.setFilter(filter);
        bizMaterialBox.setEntityViewInfo(view);
    }

    protected void setBizCustomerF7(KDBizPromptBox bizCustomerBox, boolean isMultiSelect, String queryInfo) {
        this.f7Manager.registerBizCustomerF7(bizCustomerBox, null, isMultiSelect, queryInfo, null, OrgType.Sale);
    }

    protected void setCustomerGroupF7(KDBizPromptBox bizCustomerGroupBox, boolean isMiltiSelect) {
        bizCustomerGroupBox.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerGroupQuery");
        bizCustomerGroupBox.setEnabledMultiSelection(isMiltiSelect);
    }

    protected void setMaterialGroupF7(KDBizPromptBox bizMaterialGroupBox, boolean isMiltiSelect) {
        bizMaterialGroupBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupAllQuery");
        bizMaterialGroupBox.setEnabledMultiSelection(isMiltiSelect);
    }

    protected void setPriceTypeF7(KDBizPromptBox bizPriceTypeBox) {
        bizPriceTypeBox.setQueryInfo("com.kingdee.eas.basedata.scm.sd.sale.app.F7PriceTypeQuery");
    }

    private void formatF7(KDBizPromptBox bizMaterialGroupBox) {
        bizMaterialGroupBox.setEditFormat("$number$");
        bizMaterialGroupBox.setDisplayFormat("$number$");
        bizMaterialGroupBox.setCommitFormat("$number$");
    }

    public boolean checkData() {
        boolean flag = true;
        if (this.prmtSaleOrgUnit.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)SCMClientUtils.getResource((String)"SALEORGNOTNULL"));
            flag = false;
        }
        if (StringUtil.isEmpty((String)this.prmtPricePolicy.getText()) && StringUtil.isEmpty((String)this.prmtMaterial.getText()) && StringUtil.isEmpty((String)this.prmtMaterialGroup.getText()) && StringUtil.isEmpty((String)this.prmtCustomer.getText()) && StringUtil.isEmpty((String)this.prmtCustomerGroup.getText()) && StringUtil.isEmpty((String)this.prmtPriceType.getText()) && 2 == MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCE, (String)"UPDATEPRICECONFIRM"))) {
            flag = false;
        }
        return flag;
    }

    public Map getUpdateParams() {
        HashMap<String, Object> conditionMap = new HashMap<String, Object>();
        if (this.prmtSaleOrgUnit.getValue() != null) {
            conditionMap.put("saleOrgUnit", this.prmtSaleOrgUnit.getValue());
        }
        if (!StringUtil.isEmpty((String)this.prmtPricePolicy.getText())) {
            conditionMap.put("pricePolicy", this.prmtPricePolicy.getValue());
        }
        if (!StringUtil.isEmpty((String)this.prmtMaterial.getText())) {
            conditionMap.put("material", this.prmtMaterial.getValue());
        }
        if (!StringUtil.isEmpty((String)this.prmtMaterialGroup.getText())) {
            conditionMap.put("materialGroup", this.prmtMaterialGroup.getValue());
        }
        if (!StringUtil.isEmpty((String)this.prmtCustomerGroup.getText())) {
            conditionMap.put("customerGroup", this.prmtCustomerGroup.getValue());
        }
        if (!StringUtil.isEmpty((String)this.prmtCustomer.getText())) {
            conditionMap.put("customer", this.prmtCustomer.getValue());
        }
        if (!StringUtil.isEmpty((String)this.prmtPriceType.getText())) {
            conditionMap.put("priceType", this.prmtPriceType.getValue());
        }
        return conditionMap;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtSaleOrgUnit;
    }

    protected String getViewPermission() {
        return "PricePolicyAdjust_batchUpate";
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }
}

