/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ChannelTypeInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.client.AssistantClientUtils;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.client.DEditClientControlStrategy;
import com.kingdee.eas.basedata.framework.client.IControlModeEditUIProxy;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.client.AsstAttrPromptBox;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.CUBDControlFactory;
import com.kingdee.eas.basedata.org.CUBDControlInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICUBDControl;
import com.kingdee.eas.basedata.scm.common.client.BDInvClientUtils;
import com.kingdee.eas.basedata.scm.sd.sale.IMaterialBasePrice;
import com.kingdee.eas.basedata.scm.sd.sale.MaterialBasePriceCollection;
import com.kingdee.eas.basedata.scm.sd.sale.MaterialBasePriceException;
import com.kingdee.eas.basedata.scm.sd.sale.MaterialBasePriceFactory;
import com.kingdee.eas.basedata.scm.sd.sale.MaterialBasePriceInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PriceTypeInfo;
import com.kingdee.eas.basedata.scm.sd.sale.client.AbstractMaterialBasePriceEditUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectValueForEditUIUtil;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.framework.client.SCMPasteHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class MaterialBasePriceEditUI
extends AbstractMaterialBasePriceEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialBasePriceEditUI.class);
    private static final String TB_Material = "material";
    private static final String TB_MaterialName = "materialname";
    private static final String TB_Model = "model";
    private static final String TB_AssistProperty = "assistProperty";
    private static final String TB_Unit = "unit";
    private static final String TB_Price = "price";
    private static final String TB_FloorPrice = "floorPrice";
    private static final String TB_MAXPRICE = "maxPrice";
    private static final String[] Prices = new String[]{"price", "floorPrice", "maxPrice"};
    private static final String TB_Currency = "currency";
    private static final String TB_ID = "id";
    private static final String TB_CheckedFlag = "checkedFlag";
    private static final String TB_BlockedFlag = "blockedFlag";
    private static final String TB_CU = "CU";
    private static final String TB_PriceType = "priceType";
    private static final String TB_Priority = "priority";
    private static final String TB_Creater = "creater";
    private static final String TB_CreateTime = "createTime";
    private static final String TB_Auditor = "auditor";
    private static final String TB_AuditTime = "auditTime";
    private static final String TB_Updater = "updater";
    private static final String TB_UpdaterTime = "updateTime";
    private AbstractObjectCollection basePrices = null;
    DataChangeListener materialChangeListener = null;
    private int f7DisplayMode = 0;
    private static final BigDecimal DEFAULTNUM = new BigDecimal("0");
    private static final String RES_PROMPT = "com.kingdee.eas.basedata.scm.sd.sale.MaterialBasePriceResource";
    DEditClientControlStrategy cStrategy = new DEditClientControlStrategy((IControlModeEditUIProxy)this);
    private static final String PRICETYPEID_CHANNEL = "00000000-0000-0000-0000-0000000000046A61CE8D";
    private AbstractObjectCollection oldBasePrices = null;
    private SCMPasteHelper pastehelper;

    public void onLoad() throws Exception {
        int i;
        this.f7DisplayMode = SCMGroupClientUtils.getF7DisplayMode((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.kDTable.checkParsed();
        for (i = 0; i < 20; ++i) {
            this.kDTable.addRow();
            this.kDTable.getRow(i).getCell(TB_CheckedFlag).setValue((Object)new Boolean("false"));
            this.kDTable.getRow(i).getCell(TB_BlockedFlag).setValue((Object)new Boolean("false"));
        }
        KDTableHelper.updateEnterWithTab((KDTable)this.kDTable, (boolean)true);
        this.pastehelper = new SCMPasteHelper(this.getDetailTable()){

            public void insertRow(int row) {
                this.insertRow(row);
            }

            protected void pasteAfterProcess() {
            }
        };
        super.onLoad();
        this.initIcon();
        this.initTableF7();
        this.initBpData();
        this.initCtrlListener();
        if (!this.oprtState.equalsIgnoreCase("ADDNEW")) {
            this.prmtPriceType.setEnabled(false);
        }
        this.txtPriority.setEnabled(false);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        if (this.oprtState.equalsIgnoreCase("EDIT")) {
            for (i = 0; i < this.kDTable.getRowCount(); ++i) {
                this.setEntryAssistProperty(i, (MaterialInfo)this.kDTable.getRow(i).getCell(TB_Material).getValue());
            }
        }
    }

    private void initIcon() {
        this.btnSumbit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    private void initBpData() {
        if (this.oprtState.equalsIgnoreCase("addnew")) {
            this.prmtCreator.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
            this.kdCreaterDate.setValue((Object)new Timestamp(System.currentTimeMillis()));
            this.pkAuditDate.setValue(null);
            this.pkUpdateDate.setValue(null);
        }
    }

    private void initTableF7() {
        KDBizPromptBox bizMaterialBox = new KDBizPromptBox();
        bizMaterialBox.setEditFormat("$number$");
        bizMaterialBox.setDisplayFormat("$number$");
        bizMaterialBox.setCommitFormat("$helpCode$;$number$;$name$");
        bizMaterialBox.setEditable(true);
        this.setBizMaterial(bizMaterialBox, null, null);
        this.kDTable.getColumn(TB_Material).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizMaterialBox));
        KDBizPromptBox bizUnitBox = new KDBizPromptBox();
        bizUnitBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
        bizUnitBox.setEditFormat("$number$");
        bizUnitBox.setDisplayFormat("$name$");
        bizUnitBox.setCommitFormat("$number$");
        bizUnitBox.setEditable(true);
        this.kDTable.getColumn(TB_Unit).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizUnitBox));
        KDBizPromptBox bizCurrencyBox = new KDBizPromptBox();
        bizCurrencyBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        bizCurrencyBox.setEditFormat("$number$");
        bizCurrencyBox.setDisplayFormat("$name$");
        bizCurrencyBox.setCommitFormat("$number$");
        bizCurrencyBox.setEditable(true);
        this.kDTable.getColumn(TB_Currency).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizCurrencyBox));
        KDFormattedTextField textField = new KDFormattedTextField();
        textField.setDataType(1);
        textField.setNegatived(false);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)textField);
        this.kDTable.getColumn(TB_Price).setEditor((ICellEditor)editor);
        this.kDTable.getColumn(TB_FloorPrice).setEditor((ICellEditor)editor);
        KDBizPromptBox bizAssistPropertyBox = new KDBizPromptBox();
        bizAssistPropertyBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.AsstAttrValueF7Query");
        bizAssistPropertyBox.setEditFormat("$number$");
        bizAssistPropertyBox.setDisplayFormat("$name$");
        bizAssistPropertyBox.setCommitFormat("$number$");
        this.kDTable.getColumn(TB_AssistProperty).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizAssistPropertyBox));
        this.kDTable.getColumn(TB_AssistProperty).getStyleAttributes().setLocked(true);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kDTable.getColumn(TB_Material).setRenderer((IBasicRender)avr);
    }

    private void initCtrlListener() {
        this.kDTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    MaterialBasePriceEditUI.this.kDTable_EditStarting(e);
                }
                catch (Exception exc) {
                    MaterialBasePriceEditUI.this.handUIException(exc);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    MaterialBasePriceEditUI.this.kDTable_EditChanged(e.getRowIndex(), e.getColIndex());
                }
                catch (Exception exc) {
                    MaterialBasePriceEditUI.this.handUIException(exc);
                }
            }
        });
        this.prmtPriceType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    MaterialBasePriceEditUI.this.prmtPriceType_dataChange(e);
                }
                catch (Exception exc) {
                    MaterialBasePriceEditUI.this.handUIException(exc);
                }
            }
        });
    }

    private void prmtPriceType_dataChange(DataChangeEvent e) {
        if (this.prmtPriceType.getData() != null) {
            PriceTypeInfo pInfo = (PriceTypeInfo)this.prmtPriceType.getData();
            this.txtPriceTypeName.setText(pInfo.getName());
            this.txtPriority.setValue((Object)new Integer(pInfo.getPriority()));
            if (((PriceTypeInfo)this.prmtPriceType.getData()).getId().toString().equals(PRICETYPEID_CHANNEL)) {
                this.prmtChannelType.setEnabled(true);
                this.prmtChannelType.setRequired(true);
            } else {
                this.prmtChannelType.setEnabled(false);
                this.prmtChannelType.setData(null);
                this.prmtChannelType.setRequired(false);
            }
        } else {
            this.txtPriceTypeName.setText(null);
            this.txtPriority.setValue(null);
            this.prmtChannelType.setEnabled(false);
            this.prmtChannelType.setData(null);
        }
    }

    private void kDTable_EditStarting(KDTEditEvent e) throws Exception {
        int row = e.getRowIndex();
        int col = e.getColIndex();
        String fieldName = this.kDTable.getColumn(col).getKey();
        if (TB_Unit.equals(fieldName) && !this.kDTable.getColumn(TB_Unit).getStyleAttributes().isHided()) {
            ICell tmpCell = this.kDTable.getRow(row).getCell(TB_Material);
            if (tmpCell.getValue() instanceof MaterialInfo) {
                MaterialInfo mi = (MaterialInfo)tmpCell.getValue();
                KDBizPromptBox bizUnitBox = (KDBizPromptBox)this.kDTable.getColumn(TB_Unit).getEditor().getComponent();
                SCMClientUtils.setF7MeasureUnit((KDBizPromptBox)bizUnitBox, (String)mi.getId().toString());
            } else {
                KDBizPromptBox bizUnitBox = (KDBizPromptBox)this.kDTable.getColumn(TB_Unit).getEditor().getComponent();
                bizUnitBox.setEntityViewInfo(null);
            }
        }
    }

    private void kDTable_EditChanged(int rowIndex, int colIndex) throws Exception {
        String fieldName = this.kDTable.getColumnKey(colIndex);
        if (TB_Material.equalsIgnoreCase(fieldName) && this.kDTable.getColumn(colIndex).getEditor().getComponent() instanceof KDBizPromptBox) {
            this.MaterialDataChanged((KDBizPromptBox)this.kDTable.getColumn(colIndex).getEditor().getComponent());
        }
    }

    private void handleMaterialChange(int rowIndex) throws Exception {
        ICell cell = this.kDTable.getRow(rowIndex).getCell(TB_Material);
        Object value = cell.getValue();
        this.materialChange((MaterialInfo)value, rowIndex);
    }

    private void materialChange(MaterialInfo value, int rowIndex) throws Exception {
        MaterialInfo materialInfo = value;
        if (materialInfo != null) {
            this.kDTable.getRow(rowIndex).getCell(TB_Material).setValue((Object)materialInfo);
            this.kDTable.getRow(rowIndex).getCell(TB_MaterialName).setValue((Object)materialInfo.getName());
            this.kDTable.getRow(rowIndex).getCell(TB_Model).setValue((Object)materialInfo.getModel());
            IMeasureUnit im = MeasureUnitFactory.getRemoteInstance();
            if (materialInfo.getBaseUnit() != null) {
                MeasureUnitInfo mUnitInfo = im.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(materialInfo.getBaseUnit().getId()));
                this.kDTable.getRow(rowIndex).getCell(TB_Unit).setValue((Object)mUnitInfo);
            }
            int precision = materialInfo.getPricePrecision();
            SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)this.kDTable, (String[])Prices, (int)rowIndex);
        } else {
            this.kDTable.getRow(rowIndex).getCell(TB_MaterialName).setValue(null);
            this.kDTable.getRow(rowIndex).getCell(TB_Model).setValue(null);
            this.kDTable.getRow(rowIndex).getCell(TB_Unit).setValue(null);
        }
        this.setEntryAssistProperty(rowIndex, materialInfo);
        CurrencyInfo currencyInfo = null;
        if (materialInfo != null && this.kDTable.getRow(rowIndex).getCell(TB_Currency).getValue() == null) {
            if (SysContext.getSysContext().getCurrentFIUnit() != null) {
                CompanyOrgUnitInfo ficompanyOrgInfo = SysContext.getSysContext().getCurrentFIUnit();
                if (ficompanyOrgInfo != null && ficompanyOrgInfo.getBaseCurrency() != null) {
                    try {
                        currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getBaseCurrency().getId()));
                    }
                    catch (EASBizException e) {
                        this.handleException((Exception)((Object)e));
                    }
                    catch (BOSException e) {
                        this.handleException((Exception)((Object)e));
                    }
                }
            } else {
                EntityViewInfo currencyView = new EntityViewInfo();
                currencyView.setFilter(new FilterInfo());
                currencyView.getFilter().getFilterItems().add(new FilterItemInfo("isoCode", (Object)"RMB"));
                try {
                    CurrencyCollection currencyCollection = CurrencyFactory.getRemoteInstance().getCurrencyCollection(currencyView);
                    if (currencyCollection.size() > 0) {
                        currencyInfo = currencyCollection.get(0);
                    }
                }
                catch (Exception e) {
                    super.handUIException((Throwable)e);
                }
            }
        } else if (this.kDTable.getRow(rowIndex).getCell(TB_Currency).getValue() instanceof CurrencyInfo) {
            currencyInfo = (CurrencyInfo)this.kDTable.getRow(rowIndex).getCell(TB_Currency).getValue();
        }
        this.kDTable.getRow(rowIndex).getCell(TB_Currency).setValue(currencyInfo);
        this.kDTable.getRow(rowIndex).getCell(TB_AssistProperty).setValue(null);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.bpLoadFields();
        }
        catch (Exception exc) {
            this.handleException(exc);
        }
        int size = this.kDTable.getRowCount();
        for (int i = 0; i < size; ++i) {
            ICell cell = this.kDTable.getRow(i).getCell(TB_Material);
            Object value = cell.getValue();
            if (value == null) continue;
            MaterialInfo materialInfo = (MaterialInfo)value;
            int precision = materialInfo.getPricePrecision();
            SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)this.kDTable, (String[])Prices, (int)i);
        }
        if (this.editData != null && this.editData.getPriceType() != null && this.editData.getPriceType().getId().toString().equals(PRICETYPEID_CHANNEL)) {
            this.prmtChannelType.setEnabled(true);
            this.prmtChannelType.setRequired(true);
        } else {
            this.prmtChannelType.setEnabled(false);
            this.prmtChannelType.setRequired(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.bpStoreFields();
    }

    private void bpLoadFields() throws Exception {
        this.oldBasePrices = new MaterialBasePriceCollection();
        if (this.getUIContext().get("List") == null && this.getServiceContext().get("List") == null) {
            if (this.editData != null && !this.oprtState.equalsIgnoreCase("ADDNEW")) {
                this.setEditBody(this.editData, 0);
                this.oldBasePrices.addObject((IObjectValue)this.editData.clone());
                this.prmtCreator.setValue((Object)this.editData.getCreator());
                this.kdCreaterDate.setValue((Object)this.editData.getCreateTime());
                this.prmtAuditor.setValue((Object)this.editData.getAuditor());
                this.pkAuditDate.setValue((Object)this.editData.getAuditDate());
                this.prmtUpdator.setValue((Object)this.editData.getLastUpdateUser());
                this.pkUpdateDate.setValue((Object)this.editData.getLastUpdateTime());
                this.prmtAdminCU.setData((Object)this.editData.getAdminCU());
            }
        } else {
            int i;
            List list = (List)this.getUIContext().get("List");
            int size = list.size();
            if (size > 20) {
                for (i = 0; i < size - 20; ++i) {
                    this.kDTable.addRow();
                }
            }
            for (i = 0; i < size; ++i) {
                ObjectUuidPK pk = null;
                MaterialBasePriceInfo priceInfo = null;
                pk = new ObjectUuidPK(BOSUuid.read((String)list.get(i).toString()));
                priceInfo = (MaterialBasePriceInfo)this.getValue((IObjectPK)pk);
                this.setEditBody(priceInfo, i);
                this.oldBasePrices.addObject((IObjectValue)priceInfo.clone());
                if (i != 0) continue;
                this.setEditHead(priceInfo);
            }
        }
    }

    private void setEditBody(MaterialBasePriceInfo mInfo, int i) {
        this.kDTable.getRow(i).getCell(TB_ID).setValue((Object)mInfo.getId());
        this.kDTable.getRow(i).getCell(TB_Material).setValue((Object)mInfo.getMaterial());
        this.kDTable.getRow(i).getCell(TB_MaterialName).setValue((Object)mInfo.getMaterial().getName());
        this.kDTable.getRow(i).getCell(TB_Model).setValue((Object)mInfo.getMaterial().getModel());
        this.kDTable.getRow(i).getCell(TB_AssistProperty).setValue((Object)mInfo.getAssistProperty());
        this.kDTable.getRow(i).getCell(TB_Currency).setValue((Object)mInfo.getCurrency());
        this.kDTable.getRow(i).getCell(TB_Unit).setValue((Object)mInfo.getUnit());
        this.kDTable.getRow(i).getCell(TB_Price).setValue((Object)mInfo.getPrice());
        this.kDTable.getRow(i).getCell(TB_FloorPrice).setValue((Object)mInfo.getFloorPrice());
        this.kDTable.getRow(i).getCell(TB_MAXPRICE).setValue((Object)mInfo.getMaxPrice());
        this.kDTable.getRow(i).getCell(TB_CheckedFlag).setValue((Object)new Boolean(mInfo.isCheckedFlag()));
        this.kDTable.getRow(i).getCell(TB_BlockedFlag).setValue((Object)new Boolean(mInfo.isBlockedFlag()));
        this.kDTable.getRow(i).getCell(TB_CU).setValue((Object)mInfo.getCU());
        this.kDTable.getRow(i).getCell(TB_PriceType).setValue((Object)mInfo.getPriceType());
        this.kDTable.getRow(i).getCell(TB_Priority).setValue((Object)new Integer(mInfo.getPriority()));
        this.kDTable.getRow(i).getCell(TB_Creater).setValue((Object)mInfo.getCreator());
        this.kDTable.getRow(i).getCell(TB_CreateTime).setValue((Object)mInfo.getCreateTime());
        this.kDTable.getRow(i).getCell(TB_Auditor).setValue((Object)mInfo.getAuditor());
        this.kDTable.getRow(i).getCell(TB_AuditTime).setValue((Object)mInfo.getAuditDate());
        this.kDTable.getRow(i).getCell(TB_Updater).setValue((Object)mInfo.getLastUpdateUser());
        this.kDTable.getRow(i).getCell(TB_UpdaterTime).setValue((Object)mInfo.getLastUpdateTime());
        if (mInfo.getAssistProperty() != null) {
            this.kDTable.getRow(i).getCell(TB_AssistProperty).getStyleAttributes().setLocked(false);
        }
        if (mInfo.isCheckedFlag() || mInfo.isBlockedFlag()) {
            this.kDTable.getRow(i).getStyleAttributes().setLocked(true);
        }
    }

    private void setEditHead(MaterialBasePriceInfo mInfo) {
        this.prmtPriceType.setValue((Object)mInfo.getPriceType());
        this.prmtChannelType.setValue((Object)mInfo.getChannelType());
        this.txtPriceTypeName.setText(mInfo.getPriceType().getName().toString());
        this.txtPriority.setValue((Object)new Integer(mInfo.getPriceType().getPriority()));
        this.prmtCreator.setValue((Object)mInfo.getCreator());
        this.kdCreaterDate.setValue((Object)mInfo.getCreateTime());
        this.prmtAuditor.setValue((Object)mInfo.getAuditor());
        this.pkAuditDate.setValue((Object)mInfo.getAuditDate());
        this.prmtUpdator.setValue((Object)mInfo.getLastUpdateUser());
        this.pkUpdateDate.setValue((Object)mInfo.getLastUpdateTime());
    }

    private void bpStoreFields() {
        this.basePrices = new MaterialBasePriceCollection();
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            IRow row = this.kDTable.getRow(i);
            if (row.getCell(TB_Material).getValue() == null) continue;
            MaterialBasePriceInfo mInfo = new MaterialBasePriceInfo();
            if (row.getCell(TB_ID).getValue() != null) {
                mInfo.setId(BOSUuid.read((String)row.getCell(TB_ID).getValue().toString()));
            }
            if (row.getCell(TB_Material).getValue() instanceof MaterialInfo) {
                mInfo.setMaterial((MaterialInfo)row.getCell(TB_Material).getValue());
            } else if (row.getCell(TB_Material).getValue() instanceof Object[]) {
                Object[] o = (Object[])row.getCell(TB_Material).getValue();
                mInfo.setMaterial((MaterialInfo)o[0]);
            }
            mInfo.setCurrency((CurrencyInfo)row.getCell(TB_Currency).getValue());
            mInfo.setUnit((MeasureUnitInfo)row.getCell(TB_Unit).getValue());
            if (row.getCell(TB_ID).getValue() == null) {
                mInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                mInfo.setAdminCU(SysContext.getSysContext().getCurrentCtrlUnit());
            } else {
                mInfo.setCU(this.editData.getCU());
                mInfo.setAdminCU(this.editData.getAdminCU());
            }
            if (row.getCell(TB_AssistProperty).getValue() != null) {
                mInfo.setAssistProperty((AsstAttrValueInfo)row.getCell(TB_AssistProperty).getValue());
            } else {
                mInfo.setAssistProperty(null);
            }
            if (row.getCell(TB_Price).getValue() != null) {
                mInfo.setPrice(new BigDecimal(row.getCell(TB_Price).getValue().toString()));
            } else {
                mInfo.setPrice(null);
            }
            if (row.getCell(TB_FloorPrice).getValue() != null) {
                mInfo.setFloorPrice(new BigDecimal(row.getCell(TB_FloorPrice).getValue().toString()));
            } else {
                mInfo.setFloorPrice(null);
            }
            if (row.getCell(TB_MAXPRICE).getValue() != null) {
                mInfo.setMaxPrice(new BigDecimal(row.getCell(TB_MAXPRICE).getValue().toString()));
            } else {
                mInfo.setMaxPrice(null);
            }
            mInfo.setPriceType((PriceTypeInfo)this.prmtPriceType.getData());
            mInfo.setChannelType((ChannelTypeInfo)this.prmtChannelType.getData());
            if (this.txtPriority.getNumberValue() != null) {
                mInfo.setPriority(this.txtPriority.getNumberValue().intValue());
            }
            this.basePrices.addObject((IObjectValue)mInfo);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.COPYADDNEW.equals(this.getOprtState())) {
            this.cStrategy.checkCanAdd();
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.cStrategy.checkCanUpdateByAdminCUID(this.editData.getAdminCU().getId().toString());
        }
        this.checkData();
        this.bpStoreFields();
        IMaterialBasePrice imbp = MaterialBasePriceFactory.getRemoteInstance();
        if (this.basePrices.size() > 0) {
            this.oldBasePrices = new MaterialBasePriceCollection();
            int size = this.basePrices.size();
            for (int i = 0; i < size; ++i) {
                MaterialBasePriceInfo mInfo = (MaterialBasePriceInfo)this.basePrices.getObject(i);
                if (mInfo.getId() != null) {
                    this.checkDuplicateEdit(this.kDTable.getRow(i), i);
                    imbp.update((IObjectPK)new ObjectUuidPK(mInfo.getId()), (CoreBaseInfo)mInfo);
                    if (i == size - 1) {
                        MsgBox.showInfo((Component)((Object)this), (String)this.getResource("Edit_Success"));
                    }
                } else {
                    this.checkDuplicate(this.kDTable.getRow(i), i);
                    IObjectPK pk = imbp.submit((CoreBaseInfo)mInfo);
                    this.kDTable.getRow(i).getCell(TB_ID).setValue((Object)pk);
                    mInfo.setId(BOSUuid.read((String)pk.toString()));
                    if (i == size - 1) {
                        this.showSubmitSuccess();
                    }
                }
                this.oldBasePrices.addObject((IObjectValue)mInfo.clone());
            }
        }
        this.initOldData((IObjectValue)this.editData);
    }

    public void clearData() {
        this.prmtPriceType.setValue(null);
        this.prmtChannelType.setValue(null);
        this.txtPriceTypeName.setText("");
        this.txtPriority.setValue(null);
        this.prmtAuditor.setValue(null);
        this.pkAuditDate.setValue(null);
        this.prmtUpdator.setValue(null);
        this.pkUpdateDate.setValue(null);
        if (this.editData != null) {
            this.editData = (MaterialBasePriceInfo)this.createNewData();
        }
        for (int i = 0; i < 20; ++i) {
            this.kDTable.addRow();
            this.kDTable.getRow(i).getCell(TB_CheckedFlag).setValue((Object)new Boolean("false"));
            this.kDTable.getRow(i).getCell(TB_BlockedFlag).setValue((Object)new Boolean("false"));
        }
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.cStrategy.checkCanAdd();
        this.checkCanModify();
        super.actionAddLine_actionPerformed(e);
        IRow row = this.kDTable.addRow();
        row.setUserObject((Object)new MaterialBasePriceInfo());
        row.getCell(TB_CheckedFlag).setValue((Object)new Boolean("false"));
        row.getCell(TB_BlockedFlag).setValue((Object)new Boolean("false"));
    }

    private void checkCanModify() throws Exception {
        if (this.editData.getCheckedStatus() != null && this.editData.getCheckedStatus().equals(CheckedStatusEnum.AUDITED) || this.editData.getBlockedStatus() != null && this.editData.getBlockedStatus().equals(BlockedStatusEnum.BLOCKED)) {
            throw new MaterialBasePriceException(MaterialBasePriceException.EDIT_NEED_UNAUDIT);
        }
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int index = this.kDTable.getSelectManager().getActiveRowIndex();
        if (index > -1) {
            if (this.kDTable.getCell(index, TB_ID).getValue() != null) {
                if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)this.getResource("prompt_request_remove")))) {
                    ObjectUuidPK[] pks = new ObjectUuidPK[]{new ObjectUuidPK(this.kDTable.getCell(index, TB_ID).getValue().toString())};
                    this.getBizInterface().delete((IObjectPK[])pks);
                    this.kDTable.removeRow(index);
                    this.kDTable.addRow();
                }
            } else {
                this.kDTable.removeRow(index);
                this.kDTable.addRow();
            }
        } else {
            AssistantClientUtils.plsSelectRowFirst((Component)((Object)this));
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.cStrategy.checkCanAdd();
        this.checkModified();
        this.btnSubmit.setEnabled(true);
        if (this.kDTable.getRowCount() > 0) {
            this.kDTable.removeRows();
            for (int i = 0; i < 20; ++i) {
                this.kDTable.addRow();
                this.kDTable.getRow(i).getCell(TB_CheckedFlag).setValue((Object)new Boolean("false"));
                this.kDTable.getRow(i).getCell(TB_BlockedFlag).setValue((Object)new Boolean("false"));
            }
            this.prmtPriceType.setValue(null);
            this.prmtChannelType.setValue(null);
            this.txtPriceTypeName.setText("");
            this.txtPriority.setValue(null);
            this.prmtAuditor.setValue(null);
            this.pkAuditDate.setValue(null);
            this.prmtUpdator.setValue(null);
            this.pkUpdateDate.setValue(null);
            this.prmtCreator.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
            this.kdCreaterDate.setValue((Object)new Timestamp(System.currentTimeMillis()));
        }
        this.setDataObject(this.createNewData());
        this.initOldData((IObjectValue)this.editData);
        this.setOprtState("ADDNEW");
        this.unLockUI();
        this.setDefaultFocused();
        this.prmtPriceType.setEnabled(true);
        this.initTableF7();
    }

    private void checkData() throws Exception {
        if (this.prmtPriceType.getData() == null) {
            this.prmtPriceType.requestFocus();
            MsgBox.showInfo((String)this.getResource("null_priceType"));
            SysUtil.abort();
        }
        if (this.prmtPriceType.getData() != null && this.prmtChannelType.isEnabled() && this.prmtChannelType.getData() == null) {
            this.prmtChannelType.requestFocus();
            MsgBox.showInfo((String)this.getResource("null_channelType"));
            SysUtil.abort();
        }
        if (this.txtPriority.getText().length() <= 0) {
            this.prmtPriceType.requestFocus();
            MsgBox.showInfo((String)this.getResource("null_priority"));
            SysUtil.abort();
        }
        if (this.kDTable.getRowCount() > 0) {
            for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
                BigDecimal maxPrice;
                BigDecimal price;
                IRow row = this.kDTable.getRow(i);
                if (row.getCell(TB_Material).getValue() == null && row.getCell(TB_Unit).getValue() == null && row.getCell(TB_Currency).getValue() == null) continue;
                if (row.getCell(TB_Material).getValue() == null) {
                    this.kDTable.getSelectManager().select(i, 1);
                    MsgBox.showInfo((String)this.getResource("null_material"));
                    SysUtil.abort();
                }
                if (row.getCell(TB_Unit).getValue() == null) {
                    this.kDTable.getSelectManager().select(i, 5);
                    MsgBox.showInfo((String)this.getResource("null_unit"));
                    SysUtil.abort();
                }
                if (row.getCell(TB_Currency).getValue() == null) {
                    this.kDTable.getSelectManager().select(i, 6);
                    MsgBox.showInfo((String)this.getResource("null_currency"));
                    SysUtil.abort();
                }
                if (row.getCell(TB_Price).getValue() == null && row.getCell(TB_FloorPrice).getValue() == null) {
                    if (row.getCell(TB_Price).getValue() == null) {
                        this.kDTable.getSelectManager().select(i, 7);
                    }
                    this.kDTable.getSelectManager().select(i, 8);
                    MsgBox.showInfo((String)this.getResource("null_priceOrfloorPrice"));
                    SysUtil.abort();
                }
                if (row.getCell(TB_Price).getValue() != null && row.getCell(TB_FloorPrice).getValue() != null) {
                    price = (BigDecimal)row.getCell(TB_Price).getValue();
                    BigDecimal floorPrice = (BigDecimal)row.getCell(TB_FloorPrice).getValue();
                    if (floorPrice.compareTo(price) == 1) {
                        this.kDTable.getSelectManager().select(i, 8);
                        MsgBox.showInfo((String)this.getResource("fp_biggerthan_p"));
                        SysUtil.abort();
                    }
                }
                if (row.getCell(TB_MAXPRICE).getValue() != null && row.getCell(TB_Price).getValue() != null) {
                    price = (BigDecimal)row.getCell(TB_Price).getValue();
                    maxPrice = (BigDecimal)row.getCell(TB_MAXPRICE).getValue();
                    if (maxPrice.compareTo(price) == -1) {
                        this.kDTable.getSelectManager().select(i, 8);
                        MsgBox.showInfo((String)this.getResource("fp_lessthan_price"));
                        SysUtil.abort();
                    }
                }
                if (row.getCell(TB_MAXPRICE).getValue() == null || row.getCell(TB_FloorPrice).getValue() == null) continue;
                BigDecimal floorPrice = (BigDecimal)row.getCell(TB_FloorPrice).getValue();
                maxPrice = (BigDecimal)row.getCell(TB_MAXPRICE).getValue();
                if (maxPrice.compareTo(floorPrice) != -1) continue;
                this.kDTable.getSelectManager().select(i, 8);
                MsgBox.showInfo((String)this.getResource("max_lessthan_min"));
                SysUtil.abort();
            }
        }
    }

    private void checkDuplicate(IRow row, int i) throws Exception {
        MaterialBasePriceInfo mInfo = new MaterialBasePriceInfo();
        if (row.getCell(TB_Material).getValue() instanceof MaterialInfo) {
            mInfo.setMaterial((MaterialInfo)row.getCell(TB_Material).getValue());
        } else if (row.getCell(TB_Material).getValue() instanceof Object[]) {
            Object[] o = (Object[])row.getCell(TB_Material).getValue();
            mInfo.setMaterial((MaterialInfo)o[0]);
        }
        if (row.getCell(TB_AssistProperty).getValue() != null) {
            mInfo.setAssistProperty((AsstAttrValueInfo)row.getCell(TB_AssistProperty).getValue());
        }
        mInfo.setCurrency((CurrencyInfo)row.getCell(TB_Currency).getValue());
        mInfo.setPriceType((PriceTypeInfo)this.prmtPriceType.getData());
        if (this.prmtChannelType.getData() != null) {
            mInfo.setChannelType((ChannelTypeInfo)this.prmtChannelType.getData());
        }
        mInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        mInfo.setUnit((MeasureUnitInfo)row.getCell(TB_Unit).getValue());
        boolean isexists = ((IMaterialBasePrice)this.getBizInterface()).existBasePrice(mInfo);
        if (isexists) {
            String msg;
            if (row.getCell(TB_AssistProperty).getValue() != null) {
                msg = this.getResource("Duplicate_Material") + "(" + ((MaterialInfo)row.getCell(TB_Material).getValue()).getNumber().toString() + ")" + this.getResource("Duplicate_AssistProperty") + "(" + row.getCell(TB_AssistProperty).getValue().toString() + ")" + this.getResource("Duplicate_Currency") + "(" + ((CurrencyInfo)row.getCell(TB_Currency).getValue()).getName().toString() + ")" + this.getResource("Duplicate_PriceType") + "(" + ((PriceTypeInfo)this.prmtPriceType.getValue()).getName().toString() + ")";
                msg = this.prmtChannelType.getValue() instanceof ChannelTypeInfo ? msg + this.getResource("Duplicate_ChannelType") + "(" + ((ChannelTypeInfo)this.prmtChannelType.getValue()).getName().toString() + ")" + this.getResource("Duplicate_Unit") + "(" + ((MeasureUnitInfo)row.getCell(TB_Unit).getValue()).getName().toString() + ")" : msg + this.getResource("Duplicate_Unit") + "(" + ((MeasureUnitInfo)row.getCell(TB_Unit).getValue()).getName().toString() + ")";
                MsgBox.showInfo((String)MessageFormat.format(this.getResource("Duplicate_HavedPrice1"), String.valueOf(i + 1), msg));
                SysUtil.abort();
            }
            if (row.getCell(TB_AssistProperty).getValue() == null) {
                msg = this.getResource("Duplicate_Material") + "(" + ((MaterialInfo)row.getCell(TB_Material).getValue()).getNumber().toString() + ")" + this.getResource("Duplicate_Currency") + "(" + ((CurrencyInfo)row.getCell(TB_Currency).getValue()).getName().toString() + ")" + this.getResource("Duplicate_PriceType") + "(" + ((PriceTypeInfo)this.prmtPriceType.getValue()).getName().toString() + ")";
                msg = this.prmtChannelType.getValue() instanceof ChannelTypeInfo ? msg + this.getResource("Duplicate_ChannelType") + "(" + ((ChannelTypeInfo)this.prmtChannelType.getValue()).getName().toString() + ")" + this.getResource("Duplicate_Unit") + "(" + ((MeasureUnitInfo)row.getCell(TB_Unit).getValue()).getName().toString() + ")" : msg + this.getResource("Duplicate_Unit") + "(" + ((MeasureUnitInfo)row.getCell(TB_Unit).getValue()).getName().toString() + ")";
                MsgBox.showInfo((String)MessageFormat.format(this.getResource("Duplicate_HavedPrice1"), String.valueOf(i + 1), msg));
                SysUtil.abort();
            }
        }
    }

    private void checkDuplicateEdit(IRow row, int i) throws Exception {
        MaterialBasePriceInfo mInfo = new MaterialBasePriceInfo();
        if (row.getCell(TB_Material).getValue() instanceof MaterialInfo) {
            mInfo.setMaterial((MaterialInfo)row.getCell(TB_Material).getValue());
        } else if (row.getCell(TB_Material).getValue() instanceof Object[]) {
            Object[] o = (Object[])row.getCell(TB_Material).getValue();
            mInfo.setMaterial((MaterialInfo)o[0]);
        }
        if (row.getCell(TB_AssistProperty).getValue() != null) {
            mInfo.setAssistProperty((AsstAttrValueInfo)row.getCell(TB_AssistProperty).getValue());
        }
        mInfo.setCurrency((CurrencyInfo)row.getCell(TB_Currency).getValue());
        mInfo.setPriceType((PriceTypeInfo)this.prmtPriceType.getData());
        mInfo.setChannelType((ChannelTypeInfo)this.prmtChannelType.getData());
        mInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        mInfo.setUnit((MeasureUnitInfo)row.getCell(TB_Unit).getValue());
        Object id = row.getCell(TB_ID).getValue();
        if (id != null) {
            mInfo.setId(BOSUuid.read((String)id.toString()));
        }
        if (((IMaterialBasePrice)this.getBizInterface()).existBasePriceInEdit(mInfo)) {
            String msg = this.getResource("Duplicate_Material") + "(" + ((MaterialInfo)row.getCell(TB_Material).getValue()).getNumber().toString() + ")";
            msg = row.getCell(TB_AssistProperty).getValue() != null ? msg + this.getResource("Duplicate_AssistProperty") + "(" + row.getCell(TB_AssistProperty).getValue().toString() + ")" + this.getResource("Duplicate_Currency") + "(" + ((CurrencyInfo)row.getCell(TB_Currency).getValue()).getName().toString() + ")" + this.getResource("Duplicate_PriceType") + "(" + ((PriceTypeInfo)this.prmtPriceType.getValue()).getName().toString() + ")" : msg + this.getResource("Duplicate_Currency") + "(" + ((CurrencyInfo)row.getCell(TB_Currency).getValue()).getName().toString() + ")" + this.getResource("Duplicate_PriceType") + "(" + ((PriceTypeInfo)this.prmtPriceType.getValue()).getName().toString() + ")";
            msg = this.prmtChannelType.getValue() instanceof ChannelTypeInfo ? msg + this.getResource("Duplicate_ChannelType") + "(" + ((ChannelTypeInfo)this.prmtChannelType.getValue()).getName().toString() + ")" + this.getResource("Duplicate_Unit") + "(" + ((MeasureUnitInfo)row.getCell(TB_Unit).getValue()).getName().toString() + ")" : msg + this.getResource("Duplicate_Unit") + "(" + ((MeasureUnitInfo)row.getCell(TB_Unit).getValue()).getName().toString() + ")";
            MsgBox.showInfo((String)MessageFormat.format(this.getResource("Duplicate_HavedPrice1"), String.valueOf(i + 1), msg));
            SysUtil.abort();
        }
    }

    private String getResource(String key) {
        return EASResource.getString((String)RES_PROMPT, (String)key);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialBasePriceFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        MaterialBasePriceInfo value = new MaterialBasePriceInfo();
        value.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        value.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        value.setAdminCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return value;
    }

    protected void MaterialDataChanged(KDBizPromptBox bizMaterialBox) throws Exception {
        KDTSelectBlock ksb = this.kDTable.getSelectManager().get();
        int beginRow = ksb.getBeginRow();
        Object[] obj = null;
        if (bizMaterialBox.getValue() instanceof Object[]) {
            obj = (Object[])bizMaterialBox.getValue();
            if (obj.length == 1 && obj[0] instanceof MaterialInfo) {
                this.materialChange((MaterialInfo)obj[0], beginRow);
            } else {
                IRow curRow2 = null;
                MaterialInfo mi = null;
                boolean needInsert = false;
                int insertedRowCount = 0;
                for (int i = 0; i < obj.length; ++i) {
                    if (needInsert) {
                        this.insertRow(beginRow + insertedRowCount);
                        needInsert = false;
                    }
                    if (!(obj[i] instanceof MaterialInfo)) {
                        return;
                    }
                    mi = (MaterialInfo)obj[i];
                    curRow2 = this.kDTable.getRow(beginRow + insertedRowCount);
                    int curCol = this.kDTable.getColumnIndex(TB_Material);
                    curRow2.getCell(curCol).setValue(null);
                    curRow2.getCell(curCol).setValue((Object)mi);
                    try {
                        this.handleMaterialChange(beginRow + insertedRowCount);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    needInsert = true;
                    ++insertedRowCount;
                }
            }
        } else if (bizMaterialBox.getValue() instanceof MaterialInfo) {
            this.materialChange((MaterialInfo)bizMaterialBox.getValue(), beginRow);
        }
    }

    protected void insertRow(int row) {
        this.kDTable.addRow(row);
        this.kDTable.getRow(row).getCell(TB_CheckedFlag).setValue((Object)new Boolean("false"));
        this.kDTable.getRow(row).getCell(TB_BlockedFlag).setValue((Object)new Boolean("false"));
    }

    public static String getFormatString(int precision) {
        if (precision == 0) {
            return "%R-{#,##0}f";
        }
        StringBuffer buffer = new StringBuffer();
        if (precision == 0) {
            buffer.append("#");
        } else {
            buffer.append("0.");
        }
        for (int i = 0; i < precision; ++i) {
            buffer = buffer.append("0");
        }
        StringBuffer formatString = new StringBuffer();
        formatString.append("%r-[=]{#,##").append(buffer).append("}f");
        return formatString.toString();
    }

    protected void setEntryAssistProperty(int rowIndex, MaterialInfo materialInfo) {
        if (materialInfo != null) {
            String assistAttrTypeID = materialInfo.getAssistAttr() == null ? null : materialInfo.getAssistAttr().getId().toString();
            KDBizPromptBox bizAssistPropertyBox = new KDBizPromptBox();
            SCMClientUtils.setAsstAttrInputF7((KDBizPromptBox)bizAssistPropertyBox, (MaterialInfo)materialInfo, (IUIObject)this);
            ObjectValueRender avr = new ObjectValueRender();
            avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
            this.kDTable.getColumn(TB_AssistProperty).setRenderer((IBasicRender)avr);
            if (assistAttrTypeID != null) {
                this.kDTable.getRow(rowIndex).getCell(TB_AssistProperty).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizAssistPropertyBox));
                this.kDTable.getRow(rowIndex).getCell(TB_AssistProperty).getStyleAttributes().setLocked(false);
            } else {
                this.kDTable.getRow(rowIndex).getCell(TB_AssistProperty).getStyleAttributes().setLocked(true);
            }
        } else {
            this.kDTable.getRow(rowIndex).getCell(TB_AssistProperty).getStyleAttributes().setLocked(true);
        }
    }

    public static void setF7AssistProperty(KDBizPromptBox bizBox, String asstAttrTypeID, EditUI editUI) {
        AsstAttrPromptBox box = new AsstAttrPromptBox((IUIObject)editUI);
        bizBox.setDisplayFormat("$name$");
        bizBox.setEditFormat("$number$");
        bizBox.setCommitFormat("$number$");
        bizBox.setHasCUDefaultFilter(false);
        bizBox.setEditable(true);
        bizBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7AsstAttrValueQuery");
        box.AsstAttrTypeID = asstAttrTypeID;
        EntityViewInfo viewInfo = box.getViewInfoByType(asstAttrTypeID);
        bizBox.setEntityViewInfo(viewInfo);
        bizBox.setSelector((KDPromptSelector)box);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        BDInvClientUtils.logUIOperation("LOG_PRINT", new MaterialBasePriceInfo().getBOSType());
        super.actionPrint_actionPerformed(e);
    }

    protected void setBizMaterial(KDBizPromptBox bizMaterialBox, IColumn col, String queryInfo) {
        if (queryInfo != null) {
            bizMaterialBox.setQueryInfo(queryInfo);
        }
        bizMaterialBox.setEditFormat("$number$");
        bizMaterialBox.setDisplayFormat("$number$");
        bizMaterialBox.setCommitFormat("$helpCode$;$number$;$name$");
        bizMaterialBox.setEditable(true);
        bizMaterialBox.setEnabledMultiSelection(true);
        if (this.f7DisplayMode == 0) {
            try {
                F7MaterialMultiUISelectorAdaptor selectorLisenter = null;
                selectorLisenter = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)bizMaterialBox, "com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUI", (Object)this, "C79FC042", "com.kingdee.eas.basedata.master.material.app.F7MaterialQuery", "MaterialGroup.id");
                selectorLisenter.setQueryProperty("helpCode", "or");
                selectorLisenter.setIsMultiSelect(true);
                bizMaterialBox.setSelector((KDPromptSelector)selectorLisenter);
                bizMaterialBox.addSelectorListener((SelectorListener)selectorLisenter);
                EntityViewInfo eve = new EntityViewInfo();
                FilterInfo filterinfo = new FilterInfo();
                CtrlUnitInfo CU = null;
                if (this.prmtAdminCU.getValue() != null && this.prmtAdminCU.getValue() instanceof CtrlUnitInfo) {
                    CU = (CtrlUnitInfo)this.prmtAdminCU.getValue();
                }
                if (CU != null && CU.getId() != null) {
                    filterinfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)("SELECT FDataBaseDID FROM t_bd_databasedassign WHERE FBOSObjectType = '4409E7F0' AND FAssignCUID = '" + CU.getId().toString() + "' UNION ALL SELECT fid FROM T_BD_Material WHERE fcontrolunitid = '" + CU.getId().toString() + "'"), CompareType.INNER));
                    eve.setFilter(filterinfo);
                    bizMaterialBox.setEntityViewInfo(eve);
                }
            }
            catch (Exception e) {
                super.handUIException((Throwable)e);
            }
        } else if (queryInfo == null) {
            bizMaterialBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialBaseInfoQuery");
        }
    }

    protected void checkDeletePolicy(IObjectPK ctrlUnitPK, BOSObjectType objectType) throws BOSException, EASBizException {
        boolean flag;
        ICUBDControl iCUBDControl = CUBDControlFactory.getRemoteInstance();
        CUBDControlInfo controlInfo = iCUBDControl.getBDCtrlInfo(objectType.toString(), this.getBizCUPK().toString());
        boolean bl = flag = controlInfo == null ? false : controlInfo.isIsSubordinateDeletable();
        if (!flag) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.cStrategy.checkCanUpdateByAdminCUID(this.editData.getAdminCU().getId().toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo(TB_CheckedFlag));
        selector.add(new SelectorItemInfo(TB_BlockedFlag));
        MaterialBasePriceInfo info = (MaterialBasePriceInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()), selector);
        if (info.isCheckedFlag() || info.isBlockedFlag()) {
            MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"NOTEDIT"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        if (this.oprtState.equalsIgnoreCase("EDIT")) {
            for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
                this.setEntryAssistProperty(i, (MaterialInfo)this.kDTable.getRow(i).getCell(TB_Material).getValue());
            }
            if (this.prmtPriceType.getData() != null) {
                if (((PriceTypeInfo)this.prmtPriceType.getData()).getId().toString().equals(PRICETYPEID_CHANNEL)) {
                    this.prmtChannelType.setEnabled(true);
                    this.prmtChannelType.setRequired(true);
                } else {
                    this.prmtChannelType.setEnabled(false);
                    this.prmtChannelType.setData(null);
                    this.prmtChannelType.setRequired(false);
                }
            } else {
                this.prmtChannelType.setEnabled(false);
                this.prmtChannelType.setData(null);
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("priceType.*"));
        sic.add(new SelectorItemInfo(TB_Priority));
        sic.add(new SelectorItemInfo(TB_ID));
        sic.add(new SelectorItemInfo(TB_FloorPrice));
        sic.add(new SelectorItemInfo(TB_Price));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("unit.*"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.*"));
        sic.add(new SelectorItemInfo(TB_CheckedFlag));
        sic.add(new SelectorItemInfo(TB_BlockedFlag));
        sic.add(new SelectorItemInfo("assistProperty.*"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo(TB_MAXPRICE));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo(TB_CreateTime));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("adminCU.*"));
        sic.add(new SelectorItemInfo("channelType.id"));
        sic.add(new SelectorItemInfo("channelType.name"));
        sic.add(new SelectorItemInfo("channelType.number"));
        return sic;
    }

    public boolean isModify() {
        boolean isModify = super.isModify();
        if (!isModify) {
            isModify = !MaterialBasePriceEditUI.objectCollectionEquals(this.oldBasePrices, this.basePrices);
        }
        return isModify;
    }

    public static boolean objectCollectionEquals(AbstractObjectCollection sourceCollection, AbstractObjectCollection targetCollection) {
        if (sourceCollection == null || targetCollection == null || sourceCollection.size() != targetCollection.size()) {
            return false;
        }
        for (int i = 0; i < sourceCollection.size(); ++i) {
            if (sourceCollection.getObject(i) == null || targetCollection.getObject(i) == null) {
                return false;
            }
            MaterialBasePriceInfo sourceObject = (MaterialBasePriceInfo)sourceCollection.getObject(i);
            MaterialBasePriceInfo targetObject = (MaterialBasePriceInfo)targetCollection.getObject(i);
            if (ObjectValueForEditUIUtil.objectValueEquals((AbstractObjectValue)MaterialBasePriceEditUI.getObjectValue(sourceObject), (AbstractObjectValue)MaterialBasePriceEditUI.getObjectValue(targetObject))) continue;
            return false;
        }
        return true;
    }

    private static AbstractObjectValue getObjectValue(MaterialBasePriceInfo object) {
        MaterialBasePriceInfo objValue = new MaterialBasePriceInfo();
        objValue.setMaterial(object.getMaterial());
        objValue.setId(object.getId());
        objValue.setCurrency(object.getCurrency());
        objValue.setUnit(object.getUnit());
        objValue.setCU(object.getCU());
        objValue.setAdminCU(object.getAdminCU());
        objValue.setAssistProperty(object.getAssistProperty());
        objValue.setPrice(object.getPrice());
        objValue.setFloorPrice(object.getFloorPrice());
        objValue.setMaxPrice(object.getMaxPrice());
        objValue.setPriceType(object.getPriceType());
        objValue.setChannelType(object.getChannelType());
        objValue.setPriority(object.getPriority());
        return objValue;
    }

    protected KDTable getDetailTable() {
        return this.kDTable;
    }
}

