/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.scm.common.client.BDInvClientUtils;
import com.kingdee.eas.basedata.scm.sd.sale.IMaterialBasePrice;
import com.kingdee.eas.basedata.scm.sd.sale.MaterialBasePriceFactory;
import com.kingdee.eas.basedata.scm.sd.sale.MaterialBasePriceInfo;
import com.kingdee.eas.basedata.scm.sd.sale.client.AbstractMaterialBasePriceListUI;
import com.kingdee.eas.basedata.scm.sd.sale.client.MaterialBasePriceEditUI;
import com.kingdee.eas.basedata.scm.sd.sale.client.MaterialBasePriceQueryUI;
import com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicyCache;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MaterialBasePriceListUI
extends AbstractMaterialBasePriceListUI {
    private static final Logger logger = CoreUIObject.getLogger(MaterialBasePriceListUI.class);
    private static final String RES_PROMPT = "com.kingdee.eas.basedata.scm.sd.sale.MaterialBasePriceResource";
    private int currentRow = -1;
    private static final String TB_CHECKEDSTATUS = "checkedStatus";
    private static final String TB_BLOCKEDSTATUS = "blockedStatus";
    private static final String TB_PriceTypeNumber = "priceType.number";
    CommonQueryDialog conditionDialog = null;
    MaterialBasePriceQueryUI conditionPanel = null;
    UserInfo user = SysContext.getSysContext().getCurrentUserInfo();

    public void onLoad() throws Exception {
        super.onLoad();
        this.initForm();
        this.tblMain.removeRows();
        if (this.mainQuery.size() > 0) {
            this.setButtonStatus(0);
        }
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(DateTimeUtil.getDateFormatString());
        this.tblMain.getColumn("lastUpdateUserDate").getStyleAttributes().setNumberFormat(DateTimeUtil.getDateFormatString());
        this.tblMain.getColumn("auditDate").getStyleAttributes().setNumberFormat(DateTimeUtil.getDateFormatString());
    }

    public void actionAssignDataBaseD_actionPerformed(ActionEvent arg0) throws Exception {
        this.checkSelected();
        int row = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        Boolean checkedFlag = (Boolean)this.tblMain.getRow(row).getCell(TB_CHECKEDSTATUS).getValue();
        Boolean blockedFlag = (Boolean)this.tblMain.getRow(row).getCell(TB_BLOCKEDSTATUS).getValue();
        if (checkedFlag != null && blockedFlag != null && checkedFlag.booleanValue() && !blockedFlag.booleanValue()) {
            super.actionAssignDataBaseD_actionPerformed(arg0);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"CANNOT_ASSIGN"));
            SysUtil.abort();
        }
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"material.number", "material.name"};
        return locateNames;
    }

    public CommonQueryDialog initCommonQueryDialog() {
        if (this.conditionDialog == null) {
            this.conditionDialog = super.initCommonQueryDialog();
            this.conditionDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            this.conditionDialog.setTitle(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"Query_Filter"), this.getUITitle()));
            this.conditionDialog.setShowFilter(true);
            this.conditionDialog.setShowSorter(true);
            this.conditionDialog.setProcessor((IProcessor)new SCMCommonProcessor());
            try {
                this.conditionDialog.addUserPanel(this.getConditionPanel());
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            this.conditionDialog.setQueryObjectPK(this.mainQueryPK);
            this.conditionDialog.setParentUIClassName(MaterialBasePriceListUI.class.getName());
        }
        return this.conditionDialog;
    }

    protected void applyPreference() {
        super.applyPreference();
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public KDPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new MaterialBasePriceQueryUI();
        }
        return this.conditionPanel;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new MaterialBasePriceQueryUI();
        }
        return this.conditionPanel;
    }

    private void initForm() {
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnBlock.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnUnBlock.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.kDMenuItem1.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.kDMenuItem2.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.kDMenuItem3.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.kDMenuItem4.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.tblMain.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                MaterialBasePriceListUI.this.currentRow = e.getRowIndex();
                MaterialBasePriceListUI.this.setButtonStatus(MaterialBasePriceListUI.this.currentRow);
            }
        });
    }

    private void setButtonStatus(int rowIndex) {
        boolean isEditable = false;
        boolean isRemovable = false;
        boolean isAuditable = false;
        boolean isAuditVisiable = false;
        boolean isUnAuditable = false;
        boolean isUnAuditVisiable = false;
        boolean isBlockable = false;
        boolean isBlockVisiable = false;
        boolean isUnBlockable = false;
        boolean isUnBlockVisiable = false;
        if (rowIndex >= 0 && rowIndex < this.tblMain.getRowCount()) {
            boolean checkStatus = false;
            boolean blockStatus = false;
            if (this.tblMain.getCell(rowIndex, TB_CHECKEDSTATUS).getValue().toString().equalsIgnoreCase("true")) {
                checkStatus = true;
            }
            if (this.tblMain.getCell(rowIndex, TB_BLOCKEDSTATUS).getValue().toString().equalsIgnoreCase("true")) {
                blockStatus = true;
            }
            if (!checkStatus) {
                isEditable = true;
                isRemovable = true;
                isAuditable = true;
                isAuditVisiable = true;
            }
            if (checkStatus && !blockStatus) {
                isUnAuditable = true;
                isUnAuditVisiable = true;
                isBlockable = true;
                isBlockVisiable = true;
            }
            if (checkStatus && blockStatus) {
                isUnBlockable = true;
                isUnBlockVisiable = true;
            }
            this.btnEdit.setEnabled(isEditable);
            this.btnRemove.setEnabled(isRemovable);
            this.btnAudit.setEnabled(isAuditable);
            this.kDMenuItem1.setEnabled(isAuditable);
            this.btnUnAudit.setEnabled(isUnAuditable);
            this.kDMenuItem2.setEnabled(isUnAuditable);
            this.btnBlock.setEnabled(isBlockable);
            this.kDMenuItem3.setEnabled(isBlockable);
            this.btnUnBlock.setEnabled(isUnBlockable);
            this.kDMenuItem4.setEnabled(isUnBlockable);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkEdit();
        this.checkPriceType();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        ArrayList ids = this.getSelectedIdValues();
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)ids);
            Iterator lt = map.values().iterator();
            while (lt.hasNext()) {
                if (((Boolean)lt.next()).booleanValue()) continue;
                throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
            }
            uiContext.put((Object)"List", (Object)ids);
            this.prepareUIContext(uiContext, e);
            IUIWindow uiWindow = null;
            uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
            if (this.isDoRefresh(uiWindow)) {
                this.refresh(e);
            }
            this.tblMain.refresh();
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)ids);
        }
    }

    private void checkPriceType() {
        int size = this.tblMain.getSelectManager().size();
        String typeNumber1 = this.tblMain.getRow(this.tblMain.getSelectManager().get(0).getTop()).getCell(TB_PriceTypeNumber).getValue().toString();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                String typeNumber = row.getCell(TB_PriceTypeNumber).getValue().toString();
                if (typeNumber.trim().equalsIgnoreCase(typeNumber1)) continue;
                MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"check_priceType"));
                SysUtil.abort();
            }
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPriceType();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"List", (Object)this.getSelectedIdValues());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            this.isModify = true;
            this.refresh(e);
        }
        this.refreshList();
    }

    private void checkEdit() {
        int size = this.tblMain.getSelectManager().size();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                IRow row = this.tblMain.getRow(i);
                if (!row.getCell(TB_CHECKEDSTATUS).getValue().toString().equalsIgnoreCase("true") && !row.getCell(TB_BLOCKEDSTATUS).getValue().toString().equalsIgnoreCase("true")) continue;
                MsgBox.showError((String)EASResource.getString((String)RES_PROMPT, (String)"check_Edit"));
                SysUtil.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (MsgBox.showConfirm2((String)EASResource.getString((String)RES_PROMPT, (String)"prompt_request_audit")) != 0) {
            return;
        }
        super.actionAudit_actionPerformed(e);
        ArrayList list = super.getSelectedIdValues();
        int count = list.size();
        IObjectPK[] pks = new IObjectPK[count];
        if (count != 0) {
            for (int i = 0; i < count; ++i) {
                pks[i] = new ObjectStringPK(list.get(i).toString());
            }
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)list);
            Iterator lt = map.values().iterator();
            while (lt.hasNext()) {
                if (((Boolean)lt.next()).booleanValue()) continue;
                throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
            }
            MaterialBasePriceFactory.getRemoteInstance().audit(pks);
            PricePolicyCache.clearCache();
            MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"prompt_audit_success"));
            this.refreshList();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] ids = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)"id");
        if (MsgBox.showConfirm2((String)EASResource.getString((String)RES_PROMPT, (String)"prompt_request_unaudit")) != 0) {
            return;
        }
        int count = ids.length;
        IObjectPK[] pks = new IObjectPK[count];
        if (count != 0) {
            for (int i = 0; i < count; ++i) {
                pks[i] = new ObjectStringPK(ids[i]);
            }
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        List<String> list = Arrays.asList(ids);
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate(list);
            Iterator lt = map.values().iterator();
            while (lt.hasNext()) {
                if (((Boolean)lt.next()).booleanValue()) continue;
                throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
            }
            MaterialBasePriceFactory.getRemoteInstance().unAudit(pks);
            PricePolicyCache.clearCache();
            MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"prompt_unaudit_success"));
            this.refreshList();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionBlock_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicy", (String)"blockAlert")) != 0) {
            return;
        }
        super.actionBlock_actionPerformed(e);
        ArrayList list = super.getSelectedIdValues();
        int count = list.size();
        IObjectPK[] pks = new IObjectPK[count];
        if (count != 0) {
            for (int i = 0; i < count; ++i) {
                pks[i] = new ObjectStringPK(list.get(i).toString());
            }
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)list);
            Iterator lt = map.values().iterator();
            while (lt.hasNext()) {
                if (((Boolean)lt.next()).booleanValue()) continue;
                throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
            }
            ((IMaterialBasePrice)this.getBizInterface()).block(pks);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicy", (String)"blockSuccess"));
            this.refreshList();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionUnBlock_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicy", (String)"unblockAlert")) != 0) {
            return;
        }
        super.actionUnBlock_actionPerformed(e);
        ArrayList list = super.getSelectedIdValues();
        int count = list.size();
        IObjectPK[] pks = new IObjectPK[count];
        if (count != 0) {
            for (int i = 0; i < count; ++i) {
                pks[i] = new ObjectStringPK(list.get(i).toString());
            }
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)list);
            Iterator lt = map.values().iterator();
            while (lt.hasNext()) {
                if (((Boolean)lt.next()).booleanValue()) continue;
                throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
            }
            ((IMaterialBasePrice)this.getBizInterface()).unBlock(pks);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicy", (String)"unblockSuccess"));
            this.refreshList();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (MsgBox.showConfirm2((String)EASResource.getString((String)RES_PROMPT, (String)"prompt_request_remove")) != 0) {
            return;
        }
        ArrayList list = super.getSelectedIdValues();
        int count = list.size();
        IObjectPK[] pks = new IObjectPK[count];
        if (count != 0) {
            for (int i = 0; i < count; ++i) {
                pks[i] = new ObjectStringPK(list.get(i).toString());
            }
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        try {
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)list);
            Iterator lt = map.values().iterator();
            while (lt.hasNext()) {
                if (((Boolean)lt.next()).booleanValue()) continue;
                throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request")));
            }
            ((IMaterialBasePrice)this.getBizInterface()).delete(pks);
            MsgBox.showInfo((String)EASResource.getString((String)RES_PROMPT, (String)"prompt_remove_success"));
            this.refreshList();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)list);
        }
    }

    protected String getEditUIName() {
        return MaterialBasePriceEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MaterialBasePriceFactory.getRemoteInstance();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.refreshList();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.tblMain.refresh();
        }
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.scm.scmbd.MaterialBasePrice";
        param.alias = EASResource.getString((String)RES_PROMPT, (String)"BasePrice");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    protected ArrayList getExportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.scm.scmbd.MaterialBasePrice";
        param.alias = EASResource.getString((String)RES_PROMPT, (String)"BasePrice");
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        int pricePre = 2;
        String[] PRICE_COLUMNS = new String[]{"price", "floorPrice", "maxPrice"};
        try {
            while (rowSet.next()) {
                pricePre = rowSet.getInt("material.pricePrecision");
                SCMClientUtils.iniColumnsPrecision((int)pricePre, (String[])PRICE_COLUMNS, (IRowSet)rowSet);
            }
        }
        catch (SQLException ex) {
            this.handUIException(ex);
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.print(false);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.print(true);
    }

    private void print(boolean isPreview) {
        this.preparePrintPage(this.tblMain);
        KDPrinter printer = this.tblMain.getPrintManager().getNewPrintManager().getPrinter();
        PrintListener printListener = new PrintListener();
        printer.addPrintActionListener((IPrintActionListener)printListener);
        if (isPreview) {
            this.tblMain.getPrintManager().printPreview();
        } else {
            this.tblMain.getPrintManager().print();
        }
        printer.removePrintActionListener((IPrintActionListener)printListener);
    }

    protected MetaDataPK getQueryPKFromEntity() throws Exception {
        String queryName = "com.kingdee.eas.basedata.scm.sd.sale.app.F7MaterialBasePriceQueryForDefaultAssign";
        MetaDataPK queryPK = new MetaDataPK(queryName);
        return queryPK;
    }

    @Override
    public void actionUpdatePricePolicy_actionPerformed(ActionEvent e) throws Exception {
        String sunUIPath = "com.kingdee.eas.basedata.scm.sd.sale.client.MaterialUpdatePriceFilterUI";
        UIContext paramMap = new UIContext((Object)this);
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create(sunUIPath, (Map)paramMap, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectorCol = super.getSelectors();
        selectorCol.add(new SelectorItemInfo("material.pricePrecision"));
        return selectorCol;
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    class PrintListener
    implements IPrintActionListener {
        PrintListener() {
        }

        public void beforePrintOrPreview() {
        }

        public void beforePreview() {
        }

        public void beforePrint() {
            BDInvClientUtils.logUIOperation("LOG_PRINT", new MaterialBasePriceInfo().getBOSType());
        }

        public void closePreview() {
        }
    }
}

