/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.IPricePolicyFacade;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyFacadeFactory;
import com.kingdee.eas.basedata.scm.sd.sale.client.AbstractMaterialUpdatePriceFilterUI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MaterialUpdatePriceFilterUI
extends AbstractMaterialUpdatePriceFilterUI {
    private static final long serialVersionUID = 4820945962008614261L;
    public static final BigDecimal ZERO = new BigDecimal("0.000000");
    public static final BigDecimal HUNDRED = new BigDecimal("100.00");
    private static final Logger logger = CoreUIObject.getLogger(MaterialUpdatePriceFilterUI.class);
    private ItemListener rbEqualListener;
    private ItemListener rbUnEqualListener;
    BigDecimal fixRate = new BigDecimal("100.00");
    BigDecimal fixPrice = new BigDecimal("0.000000");

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(MaterialUpdatePriceFilterUI.getF7FilterInfoByAuthorizeSaleOrg("saleOrgUnit.id", "pricepolicy_update"));
        this.prmtSaleOrgUnit.setEntityViewInfo(viewInfo);
        this.prmtSaleOrgUnit.setEnabledMultiSelection(true);
        this.prmtSaleOrgUnit.setDisplayFormat("$name$");
        this.prmtSaleOrgUnit.setEditFormat("$number$");
        this.prmtSaleOrgUnit.setCommitFormat("$number$");
        this.prmtMaterialGroup.setEnabledMultiSelection(true);
        this.prmtMaterialGroup.setDisplayFormat("$name$");
        this.prmtMaterialGroup.setEditFormat("$number$");
        this.prmtMaterialGroup.setCommitFormat("$number$");
        this.txtFixBasePrice.setValue((Object)ZERO);
        this.txtFixRate.setValue((Object)HUNDRED);
        this.txtFixPrice.setValue((Object)ZERO);
        this.txtFixBasePrice.setPrecision(6);
        this.txtFixRate.setPrecision(2);
        this.txtFixPrice.setPrecision(6);
        this.txtFixBasePrice.setText("0.000000");
        this.txtFixRate.setText("100.00");
        this.txtFixPrice.setText("0.000000");
        if (this.rbEqualListener == null) {
            this.rbEqualListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        MaterialUpdatePriceFilterUI.this.rbEqual_itemStateChanged(e);
                    }
                    catch (Exception exc) {
                        MaterialUpdatePriceFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.isContain.addItemListener(this.rbEqualListener);
        if (this.rbUnEqualListener == null) {
            this.rbUnEqualListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        MaterialUpdatePriceFilterUI.this.rbUnEqual_itemStateChanged(e);
                    }
                    catch (Exception exc) {
                        MaterialUpdatePriceFilterUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.unContain.addItemListener(this.rbUnEqualListener);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void rbEqual_itemStateChanged(ItemEvent e) throws Exception {
        boolean isEqual = this.isContain.isSelected();
        if (isEqual) {
            this.unContain.setSelected(false);
        }
    }

    protected void rbUnEqual_itemStateChanged(ItemEvent e) throws Exception {
        boolean isEqual = this.unContain.isSelected();
        if (isEqual) {
            this.isContain.setSelected(false);
        }
    }

    @Override
    public void updatePrice_actionPerformed(ActionEvent e) throws Exception {
        int i;
        SaleOrgUnitCollection saleOrgUnitCollection = new SaleOrgUnitCollection();
        if (this.prmtSaleOrgUnit.getValue() != null && this.prmtSaleOrgUnit.getValue() instanceof SaleOrgUnitInfo) {
            saleOrgUnitCollection = new SaleOrgUnitCollection();
            saleOrgUnitCollection.add((SaleOrgUnitInfo)this.prmtSaleOrgUnit.getValue());
        } else if (this.prmtSaleOrgUnit.getValue() instanceof Object[]) {
            Object[] saleOrgs = (Object[])this.prmtSaleOrgUnit.getValue();
            int size = saleOrgs.length;
            for (i = 0; i < size; ++i) {
                if (saleOrgs[i] == null) continue;
                saleOrgUnitCollection.add((SaleOrgUnitInfo)saleOrgs[i]);
            }
        }
        MaterialGroupCollection materialGroups = new MaterialGroupCollection();
        if (this.prmtMaterialGroup.getValue() != null && this.prmtMaterialGroup.getValue() instanceof MaterialGroupInfo) {
            materialGroups.add((MaterialGroupInfo)this.prmtMaterialGroup.getValue());
        } else if (this.prmtMaterialGroup.getValue() instanceof Object[]) {
            Object[] materialGroupArray = (Object[])this.prmtMaterialGroup.getValue();
            for (i = 0; i < materialGroupArray.length; ++i) {
                if (materialGroupArray[i] == null) continue;
                materialGroups.add((MaterialGroupInfo)materialGroupArray[i]);
            }
        }
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (materialGroups != null && materialGroups.size() > 0) {
            if (this.isContain.isSelected()) {
                conditions.put("ISIN", " in ");
            } else if (this.unContain.isSelected()) {
                conditions.put("ISIN", " not in ");
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.sale.BDScmSaleResource", (String)"UNSELECT_ISCONTAIN_RADIO"));
                return;
            }
        }
        BigDecimal fixBasePrice = ZERO;
        BigDecimal fixRate = HUNDRED;
        BigDecimal fixPrice = ZERO;
        try {
            if (this.txtFixBasePrice.getText() != null || this.txtFixBasePrice.getText().trim().length() > 0) {
                fixBasePrice = (BigDecimal)this.txtFixBasePrice.getValue();
            }
            if (this.txtFixRate.getText() != null || this.txtFixRate.getText().trim().length() > 0) {
                fixRate = (BigDecimal)this.txtFixRate.getValue();
            }
            if (this.txtFixPrice.getText() != null || this.txtFixPrice.getText().trim().length() > 0) {
                fixPrice = (BigDecimal)this.txtFixPrice.getValue();
            }
        }
        catch (Exception e2) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.sale.BDScmSaleResource", (String)"ERROR_UPDATEPRICE_DATA"));
            return;
        }
        if (fixRate.compareTo(ZERO) == -1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.sale.BDScmSaleResource", (String)"ERROR_UPDATEPRICE_RATE"));
            return;
        }
        conditions.put("FIX_BASEPRICE", fixBasePrice);
        conditions.put("FIX_RATE", fixRate);
        conditions.put("FIX_PRICE", fixPrice);
        String updateSuccess = null;
        try {
            IPricePolicyFacade pricePolicyFacade = PricePolicyFacadeFactory.getRemoteInstance();
            updateSuccess = pricePolicyFacade.batchUpdatePrice(saleOrgUnitCollection, materialGroups, conditions);
        }
        catch (Exception e1) {
            logger.info((Object)e1.getMessage());
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.sale.BDScmSaleResource", (String)"ERROR_UPDATAPRICE"));
            return;
        }
        if (updateSuccess == null || updateSuccess.length() < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.sale.BDScmSaleResource", (String)"SUCCESS_UPDATEPRICE"));
        } else {
            MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.sale.BDScmSaleResource", (String)"ERROR_UPDATAPRICE1"), updateSuccess));
        }
        this.destroyWindow();
    }

    public static FilterInfo getF7FilterInfoByAuthorizeSaleOrg(String orgFieldName, String permissionItem) {
        HashSet<String> orgSet = new HashSet<String>();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        try {
            FullOrgUnitCollection fullOrgUnitCollection = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)userPK, OrgType.Sale, null, "pricepolicy_update");
            if (fullOrgUnitCollection != null) {
                int size = fullOrgUnitCollection.size();
                for (int i = 0; i < size; ++i) {
                    orgSet.add(fullOrgUnitCollection.get(i).getId().toString());
                }
            }
        }
        catch (Exception size) {
            // empty catch block
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(orgFieldName, orgSet, CompareType.INCLUDE));
        return filterInfo;
    }
}

