/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.param.IOtherParam;
import com.kingdee.eas.base.param.client.ICustomParamUI;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgF7;
import com.kingdee.eas.basedata.org.client.uihelper.imp.OrgTypeFIHelper;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceParam;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamException;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamPriorityEnum;
import com.kingdee.eas.basedata.scm.sd.sale.client.AbstractPriceParameterSetUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PriceParameterSetUI
extends AbstractPriceParameterSetUI
implements IOtherParam,
ICustomParamUI,
ChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(PriceParameterSetUI.class);
    private SaleOrgUnitInfo saleOrgInfo = null;
    private OrgType cuOrgType = null;
    private PriceParamInfo info = null;

    public PriceParameterSetUI() throws Exception {
        this.psdCtrlChanged();
        this.btnPricePassCtl.addChangeListener((ChangeListener)this);
        this.btnPsdCtl.addChangeListener((ChangeListener)this);
        this.chkCusGrpMat.addChangeListener((ChangeListener)this);
        this.chkCusGrpMatGrp.addChangeListener((ChangeListener)this);
        this.chkCusMat.addChangeListener((ChangeListener)this);
        this.chkCusMatGroup.addChangeListener((ChangeListener)this);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    private void psdCtrlChanged() {
        if (this.btnPricePassCtl.isSelected()) {
            this.pwdPricePass.setEnabled(true);
            this.pwdPricePassVerify.setEnabled(true);
        } else {
            this.pwdPricePass.setEnabled(false);
            this.pwdPricePass.setText("");
            this.pwdPricePassVerify.setEnabled(false);
            this.pwdPricePassVerify.setText("");
        }
        if (this.btnPsdCtl.isSelected()) {
            this.pwdEditPass.setEnabled(true);
            this.pwdEditPassVerify.setEnabled(true);
        } else {
            this.pwdEditPass.setEnabled(false);
            this.pwdEditPass.setText("");
            this.pwdEditPassVerify.setEnabled(false);
            this.pwdEditPassVerify.setText("");
        }
        if (this.chkCusMat.isSelected()) {
            this.comboPriCusMat.setEnabled(true);
        } else {
            this.comboPriCusMat.setEnabled(false);
            this.comboPriCusMat.setSelectedItem(null);
        }
        if (this.chkCusGrpMat.isSelected()) {
            this.comboPriCusGrpMat.setEnabled(true);
        } else {
            this.comboPriCusGrpMat.setEnabled(false);
            this.comboPriCusGrpMat.setSelectedItem(null);
        }
        if (this.chkCusMatGroup.isSelected()) {
            this.comboPriCusMatGrp.setEnabled(true);
        } else {
            this.comboPriCusMatGrp.setEnabled(false);
            this.comboPriCusMatGrp.setSelectedItem(null);
        }
        if (this.chkCusGrpMatGrp.isSelected()) {
            this.comboPriCusGrpMatGrp.setEnabled(true);
        } else {
            this.comboPriCusGrpMatGrp.setEnabled(false);
            this.comboPriCusGrpMatGrp.setSelectedItem(null);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.loadParaValue();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.kDTabbedPane1.setTabPlacement(1);
    }

    private void loadParaValue() {
        try {
            IPriceParam ipriceParam = PriceParamFactory.getRemoteInstance();
            String cuid = this.saleOrgInfo.getId().toString();
            this.info = ipriceParam.getParameterInfo(cuid);
            this.chkOtherStartPriceDisM.setSelected(this.info.getBoolValue("PricePa001"));
            this.chkOtherHasRax.setSelected(this.info.getBoolValue("PricePa002"));
            this.chkAutoAudit.setSelected(this.info.getBoolValue("PricePa003"));
            this.chkOtherCurrencyConvert.setSelected(this.info.getBoolValue("PricePa004"));
            this.chkOtherLastest.setSelected(this.info.getBoolValue("PricePa005"));
            this.chkGetPriceByDate.setSelected(this.info.getBoolValue("PricePa022"));
            this.kDButtonGroup2.setValue(this.info.getIntValue("PricePa006"));
            this.pwdPricePass.setText(this.info.getStrValue("PricePa007"));
            this.pwdPricePassVerify.setText(this.info.getStrValue("PricePa008"));
            this.chkCusMat.setSelected(this.info.getBoolValue("PricePa010"));
            this.chkCusMatGroup.setSelected(this.info.getBoolValue("PricePa011"));
            this.chkCusGrpMat.setSelected(this.info.getBoolValue("PricePa012"));
            this.chkCusGrpMatGrp.setSelected(this.info.getBoolValue("PricePa013"));
            this.comboPriCusMat.setSelectedItem((Object)PriceParamPriorityEnum.getEnum(this.info.getIntValue("PricePa014")));
            this.comboPriCusMatGrp.setSelectedItem((Object)PriceParamPriorityEnum.getEnum(this.info.getIntValue("PricePa015")));
            this.comboPriCusGrpMat.setSelectedItem((Object)PriceParamPriorityEnum.getEnum(this.info.getIntValue("PricePa016")));
            this.comboPriCusGrpMatGrp.setSelectedItem((Object)PriceParamPriorityEnum.getEnum(this.info.getIntValue("PricePa017")));
            this.kDButtonGroup1.setValue(this.info.getIntValue("PricePa018"));
            this.pwdEditPass.setText(this.info.getStrValue("PricePa019"));
            this.pwdEditPassVerify.setText(this.info.getStrValue("PricePa020"));
            this.chkPriceCanNotEdit.setSelected(this.info.getBoolValue("PricePa021"));
            this.chkCenterSaleInnerPrice.setSelected(this.info.getBoolValue("PricePa023"));
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u4ef7\u683c\u53c2\u6570\u51fa\u73b0\u9519\u8bef:" + e));
            this.handUIException(e);
        }
    }

    private PriceParamInfo getParaValue() {
        PriceParamInfo value = this.info;
        if (value == null) {
            value = new PriceParamInfo();
        }
        value.setOrgUnitInfo((OrgUnitInfo)this.saleOrgInfo);
        boolean btmp = this.chkOtherStartPriceDisM.isSelected();
        value.setParameter("PricePa001", btmp);
        btmp = this.chkOtherHasRax.isSelected();
        value.setParameter("PricePa002", btmp);
        btmp = this.chkAutoAudit.isSelected();
        value.setParameter("PricePa003", btmp);
        btmp = this.chkOtherCurrencyConvert.isSelected();
        value.setParameter("PricePa004", btmp);
        btmp = this.chkOtherLastest.isSelected();
        value.setParameter("PricePa005", btmp);
        btmp = this.chkGetPriceByDate.isSelected();
        value.setParameter("PricePa022", btmp);
        int itmp = this.kDButtonGroup2.getValue();
        value.setParameter("PricePa006", itmp);
        String stmp = null;
        stmp = this.pwdPricePass.getText();
        value.setParameter("PricePa007", stmp);
        stmp = this.pwdPricePassVerify.getText();
        value.setParameter("PricePa008", stmp);
        btmp = this.chkCusMat.isSelected();
        value.setParameter("PricePa010", btmp);
        btmp = this.chkCusMatGroup.isSelected();
        value.setParameter("PricePa011", btmp);
        btmp = this.chkCusGrpMat.isSelected();
        value.setParameter("PricePa012", btmp);
        btmp = this.chkCusGrpMatGrp.isSelected();
        value.setParameter("PricePa013", btmp);
        if (this.chkCusMat.isSelected()) {
            itmp = ((PriceParamPriorityEnum)((Object)this.comboPriCusMat.getSelectedItem())).getValue();
            value.setParameter("PricePa014", itmp);
        } else {
            value.setParameter("PricePa014", -1);
        }
        if (this.chkCusMatGroup.isSelected()) {
            itmp = ((PriceParamPriorityEnum)((Object)this.comboPriCusMatGrp.getSelectedItem())).getValue();
            value.setParameter("PricePa015", itmp);
        } else {
            value.setParameter("PricePa015", -1);
        }
        if (this.chkCusGrpMat.isSelected()) {
            itmp = ((PriceParamPriorityEnum)((Object)this.comboPriCusGrpMat.getSelectedItem())).getValue();
            value.setParameter("PricePa016", itmp);
        } else {
            value.setParameter("PricePa016", -1);
        }
        if (this.chkCusGrpMatGrp.isSelected()) {
            itmp = ((PriceParamPriorityEnum)((Object)this.comboPriCusGrpMatGrp.getSelectedItem())).getValue();
            value.setParameter("PricePa017", itmp);
        } else {
            value.setParameter("PricePa017", -1);
        }
        itmp = this.kDButtonGroup1.getValue();
        value.setParameter("PricePa018", itmp);
        stmp = this.pwdEditPass.getText();
        value.setParameter("PricePa019", stmp);
        stmp = this.pwdEditPassVerify.getText();
        value.setParameter("PricePa020", stmp);
        btmp = this.chkPriceCanNotEdit.isSelected();
        value.setParameter("PricePa021", btmp);
        btmp = this.chkCenterSaleInnerPrice.isSelected();
        value.setParameter("PricePa023", btmp);
        return value;
    }

    public void otherParamSave() throws BOSException, EASBizException {
        this.verifyInput();
        PriceParamInfo paramInfo = this.getParaValue();
        IPriceParam ipriceParam = PriceParamFactory.getRemoteInstance();
        try {
            ipriceParam.saveParameter(paramInfo);
            this.loadParaValue();
        }
        catch (PriceParamException e) {
            logger.error((Object)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtSaleOrgUnit.getData() == null) {
            this.prmtSaleOrgUnit.setFocusable(true);
            throw new PriceParamException(PriceParamException.SALEORGUNITNOTNULL);
        }
        if (this.prmtSaleOrgUnit.getData() != null) {
            this.otherParamSave();
        }
    }

    public void sendOrgInfo(OrgType orgType, OrgUnitInfo orgUnit, OrgTreeInfo orgTree) {
        this.cuOrgType = orgType;
        if (orgType.getValue() != 2) {
            return;
        }
        if (orgUnit == null || orgUnit.getId() == null) {
            return;
        }
        this.saleOrgInfo = new SaleOrgUnitInfo();
        this.saleOrgInfo.setId(orgUnit.getId());
        try {
            this.loadFields();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void verifyInput() throws EASBizException {
        if (this.prmtSaleOrgUnit.getData() == null) {
            this.prmtSaleOrgUnit.setFocusable(true);
            throw new PriceParamException(PriceParamException.SALEORGUNITNOTNULL);
        }
        if (!(this.btnPriceCacelTrade.isSelected() || this.btnPriceFwHint.isSelected() || this.btnPriceNoCtl.isSelected() || this.btnPricePassCtl.isSelected())) {
            this.kDTabbedPane1.setSelectedComponent((Component)this.panelLimitPriceControl);
            throw new PriceParamException(PriceParamException.NO_LIMITPRICE);
        }
        if (!(!this.chkOtherStartPriceDisM.isSelected() || this.chkCusMat.isSelected() || this.chkCusMatGroup.isSelected() || this.chkCusGrpMat.isSelected() || this.chkCusGrpMatGrp.isSelected())) {
            this.kDTabbedPane1.setSelectedComponent((Component)this.panelgetPriceRule);
            throw new PriceParamException(PriceParamException.NO_PRICERULE);
        }
        if (this.btnPricePassCtl.isSelected() && (this.pwdPricePass.getText() == null || this.pwdPricePass.getText().equals(""))) {
            this.kDTabbedPane1.setSelectedComponent((Component)this.panelLimitPriceControl);
            this.pwdPricePass.requestFocus();
            throw new PriceParamException(PriceParamException.NO_LIMITPRICE_PSD);
        }
        if (this.btnPricePassCtl.isSelected() && (this.pwdPricePassVerify.getText() == null || this.pwdPricePassVerify.getText().equals(""))) {
            this.kDTabbedPane1.setSelectedComponent((Component)this.panelLimitPriceControl);
            this.pwdPricePassVerify.requestFocus();
            throw new PriceParamException(PriceParamException.NO_LIMITPRICE_PSDVERIFY);
        }
        if (this.chkCusMat.isSelected() && (this.comboPriCusMat.getSelectedItem() == null || this.comboPriCusMat.getSelectedItem().equals(""))) {
            this.kDTabbedPane1.setSelectedComponent((Component)this.panelgetPriceRule);
            this.comboPriCusMat.requestFocus();
            throw new PriceParamException(PriceParamException.NO_PRICERULE_CMP);
        }
        if (this.chkCusMatGroup.isSelected() && (this.comboPriCusMatGrp.getSelectedItem() == null || this.comboPriCusMatGrp.getSelectedItem().equals(""))) {
            this.kDTabbedPane1.setSelectedComponent((Component)this.panelgetPriceRule);
            this.comboPriCusMatGrp.requestFocus();
            throw new PriceParamException(PriceParamException.NO_PRICERULE_CMGP);
        }
        if (this.chkCusGrpMat.isSelected() && (this.comboPriCusGrpMat.getSelectedItem() == null || this.comboPriCusGrpMat.getSelectedItem().equals(""))) {
            this.kDTabbedPane1.setSelectedComponent((Component)this.panelgetPriceRule);
            this.comboPriCusGrpMat.requestFocus();
            throw new PriceParamException(PriceParamException.NO_PRICERULE_CGMP);
        }
        if (this.chkCusGrpMatGrp.isSelected() && (this.comboPriCusGrpMatGrp.getSelectedItem() == null || this.comboPriCusGrpMatGrp.getSelectedItem().equals(""))) {
            this.kDTabbedPane1.setSelectedComponent((Component)this.panelgetPriceRule);
            this.comboPriCusGrpMatGrp.requestFocus();
            throw new PriceParamException(PriceParamException.NO_PRICERULE_CGMGP);
        }
        ArrayList<Integer> priValues = new ArrayList<Integer>();
        if (this.comboPriCusMat.getSelectedItem() != null) {
            priValues.add(new Integer(((PriceParamPriorityEnum)((Object)this.comboPriCusMat.getSelectedItem())).getValue()));
        }
        if (this.comboPriCusMatGrp.getSelectedItem() != null) {
            priValues.add(new Integer(((PriceParamPriorityEnum)((Object)this.comboPriCusMatGrp.getSelectedItem())).getValue()));
        }
        if (this.comboPriCusGrpMat.getSelectedItem() != null) {
            priValues.add(new Integer(((PriceParamPriorityEnum)((Object)this.comboPriCusGrpMat.getSelectedItem())).getValue()));
        }
        if (this.comboPriCusGrpMatGrp.getSelectedItem() != null) {
            priValues.add(new Integer(((PriceParamPriorityEnum)((Object)this.comboPriCusGrpMatGrp.getSelectedItem())).getValue()));
        }
        int size = priValues.size();
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                if (!priValues.get(i).equals(priValues.get(j)) || (Integer)priValues.get(i) == -1) continue;
                this.kDTabbedPane1.setSelectedComponent((Component)this.panelgetPriceRule);
                throw new PriceParamException(PriceParamException.PRICECOMPRIISSAME);
            }
        }
        if (!(this.btnForbidEdit.isSelected() || this.btnHint.isSelected() || this.btnNoCtl.isSelected() || this.btnPsdCtl.isSelected())) {
            this.kDTabbedPane1.setSelectedComponent((Component)this.panelEditControl);
            throw new PriceParamException(PriceParamException.NO_EDITCTL);
        }
        if (this.btnPsdCtl.isSelected() && (this.pwdEditPass.getText() == null || this.pwdEditPass.getText().equals(""))) {
            this.kDTabbedPane1.setSelectedComponent((Component)this.panelEditControl);
            this.pwdEditPass.requestFocus();
            throw new PriceParamException(PriceParamException.NO_EDITCTL_PSD);
        }
        if (this.btnPsdCtl.isSelected() && (this.pwdEditPassVerify.getText() == null || this.pwdEditPassVerify.getText().equals(""))) {
            this.kDTabbedPane1.setSelectedComponent((Component)this.panelEditControl);
            this.pwdEditPassVerify.requestFocus();
            throw new PriceParamException(PriceParamException.NO_EDITCTL_PSDVERRIFY);
        }
        if (!this.pwdEditPass.getText().equals(this.pwdEditPassVerify.getText())) {
            this.kDTabbedPane1.setSelectedComponent((Component)this.panelEditControl);
            this.pwdEditPass.requestFocus();
            throw new PriceParamException(PriceParamException.NO_EDITCTL_PSDDIFF);
        }
        if (!this.pwdPricePass.getText().equals(this.pwdPricePassVerify.getText())) {
            this.kDTabbedPane1.setSelectedComponent((Component)this.panelEditControl);
            this.pwdPricePass.requestFocus();
            throw new PriceParamException(PriceParamException.NO_LIMITPRICE_PSDDIFF);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.psdCtrlChanged();
    }

    @Override
    protected void prmtSaleOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtSaleOrgUnit.getData() != null) {
            this.sendOrgInfo(OrgType.Sale, (OrgUnitInfo)this.prmtSaleOrgUnit.getData(), null);
        }
    }

    private void setBizCombox(OrgType orgtype1) {
        if (orgtype1 != null && -1 == orgtype1.getValue()) {
            this.prmtSaleOrgUnit.setEnabled(false);
            return;
        }
        this.prmtSaleOrgUnit.setEnabled(true);
        NewOrgF7PromptDialog orgf7 = this.getUnitInfo(orgtype1);
        orgf7.setShowAssistantOrg(true);
        this.prmtSaleOrgUnit.setSelector((KDPromptSelector)orgf7);
        this.prmtSaleOrgUnit.setEditable(false);
        this.prmtSaleOrgUnit.setDisplayFormat("$name$");
        OrgUnitInfo orgInfo = SysContext.getSysContext().getCurrentOrgUnit(orgtype1);
        try {
            IFullOrgUnit iorgUnit = FullOrgUnitFactory.getRemoteInstance();
            if (orgInfo != null) {
                orgInfo = iorgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgInfo.getId()));
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        if (OrgCommonUtils.isOrgType((OrgUnitInfo)orgInfo, (OrgType)orgtype1)) {
            this.prmtSaleOrgUnit.setValue((Object)SysContext.getSysContext().getCurrentOrgUnit(orgtype1));
        } else {
            this.prmtSaleOrgUnit.setValue(null);
        }
        if (this.prmtSaleOrgUnit.getData() == null || orgtype1 != OrgType.NONE) {
            // empty if block
        }
    }

    private NewOrgF7PromptDialog getUnitInfo(OrgType orgtype1) {
        OrgType[] type = new OrgType[]{orgtype1};
        OrgUnitInfo orgInfo = SysContext.getSysContext().getCurrentOrgUnit(orgtype1);
        boolean setCompanyView = false;
        if (setCompanyView && orgtype1 != null && 1 == orgtype1.getValue()) {
            NewCompanyF7 companyF7 = (NewCompanyF7)new OrgTypeFIHelper().createNewF7ByCondition("TREETYPE_BIZUNIT");
            if (orgInfo != null) {
                companyF7.setRootUnitID(orgInfo.getId().toString());
            }
            companyF7.setIsCUFilter(true);
            return companyF7;
        }
        NewOrgF7 orgf7 = new NewOrgF7((IUIObject)this);
        orgf7.setOrgTypes(type);
        orgf7.setIsCUFilter(true);
        if (orgInfo != null) {
            orgf7.setRootUnitID(orgInfo.getId().toString());
        }
        return orgf7;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setBizCombox(OrgType.Sale);
    }
}

