/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceProvider;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PriceProviderFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePriceTO;
import com.kingdee.eas.basedata.scm.sd.sale.client.PriceSolve;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.loadmass.SaleOrderDataVO;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class PricePolicyCache {
    private static PricePolicyCache cache = null;
    Map cacheMap = null;
    Map keyMap = new HashMap();
    Map pricePolicyMap = null;
    Map basePriceMap = null;

    private PricePolicyCache() {
        this.cacheMap = new HashMap();
        this.pricePolicyMap = new HashMap();
        this.basePriceMap = new HashMap();
    }

    public static PricePolicyCache getInstance() {
        if (cache == null) {
            cache = new PricePolicyCache();
        }
        return cache;
    }

    public SalePriceTO getSalePrice(PriceCondition condition) {
        if (condition.getCurrencyInfo() == null || condition.getMaterialInfo() == null || condition.getSaleOrg() == null) {
            return null;
        }
        StringBuffer keyBuf = new StringBuffer();
        keyBuf.append(condition.getSaleOrg().getId().toString());
        keyBuf.append(condition.getCustomerInfo() != null ? condition.getCustomerInfo().getId().toString() : null);
        keyBuf.append(condition.getMaterialInfo().getId().toString());
        keyBuf.append(condition.getCurrencyInfo() != null ? condition.getCurrencyInfo().getId().toString() : null);
        keyBuf.append(condition.getAssisProperty() != null ? condition.getAssisProperty().getId().toString() : null);
        keyBuf.append(condition.getMeasureUnit());
        String key = keyBuf.toString();
        int counts = 0;
        String symbol = null;
        if (this.keyMap.containsKey(key)) {
            String value = (String)this.keyMap.get(key);
            symbol = value.substring(0, 1);
            counts = Integer.valueOf(value.substring(1));
            SalePriceTO price = this.findPrice(condition, key, counts);
            if (price == null && symbol.equals("1")) {
                condition.setPriceType("basePrice");
            } else {
                return price;
            }
        }
        return this.fetchPrice(key, condition, counts);
    }

    public SalePriceTO getSalePriceForBatch(PriceCondition condition) {
        if (condition.getCurrencyInfo() == null || condition.getMaterialInfo() == null || condition.getSaleOrg() == null) {
            return null;
        }
        StringBuffer keyBuf = new StringBuffer();
        keyBuf.append(condition.getSaleOrg().getId().toString());
        keyBuf.append(condition.getCustomerInfo() != null ? condition.getCustomerInfo().getId().toString() : null);
        keyBuf.append(condition.getMaterialInfo().getId().toString());
        keyBuf.append(condition.getCurrencyInfo() != null ? condition.getCurrencyInfo().getId().toString() : null);
        keyBuf.append(condition.getAssisProperty() != null ? condition.getAssisProperty().getId().toString() : null);
        keyBuf.append(condition.getMeasureUnit());
        String key = keyBuf.toString();
        SalePriceTO priceTo = this.fetchPriceForBatch(key, condition);
        return priceTo;
    }

    private SalePriceTO fetchPriceForBatch(String key, PriceCondition condition) {
        PriceSolve priceSolve = new PriceSolve();
        List priceToList = (List)priceSolve.fetchPriceInfos(condition);
        if (priceToList == null) {
            return null;
        }
        this.pricePolicyMap.put(key, priceToList.toArray());
        SalePriceTO priceTo = this.findPrice((Object[])this.pricePolicyMap.get(key), condition);
        if (priceTo == null) {
            priceTo = this.findPrice((Object[])this.basePriceMap.get(key), condition);
        }
        return priceTo;
    }

    private SalePriceTO fetchPrice(String key, PriceCondition condition, int counts) {
        PriceSolve priceSolve = new PriceSolve();
        Collection prices = priceSolve.fetchPriceInfos(condition);
        if (prices != null) {
            int idx = counts;
            this.keyMap.put(key, condition.getPriceType().equals("basePrice") ? "2" + counts : "1" + (counts += prices.size()));
            Iterator iter = prices.iterator();
            while (iter.hasNext()) {
                this.cacheMap.put(key + idx++, iter.next());
            }
            SalePriceTO price = this.findPrice(condition, key, counts);
            if (price == null) {
                String value = (String)this.keyMap.get(key);
                String symbol = value.substring(0, 1);
                if (!condition.getPriceType().equals("basePrice") && symbol.equals("1")) {
                    condition.setPriceType("basePrice");
                    return this.fetchPrice(key, condition, counts);
                }
            }
            return price;
        }
        if (condition.getPriceType().equals("basePrice")) {
            if (this.keyMap.containsKey(key)) {
                counts = Integer.valueOf(((String)this.keyMap.get(key)).substring(1));
                this.keyMap.put(key, "2" + counts);
            }
        } else {
            this.keyMap.put(key, "00");
        }
        return null;
    }

    public List putInCache(SaleOrderDataVO resultVO) {
        if (resultVO.getPriceList() == null) {
            return null;
        }
        int size = resultVO.getMaterialInfos().length;
        ArrayList<SalePriceTO> priceList = new ArrayList<SalePriceTO>(size);
        for (int idxOfMaterial = 0; idxOfMaterial < size; ++idxOfMaterial) {
            if (resultVO.getMaterialInfos()[idxOfMaterial] == null) continue;
            String key = new StringBuffer().append(resultVO.getMainOrg().getId().toString()).append(resultVO.getCustomerInfo() != null ? resultVO.getCustomerInfo().getId().toString() : null).append(resultVO.getMaterialInfos()[idxOfMaterial].getId().toString()).append(resultVO.getCurrencyInfo() != null ? resultVO.getCurrencyInfo().getId().toString() : null).append(resultVO.getAsstProperties() != null ? (resultVO.getAsstProperties()[idxOfMaterial] != null ? resultVO.getAsstProperties()[idxOfMaterial].getId().toString() : null) : null).append(resultVO.getMeasureUnitInfos()[idxOfMaterial] != null ? resultVO.getMeasureUnitInfos()[idxOfMaterial].getId().toString() : null).toString();
            List prices = this.findPrices(resultVO, resultVO.getPriceList(), idxOfMaterial);
            if (!this.keyMap.containsKey(key)) {
                int counts = 0;
                if (prices != null && prices.size() > 0) {
                    int idx = counts;
                    boolean isKey = false;
                    boolean includeBase = false;
                    int s = prices.size();
                    for (int i = 0; i < s; ++i) {
                        SalePriceTO price = (SalePriceTO)prices.get(i);
                        this.cacheMap.put(key + idx++, price);
                        if (isKey || price == null) continue;
                        ++counts;
                        if (includeBase) continue;
                        includeBase = price.priceType.equals("basePrice");
                    }
                    this.keyMap.put(key, includeBase ? "2" + counts : "1" + counts);
                    priceList.add(this.findPrice(resultVO, prices, idxOfMaterial));
                } else {
                    this.keyMap.put(key, "00");
                    priceList.add(null);
                }
            } else {
                priceList.add(this.findPrice(resultVO, prices, idxOfMaterial));
            }
            if (resultVO.getPriceList() == null) continue;
            for (ArrayList priceToList : resultVO.getPriceList()) {
                if (priceToList == null) continue;
                this.pricePolicyMap.put(key, priceToList.toArray());
            }
        }
        return priceList;
    }

    private List findPrices(SaleOrderDataVO resultVO, List priceList, int idxOfMaterial) {
        if (priceList == null) {
            return null;
        }
        for (ArrayList prices : priceList) {
            if (this.findPrice(resultVO, prices, idxOfMaterial) == null) continue;
            return prices;
        }
        return null;
    }

    private SalePriceTO findPrice(SaleOrderDataVO resultVO, List prices, int idxOfMaterial) {
        if (prices == null) {
            return null;
        }
        boolean found = false;
        SalePriceTO basePrice = null;
        boolean basePriceFound = false;
        ArrayList<SalePriceTO> resultPriceList = new ArrayList<SalePriceTO>();
        if (resultVO.isDoContainsPriceOnUpperBill()) {
            int s = prices.size();
            for (int i = 0; i < s; ++i) {
                SalePriceTO price = (SalePriceTO)prices.get(i);
                if (price.priceType != null && price.priceType.equals("pricePolicy")) {
                    price.priceComposition += 10;
                    if (resultVO.getServerDate() != null) {
                        java.util.Date date1 = price.dateFrom;
                        java.util.Date date2 = price.dateTo;
                        java.util.Date serverDate = this.getServerDate(resultVO.getServerDate());
                        if (serverDate.compareTo(date1) >= 0 && (date2 == null || serverDate.compareTo(date2) <= 0)) {
                            found = true;
                        }
                    }
                    if (price.material != null && !resultVO.getMaterialInfos()[idxOfMaterial].getId().toString().equals(price.material)) {
                        found = false;
                    }
                    if (found && price.assistProperty != null && resultVO.getAsstProperties()[idxOfMaterial] != null && !price.assistProperty.equals(resultVO.getAsstProperties()[idxOfMaterial].getId().toString())) {
                        found = false;
                    } else if (found && price.assistProperty != null && price.assistProperty.equals(resultVO.getAsstProperties()[idxOfMaterial].getId().toString())) {
                        price.priceComposition += 11;
                    } else if (found && price.assistProperty == null) {
                        price.priceComposition += 10;
                    }
                    if (found && resultVO.getQuantities() != null) {
                        BigDecimal entryQty = resultVO.getQuantities()[idxOfMaterial] != null ? resultVO.getQuantities()[idxOfMaterial] : new BigDecimal("0.00");
                        BigDecimal qty1 = price.qtyFrom;
                        BigDecimal qty2 = price.qtyTo;
                        if (qty1 != null && qty2 != null && entryQty.compareTo(qty1) >= 0 && entryQty.compareTo(qty2) <= 0) {
                            price.priceComposition += 12;
                        } else if (qty1 != null && qty2 == null && entryQty.compareTo(qty1) >= 0 || qty1 == null && qty2 != null && entryQty.compareTo(qty2) <= 0) {
                            price.priceComposition += 11;
                        } else if (qty1 == null && qty2 == null) {
                            price.priceComposition += 10;
                        }
                    }
                    if (!found) continue;
                    resultPriceList.add(price);
                    continue;
                }
                if (price.material != null && !resultVO.getMaterialInfos()[idxOfMaterial].getId().toString().equals(price.material)) {
                    return null;
                }
                MeasureUnitInfo measureUnitInfo = resultVO.getMeasureUnitInfos()[idxOfMaterial];
                if (price.measureUnit.equals(measureUnitInfo.getId().toString())) {
                    return price;
                }
                basePrice = price;
                basePriceFound = true;
            }
        } else {
            return this.findPriceWhenUpperBillHasNoPrice(resultVO, prices, idxOfMaterial);
        }
        if (resultPriceList != null && resultPriceList.size() > 0) {
            SalePriceTO returnSalePriceTo = null;
            SalePriceTO tempSalePriceTo2 = null;
            int i = 0;
            for (SalePriceTO tempSalePriceTo2 : resultPriceList) {
                if (i++ == 0) {
                    returnSalePriceTo = tempSalePriceTo2;
                    continue;
                }
                if (tempSalePriceTo2 == null || returnSalePriceTo == null || returnSalePriceTo.priceComposition >= tempSalePriceTo2.priceComposition) continue;
                returnSalePriceTo = tempSalePriceTo2;
            }
            return returnSalePriceTo;
        }
        return basePriceFound ? basePrice : null;
    }

    private SalePriceTO findPrice(Object[] prices, PriceCondition condition) {
        if (prices == null) {
            return null;
        }
        boolean found = false;
        SalePriceTO basePrice = null;
        boolean basePriceFound = false;
        String assisPropertyId = condition.getAssisProperty() != null ? condition.getAssisProperty().getId().toString() : null;
        ArrayList<SalePriceTO> resultPriceList = new ArrayList<SalePriceTO>();
        int length = prices.length;
        for (int i = 0; i < length; ++i) {
            SalePriceTO price = (SalePriceTO)prices[i];
            price.priceComposition = 0;
            if (price == null) continue;
            if (price.priceType != null && price.priceType.equals("pricePolicy")) {
                price.priceComposition += 10;
                if (condition.getCurDate() != null) {
                    java.util.Date date1 = price.dateFrom;
                    java.util.Date date2 = price.dateTo;
                    java.util.Date serverDate = condition.getCurDate();
                    if (serverDate.compareTo(date1) >= 0 && (date2 == null || serverDate.compareTo(date2) <= 0)) {
                        found = true;
                    }
                }
                if (price.material != null && condition.getMaterialInfo() != null && !condition.getMaterialInfo().getId().toString().equals(price.material)) {
                    found = false;
                }
                if (condition.getMeasureUnit() != null && price.measureUnit != null && !price.measureUnit.equals(condition.getMeasureUnit()) && condition.getMaterialInfo().getBaseUnit() != null && !condition.getMaterialInfo().getBaseUnit().getId().toString().equals(price.measureUnit)) {
                    found = false;
                }
                if (found && price.assistProperty != null && !price.assistProperty.equals(assisPropertyId)) {
                    found = false;
                } else if (found && price.assistProperty != null && price.assistProperty.equals(assisPropertyId)) {
                    price.priceComposition += 11;
                } else if (found && price.assistProperty == null) {
                    price.priceComposition += 10;
                }
                if (found && condition.getOrderQty() != null) {
                    BigDecimal entryQty = condition.getOrderQty() != null ? condition.getOrderQty() : new BigDecimal("0.00");
                    BigDecimal qty1 = price.qtyFrom;
                    BigDecimal qty2 = price.qtyTo;
                    if (qty1 != null && qty2 != null && entryQty.compareTo(qty1) >= 0 && entryQty.compareTo(qty2) <= 0) {
                        price.priceComposition += 12;
                    } else if (qty1 != null && qty2 == null && entryQty.compareTo(qty1) >= 0 || qty1 == null && qty2 != null && entryQty.compareTo(qty2) <= 0) {
                        price.priceComposition += 11;
                    } else if (qty1 == null && qty2 == null) {
                        price.priceComposition += 10;
                    }
                }
                if (!found) continue;
                resultPriceList.add(price);
                continue;
            }
            if (price.material != null && !condition.getMaterialInfo().getId().toString().equals(price.material)) {
                return null;
            }
            String unitId = condition.getMeasureUnit();
            if (price.measureUnit.equals(unitId)) {
                return price;
            }
            basePrice = price;
            basePriceFound = true;
        }
        if (resultPriceList != null && resultPriceList.size() > 0) {
            SalePriceTO returnSalePriceTo = null;
            SalePriceTO tempSalePriceTo2 = null;
            int i = 0;
            for (SalePriceTO tempSalePriceTo2 : resultPriceList) {
                if (i++ == 0) {
                    returnSalePriceTo = tempSalePriceTo2;
                    continue;
                }
                if (tempSalePriceTo2 == null || returnSalePriceTo == null || returnSalePriceTo.priceComposition >= tempSalePriceTo2.priceComposition) continue;
                returnSalePriceTo = tempSalePriceTo2;
            }
            return returnSalePriceTo;
        }
        return basePriceFound ? basePrice : null;
    }

    private SalePriceTO findPriceWhenUpperBillHasNoPrice(SaleOrderDataVO resultVO, List prices, int idxOfMaterial) {
        int s = prices.size();
        for (int i = 0; i < s; ++i) {
            boolean satisfyQtyConditions;
            SalePriceTO price = (SalePriceTO)prices.get(i);
            if (price.priceType == null || !price.priceType.equals("pricePolicy")) {
                return price;
            }
            if (resultVO.getServerDate() == null || resultVO.getQuantities() == null || resultVO.getQuantities()[idxOfMaterial] == null) continue;
            java.util.Date date1 = price.dateFrom;
            java.util.Date date2 = price.dateTo;
            BigDecimal qty1 = price.qtyFrom;
            BigDecimal qty2 = price.qtyTo;
            java.util.Date serverDate = this.getServerDate(resultVO.getServerDate());
            boolean satisfyDateConditions = serverDate.compareTo(date1) >= 0 && (date2 == null || serverDate.compareTo(date2) <= 0);
            boolean bl = satisfyQtyConditions = !(qty1 != null && resultVO.getQuantities()[idxOfMaterial].compareTo(qty1) < 0 || qty2 != null && resultVO.getQuantities()[idxOfMaterial].compareTo(qty2) > 0);
            if (!satisfyDateConditions || !satisfyQtyConditions) continue;
            return price;
        }
        return null;
    }

    private java.util.Date getServerDate(java.util.Date serverDate) {
        java.util.Date curDate = Calendar.getInstance().getTime();
        curDate.setYear(serverDate.getYear());
        curDate.setMonth(serverDate.getMonth());
        curDate.setDate(serverDate.getDate());
        return new Date(curDate.getTime());
    }

    private SalePriceTO findPrice(PriceCondition condition, String key, int counts) {
        String subkey = null;
        boolean found = false;
        boolean isBasic = false;
        for (int i = 0; i < counts; ++i) {
            subkey = key + i;
            if (!this.cacheMap.containsKey(subkey)) continue;
            found = true;
            SalePriceTO price = (SalePriceTO)this.cacheMap.get(subkey);
            boolean bl = isBasic = isBasic ? true : price.priceType.equals("basePrice");
            if (price.priceType != null && price.priceType.equals("pricePolicy")) {
                if (condition.getCurDate() != null) {
                    java.util.Date date1 = price.dateFrom;
                    java.util.Date date2 = price.dateTo;
                    java.util.Date curDate = this.getServerDate(condition.getCurDate());
                    found = curDate.compareTo(date1) >= 0 && (date2 == null || curDate.compareTo(date2) <= 0);
                }
                if (found && condition.getOrderQty() != null) {
                    BigDecimal qty = new BigDecimal(0.0);
                    BigDecimal qty1 = price.qtyFrom;
                    BigDecimal qty2 = price.qtyTo;
                    if (null != qty1 && condition.getOrderQty().compareTo(qty1) >= 0 && null != qty2 && condition.getOrderQty().compareTo(qty2) <= 0 && (found = true)) break;
                    found = qty1 == null && condition.getOrderQty().compareTo(qty) >= 0 && qty2 == null;
                }
            }
            if (found) break;
        }
        if (!condition.getPriceType().equals("basePrice") && isBasic) {
            this.keyMap.put(key, "2" + counts);
        }
        if (found) {
            return (SalePriceTO)this.cacheMap.get(subkey);
        }
        return null;
    }

    public BigDecimal getPriceMin(PriceCondition condition) {
        BigDecimal priceMin = null;
        try {
            SalePriceTO priceTO;
            List[] priceList = PricePolicyCache.getInstance().getPrices(new PriceCondition[]{condition});
            if (priceList != null && priceList[0] != null && (priceTO = (SalePriceTO)priceList[0].get(0)) != null) {
                priceMin = priceTO.priceMin;
            }
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return priceMin;
    }

    private boolean isInventoryAddNew(Map dataMap) {
        boolean isInventoryAddLine = false;
        if (dataMap != null && dataMap.get("isInventoryAddLine") != null && dataMap.get("isInventoryAddLine").toString().equals("isInventoryAddLine")) {
            isInventoryAddLine = true;
        }
        return isInventoryAddLine;
    }

    public List[] getPrices(PriceCondition[] priceConditionArray) throws BOSException, EASBizException {
        if (!this.checkConditions(priceConditionArray)) {
            return null;
        }
        List[] priceList = null;
        if (this.isAllConditionFoundPrice(priceList)) {
            return priceList;
        }
        IPriceProvider iPriceProvider = PriceProviderFactory.getRemoteInstance();
        priceList = iPriceProvider.getPrices(priceConditionArray);
        return priceList;
    }

    private boolean isAllConditionFoundPrice(List[] priceList) {
        if (priceList == null || priceList.length == 0) {
            return false;
        }
        int n = priceList.length;
        for (int i = 0; i < n; ++i) {
            if (priceList[i] != null) continue;
            return false;
        }
        return true;
    }

    private List[] getPricesFromCache(PriceCondition[] priceConditionArray) {
        List[] priceList = new ArrayList[priceConditionArray.length];
        priceConditionArray[0].getSaleOrg();
        for (PriceCondition pc : priceConditionArray) {
            String keyStr = this.getPricesKeyStr(pc);
            List cachePriceList = (List)this.cacheMap.get(keyStr);
            if (cachePriceList == null || cachePriceList.isEmpty()) {
                return null;
            }
            ArrayList<SalePriceTO> pcPriceList = new ArrayList<SalePriceTO>();
            int m = cachePriceList.size();
            for (int j = 0; j < m; ++j) {
                SalePriceTO to = (SalePriceTO)cachePriceList.get(j);
                if (!to.priceType.equals("pricePolicy") || !this.isQtyScopeMatch(pc, to)) continue;
                pcPriceList.add(to);
                break;
            }
            if (pcPriceList.isEmpty()) continue;
            priceList[i] = pcPriceList;
        }
        return priceList;
    }

    private boolean isQtyScopeMatch(PriceCondition pc, SalePriceTO to) {
        BigDecimal zero = new BigDecimal("0.00");
        boolean flag = false;
        if (pc.getOrderQty().compareTo(zero) > 0) {
            BigDecimal qty = pc.getOrderQty();
            if (to.qtyFrom == null && to.qtyTo == null) {
                flag = true;
            } else if (to.qtyFrom == null || to.qtyTo == null) {
                if (to.qtyFrom == null && qty.compareTo(to.qtyTo) <= 0) {
                    flag = true;
                }
                if (to.qtyTo == null && qty.compareTo(to.qtyFrom) >= 0) {
                    flag = true;
                }
            } else if (to.qtyFrom != null && to.qtyTo != null && qty.compareTo(to.qtyFrom) >= 0 && qty.compareTo(to.qtyTo) <= 0) {
                flag = true;
            }
        } else {
            flag = true;
        }
        return flag;
    }

    private String getPricesKeyStr(PriceCondition pc) {
        StringBuffer keyStr = new StringBuffer("");
        String assStr = pc.getAssisProperty() == null ? "" : pc.getAssisProperty().getId().toString();
        keyStr.append(pc.getSaleOrg().getId().toString()).append(pc.getCustomerInfo().getId().toString()).append(pc.getCurrencyInfo().getId().toString()).append(pc.getMaterialInfo().getId().toString()).append(pc.getMeasureUnit()).append(assStr);
        return keyStr.toString();
    }

    private void putInCache(PriceCondition[] priceConditionArray, List[] priceList) {
        if (priceList == null) {
            return;
        }
        int n = priceConditionArray.length;
        for (int i = 0; i < n; ++i) {
            PriceCondition pc = priceConditionArray[i];
            if (priceList[i] == null) continue;
            String keyStr = this.getPricesKeyStr(pc);
            if (!this.cacheMap.keySet().contains(keyStr)) {
                this.cacheMap.put(keyStr, priceList[i]);
                continue;
            }
            List pcCachePriceList = (List)this.cacheMap.get(keyStr);
            List pcPriceList = priceList[i];
            SalePriceTO to = (SalePriceTO)pcPriceList.get(0);
            if (pcCachePriceList == null || pcCachePriceList.isEmpty() || pcPriceList == null || pcPriceList.isEmpty()) continue;
            int m = pcCachePriceList.size();
            for (int j = 0; j < m; ++j) {
                SalePriceTO cacheTO = (SalePriceTO)pcCachePriceList.get(j);
                boolean isFQMatch = false;
                boolean isTQMatch = false;
                if (to.qtyFrom == null || cacheTO.qtyFrom == null) {
                    if (to.qtyFrom == null && cacheTO.qtyFrom == null) {
                        isFQMatch = true;
                    }
                } else if (to.qtyFrom.compareTo(cacheTO.qtyFrom) == 0) {
                    isFQMatch = true;
                }
                if (to.qtyTo == null || cacheTO.qtyTo == null) {
                    if (to.qtyTo == null && cacheTO.qtyTo == null) {
                        isTQMatch = true;
                    }
                } else if (to.qtyTo.compareTo(cacheTO.qtyTo) == 0) {
                    isTQMatch = true;
                }
                if (isFQMatch && isTQMatch) continue;
                pcCachePriceList.add(to);
            }
        }
    }

    private boolean checkConditions(PriceCondition[] priceConditionArray) {
        for (PriceCondition pc : priceConditionArray) {
            if (pc == null || pc.getMaterialInfo() == null || pc.getMeasureUnit() == null || pc.getCustomerInfo() == null || pc.getCurrencyInfo() == null || pc.getSaleOrg() == null) continue;
            return true;
        }
        return false;
    }

    public static void clearCache() {
        if (cache != null) {
            PricePolicyCache.cache.keyMap.clear();
            PricePolicyCache.cache.cacheMap.clear();
            PricePolicyCache.cache.pricePolicyMap.clear();
            PricePolicyCache.cache.basePriceMap.clear();
        }
    }
}

