/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.attachment.util.UICreator;
import com.kingdee.eas.base.commonquery.UserPreferenceData;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.MutiOrgPermParam;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.client.BDInvClientUtils;
import com.kingdee.eas.basedata.scm.sd.sale.IPricePolicy;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyCollection;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyEntryFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyException;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyInfo;
import com.kingdee.eas.basedata.scm.sd.sale.client.AbstractPricePolicyDetailListUI;
import com.kingdee.eas.basedata.scm.sd.sale.client.AssignPricePolicyForResultView;
import com.kingdee.eas.basedata.scm.sd.sale.client.AssignPricePolicySelectMultiOrgsUi;
import com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicyCache;
import com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicyDetailViewListUI;
import com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicyEditUI;
import com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicyFilterUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMCommonProcessor;
import com.kingdee.eas.scm.common.client.SCMPromptBoxFactory;
import com.kingdee.eas.scm.common.util.EntityViewInfoUtil;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.util.numeric.PrecisionUtil;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PricePolicyDetailListUI
extends AbstractPricePolicyDetailListUI {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicyDetailListUI");
    private static final String RESOURCE = "com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicy";
    CommonQueryDialog conditionDialog = null;
    PricePolicyFilterUI conditionPanel = null;
    protected int numericPrecision = 6;
    private boolean isFirstLoad = true;
    private static final String[] NUMERICCOLUMNS = new String[]{"entries.qtyMin", "entries.qtyMax", "entries.price", "entries.discount", "entries.priceMin", "entries.priceMax", "entries.saleLeadTime", "discountedPrice"};
    private int importInfoIndex = 0;
    private boolean isDisplayEntries = true;
    private static final String[] PRICEPOLICYENTRYFIELDS = new String[]{"customer.number", "customer.name", "customerGroup.number", "customerGroup.name", "material.number", "material.name", "materialGroup.number", "materialGroup.name", "material.model", "entries.price", "entries.discountMode", "entries.discount", "discountedPrice", "asistProperty.name", "measureUnit.name", "entries.qtyMin", "entries.qtyMax", "currency.name", "priceType.name", "entries.priceMin", "entries.priceMax", "entries.effectiveDate", "entries.expireDate", "entries.saleLeadTime", "entries.checkedStatus"};
    private static final String[] PRICEPOLICYFIELDS = new String[]{"customer.number", "customer.name", "customerGroup.number", "customerGroup.name", "material.number", "material.name", "materialGroup.number", "materialGroup.name", "material.model", "entries.price", "entries.discountMode", "entries.discount", "discountedPrice", "asistProperty.name", "measureUnit.name", "entries.qtyMin", "entries.qtyMax", "currency.name", "priceType.name", "entries.priceMin", "entries.priceMax", "entries.effectiveDate", "entries.expireDate", "entries.saleLeadTime", "entries.checkedStatus"};
    private UserPreferenceData userPreferenceData = null;
    private Map cacheTableConfig = new HashMap();
    Map<String, Integer> pricisionMap = new HashMap<String, Integer>();

    public KDPanel getConditionPanel() throws Exception {
        if (this.conditionPanel == null) {
            this.conditionPanel = new PricePolicyFilterUI();
        }
        return this.conditionPanel;
    }

    protected CustomerQueryPanel getFilterUI() throws Exception {
        if (this.getUIContext().get("pricePolicyInfo") != null) {
            PricePolicyInfo info = (PricePolicyInfo)this.getUIContext().get("pricePolicyInfo");
            UIContext uiContext = new UIContext();
            uiContext.put((Object)"pricePolicyInfo", (Object)info);
            IUIWindow queryUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PricePolicyFilterUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            this.conditionPanel = (PricePolicyFilterUI)queryUI.getUIObject();
        } else if (this.conditionPanel == null) {
            this.conditionPanel = new PricePolicyFilterUI();
        }
        return this.conditionPanel;
    }

    public CommonQueryDialog initCommonQueryDialog() {
        if (this.conditionDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.conditionDialog = super.initCommonQueryDialog();
            this.conditionDialog.setWidth(580);
            this.conditionDialog.setHeight(385);
            this.conditionDialog.setProcessor((IProcessor)new SCMCommonProcessor());
            try {
                CustomerQueryPanel queryPanel = this.getFilterUI();
                SCMPromptBoxFactory scmF7Factory = new SCMPromptBoxFactory(queryPanel, this.getMainBizOrgType());
                this.conditionDialog.setPromptBoxFactory((IPromptBoxFactory)scmF7Factory);
                this.conditionDialog.addUserPanel((KDPanel)queryPanel);
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return this.conditionDialog;
    }

    public void onLoad() throws Exception {
        ArrayList list = (ArrayList)this.getUIContext().get("pricePolicyIds");
        if (list != null && list.size() > 0) {
            this.setIsNeedDefaultFilter(false);
        }
        super.onLoad();
        this.handleFiledsPrecision();
        this.isFirstLoad = false;
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionAudit.setEnabled(true);
        this.actionUnAudit.setEnabled(true);
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnAuditEntry.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnUnAuditEntry.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuItemAuditEntry.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemUnAuditEntry.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.menuItemAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.actionAddNew.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.refreshEntry();
    }

    private void initMainOrgContext() throws Exception {
        IPermission permission = PermissionFactory.getRemoteInstance();
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)OrgType.Sale));
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        FullOrgUnitCollection orgUnitColl = permission.getAuthorizedOrg((IObjectPK)userPK, OrgType.Sale, (IObjectPK)treePK, "pricepolicy_view");
        for (int i = 0; i < orgUnitColl.size(); ++i) {
            this.initUIMainOrgContext(orgUnitColl.get(i).getId().toString());
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        if (orgType.equals((Object)OrgType.Sale)) {
            return "saleOrgUnit.id";
        }
        return null;
    }

    protected void doFieldPermission() {
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initMainBizOrg(List l) {
        super.initMainBizOrg(l);
        if (this.getMainOrgContext() != null) {
            MutiOrgPermParam mutiOrgParam = new MutiOrgPermParam();
            mutiOrgParam.setOrgType(this.getMainBizOrgType());
            mutiOrgParam.setOrgIdList(l);
            this.getMainOrgContext().put((Object)"MUTI_ORG_INFO", (Object)mutiOrgParam);
        }
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        if (this.isDisplayEntries) {
            this.checkSelected();
            if (this.getSelectedKeyValue() == null) {
                return;
            }
            if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
                this.refreshList();
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
            ArrayList entryIDList = this.getSelectedFieldValues("entries.id");
            StringBuffer entryIDStr = new StringBuffer("");
            int size = entryIDList.size();
            for (int i = 0; i < size; ++i) {
                entryIDStr.append(entryIDList.get(i).toString());
            }
            uiContext.put((Object)"entryID", (Object)entryIDStr.toString());
            this.prepareUIContext(uiContext, e);
            IUIWindow uiWindow = null;
            uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
            this.showDetailList();
        }
    }

    private void showDetailList() throws UIException {
        ArrayList sids = this.getSelectedIdValues();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"pricePolicyIds", (Object)sids);
        uiContext.put((Object)"pricePolicyId", (Object)sids.get(0).toString());
        PricePolicyInfo tempInfo = null;
        if (sids != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)sids.get(0))));
            try {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("checkedStatus"));
                sic.add(new SelectorItemInfo("blockedStatus"));
                sic.add(new SelectorItemInfo("saleOrgUnit.id"));
                sic.add(new SelectorItemInfo("saleOrgUnit.number"));
                sic.add(new SelectorItemInfo("saleOrgUnit.name"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.EQUALS));
                view.setFilter(filter);
                view.setSelector(sic);
                EntityViewInfoUtil.setBaseOnSelector((EntityViewInfo)view);
                PricePolicyCollection ppc = PricePolicyFactory.getRemoteInstance().getPricePolicyCollection(view);
                if (ppc != null && ppc.size() > 0) {
                    tempInfo = ppc.get(0);
                }
            }
            catch (BOSException e1) {
                logger.error((Object)e1);
                this.handUIExceptionAndAbort((Exception)((Object)e1));
            }
        }
        uiContext.put((Object)"pricePolicyInfo", tempInfo);
        IUIWindow popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(PricePolicyDetailViewListUI.class.getName(), (Map)uiContext, null);
        popUI.show();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        int size = this.getSelectedRowCount(this.getDetailTable());
        if (size > 1000) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"TOOMUCHROWS"));
            return;
        }
        this.checkSelected();
        Object baseStatus = this.tblMain.getRow(this.tblMain.getSelectManager().get(0).getTop()).getCell("blockedStatus").getValue();
        if (baseStatus != null && ((BizEnumValueDTO)baseStatus).getInt() == 2) {
            throw new PricePolicyException(PricePolicyException.CANNOTEDIT2);
        }
        super.actionEdit_actionPerformed(e);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        ItemAction action = this.getActionFromActionEvent(e);
        if (action.equals(this.actionEdit) || action.equals(this.actionView) || action.equals((Object)this.actionAddLine)) {
            ArrayList idList = this.getSelectedIdValues();
            HashMap<String, Object> conditionMap = new HashMap<String, Object>();
            String id = idList.get(0).toString();
            if (this.isDisplayEntries && !action.equals((Object)this.actionAddLine)) {
                KDTSelectManager sm = this.tblMain.getSelectManager();
                int blockCount = sm.size();
                HashSet<Object> entryIdSet = new HashSet<Object>();
                for (int i = 0; i < blockCount; ++i) {
                    KDTSelectBlock block = sm.get(i);
                    int bottom = block.getBottom();
                    for (int j = block.getTop(); j <= bottom; ++j) {
                        IRow row = this.tblMain.getRow(j);
                        if (row.getCell("entries.id").getValue() == null) continue;
                        entryIdSet.add(row.getCell("entries.id").getValue());
                    }
                }
                conditionMap.put("entryIdSet", entryIdSet);
            }
            conditionMap.put("id", id);
            uiContext.put((Object)"isFrom", (Object)PricePolicyFilterUI.FROMDETAILLIST);
            uiContext.put((Object)"conditionMap", conditionMap);
            uiContext.put((Object)"action", (Object)action);
        }
    }

    public void checkSelected() {
        super.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (String obj : idList) {
            idMap.put(obj, obj);
        }
        if (idMap.keySet().size() > 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"ISNOTTHESAME"));
            SysUtil.abort();
        }
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isSupportDynQuery() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        HashSet idSet = (HashSet)this.getUIContext().get("exceptionPriceEntryIdSet");
        if (idSet != null && idSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("entries.id", (Object)idSet, CompareType.INCLUDE));
            return filter;
        }
        ArrayList list = (ArrayList)this.getUIContext().get("pricePolicyIds");
        if (this.isFirstLoad && list != null && list.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)StringUtil.getKeyIdListWithOutQuotationMask((Object[])list.toArray()), CompareType.INCLUDE));
            return filter;
        }
        return super.getDefaultFilterForQuery();
    }

    protected boolean initDefaultFilter() {
        HashSet idSet = (HashSet)this.getUIContext().get("exceptionPriceEntryIdSet");
        if (idSet != null) {
            return false;
        }
        ArrayList list = (ArrayList)this.getUIContext().get("pricePolicyIds");
        return list == null;
    }

    private void handleFiledsPrecision() throws Exception {
        SCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])this.getNumericColumns(), (String)SCMClientUtils.getFormatPattern((int)this.numericPrecision, (boolean)false));
    }

    protected String[] getNumericColumns() throws Exception {
        return NUMERICCOLUMNS;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PricePolicyFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return PricePolicyEditUI.class.getName();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.actionCloudFeed.setVisible(false);
        this.actionCloudScreen.setVisible(false);
        this.actionCloudShare.setVisible(false);
        if (!this.isDisplayEntries) {
            this.tHelper.setQuerySolutionInfo(null);
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isDisplayEntries) {
            this.checkSelected();
            this.auditEntries();
        } else {
            if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
            this.auditBill();
        }
        this.refreshList();
    }

    public void actionAudit_beforeActionPerformed(ActionEvent e) throws Exception {
        ArrayList aids = this.getSelectedFieldValues("saleOrgUnit.id");
        if (aids.size() > 1) {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            ObjectUuidPK[] pks = new ObjectUuidPK[aids.size()];
            for (int i = 0; i < pks.length; ++i) {
                pks[i] = new ObjectUuidPK(BOSUuid.read((String)aids.get(i).toString()));
            }
            Set orgIDSet = PermissionFactory.getRemoteInstance().checkBatchPermission((IObjectPK)userPK, (IObjectPK[])pks, "pricepolicy_entryaudit");
            if (this.getMainOrgContext() != null && orgIDSet != null && orgIDSet.size() == aids.size()) {
                OrgUnitInfo orgInfo = new OrgUnitInfo();
                orgInfo.setId(BOSUuid.read((String)orgIDSet.toArray(new String[0])[0].toString()));
                this.getMainOrgContext().put((Object)this.getMainBizOrgType(), (Object)orgInfo);
            }
        }
    }

    private void auditBill() throws Exception {
        int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"auditAlert"));
        if (!MsgBox.isYes((int)isYes)) {
            return;
        }
        ArrayList aids = this.getSelectedIdValues();
        String[] IDs = aids.toArray(new String[0]);
        if (SCMClientUtils.checkAllBizObjInWfProcess((String[])IDs)) {
            this.actionMultiapprove_actionPerformed(null);
            this.execQuery();
        } else {
            ObjectUuidPK[] pks = new ObjectUuidPK[IDs.length];
            for (int i = 0; i < pks.length; ++i) {
                pks[i] = new ObjectUuidPK(BOSUuid.read((String)IDs[i]));
            }
            ((IPricePolicy)this.getBizInterface()).audit((IObjectPK[])pks);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"auditSuccess"));
        }
        PricePolicyCache.clearCache();
    }

    private void auditEntries() throws Exception {
        this.checkedBlock();
        int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"auditAlert"));
        if (MsgBox.isYes((int)isYes)) {
            KDTSelectManager sm = this.tblMain.getSelectManager();
            BizEnumValueInfo statusValue = null;
            int blockCount = sm.size();
            for (int i = 0; i < blockCount; ++i) {
                KDTSelectBlock block = sm.get(i);
                int bottom = block.getBottom();
                for (int j = block.getTop(); j <= bottom; ++j) {
                    IRow row = this.tblMain.getRow(j);
                    if (row.getCell("entries.checkedStatus").getValue() == null || (statusValue = (BizEnumValueInfo)row.getCell("entries.checkedStatus").getValue()).getInt() == 3) continue;
                    throw new PricePolicyException(PricePolicyException.CANNOTAUDIT2);
                }
            }
            ArrayList aids = this.getSelectedFieldValues("entries.id");
            ObjectUuidPK[] pks = new ObjectUuidPK[aids.size()];
            for (int i = 0; i < pks.length; ++i) {
                pks[i] = new ObjectUuidPK(aids.get(i).toString());
            }
            PricePolicyFactory.getRemoteInstance().auditForEntries((IObjectPK[])pks);
            PricePolicyCache.clearCache();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"auditSuccess"));
            String id = this.tblMain.getRow(this.tblMain.getSelectManager().get(0).getTop()).getCell("id").getValue().toString();
            String number = this.tblMain.getRow(this.tblMain.getSelectManager().get(0).getTop()).getCell("number").getValue().toString();
            IObjectPK logPk = LogUtil.beginLog(null, (String)EASResource.getString((String)RESOURCE, (String)"auditEntries"), (BOSObjectType)BOSObjectType.create((String)"51C65BC5"), (IObjectPK)new ObjectUuidPK(id), (String)number, (String)"pricepolicyentry_audit");
            LogUtil.afterLog(null, (IObjectPK)logPk);
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isDisplayEntries) {
            this.checkSelected();
            this.unAuditEntries();
        } else {
            if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
            this.unAuditBill();
        }
        this.refreshList();
    }

    public void actionUnAudit_beforeActionPerformed(ActionEvent e) throws Exception {
        ArrayList aids = this.getSelectedFieldValues("saleOrgUnit.id");
        if (aids.size() > 1) {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
            ObjectUuidPK[] pks = new ObjectUuidPK[aids.size()];
            for (int i = 0; i < pks.length; ++i) {
                pks[i] = new ObjectUuidPK(BOSUuid.read((String)aids.get(i).toString()));
            }
            Set orgIDSet = PermissionFactory.getRemoteInstance().checkBatchPermission((IObjectPK)userPK, (IObjectPK[])pks, "pricepolicy_entryunaudit");
            if (this.getMainOrgContext() != null && orgIDSet != null && orgIDSet.size() == aids.size()) {
                OrgUnitInfo orgInfo = new OrgUnitInfo();
                orgInfo.setId(BOSUuid.read((String)orgIDSet.toArray(new String[0])[0].toString()));
                this.getMainOrgContext().put((Object)this.getMainBizOrgType(), (Object)orgInfo);
            }
        }
    }

    private void unAuditBill() throws Exception {
        int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"unauditAlert"));
        if (!MsgBox.isYes((int)isYes)) {
            return;
        }
        ArrayList aids = this.getSelectedIdValues();
        String[] IDs = aids.toArray(new String[0]);
        ObjectUuidPK[] pks = new ObjectUuidPK[IDs.length];
        for (int i = 0; i < pks.length; ++i) {
            pks[i] = new ObjectUuidPK(BOSUuid.read((String)IDs[i]));
        }
        ((IPricePolicy)this.getBizInterface()).unAudit((IObjectPK[])pks);
        PricePolicyCache.clearCache();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"unauditSuccess"));
    }

    private void unAuditEntries() throws Exception {
        this.checkedBlock();
        int isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"unauditAlert"));
        if (MsgBox.isYes((int)isYes)) {
            KDTSelectManager sm = this.tblMain.getSelectManager();
            BizEnumValueInfo statusValue = null;
            int blockCount = sm.size();
            for (int i = 0; i < blockCount; ++i) {
                KDTSelectBlock block = sm.get(i);
                int bottom = block.getBottom();
                for (int j = block.getTop(); j <= bottom; ++j) {
                    IRow row = this.tblMain.getRow(j);
                    if (row.getCell("entries.checkedStatus").getValue() == null || (statusValue = (BizEnumValueInfo)row.getCell("entries.checkedStatus").getValue()).getInt() != 3 && statusValue.getInt() != 1) continue;
                    throw new PricePolicyException(PricePolicyException.CANNOTUNAUDIT2);
                }
            }
            ArrayList aids = this.getSelectedFieldValues("entries.id");
            ObjectUuidPK[] pks = new ObjectUuidPK[aids.size()];
            for (int i = 0; i < pks.length; ++i) {
                pks[i] = new ObjectUuidPK(aids.get(i).toString());
            }
            PricePolicyEntryFactory.getRemoteInstance().unAuditForEntries((IObjectPK[])pks);
            PricePolicyCache.clearCache();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"unauditSuccess"));
            String id = this.tblMain.getRow(this.tblMain.getSelectManager().get(0).getTop()).getCell("id").getValue().toString();
            String number = this.tblMain.getRow(this.tblMain.getSelectManager().get(0).getTop()).getCell("number").getValue().toString();
            IObjectPK logPk = LogUtil.beginLog(null, (String)EASResource.getString((String)RESOURCE, (String)"unAuditEntries"), (BOSObjectType)BOSObjectType.create((String)"51C65BC5"), (IObjectPK)new ObjectUuidPK(id), (String)number, (String)"pricepolicyentry_unaudit");
            LogUtil.afterLog(null, (IObjectPK)logPk);
        }
    }

    private boolean hasSubmitWorkFlow() throws BOSException {
        ProcessDefInfo processDefInfo;
        boolean flag = false;
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        String procDefID = service.findSubmitProcDef(BOSObjectType.create((String)"51C65BC5"), SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        if (procDefID != null && (processDefInfo = service.getProcessDefInfo(procDefID)).isEnable()) {
            flag = true;
        }
        return flag;
    }

    public void checkedBlock() {
        Object baseStatus = this.tblMain.getRow(this.tblMain.getSelectManager().get(0).getTop()).getCell("blockedStatus").getValue();
        if (baseStatus != null && ((BizEnumValueDTO)baseStatus).getInt() == 2) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"CANNOTAUDIT_BLOCK"));
            SysUtil.abort();
        }
    }

    private String convertToString(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int count = objs.length;
        for (int i = 0; i < count; ++i) {
            if (objs[i] == null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(objs[i].toString());
            sb.append("'");
        }
        return sb.toString();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        int isYes;
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (!MsgBox.isYes((int)(isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"blockAlert"))))) {
            return;
        }
        ArrayList aids = this.getSelectedIdValues();
        String[] IDs = aids.toArray(new String[0]);
        ObjectUuidPK[] pks = new ObjectUuidPK[IDs.length];
        for (int i = 0; i < pks.length; ++i) {
            pks[i] = new ObjectUuidPK(BOSUuid.read((String)IDs[i]));
        }
        ((IPricePolicy)this.getBizInterface()).block((IObjectPK[])pks);
        PricePolicyCache.clearCache();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"blockSuccess"));
        this.refreshList();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        int isYes;
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (!MsgBox.isYes((int)(isYes = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"unblockAlert"))))) {
            return;
        }
        ArrayList aids = this.getSelectedIdValues();
        String[] IDs = aids.toArray(new String[0]);
        ObjectUuidPK[] pks = new ObjectUuidPK[IDs.length];
        for (int i = 0; i < pks.length; ++i) {
            pks[i] = new ObjectUuidPK(BOSUuid.read((String)IDs[i]));
        }
        ((IPricePolicy)this.getBizInterface()).unBlock((IObjectPK[])pks);
        PricePolicyCache.clearCache();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"unblockSuccess"));
        this.refreshList();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isDisplayEntries) {
            this.checkSelected();
        } else if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (this.confirmRemove()) {
            try {
                this.setOprtState("REMOVE");
                this.pubFireVOChangeListener(this.getSelectedKeyValue());
            }
            catch (Throwable ex) {
                this.handUIException(ex);
                this.abort();
            }
            if (this.isDisplayEntries) {
                ArrayList eids = this.getSelectedFieldValues("entries.id");
                String[] IDs = eids.toArray(new String[0]);
                ObjectUuidPK[] pks = new ObjectUuidPK[IDs.length];
                for (int i = 0; i < pks.length; ++i) {
                    pks[i] = new ObjectUuidPK(BOSUuid.read((String)IDs[i]));
                }
                PricePolicyEntryFactory.getRemoteInstance().delete((IObjectPK[])pks);
            } else {
                ArrayList aids = this.getSelectedIdValues();
                String[] IDs = aids.toArray(new String[0]);
                ObjectUuidPK[] pks = new ObjectUuidPK[IDs.length];
                for (int i = 0; i < pks.length; ++i) {
                    pks[i] = new ObjectUuidPK(BOSUuid.read((String)IDs[i]));
                }
                this.getBizInterface().delete((IObjectPK[])pks);
            }
            try {
                this.pubFireVOChangeListener(this.getSelectedKeyValue());
            }
            catch (Throwable e1) {
                logger.error((Object)e1);
                this.handUIException(e1);
            }
            this.refresh(e);
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.print(false);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.print(true);
    }

    private void print(boolean isPreview) {
        this.preparePrintPage(this.tblMain);
        KDPrinter printer = this.tblMain.getPrintManager().getNewPrintManager().getPrinter();
        PrintListener printListener = new PrintListener();
        printer.addPrintActionListener((IPrintActionListener)printListener);
        if (isPreview) {
            this.tblMain.getPrintManager().printPreview();
        } else {
            this.tblMain.getPrintManager().print();
        }
        printer.removePrintActionListener((IPrintActionListener)printListener);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.scm.sd.sale.app.PricePolicyDetailQuery";
    }

    @Override
    public void actionImportCustomerGroupMaterial_actionPerformed(ActionEvent e) throws Exception {
        this.importInfoIndex = 2;
        this.importData();
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionImportCustomerGroupMaterialGroup_actionPerformed(ActionEvent e) throws Exception {
        this.importInfoIndex = 3;
        this.importData();
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionImportCustomerMaterial_actionPerformed(ActionEvent e) throws Exception {
        this.importInfoIndex = 0;
        this.importData();
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionImportCustomerMaterialGroup_actionPerformed(ActionEvent e) throws Exception {
        this.importInfoIndex = 1;
        this.importData();
        this.actionRefresh_actionPerformed(e);
    }

    private void importData() throws Exception {
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        if (this.getImportParam() != null) {
            task.invoke(this.getImportParam(), 0, true, true);
        }
    }

    @Override
    public void actionExportCustomerGroupMaterial_actionPerformed(ActionEvent e) throws Exception {
        this.importInfoIndex = 2;
        this.ExportData();
    }

    @Override
    public void actionExportCustomerGroupMaterialGroup_actionPerformed(ActionEvent e) throws Exception {
        this.importInfoIndex = 3;
        this.ExportData();
    }

    @Override
    public void actionExportCustomerMaterial_actionPerformed(ActionEvent e) throws Exception {
        this.importInfoIndex = 0;
        this.ExportData();
    }

    @Override
    public void actionExportCustomerMaterialGroup_actionPerformed(ActionEvent e) throws Exception {
        this.importInfoIndex = 1;
        this.ExportData();
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        switch (this.importInfoIndex) {
            case 0: {
                String solutionName;
                param.solutionName = solutionName = "eas.scm.scmbd.PricePolicy_Customer_Material";
                break;
            }
            case 1: {
                String solutionName;
                param.solutionName = solutionName = "eas.scm.scmbd.PricePolicy_Customer_MaterialGroup";
                break;
            }
            case 2: {
                String solutionName;
                param.solutionName = solutionName = "eas.scm.scmbd.PricePolicy_CustomerGroup_Material";
                break;
            }
            case 3: {
                String solutionName;
                param.solutionName = solutionName = "eas.scm.scmbd.PricePolicy_CustomerGroup_MaterialGroup";
            }
        }
        param.alias = EASResource.getString((String)RESOURCE, (String)"pricePolicy");
        param.datataskMode = 0;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        UserInfo currentUser = SysContext.getSysContext().getCurrentUserInfo();
        DatataskParameter param = new DatataskParameter();
        String solutionName = null;
        switch (this.importInfoIndex) {
            case 0: {
                param.solutionName = solutionName = "eas.scm.scmbd.PricePolicy_Customer_Material";
                break;
            }
            case 1: {
                param.solutionName = solutionName = "eas.scm.scmbd.PricePolicy_Customer_MaterialGroup";
                break;
            }
            case 2: {
                param.solutionName = solutionName = "eas.scm.scmbd.PricePolicy_CustomerGroup_Material";
                break;
            }
            case 3: {
                param.solutionName = solutionName = "eas.scm.scmbd.PricePolicy_CustomerGroup_MaterialGroup";
            }
        }
        param.alias = EASResource.getString((String)RESOURCE, (String)"pricePolicy");
        param.solutionName = solutionName;
        param.datataskMode = 1;
        param.varList = new ArrayList();
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    private void ExportData() throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        Object tmp = para.get(0);
        if (tmp instanceof DatataskParameter) {
            DatataskParameter dp = (DatataskParameter)tmp;
            MetaDataPK queryPK = null;
            switch (this.importInfoIndex) {
                case 0: {
                    queryPK = new MetaDataPK("com.kingdee.eas.basedata.scm.sd.sale.app", "PricePolicyCustomerMaterialExportQuery");
                    break;
                }
                case 1: {
                    queryPK = new MetaDataPK("com.kingdee.eas.basedata.scm.sd.sale.app", "PricePolicyCustomerMaterialGroupExportQuery");
                    break;
                }
                case 2: {
                    queryPK = new MetaDataPK("com.kingdee.eas.basedata.scm.sd.sale.app", "PricePolicyCustomerGroupMaterialExportQuery");
                    break;
                }
                default: {
                    queryPK = new MetaDataPK("com.kingdee.eas.basedata.scm.sd.sale.app", "PricePolicyCustomerGroupMaterialGroupExportQuery");
                }
            }
            EntityViewInfo viewInfo = this.mainQuery;
            dp.putContextParam((Object)"mainQueryPK", (Object)queryPK);
            dp.putContextParam((Object)"mainQuery", (Object)viewInfo);
        }
        DatataskCaller dc = new DatataskCaller();
        dc.setParentComponent((Component)((Object)this));
        dc.invoke(para, 1);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        Object baseStatus;
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        ArrayList idList = this.getSelectedIdValues();
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (String obj : idList) {
            idMap.put(obj, obj);
        }
        if (idMap.keySet().size() > 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"SELECTSAMEPOLICY"));
            SysUtil.abort();
        }
        if ((baseStatus = this.tblMain.getRow(this.tblMain.getSelectManager().get(0).getTop()).getCell("blockedStatus").getValue()) != null && ((BizEnumValueDTO)baseStatus).getInt() == 2) {
            throw new PricePolicyException(PricePolicyException.CANNOTEDIT2);
        }
        super.actionEdit_actionPerformed(e);
    }

    public void setDisplayEntries(boolean isDisplayEntries) {
        this.isDisplayEntries = isDisplayEntries;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        if (ev == null || ev.getFilter() == null) {
            return;
        }
        FilterInfo hideFilter = ev.getFilter();
        for (FilterItemInfo filterItem : hideFilter.getFilterItems()) {
            if (filterItem != null && filterItem.getPropertyName() != null && "entries.seq".equals(filterItem.getPropertyName())) {
                Object obj = filterItem.getCompareValue();
                if (!(obj instanceof Integer)) continue;
                Integer cpInte = (Integer)obj;
                if (cpInte == 1) {
                    this.setDisplayEntries(false);
                    continue;
                }
                this.setDisplayEntries(true);
                continue;
            }
            this.setDisplayEntries(true);
        }
        super.beforeExcutQuery(ev);
    }

    private void refreshEntry() {
        this.setTableRowHide(this.tblMain, PRICEPOLICYENTRYFIELDS, !this.isDisplayEntries);
        if (!this.isDisplayEntries) {
            this.actionCancel.setVisible(true);
            this.actionCancelCancel.setVisible(true);
            this.actionWorkFlowG.setVisible(true);
            this.menuWorkFlow.setVisible(true);
            this.actionQueryScheme.setVisible(true);
            this.actionAddLine.setVisible(false);
            this.menuExportData.setVisible(true);
            this.menuImportData.setVisible(true);
            this.actionEdit.setVisible(false);
            this.actionCancel.setVisible(true);
            this.actionCancelCancel.setVisible(true);
            this.btnAudit.setVisible(true);
            this.btnUnAudit.setVisible(true);
            this.menuItemAudit.setVisible(true);
            this.menuItemUnAudit.setVisible(true);
            this.btnUnAudit.setVisible(true);
            this.menuItemAudit.setVisible(true);
            this.menuItemUnAudit.setVisible(true);
            this.btnAuditEntry.setVisible(false);
            this.btnUnAuditEntry.setVisible(false);
            this.menuItemAuditEntry.setVisible(false);
            this.menuItemUnAuditEntry.setVisible(false);
        } else {
            this.actionCancel.setVisible(false);
            this.actionCancelCancel.setVisible(false);
            this.actionWorkFlowG.setVisible(false);
            this.menuWorkFlow.setVisible(false);
            this.actionQueryScheme.setVisible(false);
            this.actionAddLine.setVisible(true);
            this.menuExportData.setVisible(false);
            this.menuImportData.setVisible(false);
            this.actionEdit.setVisible(true);
            this.actionCancel.setVisible(false);
            this.actionCancelCancel.setVisible(false);
            this.btnAudit.setVisible(false);
            this.btnUnAudit.setVisible(false);
            this.menuItemAudit.setVisible(false);
            this.menuItemUnAudit.setVisible(false);
            this.btnAuditEntry.setVisible(true);
            this.btnUnAuditEntry.setVisible(true);
            this.menuItemAuditEntry.setVisible(true);
            this.menuItemUnAuditEntry.setVisible(true);
            this.btnUnAuditEntry.setVisible(true);
            this.menuItemAuditEntry.setVisible(true);
            this.menuItemUnAuditEntry.setVisible(true);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (this.isDisplayEntries) {
            super.tblMain_tableClicked(e);
        } else if (e.getClickCount() == 2) {
            this.showDetailList();
        }
    }

    private void setTableRowHide(KDTable kdtEntries, String[] rowNames, boolean isHide) {
        if (isHide) {
            int n = rowNames.length;
            for (int i = 0; i < n; ++i) {
                if (rowNames[i] == null || kdtEntries.getColumn(rowNames[i]) == null) continue;
                kdtEntries.getColumn(rowNames[i]).setWidth(-1);
                kdtEntries.getColumn(rowNames[i]).getStyleAttributes().setHided(isHide);
            }
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (!this.isDisplayEntries) {
            this.tHelper.setQuerySolutionInfo(null);
        }
        this.refreshEntry();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        ArrayList aids = this.getSelectedFieldValues("saleOrgUnit.id");
        if (aids.size() == 1) {
            pk = new ObjectUuidPK(aids.get(0).toString());
            OrgUnitInfo orgInfo = new OrgUnitInfo();
            orgInfo.setId(BOSUuid.read((String)aids.get(0).toString()));
            this.getMainOrgContext().put((Object)this.getMainBizOrgType(), (Object)orgInfo);
        } else if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectStringPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
        }
        return pk;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        String[] PIRCE_COLUMNS = new String[]{"entries.price"};
        try {
            rowSet.beforeFirst();
            Object colMap = null;
            int pricePrecision = 4;
            while (rowSet.next()) {
                BigDecimal price = BigDecimal.ZERO;
                BigDecimal discountedPrice = BigDecimal.ZERO;
                if (rowSet.getInt("material.pricePrecision") > 0) {
                    pricePrecision = rowSet.getInt("material.pricePrecision");
                }
                this.pricisionMap.put(rowSet.getString("entries.id"), pricePrecision);
                if (rowSet.getBigDecimal("entries.price") != null) {
                    price = rowSet.getBigDecimal("entries.price");
                }
                if (rowSet.getBigDecimal("discountedPrice") != null) {
                    discountedPrice = rowSet.getBigDecimal("discountedPrice");
                }
                price = price.setScale(pricePrecision, 4);
                discountedPrice = discountedPrice.setScale(pricePrecision, 4);
                rowSet.updateBigDecimal("entries.price", price);
                rowSet.updateBigDecimal("discountedPrice", discountedPrice);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        IRow row = null;
        String entryId = "";
        int firstIndex = e.getFirstRow();
        int lastIndex = e.getLastRow();
        int count = lastIndex;
        for (int i = firstIndex; i <= count; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("entries.id").getValue() == null || !this.pricisionMap.containsKey(entryId = row.getCell("entries.id").getValue().toString())) continue;
            int pricision = this.pricisionMap.get(entryId);
            row.getCell("entries.price").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatPattern((int)pricision));
            row.getCell("discountedPrice").getStyleAttributes().setNumberFormat(PrecisionUtil.getFormatPattern((int)pricision));
        }
    }

    protected void initDapButtons() throws Exception {
        this.separatorFW4.setVisible(false);
        this.actionVoucher.setVisible(false);
        this.actionVoucher.setEnabled(false);
        this.actionDelVoucher.setVisible(false);
        this.actionDelVoucher.setEnabled(false);
    }

    @Override
    public void actionShareDistribute_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        KDTSelectManager sm = this.tblMain.getSelectManager();
        int blockCount = sm.size();
        for (int i = 0; i < blockCount; ++i) {
            KDTSelectBlock block = sm.get(i);
            int bottom = block.getBottom();
            for (int j = block.getTop(); j <= bottom; ++j) {
                Integer value;
                BizEnumValueInfo checkedStatus;
                IRow row = this.tblMain.getRow(j);
                if (row.getCell("checkedStatus").getValue() != null && (checkedStatus = (BizEnumValueInfo)row.getCell("checkedStatus").getValue()).getInt() != 2) {
                    throw new PricePolicyException(PricePolicyException.DISTRIBUTEEXP_UNAUDIT);
                }
                Object blockedStatus = row.getCell("blockedStatus").getValue();
                if (blockedStatus != null && ((BizEnumValueDTO)blockedStatus).getInt() == 2) {
                    throw new PricePolicyException(PricePolicyException.DISTRIBUTEEXP_BLOCK);
                }
                Object entryCheSta = row.getCell("entries.checkedStatus").getValue();
                if (entryCheSta != null && ((BizEnumValueInfo)entryCheSta).getInt() != 2) {
                    throw new PricePolicyException(PricePolicyException.DISTRIBUTEENTRYEXP_UNAUDIT);
                }
                Object priceComposition = row.getCell("priceComposition").getValue();
                if (priceComposition == null || (value = Integer.valueOf(((BizEnumValueDTO)priceComposition).getValue().toString())) == 2 || value == 7) continue;
                throw new PricePolicyException(PricePolicyException.DISTRIBUTEEXP_UNMC_OR_UNCM);
            }
        }
        ArrayList salOrgUnitIDs = this.getSelectedFieldValues("saleOrgUnit.id");
        if (salOrgUnitIDs.size() > 1) {
            throw new PricePolicyException(PricePolicyException.DISTRIBUTE_ONESALEORG);
        }
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"billIDList", (Object)this.getSelectedFieldValues("entries.id"));
        uiCtx.put((Object)"saleOrg", salOrgUnitIDs.get(0));
        uiCtx.put((Object)"Title", (Object)EASResource.getString((String)RESOURCE, (String)"sale_assign_title"));
        String uimode = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        UICreator.create((String)AssignPricePolicySelectMultiOrgsUi.class.getName(), (String)uimode, (UIContext)uiCtx);
    }

    @Override
    public void actionViewShareDistributeResult_actionPerformed(ActionEvent e) throws Exception {
        ArrayList entryIds = this.getSelectedFieldValues("entries.id");
        UIContext uiContext = new UIContext((Object)this);
        if (entryIds == null || entryIds.size() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        uiContext.put((Object)"entryIds", (Object)entryIds);
        uiContext.put((Object)"purOrgInfo", (Object)this.getMainOrgInfo());
        UICreator.create((String)AssignPricePolicyForResultView.class.getName(), (String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory", (UIContext)uiContext);
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnShareDistribute.setIcon(EASResource.getIcon((String)"imgTbtn_distributebatch"));
        this.btnShareDistributeResult.setIcon(EASResource.getIcon((String)"imgTbtn_seeallot"));
    }

    class PrintListener
    implements IPrintActionListener {
        PrintListener() {
        }

        public void beforePrintOrPreview() {
        }

        public void beforePreview() {
        }

        public void beforePrint() {
            BDInvClientUtils.logUIOperation("LOG_PRINT", new PricePolicyInfo().getBOSType());
        }

        public void closePreview() {
        }
    }
}

