/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardCollection;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroupStandard;
import com.kingdee.eas.basedata.master.cssp.StandardTypeEnum;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.org.client.f7.NewSaleF7;
import com.kingdee.eas.basedata.scm.common.PriceCompDetailEnum;
import com.kingdee.eas.basedata.scm.common.PriceCompositionEnum;
import com.kingdee.eas.basedata.scm.sd.sale.CheckedStatusEnum;
import com.kingdee.eas.basedata.scm.sd.sale.ForbidStatusEnum;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyAgent;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyCollection;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyException;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyInfo;
import com.kingdee.eas.basedata.scm.sd.sale.client.AbstractPricePolicyOptionsEditUI;
import com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicyDetailViewListUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.EntityViewInfoUtil;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class PricePolicyOptionsEditUI
extends AbstractPricePolicyOptionsEditUI
implements ItemListener {
    private static final Logger logger = CoreUIObject.getLogger(PricePolicyOptionsEditUI.class);
    private boolean isfirstload = false;
    private static final String RESOURCE = "com.kingdee.eas.basedata.scm.sd.sale.client.PricePolicy";

    @Override
    public void storeFields() {
        this.editData.setSyncOldValue(true);
        if (this.editData.getEffectiveDate() == null) {
            this.editData.setEffectiveDate(new Date());
        }
        if (this.editData.getExpireDate() == null) {
            this.editData.setExpireDate(this.getExpireDate());
        }
        super.storeFields();
        PriceCompDetailEnum customeritem = (PriceCompDetailEnum)((Object)this.comboPriceCompDetailCustomer.getSelectedItem());
        PriceCompDetailEnum materialitem = (PriceCompDetailEnum)((Object)this.comboPriceCompDetailMaterial.getSelectedItem());
        int customer = customeritem.getValue();
        int material = materialitem.getValue();
        this.editData.setPriceComposition(PriceCompositionEnum.getEnum(customer ^ material));
        this.editData.setSyncOldValue(false);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null && this.editData.getCheckedStatus() != CheckedStatusEnum.UNAUDITED && this.editData.getCheckedStatus() != CheckedStatusEnum.ADDNEW) {
            throw new PricePolicyException(PricePolicyException.CANNOTSAVE);
        }
        super.actionSave_actionPerformed(e);
        int res = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"PRICEPOLICYSAVE"));
        if (res == 0 && this.destroyWindow()) {
            this.showDetailList();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        super.actionSubmit_actionPerformed(e);
        int res = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"PRICEPOLICYSUBMIT"));
        if (res == 0 && this.destroyWindow()) {
            this.showDetailList();
        }
    }

    private void showDetailList() throws UIException {
        ArrayList<String> sids = new ArrayList<String>();
        sids.add(this.editData.getId().toString());
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"pricePolicyIds", sids);
        uiContext.put((Object)"pricePolicyId", (Object)sids.get(0).toString());
        PricePolicyInfo tempInfo = null;
        if (sids != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)((String)sids.get(0))));
            try {
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("checkedStatus"));
                sic.add(new SelectorItemInfo("blockedStatus"));
                sic.add(new SelectorItemInfo("saleOrgUnit.id"));
                sic.add(new SelectorItemInfo("saleOrgUnit.number"));
                sic.add(new SelectorItemInfo("saleOrgUnit.name"));
                sic.add(new SelectorItemInfo("effectiveDate"));
                sic.add(new SelectorItemInfo("expireDate"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.EQUALS));
                view.setFilter(filter);
                view.setSelector(sic);
                EntityViewInfoUtil.setBaseOnSelector((EntityViewInfo)view);
                PricePolicyCollection ppc = PricePolicyFactory.getRemoteInstance().getPricePolicyCollection(view);
                if (ppc != null && ppc.size() > 0) {
                    tempInfo = ppc.get(0);
                }
            }
            catch (BOSException e1) {
                logger.error((Object)e1);
                this.handUIExceptionAndAbort((Exception)((Object)e1));
            }
        }
        uiContext.put((Object)"pricePolicyInfo", tempInfo);
        IUIWindow popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(PricePolicyDetailViewListUI.class.getName(), (Map)uiContext, null);
        popUI.show();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        this.checkData();
    }

    private void checkData() throws Exception {
        PricePolicyException exception;
        if (this.prmtSaleOrgUnit.isRequired() && this.isNull(this.editData.getSaleOrgUnit())) {
            MsgBox.showInfo((Component)((Object)this), (String)SCMClientUtils.getResource((String)"SALEORGNOTNULL"));
            SysUtil.abort();
        }
        if (this.isNull(this.editData.getNumber()) || this.editData.getNumber() != null && "".equals(this.editData.getNumber().trim())) {
            this.txtNumber.requestFocus();
            throw new PricePolicyException(PricePolicyException.NUMBERISNULL);
        }
        if (this.isNull(this.editData.getName()) || this.editData.getName() != null && "".equals(this.editData.getName().trim())) {
            this.txtName.requestFocus();
            throw new PricePolicyException(PricePolicyException.NAMEISNULL);
        }
        if (this.isNull((Object)this.editData.getPriceCompDetailCustomer())) {
            this.comboPriceCompDetailCustomer.requestFocus();
            throw new PricePolicyException(PricePolicyException.CUSTOMERCOMISNULL);
        }
        if (this.isNull((Object)this.editData.getPriceCompDetailmaterial())) {
            this.comboPriceCompDetailMaterial.requestFocus();
            throw new PricePolicyException(PricePolicyException.MATERIALCOMISNULL);
        }
        if (this.editData.getEffectiveDate() == null) {
            exception = new PricePolicyException(PricePolicyException.EFFECTIVEDATEISNULL);
            this.showMessageInfo(exception.getMessage());
        }
        if (this.editData.getExpireDate() == null) {
            exception = new PricePolicyException(PricePolicyException.EXPIREDATEISNULL);
            this.showMessageInfo(exception.getMessage());
        }
        if (this.editData.getEffectiveDate().compareTo(this.editData.getExpireDate()) > 0) {
            exception = new PricePolicyException(PricePolicyException.VERIFY_EXP_NOT_SMALLER_THAN_EFF);
            this.showMessageInfo(exception.getMessage());
        }
    }

    private boolean isNull(Object o) {
        return o == null || o.toString() != null && o.toString().equals("");
    }

    private void showMessageInfo(String msg) {
        MsgBox.showInfo((String)msg);
        SysUtil.abort();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        ((PricePolicyInfo)newData).setCheckedStatus(CheckedStatusEnum.ADDNEW);
        ((PricePolicyInfo)newData).setBlockedStatus(ForbidStatusEnum.UNFORBID);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkedBlockForEdit();
        super.actionEdit_actionPerformed(e);
    }

    public void checkedBlockForEdit() throws Exception {
        if (this.editData.getId() != null) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("checkedStatus"));
            sic.add(new SelectorItemInfo("blockedStatus"));
            sic.add(new SelectorItemInfo("saleOrgUnit.id"));
            sic.add(new SelectorItemInfo("saleOrgUnit.number"));
            sic.add(new SelectorItemInfo("saleOrgUnit.name"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            view.setSelector(sic);
            EntityViewInfoUtil.setBaseOnSelector((EntityViewInfo)view);
            PricePolicyInfo ppi = null;
            PricePolicyCollection ppc = PricePolicyFactory.getRemoteInstance().getPricePolicyCollection(view);
            if (ppc != null && ppc.size() > 0) {
                ppi = ppc.get(0);
                if (ForbidStatusEnum.FORBID == ppi.getBlockedStatus()) {
                    throw new PricePolicyException(PricePolicyException.CANNOTEDIT2);
                }
                if (ppi.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
                    throw new PricePolicyException(PricePolicyException.AUDITPOLICYCANNOTEDIT);
                }
            }
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        this.isfirstload = true;
        super.onLoad();
        this.initUIOnLoad();
        if (this.getMainBizOrg() != null) {
            this.setMainBizOrgF7(this.getMainBizOrg(), this.getMainBizOrgType());
        }
        this.isfirstload = false;
        this.txtName.setMaxLength(80);
        this.txtNumber.setMaxLength(80);
    }

    @Override
    public void loadFields() {
        this.comboPriceCompDetailCustomer.addItemListener((ItemListener)this);
        this.comboPriceCompDetailMaterial.addItemListener((ItemListener)this);
        super.loadFields();
        this.initPricePolicyStatus();
        this.initCustomerGroupStandard();
        this.initBtnState();
        Object saleOrg = this.prmtSaleOrgUnit.getValue();
        this.getUIContext().put(this.getMainBizOrgType(), saleOrg);
        this.initF7Org();
        this.comboPriceCompDetailCustomer.addItemListener((ItemListener)this);
        this.comboPriceCompDetailMaterial.addItemListener((ItemListener)this);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 1) {
            return;
        }
        if (evt.getSource() == this.comboPriceCompDetailCustomer) {
            this.setPriceComp();
        } else if (evt.getSource() == this.comboPriceCompDetailMaterial) {
            this.setPriceComp();
        }
    }

    private void setPriceComp() {
        PriceCompDetailEnum customerEnum = (PriceCompDetailEnum)((Object)this.comboPriceCompDetailCustomer.getSelectedItem());
        PriceCompDetailEnum materialEnum = (PriceCompDetailEnum)((Object)this.comboPriceCompDetailMaterial.getSelectedItem());
        if (customerEnum == null || materialEnum == null) {
            return;
        }
        int value = customerEnum.getValue() ^ materialEnum.getValue();
        switch (value) {
            case 2: {
                this.priceComposition.setSelectedItem((Object)PriceCompositionEnum.CM);
                break;
            }
            case 1: {
                this.priceComposition.setSelectedItem((Object)PriceCompositionEnum.CGM);
                break;
            }
            case 5: {
                this.priceComposition.setSelectedItem((Object)PriceCompositionEnum.CMG);
                break;
            }
            case 6: {
                this.priceComposition.setSelectedItem((Object)PriceCompositionEnum.CGMG);
            }
        }
    }

    private void initPricePolicyStatus() {
        if (this.editData != null && this.editData.getCheckedStatus() == CheckedStatusEnum.AUDITED) {
            this.txtName.setEnabled(false);
            this.txtNumber.setEnabled(false);
            this.prmtSaleOrgUnit.setEnabled(false);
            this.txtPriority.setEnabled(false);
            this.pkEffectiveDate.setEnabled(false);
            this.pkExpireDate.setEnabled(false);
            this.comboPriceCompDetailCustomer.setEnabled(false);
            this.comboPriceCompDetailMaterial.setEnabled(false);
        } else if (this.editData != null && this.editData.getCheckedStatus() != CheckedStatusEnum.AUDITED && (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.ADDNEW))) {
            this.txtName.setEnabled(true);
            this.txtNumber.setEnabled(true);
            this.txtPriority.setEnabled(true);
            this.pkEffectiveDate.setEnabled(true);
            this.pkExpireDate.setEnabled(true);
            this.prmtSaleOrgUnit.setEnabled(false);
            this.comboPriceCompDetailCustomer.setEnabled(false);
            this.comboPriceCompDetailMaterial.setEnabled(false);
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                this.prmtSaleOrgUnit.setEnabled(true);
                this.comboPriceCompDetailCustomer.setEnabled(true);
                this.comboPriceCompDetailMaterial.setEnabled(true);
                this.comboCustomerGroupStandard.setEnabled(true);
            }
        }
    }

    private void initCustomerGroupStandard() {
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            this.comboCustomerGroupStandard.addItem((Object)this.editData.getGroupStandardCustomer());
            this.comboCustomerGroupStandard.setSelectedItem((Object)this.editData.getGroupStandardCustomer());
            return;
        }
        try {
            ICSSPGroupStandard cs = CSSPGroupStandardFactory.getRemoteInstance();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(0)));
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(1)));
            SaleOrgUnitInfo saleOrg = (SaleOrgUnitInfo)this.prmtSaleOrgUnit.getValue();
            String longNum = "";
            StringBuffer sb = new StringBuffer("");
            longNum = saleOrg == null ? SysContext.getSysContext().getCurrentCtrlUnit().getLongNumber() : saleOrg.getLongNumber();
            String[] longNums = longNum.split("!");
            sb.append("(");
            int size = longNums.length;
            for (int j = 0; j < size; ++j) {
                sb.append("'");
                sb.append(longNums[j]);
                sb.append("'");
                if (j >= size - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            CtrlUnitCollection cuCol = CtrlUnitFactory.getRemoteInstance().getCtrlUnitCollection(" where number in " + sb.toString());
            HashSet<String> cuSet = new HashSet<String>();
            int csize = cuCol.size();
            for (int c = 0; c < csize; ++c) {
                cuSet.add(cuCol.get(c).getId().toString());
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("CU", cuSet, CompareType.INCLUDE));
            filterInfo.setMaskString(" (#0 or #1)and #2 ");
            entityViewInfo.setFilter(filterInfo);
            CSSPGroupStandardCollection coll = cs.getCSSPGroupStandardCollection(entityViewInfo);
            int size2 = coll.size();
            this.comboCustomerGroupStandard.removeAllItems();
            for (int i = 0; i < size2; ++i) {
                this.comboCustomerGroupStandard.addItem((Object)coll.get(i));
                if (coll.get(i) == null || coll.get(i).getIsBasic() != StandardTypeEnum.basicStandard) continue;
                this.comboCustomerGroupStandard.setSelectedIndex(i);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
    }

    private void initBtnState() {
        int billStatus;
        if (this.editData.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED) || this.editData.getCheckedStatus().equals((Object)CheckedStatusEnum.SUBMIT)) {
            this.actionSave.setEnabled(false);
        }
        if (this.editData.getCheckedStatus().equals((Object)CheckedStatusEnum.AUDITED)) {
            this.actionSubmit.setEnabled(false);
        }
        int n = billStatus = this.editData == null || this.editData.getCheckedStatus() == null ? 0 : this.editData.getCheckedStatus().getValue();
        if (billStatus == 0 || this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.getMainBizOrg() != null) {
                this.getMainBizOrg().setReadOnly(false);
                this.getMainBizOrg().setEnabled(true);
                this.getMainBizOrg().setEditable(true);
            }
            this.actionEdit.setEnabled(false);
            this.comboPriceCompDetailCustomer.setEnabled(true);
            this.comboPriceCompDetailMaterial.setEnabled(true);
            this.comboCustomerGroupStandard.setEnabled(true);
        } else {
            if (this.editData != null && this.editData.getBlockedStatus() == ForbidStatusEnum.FORBID) {
                this.actionEdit.setEnabled(false);
            } else {
                this.actionEdit.setEnabled(!OprtState.EDIT.equals(this.getOprtState()));
            }
            this.comboPriceCompDetailCustomer.setEnabled(false);
            this.comboPriceCompDetailMaterial.setEnabled(false);
            this.comboCustomerGroupStandard.setEnabled(false);
        }
    }

    private void initUIOnLoad() {
        if (this.isfirstload && this.getOprtState().equals("ADDNEW")) {
            this.setMainSaleOrgPrmt();
        }
        this.menuItemSave.setVisible(true);
        this.comboBlockedStatus.setEditable(false);
        this.comboBlockedStatus.setEnabled(false);
        this.comboCheckedStatus.setEditable(false);
        this.comboCheckedStatus.setEnabled(false);
        this.txtNumber.setRequired(true);
        this.txtName.setRequired(true);
        this.prmtSaleOrgUnit.setRequired(true);
        this.comboPriceCompDetailCustomer.setRequired(true);
        this.actionSave.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_save"));
        this.actionSubmit.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.menuBiz.setVisible(false);
    }

    private void setMainSaleOrgPrmt() {
        OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        if (orgUnitInfo.isIsSaleOrgUnit()) {
            SaleOrgUnitInfo saleOrgUnitInfo = null;
            try {
                ObjectUuidPK pk = new ObjectUuidPK(orgUnitInfo.getId().toString());
                saleOrgUnitInfo = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)pk);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                this.handUIException(e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
                this.handUIException(e);
            }
            this.getMainBizOrg().setValue((Object)saleOrgUnitInfo);
        } else {
            try {
                this.getMainBizOrg().setValue((Object)this.getParentSaleOrg(orgUnitInfo.getId().toString()));
            }
            catch (EASBizException e) {
                this.getMainBizOrg().setValue(null);
                logger.error((Object)e);
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.getMainBizOrg().setValue(null);
                logger.error((Object)e);
                this.handUIException(e);
            }
        }
    }

    private SaleOrgUnitInfo getParentSaleOrg(String id) throws BOSException, EASBizException {
        SaleOrgUnitInfo saleInfo = null;
        FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
        if (fullOrgUnitInfo == null) {
            return null;
        }
        if (fullOrgUnitInfo.isIsSaleOrgUnit()) {
            String saleOrgId = fullOrgUnitInfo.getId().toString();
            saleInfo = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(saleOrgId));
        } else if (fullOrgUnitInfo.getParent() != null) {
            String orgId = fullOrgUnitInfo.getParent().getId().toString();
            saleInfo = this.getParentSaleOrg(orgId);
        }
        return saleInfo;
    }

    protected void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType) {
        NewSaleF7 model = null;
        if (orgType.equals((Object)OrgType.Sale)) {
            model = new NewSaleF7();
        }
        NewOrgUnitFilterInfoProducer iProducer = null;
        iProducer = model != null ? new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)model) : new NewOrgUnitFilterInfoProducer(orgType);
        String permissionItem = this.getPermissionItem(this.getOprtState());
        if (permissionItem != null) {
            iProducer.getModel().setPermissionItem(permissionItem);
        }
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    protected IObjectValue createNewData() {
        PricePolicyAgent ppi = null;
        try {
            ppi = PricePolicyAgent.create();
        }
        catch (BOSException ex) {
            super.handleException((Exception)((Object)ex));
        }
        ppi.setBlockedStatus(ForbidStatusEnum.UNFORBID);
        ppi.setCheckedStatus(CheckedStatusEnum.ADDNEW);
        ppi.setPriceComposition(PriceCompositionEnum.CM);
        ppi.setPriceCompDetailCustomer(PriceCompDetailEnum.CUSTOMER);
        ppi.setPriceCompDetailmaterial(PriceCompDetailEnum.MATERIAL);
        ppi.setEffectiveDate(new Date());
        ppi.setExpireDate(this.getExpireDate());
        if (this.getDefaultMainBizOrg() instanceof SaleOrgUnitInfo) {
            ppi.setSaleOrgUnit((SaleOrgUnitInfo)this.getDefaultMainBizOrg());
        } else {
            ppi.setSaleOrgUnit(null);
        }
        return ppi;
    }

    protected final OrgUnitInfo getDefaultMainBizOrg() {
        int i;
        OrgUnitInfo[] mainOrgs = null;
        try {
            FullOrgUnitCollection collection = SCMGroupClientUtils.getAuthOrgByPermItem((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (OrgType)this.getMainBizOrgType(), (String)this.getPermissionItem("ADDNEW"));
            if (collection == null) {
                mainOrgs = new OrgUnitInfo[]{};
                return null;
            }
            if (collection != null && collection.size() > 0) {
                mainOrgs = new OrgUnitInfo[collection.size()];
                for (i = 0; i < collection.size(); ++i) {
                    mainOrgs[i] = collection.get(i);
                }
            }
            if (mainOrgs.length > 0) {
                mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        OrgUnitInfo currentMainOrg = SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
        if (currentMainOrg != null && mainOrgs != null && mainOrgs.length > 0) {
            for (i = 0; i < mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(mainOrgs[i].getId().toString())) continue;
                return currentMainOrg;
            }
        }
        if (mainOrgs != null && mainOrgs.length > 0) {
            return mainOrgs[0];
        }
        return null;
    }

    protected String getPermissionItem(String status) {
        if (status.equals("ADDNEW")) {
            return "pricepolicy_addnew";
        }
        return null;
    }

    private Date getExpireDate() {
        Calendar cl = Calendar.getInstance();
        cl.set(cl.get(1) + 10, cl.get(2), cl.get(5));
        return cl.getTime();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PricePolicyFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtSaleOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = this.getSelectors();
        SelectorItemCollection dynColl = this.getDynSelectorItemCollection();
        int size = dynColl.size();
        for (int i = 0; i < size; ++i) {
            sic.add(dynColl.get(i));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(sic);
        EntityViewInfoUtil.setBaseOnSelector((EntityViewInfo)view);
        PricePolicyInfo info = null;
        PricePolicyCollection ppc = PricePolicyFactory.getRemoteInstance().getPricePolicyCollection(view);
        if (ppc != null && ppc.size() > 0) {
            info = ppc.get(0);
        }
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("priority"));
        sic.add(new SelectorItemInfo("effectiveDate"));
        sic.add(new SelectorItemInfo("expireDate"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("blockedStatus"));
        sic.add(new SelectorItemInfo("groupStandardCustomer.*"));
        sic.add(new SelectorItemInfo("priceCompDetailCustomer"));
        sic.add(new SelectorItemInfo("priceCompDetailMaterial"));
        sic.add(new SelectorItemInfo("priceComposition"));
        sic.add(new SelectorItemInfo("saleOrgUnit.*"));
        return sic;
    }

    protected void showSaveSuccess() {
    }

    protected void showSubmitSuccess() {
    }
}

