/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.scm.sd.sale.client.AbstractPricePolicyQueryPanelUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PricePolicyQueryPanelUI
extends AbstractPricePolicyQueryPanelUI {
    public static final Color NECESSARYCOLOR = SCMClientUtils.necessaryColor;
    private static String RES = "com.kingdee.eas.basedata.scm.sd.sale.BDScmSaleResource";
    private static final Logger logger = CoreUIObject.getLogger(PricePolicyQueryPanelUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        this.prmtOrgUnit.setRequired(true);
        this.prmtMaterial.setRequired(true);
        this.prmtCustomer.setRequired(true);
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Sale);
        FilterInfo filter = iProducer.getFilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        this.prmtOrgUnit.setEntityViewInfo(viewInfo);
        this.prmtOrgUnit.setSelector((KDPromptSelector)iProducer.getModel());
        this.prmtOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.FullOrgUnitQuery");
        this.prmtCustomer.setCommitFormat("$number$");
        this.prmtMaterial.setCommitFormat("$number$");
        this.prmtOrgUnit.setCommitFormat("$number$");
    }

    protected HashMap getQueryConditions() throws Exception {
        ArrayList keyList = this.getKeySequence();
        HashMap map = new HashMap();
        if (this.prmtCustomer.getData() != null) {
            CustomerInfo customerInfo = (CustomerInfo)this.prmtCustomer.getData();
            String customerNumber = customerInfo.getNumber();
            map.put(keyList.get(0), customerNumber);
        }
        if (this.prmtMaterial.getData() != null) {
            MaterialInfo materialInfo = (MaterialInfo)this.prmtMaterial.getData();
            String materialnum = materialInfo.getNumber();
            map.put(keyList.get(1), materialnum);
        }
        if (this.prmtOrgUnit.getData() != null) {
            SaleOrgUnitInfo saleorgInfo = (SaleOrgUnitInfo)this.prmtOrgUnit.getData();
            String companyNumber = saleorgInfo.getNumber();
            map.put(keyList.get(2), companyNumber);
        }
        return map;
    }

    protected void loadQueryConditions(HashMap conditionMap) throws Exception {
        String companyNumber;
        String mateiralnumber;
        CustomerCollection col;
        FilterInfo filterInfo;
        EntityViewInfo viewInfo;
        String customerNumber;
        ArrayList keyList = this.getKeySequence();
        if (conditionMap.containsKey(keyList.get(0)) && (customerNumber = (String)conditionMap.get(keyList.get(0))) != null) {
            viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)customerNumber, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            ICustomer iCustomer = CustomerFactory.getRemoteInstance();
            col = iCustomer.getCustomerCollection(viewInfo);
            if (col.size() > 0) {
                this.prmtCustomer.setData((Object)col.get(0));
            }
        }
        if (conditionMap.containsKey(keyList.get(1)) && (mateiralnumber = (String)conditionMap.get(keyList.get(1))) != null) {
            viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)mateiralnumber, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            IMaterial imaterial = MaterialFactory.getRemoteInstance();
            col = imaterial.getMaterialCollection(viewInfo);
            if (col.size() > 0) {
                this.prmtMaterial.setData((Object)col.get(0));
            }
        }
        if (conditionMap.containsKey(keyList.get(2)) && (companyNumber = (String)conditionMap.get(keyList.get(2))) != null) {
            viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("*"));
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumber, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            ISaleOrgUnit isale = SaleOrgUnitFactory.getRemoteInstance();
            col = isale.getSaleOrgUnitCollection(viewInfo);
            if (col.size() > 0) {
                this.prmtOrgUnit.setData((Object)col.get(0));
            }
        }
    }

    protected void verify() throws Exception {
        if (this.prmtCustomer.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("CUSTOMERNOTNULL"));
            SysUtil.abort();
        }
        if (this.prmtMaterial.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("MATERIALNOTNULL"));
            SysUtil.abort();
        }
        if (this.prmtOrgUnit.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)this.getResource("ORGNOTNULL"));
            SysUtil.abort();
        }
    }

    protected void clear() {
        this.prmtCustomer.setData(null);
        this.prmtMaterial.setData(null);
        this.prmtOrgUnit.setData(null);
    }

    public ArrayList getKeySequence() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("customer");
        list.add("material");
        list.add("saleorg");
        return list;
    }

    private String getResource(String key) {
        return EASResource.getString((String)RES, (String)key);
    }
}

