/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.CheckedStatusEnum;
import com.kingdee.eas.basedata.scm.sd.sale.client.AbstractPricePolicyQueryUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.EntityViewInfoUtil;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class PricePolicyQueryUI
extends AbstractPricePolicyQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(PricePolicyQueryUI.class);
    private Set saleOrgInfosSet = null;
    private DataChangeListener saleOrgUnitListener = null;

    public PricePolicyQueryUI() throws Exception {
        this.initCondition();
        this.addListener();
    }

    private void addListener() {
        if (this.saleOrgUnitListener == null) {
            this.saleOrgUnitListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    PricePolicyQueryUI.this.setPricePolicyF7(PricePolicyQueryUI.this.prmtPricePolicy);
                }
            };
        }
        this.prmtSaleOrgUnit.addDataChangeListener(this.saleOrgUnitListener);
    }

    private void initCondition() {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement element = new SingleFilterElement("saleOrgUnit.number", (Component)this.prmtSaleOrgUnit);
        element.setCompareType(CompareType.INCLUDE);
        elements.add((FilterElement)element);
        SingleFilterElement pricePolicyElement = new SingleFilterElement("number", (Component)this.prmtPricePolicy);
        pricePolicyElement.setCompareType(CompareType.INCLUDE);
        elements.add((FilterElement)pricePolicyElement);
        SingleFilterElement checkedStatusElement = new SingleFilterElement("checkedStatus", (Component)this.comboBaseStatus, (Object)CheckedStatusEnum.NULL);
        checkedStatusElement.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)checkedStatusElement);
        this.getFilterManager().setElement((FilterElement)elements);
        this.dateFrom.setValue(null);
        this.dateTo.setValue(null);
    }

    private void setMainSaleOrgPrmt() {
        OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        if (orgUnitInfo.isIsSaleOrgUnit()) {
            this.getMainBizOrgF7().setValue((Object)orgUnitInfo);
        } else {
            try {
                this.getMainBizOrgF7().setValue((Object)this.getParentSaleOrg(orgUnitInfo.getId().toString()));
            }
            catch (EASBizException e) {
                this.getMainBizOrgF7().setValue(null);
                logger.error((Object)e);
            }
            catch (BOSException e) {
                this.getMainBizOrgF7().setValue(null);
                logger.error((Object)e);
            }
        }
    }

    private SaleOrgUnitInfo getParentSaleOrg(String id) throws BOSException, EASBizException {
        SaleOrgUnitInfo saleInfo = null;
        FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
        if (fullOrgUnitInfo == null) {
            return null;
        }
        if (fullOrgUnitInfo.isIsSaleOrgUnit()) {
            String saleOrgId = fullOrgUnitInfo.getId().toString();
            saleInfo = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(saleOrgId));
        } else if (fullOrgUnitInfo.getParent() != null) {
            String orgId = fullOrgUnitInfo.getParent().getId().toString();
            saleInfo = this.getParentSaleOrg(orgId);
        }
        return saleInfo;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtSaleOrgUnit;
    }

    public boolean verify() {
        if (this.prmtSaleOrgUnit.getText() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)SCMClientUtils.getResource((String)"SALEORGNOTNULL"));
            return false;
        }
        return true;
    }

    protected String getViewPermission() {
        return "pricepolicy_view";
    }

    public void initMainBizOrg() {
    }

    public void clear() {
        this.getFilterManager().clearAll();
        try {
            this.setMainSaleOrgPrmt(this.getMainBizOrgF7());
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIException(e);
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    public boolean isSupportVirturalOrgs() {
        return true;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = super.getFilterInfo();
        if (this.dateFrom.getValue() == null && this.dateTo.getValue() == null) {
            return filter;
        }
        FilterInfo dateFilter = new FilterInfo();
        if (this.dateFrom.getValue() == null && this.dateTo.getValue() != null) {
            dateFilter.getFilterItems().add(new FilterItemInfo("expireDate", (Object)this.getOutDate("end", (Date)this.dateTo.getValue()), CompareType.LESS));
        }
        if (this.dateFrom.getValue() != null && this.dateTo.getValue() == null) {
            dateFilter.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)((Date)this.dateFrom.getValue()), CompareType.GREATER_EQUALS));
        }
        if (this.dateFrom.getValue() != null && this.dateTo.getValue() != null) {
            dateFilter.getFilterItems().add(new FilterItemInfo("effectiveDate", (Object)this.getOutDate("start", (Date)this.dateFrom.getValue()), CompareType.GREATER_EQUALS));
            dateFilter.getFilterItems().add(new FilterItemInfo("expireDate", (Object)this.getOutDate("end", (Date)this.dateTo.getValue()), CompareType.LESS));
        }
        try {
            filter.mergeFilter(dateFilter, "AND");
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return filter;
    }

    private Date getOutDate(String s, Date d) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        if (s.equals("start")) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        } else if (s.equals("end")) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5) + 1, 0, 0, 0);
        }
        return calendar.getTime();
    }

    public void onLoad() throws Exception {
        this.setMainSaleOrgPrmt(this.getMainBizOrgF7());
        super.onLoad();
        this.setSaleOrgUnitF7(this.prmtSaleOrgUnit);
        this.initUI();
    }

    private void initUI() {
        this.setPricePolicyF7(this.prmtPricePolicy);
        KDBizPromptBox[] prmtBoxs = new KDBizPromptBox[]{this.prmtPricePolicy};
        int length = prmtBoxs.length;
        for (int i = 0; i < length; ++i) {
            this.formatF7(prmtBoxs[i]);
        }
    }

    private void formatF7(KDBizPromptBox bizBox) {
        bizBox.setEditFormat("$number$");
        bizBox.setDisplayFormat("$number$");
        bizBox.setCommitFormat("$number$");
        bizBox.setCommitParser(null);
    }

    private void setSaleOrgUnitF7(KDBizPromptBox bizSaleOrgUnitBox) throws Exception {
        this.setMainSaleOrgPrmt(bizSaleOrgUnitBox);
        bizSaleOrgUnitBox.setQueryInfo("com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery");
        bizSaleOrgUnitBox.setEnabledMultiSelection(true);
        bizSaleOrgUnitBox.setEditFormat("$number$");
        bizSaleOrgUnitBox.setDisplayFormat("$number$");
        bizSaleOrgUnitBox.setCommitFormat("$number$");
    }

    private void setMainSaleOrgPrmt(KDBizPromptBox bizSaleOrgUnitBox) throws Exception {
        OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        Set saleOrgSet = this.getPermissionSaleOrgInfos(this.getViewPermission());
        try {
            if (saleOrgSet != null && saleOrgSet.size() > 0) {
                OrgUnitInfo[] orgUnitInfos = new OrgUnitInfo[saleOrgSet.size()];
                Iterator it = saleOrgSet.iterator();
                for (int i = 0; it.hasNext() && i < saleOrgSet.size(); ++i) {
                    orgUnitInfos[i] = (OrgUnitInfo)it.next();
                    if (!orgUnitInfo.getId().toString().equals(orgUnitInfos[i].getId().toString())) continue;
                    String orgId = orgUnitInfos[i].getId().toString();
                    SaleOrgUnitInfo orgInfo = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), this.getSelector());
                    bizSaleOrgUnitBox.setValue((Object)orgInfo);
                    return;
                }
                orgUnitInfos = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])orgUnitInfos, (boolean)true);
                String orgId = orgUnitInfos[0].getId().toString();
                SaleOrgUnitInfo orgInfo = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), this.getSelector());
                bizSaleOrgUnitBox.setValue((Object)orgInfo);
            }
        }
        catch (EASBizException e) {
            bizSaleOrgUnitBox.setValue(null);
            logger.error((Object)e);
        }
        catch (BOSException e) {
            bizSaleOrgUnitBox.setValue(null);
            logger.error((Object)e);
        }
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        this.setPricePolicyF7(this.prmtPricePolicy);
    }

    private void setPricePolicyF7(KDBizPromptBox bizPricePolicyBox) {
        EntityViewInfo view = new EntityViewInfo();
        this.prmtPricePolicy.setQueryInfo("com.kingdee.eas.basedata.scm.sd.sale.app.F7PricePolicyAllQuery");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        this.prmtPricePolicy.setSelectorCollection(sic);
        FilterInfo filterinfo = new FilterInfo();
        Set<String> saleOrgSet = new HashSet();
        if ((this.prmtSaleOrgUnit == null || this.prmtSaleOrgUnit.getValue() == null) && this.prmtSaleOrgUnit.getText() == null) {
            try {
                saleOrgSet = this.getPermissionSaleOrg(this.getViewPermission());
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        } else if (this.prmtSaleOrgUnit != null && this.prmtSaleOrgUnit.getValue() != null) {
            Object orgObj = this.prmtSaleOrgUnit.getValue();
            if (orgObj instanceof Object[]) {
                Object[] saleOrgs = (Object[])orgObj;
                int length = saleOrgs.length;
                for (int i = 0; i < length; ++i) {
                    saleOrgSet.add(this.getParams(saleOrgs[i]));
                }
            } else if (orgObj instanceof Object) {
                saleOrgSet.add(this.getParams(orgObj));
            } else if (orgObj instanceof String) {
                String[] saleOrgUnitInfos = orgObj.toString().split(";");
                int length = saleOrgUnitInfos.length;
                for (int i = 0; i < length; ++i) {
                    saleOrgSet.add(saleOrgUnitInfos[i].trim());
                }
            }
        } else if (this.prmtSaleOrgUnit != null && this.prmtSaleOrgUnit.getText() != null) {
            String[] saleOrgUnitInfos = this.prmtSaleOrgUnit.getText().split(";");
            int length = saleOrgUnitInfos.length;
            for (int i = 0; i < length; ++i) {
                saleOrgSet.add(saleOrgUnitInfos[i].trim());
            }
        }
        if (saleOrgSet != null && saleOrgSet.size() > 0) {
            filterinfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.number", saleOrgSet, CompareType.INCLUDE));
        } else {
            filterinfo.getFilterItems().add(new FilterItemInfo("saleOrgUnit.number", (Object)"-1", CompareType.INCLUDE));
        }
        view.setFilter(filterinfo);
        EntityViewInfoUtil.setBaseOnSelector((EntityViewInfo)view);
        this.prmtPricePolicy.setEntityViewInfo(view);
        this.prmtPricePolicy.setEnabledMultiSelection(true);
    }

    private String getParams(Object obj) {
        String getNumberMethod = "getNumber";
        StringBuffer number = new StringBuffer();
        try {
            Method method = obj.getClass().getMethod(getNumberMethod, null);
            number.append((String)method.invoke(obj, (Object[])null));
        }
        catch (Exception e) {
            logger.error((Object)e);
            return number.toString();
        }
        return number.toString();
    }

    private Set getPermissionSaleOrg(String permItem) throws Exception {
        HashSet<String> saleOrgIdSet = new HashSet<String>();
        Set saleOrgSet = this.getPermissionSaleOrgInfos(permItem);
        Iterator it = saleOrgSet.iterator();
        while (it.hasNext()) {
            saleOrgIdSet.add(((OrgUnitInfo)it.next()).getId().toString());
        }
        return saleOrgIdSet;
    }

    private Set getPermissionSaleOrgInfos(String permItem) throws Exception {
        if (this.saleOrgInfosSet != null && this.saleOrgInfosSet.size() > 0) {
            return this.saleOrgInfosSet;
        }
        this.saleOrgInfosSet = new HashSet();
        IPermission permission = PermissionFactory.getRemoteInstance();
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)OrgType.Sale));
        FullOrgUnitCollection orgUnitColl = permission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), OrgType.Sale, (IObjectPK)treePK, permItem);
        for (int i = 0; i < orgUnitColl.size(); ++i) {
            this.saleOrgInfosSet.add(orgUnitColl.get(i));
        }
        return this.saleOrgInfosSet;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection items = new SorterItemCollection();
        SorterItemInfo item = new SorterItemInfo("saleOrgUnit.number");
        item.setSortType(SortType.ASCEND);
        items.add(item);
        item = new SorterItemInfo("number");
        item.setSortType(SortType.ASCEND);
        items.add(item);
        return items;
    }
}

