/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.cssp.CustomerSupplierException;
import com.kingdee.eas.basedata.scm.common.client.BDInvClientUtils;
import com.kingdee.eas.basedata.scm.sd.sale.PriceTypeFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceTypeInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PriceTypeStateEnum;
import com.kingdee.eas.basedata.scm.sd.sale.client.AbstractPriceTypeEditUI;
import com.kingdee.eas.basedata.scm.sd.sale.client.SalesClientUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PriceTypeEditUI
extends AbstractPriceTypeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PriceTypeEditUI.class);

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected String getEditUIName() {
        return PriceTypeEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PriceTypeFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        PriceTypeInfo objectValue = new PriceTypeInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setState(PriceTypeStateEnum.NOTASSIGNED);
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.txtNumber.getText() == null || this.txtNumber.getText().length() == 0) {
            SalesClientUtils.showCannotBeEmptyMsg(SalesClientUtils.getString("PriceTypeNumber"));
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            String num = this.txtNumber.getText();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)num));
            if (PriceTypeFactory.getRemoteInstance().exists(filter)) {
                MsgBox.showInfo((String)SalesClientUtils.getString("NumberDuplicate"));
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionSubmitClose_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(e);
    }

    @Override
    public void actionCancelClose_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnSave.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.kDSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                KDSpinner sp = (KDSpinner)e.getSource();
                PriceTypeEditUI.this.setSpinner((JSpinner)sp, 0, sp.getValue());
            }
        });
        this.txtNumber.setMaxLength(40);
        this.txtName.setMaxLength(100);
        this.kDBizMultiLangArea1.setMaxLength(100);
    }

    private void setSpinner(JSpinner sp, int min, Object value) {
        int currentValue;
        if (value instanceof Integer && (currentValue = ((Integer)value).intValue()) <= min) {
            sp.setValue(new Integer(min));
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String num = this.txtNumber.getText();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)num));
        if (this.getOprtState().equals(OprtState.ADDNEW) && PriceTypeFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((String)SalesClientUtils.getString("NumberDuplicate"));
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("adminCU.id"));
        return sic;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        BDInvClientUtils.logUIOperation("LOG_PRINT", new PriceTypeInfo().getBOSType());
        super.actionPrint_actionPerformed(e);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.txtNumber.getText() == null || this.txtNumber.getText().trim().length() == 0) {
            this.txtNumber.requestFocus();
            throw new DataBaseException(DataBaseException.NUMBERNOTNULL);
        }
        if (this.txtName.getSelectedItem() == null) {
            this.txtName.requestFocus();
            throw new CustomerSupplierException(CustomerSupplierException.NAMENOTNULL);
        }
    }
}

