/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.sd.sale.SalePromotionPolicyTO;
import com.kingdee.eas.basedata.scm.sd.sale.client.AbstractPromotionPolicyMatchUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.TablePreferencesHelper;
import com.kingdee.eas.framework.config.UserPreferenceData;
import com.kingdee.eas.framework.config.client.ConfigServiceUtils;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PromotionPolicyMatchUI
extends AbstractPromotionPolicyMatchUI {
    private static final Logger logger = CoreUIObject.getLogger(PromotionPolicyMatchUI.class);
    private List promotionPolicyList = new ArrayList();
    private boolean isUpdateSaleOrder = false;
    private Map mappromotionPolicy = new HashMap();
    private Map mappromotionPresent = new HashMap();
    private List successConditionsUpdataList = new ArrayList();
    private List successConditionsAddRowList = new ArrayList();
    private List successConditionsDiscountList = new ArrayList();
    private BigDecimal ZERO = new BigDecimal("0.00");
    private int promotionType = 0;

    public PromotionPolicyMatchUI() throws Exception {
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    PromotionPolicyMatchUI.this.tblMain_tableClicked(e);
                }
                catch (Exception exc) {
                    PromotionPolicyMatchUI.this.handUIException(exc);
                }
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public List getSuccessConditionsUpdata() {
        return this.successConditionsUpdataList;
    }

    public List getSuccessConditionsAddRow() {
        return this.successConditionsAddRowList;
    }

    public List getSuccessConditionsDiscount() {
        return this.successConditionsDiscountList;
    }

    public boolean isUpdateSaleOrder() {
        return this.isUpdateSaleOrder;
    }

    public void setUpdateSaleOrder(boolean needRefresh) {
        this.isUpdateSaleOrder = needRefresh;
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed(true);
        super.onLoad();
        this.promotionPolicyList = (List)this.getUIContext().get("idList");
        this.promotionType = (Integer)this.getUIContext().get("promotionType");
        String str = ConfigServiceUtils.getUserConfigData((String)"displayConditionPromotion", (CoreUI)this);
        Boolean boolObj = null;
        boolObj = str != null ? Boolean.valueOf("true".equals(str)) : Boolean.valueOf("true");
        if (boolObj != null && boolObj instanceof Boolean) {
            this.cbIsSelect.setSelected(boolObj.booleanValue());
        }
        this.setFillTableData(this.cbIsSelect.isSelected(), true);
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        String billID = this.tblMain.getCell(this.tblMain.getSelectManager().getActiveRowIndex(), "FID").getValue().toString();
        BOSObjectType materialBosType = new BOSObjectType("3C3D5C68");
        if (!DynamicObjectFactory.getRemoteInstance().exists(materialBosType, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billID)))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)billID);
        IUIWindow itemRptUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.scm.sd.sale.client.PromotionPolicyEditUI", (Map)uiContext, null, OprtState.VIEW);
        itemRptUI.show();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.getResultData();
        this.setUpdateSaleOrder(true);
        this.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setUpdateSaleOrder(false);
        this.getUIWindow().close();
    }

    @Override
    public void cbIsSelect_actionPerformed(ActionEvent e) {
        this.setFillTableData(this.cbIsSelect.isSelected(), false);
    }

    public void setFillTableData(Boolean isSelect, Boolean isOnload) {
        this.tblMain.removeRows();
        if (this.promotionPolicyList != null && this.promotionPolicyList.size() > 0) {
            int size = this.promotionPolicyList.size();
            for (int i = 0; i < size; ++i) {
                SalePromotionPolicyTO salePriceTOList = (SalePromotionPolicyTO)this.promotionPolicyList.get(i);
                if (isOnload.booleanValue()) {
                    if (!this.mappromotionPolicy.containsKey(salePriceTOList.entryID)) {
                        this.mappromotionPolicy.put(salePriceTOList.entryID, salePriceTOList);
                    }
                    if (!this.mappromotionPresent.containsKey(salePriceTOList.groupNumber) && !salePriceTOList.isPresent.booleanValue()) {
                        this.mappromotionPresent.put(salePriceTOList.groupNumber.toString(), salePriceTOList);
                    }
                }
                if (isSelect.booleanValue() && !salePriceTOList.select.booleanValue()) continue;
                IRow newRow = this.tblMain.addRow();
                newRow.getStyleAttributes().setLocked(true);
                if (salePriceTOList.select.booleanValue() && salePriceTOList.isPresent.booleanValue() && salePriceTOList.presentLimit == 2) {
                    newRow.getCell("select").getStyleAttributes().setLocked(false);
                }
                newRow.getCell("select").setValue((Object)salePriceTOList.select);
                newRow.getCell("promotionPolicy").setValue((Object)(salePriceTOList.name + "(" + salePriceTOList.number + ")"));
                newRow.getCell("FGroupNumber").setValue((Object)salePriceTOList.groupNumber);
                newRow.getCell("FMaterialGroupID").setValue((Object)salePriceTOList.materialGroupNumerName);
                if (salePriceTOList.materialNumber == null) {
                    newRow.getCell("material").setValue(null);
                } else {
                    newRow.getCell("material").setValue((Object)(salePriceTOList.materialNumber + "(" + salePriceTOList.materialName + ")"));
                }
                newRow.getCell("FMaterialUnit").setValue((Object)salePriceTOList.materialUnitName);
                newRow.getCell("FEntryID").setValue((Object)salePriceTOList.entryID);
                newRow.getCell("FID").setValue((Object)salePriceTOList.id);
                newRow.getCell("FMatchEntryID").setValue((Object)salePriceTOList.matchEntryID);
                newRow.getCell("FMatchTypeID").setValue((Object)salePriceTOList.matchTypeID);
                if (salePriceTOList.isPresent.booleanValue()) {
                    newRow.getCell("FPurchaseQty").setValue(null);
                    newRow.getCell("FPurchaseAmount").setValue(null);
                    newRow.getCell("FRealQty").setValue(null);
                    newRow.getCell("FRealAmount").setValue(null);
                    newRow.getCell("FDiffQty").setValue(null);
                    newRow.getCell("FDiffAmount").setValue(null);
                    SalePromotionPolicyTO present = (SalePromotionPolicyTO)this.mappromotionPresent.get(newRow.getCell("FGroupNumber").getValue().toString());
                    salePriceTOList.purchaseQty = present.purchaseQty;
                    salePriceTOList.purchaseAmount = present.purchaseAmount;
                    newRow.getCell("FPresentQty").setValue((Object)this.calPresentQty(salePriceTOList));
                    newRow.getCell("FPromotionPrice").setValue(null);
                    newRow.getCell("FDiscount").setValue(null);
                    newRow.getCell("FTotalAmount").setValue(null);
                    newRow.getCell("FReturnRate").setValue(null);
                    newRow.getCell("FDiscountAmount").setValue(null);
                } else {
                    if (this.ZERO.compareTo(salePriceTOList.purchaseQty) == 0) {
                        newRow.getCell("FPurchaseQty").setValue(null);
                    } else {
                        newRow.getCell("FPurchaseQty").setValue((Object)salePriceTOList.purchaseQty);
                    }
                    if (this.ZERO.compareTo(salePriceTOList.purchaseAmount) == 0) {
                        newRow.getCell("FPurchaseAmount").setValue(null);
                    } else {
                        newRow.getCell("FPurchaseAmount").setValue((Object)salePriceTOList.purchaseAmount);
                    }
                    if (this.ZERO.compareTo(salePriceTOList.realQty) == 0) {
                        newRow.getCell("FRealQty").setValue(null);
                    } else {
                        newRow.getCell("FRealQty").setValue((Object)salePriceTOList.realQty);
                    }
                    if (this.ZERO.compareTo(salePriceTOList.realAmount) == 0) {
                        newRow.getCell("FRealAmount").setValue(null);
                    } else {
                        newRow.getCell("FRealAmount").setValue((Object)salePriceTOList.realAmount);
                    }
                    if (this.ZERO.compareTo(salePriceTOList.diffQty) == 0) {
                        newRow.getCell("FDiffQty").setValue(null);
                    } else {
                        newRow.getCell("FDiffQty").setValue((Object)salePriceTOList.diffQty);
                    }
                    if (this.ZERO.compareTo(salePriceTOList.diffAmount) == 0) {
                        newRow.getCell("FDiffAmount").setValue(null);
                    } else {
                        newRow.getCell("FDiffAmount").setValue((Object)salePriceTOList.diffAmount);
                    }
                    newRow.getCell("FPresentQty").setValue(null);
                    if (this.ZERO.compareTo(salePriceTOList.promotionPrice) == 0) {
                        newRow.getCell("FPromotionPrice").setValue(null);
                    } else {
                        newRow.getCell("FPromotionPrice").setValue((Object)salePriceTOList.promotionPrice);
                    }
                    if (this.ZERO.compareTo(salePriceTOList.discount) == 0) {
                        newRow.getCell("FDiscount").setValue(null);
                    } else {
                        newRow.getCell("FDiscount").setValue((Object)salePriceTOList.discount);
                    }
                    if (this.ZERO.compareTo(salePriceTOList.totalAmount) == 0) {
                        newRow.getCell("FTotalAmount").setValue(null);
                    } else {
                        newRow.getCell("FTotalAmount").setValue((Object)salePriceTOList.totalAmount);
                    }
                    if (this.ZERO.compareTo(salePriceTOList.returnRate) == 0) {
                        newRow.getCell("FReturnRate").setValue(null);
                    } else {
                        newRow.getCell("FReturnRate").setValue((Object)salePriceTOList.returnRate);
                    }
                    if (this.ZERO.compareTo(salePriceTOList.discountAmount) == 0) {
                        newRow.getCell("FDiscountAmount").setValue(null);
                    } else {
                        newRow.getCell("FDiscountAmount").setValue((Object)salePriceTOList.discountAmount);
                    }
                }
                newRow.getCell("FPropose").setValue((Object)salePriceTOList.propose);
                newRow.getCell("FMaterialAssistProperty").setValue((Object)salePriceTOList.materialAssistPropertyName);
                newRow.getCell("FIsPresent").setValue((Object)salePriceTOList.isPresent);
                if (salePriceTOList.discountType == -1) {
                    newRow.getCell("FDiscountType").setValue((Object)DiscountModeEnum.NULL);
                    continue;
                }
                if (salePriceTOList.discountType == 0) {
                    newRow.getCell("FDiscountType").setValue((Object)DiscountModeEnum.PERCENT);
                    continue;
                }
                if (salePriceTOList.discountType != 1) continue;
                newRow.getCell("FDiscountType").setValue((Object)DiscountModeEnum.PERUNIT);
            }
        }
        SCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])this.getQtyColumns(), (String)SCMClientUtils.getFormatPattern((int)10, (boolean)true));
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("promotionPolicy").setGroup(true);
        this.tblMain.getColumn("promotionPolicy").setMergeable(true);
        this.tblMain.getColumn("FGroupNumber").setGroup(true);
        this.tblMain.getColumn("FGroupNumber").setMergeable(true);
        this.tblMain.getColumn("FIsPresent").setGroup(true);
        this.tblMain.getColumn("FIsPresent").setMergeable(true);
        this.tblMain.getColumn("FPurchaseQty").setGroup(true);
        this.tblMain.getColumn("FPurchaseQty").setMergeable(true);
        this.tblMain.getColumn("FPurchaseAmount").setGroup(true);
        this.tblMain.getColumn("FPurchaseAmount").setMergeable(true);
        this.tblMain.getColumn("FRealQty").setGroup(true);
        this.tblMain.getColumn("FRealQty").setMergeable(true);
        this.tblMain.getColumn("FRealAmount").setGroup(true);
        this.tblMain.getColumn("FRealAmount").setMergeable(true);
        this.tblMain.getColumn("FDiffQty").setGroup(true);
        this.tblMain.getColumn("FDiffQty").setMergeable(true);
        this.tblMain.getColumn("FDiffAmount").setGroup(true);
        this.tblMain.getColumn("FDiffAmount").setMergeable(true);
        this.loadTablePreference();
    }

    public void getResultData() {
        this.successConditionsUpdataList.clear();
        this.successConditionsAddRowList.clear();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(i);
            SalePromotionPolicyTO to = (SalePromotionPolicyTO)this.mappromotionPolicy.get(row.getCell("FEntryID").getValue().toString());
            if (!((Boolean)row.getCell("select").getValue()).booleanValue()) continue;
            this.checkValidData(to);
            if (to.isSingleDiscount.booleanValue()) {
                this.successConditionsDiscountList.add(to);
                continue;
            }
            if (((Boolean)row.getCell("FIsPresent").getValue()).booleanValue()) {
                SalePromotionPolicyTO present = (SalePromotionPolicyTO)this.mappromotionPresent.get(row.getCell("FGroupNumber").getValue().toString());
                to.purchaseQty = present.purchaseQty;
                to.purchaseAmount = present.purchaseAmount;
                to.presentQty = this.calPresentQty(to);
                this.successConditionsAddRowList.add(to);
                continue;
            }
            this.successConditionsUpdataList.add(to);
        }
    }

    private BigDecimal calPresentQty(SalePromotionPolicyTO to) {
        BigDecimal presentQty = this.ZERO;
        if ((to.presentLimit == 1 || to.presentLimit == 2) && to.judgementModel == 1) {
            presentQty = to.presentQty;
        } else if ((to.presentLimit == 1 || to.presentLimit == 2) && to.judgementModel == 2) {
            presentQty = to.purchaseQty.compareTo(this.ZERO) > 0 ? new BigDecimal(Math.floor(to.realQty.divide(to.purchaseQty, to.qtyPrecision, 4).doubleValue())).multiply(to.presentQty) : (to.purchaseAmount.compareTo(this.ZERO) > 0 ? new BigDecimal(Math.floor(to.realAmount.divide(to.purchaseAmount, to.qtyPrecision, 4).doubleValue())).multiply(to.presentQty) : this.ZERO);
        }
        return presentQty;
    }

    private void checkValidData(SalePromotionPolicyTO to) {
        int selectPresentCount = 0;
        if (to.presentLimit == 2) {
            int size = this.tblMain.getRowCount();
            for (int i = 0; i < size; ++i) {
                IRow row = this.tblMain.getRow(i);
                if (!(to.id + to.groupNumber.toString()).equals(row.getCell("FID").getValue().toString() + row.getCell("FGroupNumber").getValue().toString()) || !((Boolean)row.getCell("select").getValue()).booleanValue() || !((Boolean)row.getCell("FIsPresent").getValue()).booleanValue() || this.promotionType != 2 || ++selectPresentCount <= to.headPresentQty) continue;
                to.select = false;
                row.getCell("FIsPresent").setValue((Object)false);
            }
            if (this.promotionType != 2 && selectPresentCount != to.headPresentQty) {
                MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.sale.BDScmSaleResource", (String)"ROWCOUNTEQUALPRESENTQTY"), to.groupNumber));
                SysUtil.abort();
            }
        }
    }

    public boolean checkBeforeWindowClosing() {
        ConfigServiceUtils.saveUserConfigData((String)"displayConditionPromotion", (CoreUI)this, (String)Boolean.toString(this.cbIsSelect.isSelected()));
        return super.checkBeforeWindowClosing();
    }

    protected String[] getQtyColumns() {
        return new String[]{"FPurchaseQty", "FPurchaseAmount", "FRealQty", "FRealAmount", "FDiffQty", "FDiffAmount", "FPresentQty", "FPromotionPrice", "FDiscount", "FTotalAmount", "FDiscountAmount"};
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            if (e.getType() == 0) {
                return;
            }
            ActionEvent evt = new ActionEvent(this.btnView, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            if (actView.isEnabled()) {
                actView.actionPerformed(evt);
            }
        }
    }

    protected void loadTablePreference() {
        UserPreferenceData userDBData = this.tHelper.getUserDataFromDB();
        if (this.tHelper instanceof TablePreferencesHelper) {
            TablePreferencesHelper tableHelper = (TablePreferencesHelper)this.tHelper;
            for (String key : tableHelper.tables.keySet()) {
                KDTable table = (KDTable)tableHelper.tables.get(key);
                try {
                    tableHelper.addMenuToTable(table);
                    if (!tableHelper.isCanSetTable() || userDBData == null || userDBData.getTableCurrentSetting(key) == null) continue;
                    tableHelper.applyConfigFromData(table, userDBData.getTableCurrentSetting(key), false);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
    }
}

