/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.client.BDInvClientUtils;
import com.kingdee.eas.basedata.scm.sd.sale.ForbidStatusEnum;
import com.kingdee.eas.basedata.scm.sd.sale.ISalePerson;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonFactory;
import com.kingdee.eas.basedata.scm.sd.sale.client.AbstractSaleGroupEditUI;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;

public class SaleGroupEditUI
extends AbstractSaleGroupEditUI {
    SaleOrgUnitInfo saleOrginfo = null;
    SaleGroupInfo parentgroupinfo = null;
    SaleGroupInfo currGroupInfo = null;
    int parenttype = 0;

    @Override
    public void loadFields() {
        super.loadFields();
        this.txtNumber.requestFocus();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected IObjectValue createNewData() {
        SaleGroupInfo groupInfo = new SaleGroupInfo();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.parenttype == 0) {
                this.txtSaleOrgName.setText(this.saleOrginfo.getName());
                groupInfo.setSaleOrg(this.saleOrginfo);
                this.bizPromptSaleOrg.setValue((Object)this.saleOrginfo);
            } else if (this.parenttype == 1) {
                this.txtSaleOrgName.setText(this.parentgroupinfo.getSaleOrg().getName());
                this.bizPromptSaleOrg.setValue((Object)this.parentgroupinfo.getSaleOrg());
                groupInfo.setSaleOrg(this.parentgroupinfo.getSaleOrg());
            }
            groupInfo.setParent(this.parentgroupinfo);
            groupInfo.setParentType(this.parenttype);
        } else if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW)) {
            this.txtSaleOrgName.setText(this.currGroupInfo.getSaleOrg().getName());
            this.bizPromptSaleOrg.setValue((Object)this.currGroupInfo.getSaleOrg());
            groupInfo.setSaleOrg(this.currGroupInfo.getSaleOrg());
        }
        groupInfo.setDeletedStatus(ForbidStatusEnum.UNFORBID);
        return groupInfo;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SaleGroupFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    public void onLoad() throws Exception {
        this.txtNumber.setMaxLength(80);
        this.txtName.setMaxLength(255);
        this.txtDescription.setMaxLength(255);
        try {
            SCMClientUtils.setSaleOrgF7((KDBizPromptBox)this.bizPromptSaleOrg);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.saleOrginfo = null;
            this.saleOrginfo = (SaleOrgUnitInfo)this.getUIContext().get("SaleOU");
            this.parentgroupinfo = null;
            this.parentgroupinfo = (SaleGroupInfo)this.getUIContext().get("ParentGroup");
            if (this.saleOrginfo != null) {
                this.parenttype = 0;
            } else if (this.parentgroupinfo != null) {
                this.parenttype = 1;
                this.saleOrginfo = this.parentgroupinfo.getSaleOrg();
            }
        } else if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW)) {
            this.currGroupInfo = null;
            this.currGroupInfo = (SaleGroupInfo)this.getUIContext().get("ParentGroup");
            this.saleOrginfo = this.currGroupInfo.getSaleOrg();
            if (this.isReferenced(this.currGroupInfo) && this.getOprtState().equals(OprtState.EDIT)) {
                this.bizPromptSaleOrg.setEnabled(false);
            }
        }
        super.onLoad();
        this.txtName.setRequired(true);
    }

    private boolean isReferenced(SaleGroupInfo salegroup) {
        try {
            ISalePerson person = SalePersonFactory.getRemoteInstance();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("saleGroup", (Object)salegroup.getId().toString()));
            return person.exists(filter);
        }
        catch (Exception ex) {
            Logger.error((Throwable)ex);
            this.handUIExceptionAndAbort(ex);
            return false;
        }
    }

    @Override
    protected void bizPromptSaleOrg_stateChanged(ChangeEvent e) throws Exception {
        SaleOrgUnitInfo orginfo = (SaleOrgUnitInfo)this.bizPromptSaleOrg.getValue();
        if (orginfo != null) {
            this.txtSaleOrgName.setText(orginfo.getName());
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.txtNumber.getText() == null || this.txtNumber.getText().length() == 0) {
            this.txtNumber.requestFocus();
            MsgBox.showInfo((String)this.getResString("SaleGroup_NeedNumber"));
            SysUtil.abort();
        } else if (this.txtName.getEditor().getItem() == null || this.txtName.getEditor().getItem().toString().length() <= 0) {
            this.txtName.requestFocus();
            MsgBox.showInfo((String)this.getResString("SaleGroup_NeedName"));
            SysUtil.abort();
        } else if (this.bizPromptSaleOrg.getValue() == null) {
            this.bizPromptSaleOrg.requestFocus();
            MsgBox.showInfo((String)this.getResString("SaleGroup_NeedOrgNumber"));
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    private String getResString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.sd.sale.client.SaleResource", (String)key);
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        SaleGroupInfo saleGroupInfo = (SaleGroupInfo)newData;
        saleGroupInfo.setNumber(null);
        saleGroupInfo.setName(null);
        super.setFieldsNull(newData);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionSubmit_actionPerformed(e);
        }
        catch (TreeBaseException treebaseEx) {
            if (treebaseEx.getSubCode().equals(TreeBaseException.CHECKNUMBERDUPLICATED.getCode())) {
                this.txtNumber.requestFocus();
            }
            throw treebaseEx;
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        BDInvClientUtils.logUIOperation("LOG_PRINT", new SaleGroupInfo().getBOSType());
        super.actionPrint_actionPerformed(e);
    }
}

