/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sd.sale.client;

import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ForbidStatusEnum;
import com.kingdee.eas.basedata.scm.sd.sale.ISaleGroup;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupCollection;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class SaleGroupTreeBuilder {
    Icon groupIcon = EASResource.getIcon((String)"imgTree_businessgroup");
    Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
    HashMap<String, KDTreeNode> nodeMap;
    HashMap<String, KDTreeNode> childNodeMap;
    KDTreeNode lastExpandnode = null;
    KDTreeNode expandnode = null;
    private SaleOrgUnitInfo topSaleOrgUnitInfo = null;

    public SaleGroupTreeBuilder() {
    }

    public SaleGroupTreeBuilder(KDTreeNode Lastnode) {
        this.lastExpandnode = Lastnode;
    }

    public KDTreeNode getLastExpandnode() {
        return this.lastExpandnode;
    }

    public JTree buildtree(KDTree tree) throws Exception {
        tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)((Object)this.createRootNode())));
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTree tree = (KDTree)event.getSource();
                try {
                    KDTreeNode treeNode = (KDTreeNode)event.getPath().getLastPathComponent();
                    SaleGroupTreeBuilder.this.getChildren(tree, treeNode);
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        return tree;
    }

    public void refreshChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        this.innerRefreshChildren(tree, treeNode);
    }

    protected void getChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        this.childNodeMap = new HashMap();
        if (treeNode.isVirtual()) {
            this.innerRefreshChildren(tree, treeNode);
            treeNode.setVirtual(false);
        }
    }

    private void innerRefreshChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        TreeBaseInfo treeNodeInfo = null;
        if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            treeNodeInfo = (TreeBaseInfo)treeNode.getUserObject();
        }
        tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
        if (treeNodeInfo instanceof SaleGroupInfo) {
            SaleGroupCollection col = this.getChildSaleGroup((SaleGroupInfo)treeNodeInfo);
            this.buildChildren(tree, col, treeNode);
        } else if (treeNodeInfo instanceof SaleOrgUnitInfo) {
            SaleGroupCollection col = this.getChildSaleGroup((SaleOrgUnitInfo)treeNodeInfo);
            SaleOrgUnitCollection saleOrgCol = this.getChildSaleOrg((SaleOrgUnitInfo)treeNodeInfo);
            this.buildChildren(tree, col, saleOrgCol, treeNode);
        }
    }

    private SaleGroupCollection getChildSaleGroup(SaleGroupInfo saleGroupInfo) throws Exception {
        String longNumber = saleGroupInfo.getLongNumber();
        int level = saleGroupInfo.getLevel();
        EntityViewInfo viewInfo = this.getChildViewInfo(level, longNumber);
        ISaleGroup isaleGroup = SaleGroupFactory.getRemoteInstance();
        SaleGroupCollection saleGroupCollect = isaleGroup.getSaleGroupCollection(viewInfo);
        return saleGroupCollect;
    }

    private SaleGroupCollection getChildSaleGroup(SaleOrgUnitInfo saleOrgInfo) throws Exception {
        EntityViewInfo viewInfo = this.getChildGroupFilter(saleOrgInfo);
        ISaleGroup isaleGroup = SaleGroupFactory.getRemoteInstance();
        SaleGroupCollection saleGroupCollect = isaleGroup.getSaleGroupCollection(viewInfo);
        return saleGroupCollect;
    }

    private boolean isHasChildSaleGroup(SaleOrgUnitInfo saleOrgInfo) throws Exception {
        EntityViewInfo viewInfo = this.getChildGroupFilter(saleOrgInfo);
        ISaleGroup isaleGroup = SaleGroupFactory.getRemoteInstance();
        SaleGroupCollection saleGroupCollect = isaleGroup.getSaleGroupCollection(viewInfo);
        return saleGroupCollect != null && saleGroupCollect.size() > 0;
    }

    private Map isHasChildSaleGroup(SaleOrgUnitCollection saleOrgInfos) throws Exception {
        EntityViewInfo viewInfo = this.getChildGroupFilter(saleOrgInfos);
        ISaleGroup isaleGroup = SaleGroupFactory.getRemoteInstance();
        SaleGroupCollection saleGroupCollect = isaleGroup.getSaleGroupCollection(viewInfo);
        HashMap<String, String> map = new HashMap<String, String>();
        if (saleGroupCollect != null) {
            for (int i = 0; i < saleGroupCollect.size(); ++i) {
                String saleOrgID = saleGroupCollect.get(i).getSaleOrg().getId().toString();
                map.put(saleOrgID, saleOrgID);
            }
        }
        return map;
    }

    private SaleOrgUnitCollection getChildSaleOrg(SaleOrgUnitInfo saleOrgInfo) throws Exception {
        String longNumber = saleOrgInfo.getLongNumber();
        int level = saleOrgInfo.getLevel();
        EntityViewInfo viewInfo = this.getChildViewInfo(level, longNumber);
        SaleOrgUnitCollection saleOrgCollect = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitCollection(viewInfo);
        return saleOrgCollect;
    }

    private void buildChildren(KDTree tree, SaleGroupCollection salegroupCollect, SaleOrgUnitCollection saleOrgCollect, KDTreeNode parentNode) {
        if (parentNode.getUserObject() instanceof SaleOrgUnitInfo) {
            int i;
            int num;
            if (this.childNodeMap == null) {
                this.childNodeMap = new HashMap();
            }
            parentNode.removeAllChildren();
            SaleOrgUnitInfo parentOrgInfo = (SaleOrgUnitInfo)parentNode.getUserObject();
            this.childNodeMap.put(parentOrgInfo.getId().toString(), parentNode);
            if (salegroupCollect != null && salegroupCollect.size() > 0) {
                num = salegroupCollect.size();
                for (i = 0; i < num; ++i) {
                    SaleGroupInfo groupInfo = salegroupCollect.get(i);
                    SaleGroupTreeNode node = new SaleGroupTreeNode(groupInfo);
                    if (groupInfo.getDeletedStatus() == ForbidStatusEnum.FORBID) {
                        node.setTextColor(Color.gray);
                    }
                    if (!groupInfo.isIsLeaf()) {
                        SaleOrgUnitInfo tempsaleOrgInfo = new SaleOrgUnitInfo();
                        tempsaleOrgInfo.setId(BOSUuid.read((String)"xxxxxxxxxxxxxxxxxxxxxxxxxxx="));
                        node.add((MutableTreeNode)((Object)new SaleGroupTreeNode(tempsaleOrgInfo)));
                    }
                    node.setCustomIcon(this.groupIcon);
                    node.setVirtual(true);
                    this.childNodeMap.put(groupInfo.getId().toString(), node);
                    if (groupInfo.getSaleOrg() == null || !this.childNodeMap.containsKey(groupInfo.getSaleOrg().getId().toString())) continue;
                    SaleGroupTreeNode tempParentNode = (SaleGroupTreeNode)this.childNodeMap.get(groupInfo.getSaleOrg().getId().toString());
                    int index = tempParentNode.getChildCount();
                    tree.insertNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)tempParentNode), index);
                }
            }
            if (saleOrgCollect != null && saleOrgCollect.size() > 0) {
                num = saleOrgCollect.size();
                for (i = 0; i < num; ++i) {
                    SaleOrgUnitInfo orgInfo = saleOrgCollect.get(i);
                    SaleGroupCollection saleGroupCollection = null;
                    try {
                        saleGroupCollection = this.getChildSaleGroup(orgInfo);
                    }
                    catch (Exception e) {
                        Logger.error((Throwable)e);
                    }
                    SaleGroupTreeNode node = new SaleGroupTreeNode(orgInfo);
                    if (!orgInfo.isIsLeaf() || saleGroupCollection != null && saleGroupCollection.size() > 0) {
                        SaleOrgUnitInfo tempsaleGroupInfo = new SaleOrgUnitInfo();
                        tempsaleGroupInfo.setId(BOSUuid.read((String)"xxxxxxxxxxxxxxxxxxxxxxxxxxx="));
                        node.add((MutableTreeNode)((Object)new SaleGroupTreeNode(tempsaleGroupInfo)));
                    }
                    node.setCustomIcon(this.companyIcon);
                    node.setVirtual(true);
                    this.childNodeMap.put(orgInfo.getId().toString(), node);
                    if (orgInfo.getParent() == null || !this.childNodeMap.containsKey(orgInfo.getParent().getId().toString())) continue;
                    SaleGroupTreeNode tempParentNode = (SaleGroupTreeNode)this.childNodeMap.get(orgInfo.getParent().getId().toString());
                    int index = tempParentNode.getChildCount();
                    tree.insertNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)tempParentNode), index);
                }
            }
        }
    }

    private void buildChildren(KDTree tree, SaleGroupCollection salegroupCollect, KDTreeNode parentNode) {
        if (parentNode.getUserObject() instanceof SaleGroupInfo && salegroupCollect != null && salegroupCollect.size() > 0) {
            parentNode.removeAllChildren();
            this.childNodeMap = new HashMap();
            SaleGroupInfo parentGroupInfo = (SaleGroupInfo)parentNode.getUserObject();
            this.childNodeMap.put(parentGroupInfo.getId().toString(), parentNode);
            int num = salegroupCollect.size();
            for (int i = 0; i < num; ++i) {
                SaleGroupInfo groupInfo = salegroupCollect.get(i);
                SaleGroupTreeNode node = new SaleGroupTreeNode(groupInfo);
                if (groupInfo.getDeletedStatus() == ForbidStatusEnum.FORBID) {
                    node.setTextColor(Color.gray);
                }
                if (!groupInfo.isIsLeaf()) {
                    SaleGroupInfo tempsaleGroupInfo = new SaleGroupInfo();
                    tempsaleGroupInfo.setId(BOSUuid.read((String)"xxxxxxxxxxxxxxxxxxxxxxxxxxx="));
                    node.add((MutableTreeNode)((Object)new SaleGroupTreeNode(tempsaleGroupInfo)));
                }
                node.setCustomIcon(this.groupIcon);
                node.setVirtual(true);
                this.childNodeMap.put(groupInfo.getId().toString(), node);
                if (groupInfo.getParent() == null || !this.childNodeMap.containsKey(groupInfo.getParent().getId().toString())) continue;
                SaleGroupTreeNode tempParentNode = (SaleGroupTreeNode)this.childNodeMap.get(groupInfo.getParent().getId().toString());
                int index = tempParentNode.getChildCount();
                tree.insertNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)tempParentNode), index);
            }
        }
    }

    public DefaultKingdeeTreeNode getExpandNode() {
        return this.expandnode;
    }

    private SaleGroupTreeNode createRootNode() throws Exception {
        SaleGroupTreeNode rootNode = null;
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getCU().getId().toString();
        SaleOrgUnitCollection collection = this.getInitSaleOrgRowSet(cuid);
        rootNode = this.buildInitTreeByRowSet(collection);
        return rootNode;
    }

    private SaleOrgUnitInfo getTopSaleOrgUnitInfo(String cuID) throws Exception {
        ISaleOrgUnit isale = SaleOrgUnitFactory.getRemoteInstance();
        SaleOrgUnitInfo orgInfo = null;
        orgInfo = isale.getSaleOrgUnitInfo((IObjectPK)new ObjectStringPK(cuID));
        return orgInfo;
    }

    private SaleOrgUnitCollection getInitSaleOrgRowSet(String cuID) throws Exception {
        if (this.topSaleOrgUnitInfo == null && SysContext.getSysContext().getCurrentCtrlUnit().isIsSaleOrgUnit()) {
            this.topSaleOrgUnitInfo = this.getTopSaleOrgUnitInfo(cuID);
        }
        SaleOrgUnitCollection saleOrgCollect = null;
        if (this.topSaleOrgUnitInfo != null) {
            String longNumber = this.topSaleOrgUnitInfo.getLongNumber();
            int level = this.topSaleOrgUnitInfo.getLevel();
            EntityViewInfo viewInfo = this.getChildViewInfo(level, longNumber);
            FilterInfo fi = viewInfo.getFilter();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.topSaleOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            fi.mergeFilter(filter, "or");
            saleOrgCollect = SaleOrgUnitFactory.getRemoteInstance().getSaleOrgUnitCollection(viewInfo);
        }
        return saleOrgCollect;
    }

    private EntityViewInfo getChildViewInfo(int level, String longNumber) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        viewInfo.setFilter(fi);
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(level + 1), CompareType.EQUALS));
        SorterItemInfo sorterInfo = new SorterItemInfo("longNumber");
        sorterInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterInfo);
        return viewInfo;
    }

    private SaleGroupTreeNode buildInitTreeByRowSet(SaleOrgUnitCollection collection) throws Exception {
        if (collection == null) {
            return null;
        }
        SaleGroupTreeNode rootnode = null;
        this.nodeMap = new HashMap();
        Map isLeafMap = this.isHasChildSaleGroup(collection);
        for (int i = 0; i < collection.size(); ++i) {
            SaleOrgUnitInfo orginfo = collection.get(i);
            if (rootnode == null) {
                rootnode = new SaleGroupTreeNode(orginfo);
                if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)rootnode)) {
                    this.expandnode = rootnode;
                }
                rootnode.setCustomIcon(this.companyIcon);
                this.nodeMap.put(orginfo.getId().toString(), rootnode);
                continue;
            }
            if (orginfo.isIsLeaf() && isLeafMap.get(orginfo.getId().toString()) != null) {
                orginfo.setIsLeaf(false);
            }
            SaleGroupTreeNode subTreeNode = new SaleGroupTreeNode(orginfo);
            subTreeNode.setVirtual(true);
            if (!orginfo.isIsLeaf()) {
                SaleOrgUnitInfo saleorginfo = new SaleOrgUnitInfo();
                saleorginfo.setId(BOSUuid.read((String)"xxxxxxxxxxxxxxxxxxxxxxxxxxx="));
                subTreeNode.add((MutableTreeNode)((Object)new SaleGroupTreeNode(saleorginfo)));
            }
            if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)subTreeNode)) {
                this.expandnode = subTreeNode;
            }
            subTreeNode.setCustomIcon(this.companyIcon);
            if (this.nodeMap.containsKey(orginfo.getParent().getId().toString())) {
                ((SaleGroupTreeNode)this.nodeMap.get(orginfo.getParent().getId().toString())).add((MutableTreeNode)((Object)subTreeNode));
            }
            this.nodeMap.put(orginfo.getId().toString(), subTreeNode);
        }
        if (rootnode != null) {
            ArrayList trees = this.getInitGroupTrees();
            for (SaleGroupTreeNode tree : trees) {
                SaleGroupInfo groupinfo = (SaleGroupInfo)tree.getUserObject();
                if (this.nodeMap.containsKey(groupinfo.getSaleOrg().getId().toString())) {
                    ((SaleGroupTreeNode)this.nodeMap.get(groupinfo.getSaleOrg().getId().toString())).add((MutableTreeNode)((Object)tree));
                }
                this.nodeMap.put(groupinfo.getId().toString(), tree);
            }
        }
        return rootnode;
    }

    private ArrayList getInitGroupTrees() throws Exception {
        ArrayList<SaleGroupTreeNode> grouptrees = new ArrayList<SaleGroupTreeNode>();
        HashMap<String, SaleGroupTreeNode> nodemap = new HashMap<String, SaleGroupTreeNode>();
        SaleGroupCollection collection = this.getInitGroupRowSet();
        if (collection == null) {
            return null;
        }
        for (int i = 0; i < collection.size(); ++i) {
            SaleGroupInfo groupinfo = collection.get(i);
            SaleGroupTreeNode node = new SaleGroupTreeNode(groupinfo);
            if (groupinfo.getDeletedStatus() == ForbidStatusEnum.FORBID) {
                node.setTextColor(Color.gray);
            }
            if (!groupinfo.isIsLeaf()) {
                SaleGroupInfo tempsaleGroupInfo = new SaleGroupInfo();
                tempsaleGroupInfo.setId(BOSUuid.read((String)"xxxxxxxxxxxxxxxxxxxxxxxxxxx="));
                node.add((MutableTreeNode)((Object)new SaleGroupTreeNode(tempsaleGroupInfo)));
            }
            node.setVirtual(true);
            if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)node)) {
                this.expandnode = node;
            }
            if (groupinfo.getParentType() == 0) {
                grouptrees.add(node);
                node.setCustomIcon(this.groupIcon);
            } else if (groupinfo.getParent() != null && nodemap.containsKey(groupinfo.getParent().getId().toString())) {
                ((SaleGroupTreeNode)((Object)nodemap.get(groupinfo.getParent().getId().toString()))).add((MutableTreeNode)((Object)node));
                node.setCustomIcon(this.groupIcon);
            }
            nodemap.put(groupinfo.getId().toString(), node);
        }
        return grouptrees;
    }

    private SaleGroupCollection getInitGroupRowSet() throws Exception {
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getCU().getId().toString();
        if (this.topSaleOrgUnitInfo == null && SysContext.getSysContext().getCurrentCtrlUnit().getCU().isIsSaleOrgUnit()) {
            this.topSaleOrgUnitInfo = this.getTopSaleOrgUnitInfo(cuid);
        }
        EntityViewInfo viewInfo = this.getChildGroupFilter(this.topSaleOrgUnitInfo);
        ISaleGroup isaleGroup = SaleGroupFactory.getRemoteInstance();
        SaleGroupCollection saleGroupCollect = isaleGroup.getSaleGroupCollection(viewInfo);
        return saleGroupCollect;
    }

    private EntityViewInfo getChildGroupFilter(SaleOrgUnitInfo saleOrgInfo) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("saleOrg.id", (Object)saleOrgInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1), CompareType.EQUALS));
        viewInfo.setFilter(fi);
        return viewInfo;
    }

    private EntityViewInfo getChildGroupFilter(SaleOrgUnitCollection saleOrgInfos) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        StringBuffer ids = new StringBuffer();
        if (saleOrgInfos != null) {
            for (int i = 0; i < saleOrgInfos.size(); ++i) {
                if (i > 0) {
                    ids.append(",");
                }
                ids.append(saleOrgInfos.get(i).getId().toString());
            }
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("saleOrg.id", (Object)ids.toString(), CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1), CompareType.EQUALS));
        viewInfo.setFilter(fi);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("saleOrg.id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("level"));
        viewInfo.setSelector(sic);
        return viewInfo;
    }

    public HashMap<String, KDTreeNode> getNodeMap() {
        return this.nodeMap;
    }

    public HashMap<String, KDTreeNode> getChildNodeMap() {
        return this.childNodeMap;
    }

    private class SaleGroupTreeNode
    extends KDTreeNode {
        public SaleGroupTreeNode(Object o) {
            super(o);
        }

        public boolean equals(Object obj) {
            if (obj != null && !(obj instanceof DefaultKingdeeTreeNode)) {
                return false;
            }
            SaleGroupTreeNode node = (SaleGroupTreeNode)((Object)obj);
            if (obj != null && node.getUserObject() != null && node.getUserObject() instanceof SaleOrgUnitInfo && this.getUserObject() != null && this.getUserObject() instanceof SaleOrgUnitInfo) {
                SaleOrgUnitInfo orginfo = (SaleOrgUnitInfo)this.getUserObject();
                SaleOrgUnitInfo objorginfo = (SaleOrgUnitInfo)node.getUserObject();
                if (orginfo.getId() != null && objorginfo.getId() != null && orginfo.getId().toString().equals(objorginfo.getId().toString())) {
                    return true;
                }
            } else if (obj != null && node.getUserObject() != null && node.getUserObject() instanceof SaleGroupInfo && this.getUserObject() != null && this.getUserObject() instanceof SaleGroupInfo) {
                SaleGroupInfo info = (SaleGroupInfo)this.getUserObject();
                SaleGroupInfo objinfo = (SaleGroupInfo)node.getUserObject();
                if (info.getId() != null && objinfo.getId() != null && info.getId().toString().equals(objinfo.getId().toString())) {
                    return true;
                }
            }
            return false;
        }
    }
}

