/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sm.pur.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PurClientUtils {
    private static final Logger logger = CoreUIObject.getLogger(PurClientUtils.class);

    public static String getString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.pur.BDScmPurResource", (String)key);
    }

    public static void showCannotBeEmptyMsg(String fieldName) {
        String msg = PurClientUtils.getString("FieldCannotEmpty");
        MsgBox.showInfo((String)MessageFormat.format(msg, fieldName));
        SysUtil.abort();
    }

    public static void verifyTextFieldInput(KDTextField txt, String fieldName) {
        if (txt.getText().trim().length() == 0 || txt.getText() == null) {
            PurClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyMutilTextFieldInput(KDBizMultiLangBox txt, String fieldName) {
        if (txt.getSelectedItem() == null || ((MultiLangItem)txt.getSelectedItem()).getData().toString().length() == 0) {
            PurClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyMutilAreaFieldInput(KDBizMultiLangArea txt, String fieldName) {
        if (txt.getSelectedItem() == null || ((MultiLangItem)txt.getSelectedItem()).getData().toString().length() == 0) {
            PurClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyNumFieldInput(KDFormattedTextField txt, String fieldName) {
        if (txt.getText().trim().length() == 0 || txt.getText() == null) {
            PurClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyF7Input(KDPromptBox box, String fieldName) {
        if (box.getText().trim().length() == 0 || box.getText() == null) {
            PurClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    public static void verifyComboInput(KDComboBox box, String fieldName) {
        if (box.getSelectedIndex() < 0) {
            PurClientUtils.showCannotBeEmptyMsg(fieldName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MultiLangItem getDefaultLangItemData(KDBizMultiLangBox editor) {
        MultiLangItem name = null;
        Locale l = SysContext.getSysContext().getOriginLocale();
        logger.error((Object)("\u5f53\u524d\u8bed\u8a00AAAA\uff1a" + l.toString() + "AAAAAA"));
        List langList = editor.getLanguageList();
        LanguageInfo langInfo = null;
        if (langList.size() > 1) {
            if (l.toString().equalsIgnoreCase("en_US") || l.toString().equals("l1")) {
                langInfo = (LanguageInfo)langList.get(0);
                return editor.getItemBy(langInfo);
            } else if (l.toString().equalsIgnoreCase("zh_CN") || l.toString().equals("l2")) {
                langInfo = (LanguageInfo)langList.get(1);
                return editor.getItemBy(langInfo);
            } else {
                if (!l.toString().equalsIgnoreCase("zh_TW")) {
                    if (!l.toString().equals("l3")) return null;
                }
                langInfo = (LanguageInfo)langList.get(2);
            }
            return editor.getItemBy(langInfo);
        } else {
            if (langList.size() != 1) return null;
            langInfo = (LanguageInfo)langList.get(0);
        }
        return editor.getItemBy(langInfo);
    }
}

