/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sm.pur.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ForbidStatusEnum;
import com.kingdee.eas.basedata.scm.sm.pur.IPurchaseGroup;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupCollection;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class PurGroupTreeBuilder {
    Icon groupIcon = EASResource.getIcon((String)"imgTree_businessgroup");
    Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
    KDTreeNode lastExpandnode = null;
    KDTreeNode expandnode = null;
    private PurchaseOrgUnitInfo topPurOrgUnitInfo = null;

    public PurGroupTreeBuilder() {
    }

    public PurGroupTreeBuilder(KDTreeNode Lastnode) {
        this.lastExpandnode = Lastnode;
    }

    public KDTreeNode getLastExpandnode() {
        return this.lastExpandnode;
    }

    public JTree buildtree(KDTree tree) throws Exception {
        tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)((Object)this.createInitRootNode())));
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTree tree = (KDTree)event.getSource();
                try {
                    KDTreeNode treeNode = (KDTreeNode)event.getPath().getLastPathComponent();
                    PurGroupTreeBuilder.this.getChildren(tree, treeNode);
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        return tree;
    }

    public void refreshChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        this.innerRefreshChildren(tree, treeNode);
    }

    private void getChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        if (treeNode.isVirtual()) {
            this.innerRefreshChildren(tree, treeNode);
            treeNode.setVirtual(false);
        }
    }

    private void innerRefreshChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        TreeBaseInfo treeNodeInfo = null;
        if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            treeNodeInfo = (TreeBaseInfo)treeNode.getUserObject();
        }
        tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
        if (treeNodeInfo instanceof PurchaseGroupInfo) {
            PurchaseGroupCollection col = this.getChildPurGroup((PurchaseGroupInfo)treeNodeInfo);
            this.buildChildren(tree, col, treeNode);
        } else if (treeNodeInfo instanceof PurchaseOrgUnitInfo) {
            PurchaseGroupCollection col = this.getChildPurGroup((PurchaseOrgUnitInfo)treeNodeInfo);
            PurchaseOrgUnitCollection purOrgCol = this.getChildPurOrg((PurchaseOrgUnitInfo)treeNodeInfo);
            this.buildChildren(tree, col, purOrgCol, treeNode);
        }
    }

    private PurchaseGroupCollection getChildPurGroup(PurchaseGroupInfo purGroupInfo) throws Exception {
        String longNumber = purGroupInfo.getLongNumber();
        int level = purGroupInfo.getLevel();
        EntityViewInfo viewInfo = this.getChildViewInfo(level, longNumber);
        IPurchaseGroup isaleGroup = PurchaseGroupFactory.getRemoteInstance();
        PurchaseGroupCollection purGroupCollect = isaleGroup.getPurchaseGroupCollection(viewInfo);
        return purGroupCollect;
    }

    private PurchaseGroupCollection getChildPurGroup(PurchaseOrgUnitInfo purOrgInfo) throws Exception {
        EntityViewInfo viewInfo = this.getChildGroupFilter(purOrgInfo);
        IPurchaseGroup isaleGroup = PurchaseGroupFactory.getRemoteInstance();
        PurchaseGroupCollection purGroupCollect = isaleGroup.getPurchaseGroupCollection(viewInfo);
        return purGroupCollect;
    }

    private boolean isHasChildPurGroup(PurchaseOrgUnitInfo purOrgInfo) throws Exception {
        EntityViewInfo viewInfo = this.getChildGroupFilter(purOrgInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.scm.sm.pur.app.PurGroupQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rowSet = queryExcu.executeQuery();
        return rowSet.next();
    }

    private PurchaseOrgUnitCollection getChildPurOrg(PurchaseOrgUnitInfo purOrgInfo) throws Exception {
        String longNumber = purOrgInfo.getLongNumber();
        int level = purOrgInfo.getLevel();
        EntityViewInfo viewInfo = this.getChildViewInfo(level, longNumber);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.scm.sm.pur.app.PurOrgQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rowSet = queryExcu.executeQuery();
        PurchaseOrgUnitCollection purOrgCollect = new PurchaseOrgUnitCollection();
        while (rowSet.next()) {
            PurchaseOrgUnitInfo orginfo = this.getPurchaseOrgInfo(rowSet);
            if (!this.hasViewPermission(orginfo)) continue;
            if (orginfo.isIsLeaf() && this.isHasChildPurGroup(orginfo)) {
                orginfo.setIsLeaf(false);
            }
            purOrgCollect.add(orginfo);
        }
        return purOrgCollect;
    }

    private void buildChildren(KDTree tree, PurchaseGroupCollection purgroupCollect, PurchaseOrgUnitCollection purOrgCollect, KDTreeNode parentNode) {
        if (parentNode.getUserObject() instanceof PurchaseOrgUnitInfo) {
            int index;
            PurGroupTreeNode tempParentNode;
            PurGroupTreeNode node;
            int i;
            int num;
            parentNode.removeAllChildren();
            HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
            PurchaseOrgUnitInfo parentOrgInfo = (PurchaseOrgUnitInfo)parentNode.getUserObject();
            nodeMap.put(parentOrgInfo.getId().toString(), parentNode);
            if (purgroupCollect != null && purgroupCollect.size() > 0) {
                num = purgroupCollect.size();
                for (i = 0; i < num; ++i) {
                    PurchaseGroupInfo groupInfo = purgroupCollect.get(i);
                    node = new PurGroupTreeNode(groupInfo);
                    if (groupInfo.getDeletedStatus() == ForbidStatusEnum.FORBID) {
                        node.setTextColor(Color.gray);
                    }
                    if (!groupInfo.isIsLeaf()) {
                        PurchaseOrgUnitInfo temppurOrgInfo = new PurchaseOrgUnitInfo();
                        temppurOrgInfo.setId(BOSUuid.read((String)"xxxxxxxxxxxxxxxxxxxxxxxxxxx="));
                        node.add((MutableTreeNode)((Object)new PurGroupTreeNode(temppurOrgInfo)));
                    }
                    node.setCustomIcon(this.groupIcon);
                    node.setVirtual(true);
                    nodeMap.put(groupInfo.getId().toString(), node);
                    if (groupInfo.getPurOrg() == null || !nodeMap.containsKey(groupInfo.getPurOrg().getId().toString())) continue;
                    tempParentNode = (PurGroupTreeNode)((Object)nodeMap.get(groupInfo.getPurOrg().getId().toString()));
                    index = tempParentNode.getChildCount();
                    tree.insertNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)tempParentNode), index);
                }
            }
            if (purOrgCollect != null && purOrgCollect.size() > 0) {
                num = purOrgCollect.size();
                for (i = 0; i < num; ++i) {
                    PurchaseOrgUnitInfo orgInfo = purOrgCollect.get(i);
                    node = new PurGroupTreeNode(orgInfo);
                    if (!orgInfo.isIsLeaf()) {
                        PurchaseGroupInfo temppurGroupInfo = new PurchaseGroupInfo();
                        temppurGroupInfo.setId(BOSUuid.read((String)"xxxxxxxxxxxxxxxxxxxxxxxxxxx="));
                        node.add((MutableTreeNode)((Object)new PurGroupTreeNode(temppurGroupInfo)));
                    }
                    node.setCustomIcon(this.companyIcon);
                    node.setVirtual(true);
                    nodeMap.put(orgInfo.getId().toString(), node);
                    if (orgInfo.getParent() == null || !nodeMap.containsKey(orgInfo.getParent().getId().toString())) continue;
                    tempParentNode = (PurGroupTreeNode)((Object)nodeMap.get(orgInfo.getParent().getId().toString()));
                    index = tempParentNode.getChildCount();
                    tree.insertNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)tempParentNode), index);
                }
            }
        }
    }

    private void buildChildren(KDTree tree, PurchaseGroupCollection purgroupCollect, KDTreeNode parentNode) {
        if (parentNode.getUserObject() instanceof PurchaseGroupInfo && purgroupCollect != null && purgroupCollect.size() > 0) {
            parentNode.removeAllChildren();
            HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
            PurchaseGroupInfo parentGroupInfo = (PurchaseGroupInfo)parentNode.getUserObject();
            nodeMap.put(parentGroupInfo.getId().toString(), parentNode);
            int num = purgroupCollect.size();
            for (int i = 0; i < num; ++i) {
                PurchaseGroupInfo groupInfo = purgroupCollect.get(i);
                PurGroupTreeNode node = new PurGroupTreeNode(groupInfo);
                if (!groupInfo.isIsLeaf()) {
                    PurchaseGroupInfo temppurGroupInfo = new PurchaseGroupInfo();
                    temppurGroupInfo.setId(BOSUuid.read((String)"xxxxxxxxxxxxxxxxxxxxxxxxxxx="));
                    node.add((MutableTreeNode)((Object)new PurGroupTreeNode(temppurGroupInfo)));
                }
                node.setCustomIcon(this.groupIcon);
                node.setVirtual(true);
                nodeMap.put(groupInfo.getId().toString(), node);
                if (groupInfo.getParent() == null || !nodeMap.containsKey(groupInfo.getParent().getId().toString())) continue;
                PurGroupTreeNode tempParentNode = (PurGroupTreeNode)((Object)nodeMap.get(groupInfo.getParent().getId().toString()));
                int index = tempParentNode.getChildCount();
                tree.insertNodeInto((MutableTreeNode)((Object)node), (MutableTreeNode)((Object)tempParentNode), index);
            }
        }
    }

    public DefaultKingdeeTreeNode getExpandNode() {
        return this.expandnode;
    }

    private PurGroupTreeNode createInitRootNode() throws Exception {
        PurGroupTreeNode rootNode = null;
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getCU().getId().toString();
        IRowSet rows = this.getInitPurchaseOrgRowSet(cuid);
        rootNode = this.buildInitTreeByRowSet(rows);
        return rootNode;
    }

    private IRowSet getPurchaseOrgRowSet(String cuID) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        viewInfo.setFilter(fi);
        SorterItemInfo sorterInfo = new SorterItemInfo("longNumber");
        sorterInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.scm.sm.pur.app.PurOrgQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private PurchaseOrgUnitInfo getTopPurOrgUnitInfo(String cuID) throws Exception {
        PurchaseOrgUnitInfo orgInfo = null;
        IPurchaseOrgUnit ipurchase = PurchaseOrgUnitFactory.getRemoteInstance();
        orgInfo = ipurchase.getPurchaseOrgUnitInfo((IObjectPK)new ObjectStringPK(cuID));
        return orgInfo;
    }

    private IRowSet getInitPurchaseOrgRowSet(String cuID) throws Exception {
        if (this.topPurOrgUnitInfo == null) {
            this.topPurOrgUnitInfo = this.getTopPurOrgUnitInfo(cuID);
        }
        IRowSet topRowSet = null;
        if (this.topPurOrgUnitInfo != null) {
            String longNumber = this.topPurOrgUnitInfo.getLongNumber();
            int level = this.topPurOrgUnitInfo.getLevel();
            EntityViewInfo viewInfo = this.getChildViewInfo(level, longNumber);
            FilterInfo fi = viewInfo.getFilter();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.topPurOrgUnitInfo.getId().toString(), CompareType.EQUALS));
            fi.mergeFilter(filter, "or");
            SorterItemInfo sorterInfo = new SorterItemInfo("longNumber");
            sorterInfo.setSortType(SortType.ASCEND);
            viewInfo.getSorter().add(sorterInfo);
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.scm.sm.pur.app.PurOrgQuery");
            IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            queryExcu.setObjectView(viewInfo);
            topRowSet = queryExcu.executeQuery();
        }
        return topRowSet;
    }

    private EntityViewInfo getChildViewInfo(int level, String longNumber) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        viewInfo.setFilter(fi);
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(level + 1), CompareType.EQUALS));
        SorterItemInfo sorterInfo = new SorterItemInfo("longNumber");
        sorterInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterInfo);
        return viewInfo;
    }

    private PurGroupTreeNode buildInitTreeByRowSet(IRowSet rowset) throws Exception {
        if (rowset == null) {
            return null;
        }
        PurGroupTreeNode rootnode = null;
        HashMap<String, PurGroupTreeNode> nodeMap = new HashMap<String, PurGroupTreeNode>();
        while (rowset.next()) {
            PurchaseOrgUnitInfo orginfo = this.getPurchaseOrgInfo(rowset);
            if (rootnode == null) {
                rootnode = new PurGroupTreeNode(orginfo);
                if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)rootnode)) {
                    this.expandnode = rootnode;
                }
                rootnode.setCustomIcon(this.companyIcon);
                nodeMap.put(orginfo.getId().toString(), rootnode);
                continue;
            }
            if (!this.hasViewPermission(orginfo)) continue;
            if (orginfo.isIsLeaf() && this.isHasChildPurGroup(orginfo)) {
                orginfo.setIsLeaf(false);
            }
            PurGroupTreeNode subTreeNode = new PurGroupTreeNode(orginfo);
            subTreeNode.setVirtual(true);
            if (!orginfo.isIsLeaf()) {
                PurchaseOrgUnitInfo purorginfo = new PurchaseOrgUnitInfo();
                purorginfo.setId(BOSUuid.read((String)"xxxxxxxxxxxxxxxxxxxxxxxxxxx="));
                subTreeNode.add((MutableTreeNode)((Object)new PurGroupTreeNode(purorginfo)));
            }
            if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)subTreeNode)) {
                this.expandnode = subTreeNode;
            }
            subTreeNode.setCustomIcon(this.companyIcon);
            if (nodeMap.containsKey(orginfo.getParent().getId().toString())) {
                ((PurGroupTreeNode)((Object)nodeMap.get(orginfo.getParent().getId().toString()))).add((MutableTreeNode)((Object)subTreeNode));
            }
            nodeMap.put(orginfo.getId().toString(), subTreeNode);
        }
        if (rootnode != null) {
            ArrayList trees = this.getInitGroupTrees();
            for (PurGroupTreeNode tree : trees) {
                PurchaseGroupInfo groupinfo = (PurchaseGroupInfo)tree.getUserObject();
                if (nodeMap.containsKey(groupinfo.getPurOrg().getId().toString())) {
                    ((PurGroupTreeNode)((Object)nodeMap.get(groupinfo.getPurOrg().getId().toString()))).add((MutableTreeNode)((Object)tree));
                }
                nodeMap.put(groupinfo.getId().toString(), tree);
            }
        }
        return rootnode;
    }

    private boolean hasViewPermission(PurchaseOrgUnitInfo orginfo) throws Exception {
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(orginfo.getId());
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        return iPermission.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, "purGroup_view");
    }

    private ArrayList getGroupTrees() throws Exception {
        ArrayList<PurGroupTreeNode> grouptrees = new ArrayList<PurGroupTreeNode>();
        HashMap<String, PurGroupTreeNode> nodemap = new HashMap<String, PurGroupTreeNode>();
        IRowSet rows = this.getGroupRowSet();
        if (rows == null) {
            return null;
        }
        while (rows.next()) {
            PurchaseGroupInfo groupinfo = this.getGroupInfo(rows);
            PurGroupTreeNode node = new PurGroupTreeNode(groupinfo);
            node.setVirtual(true);
            if (!groupinfo.isIsLeaf()) {
                PurchaseGroupInfo temppurGroupInfo = new PurchaseGroupInfo();
                temppurGroupInfo.setId(BOSUuid.read((String)"xxxxxxxxxxxxxxxxxxxxxxxxxxx="));
                node.add((MutableTreeNode)((Object)new PurGroupTreeNode(temppurGroupInfo)));
            }
            if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)node)) {
                this.expandnode = node;
            }
            if (groupinfo.getParentType() == 0) {
                grouptrees.add(node);
                node.setCustomIcon(this.groupIcon);
            } else if (nodemap.containsKey(groupinfo.getParent().getId().toString())) {
                ((PurGroupTreeNode)((Object)nodemap.get(groupinfo.getParent().getId().toString()))).add((MutableTreeNode)((Object)node));
                node.setCustomIcon(this.groupIcon);
            }
            nodemap.put(groupinfo.getId().toString(), node);
        }
        return grouptrees;
    }

    private ArrayList getInitGroupTrees() throws Exception {
        ArrayList<PurGroupTreeNode> grouptrees = new ArrayList<PurGroupTreeNode>();
        HashMap<String, PurGroupTreeNode> nodemap = new HashMap<String, PurGroupTreeNode>();
        IRowSet rows = this.getInitGroupRowSet();
        if (rows == null) {
            return null;
        }
        while (rows.next()) {
            PurchaseGroupInfo groupinfo = this.getGroupInfo(rows);
            PurGroupTreeNode node = new PurGroupTreeNode(groupinfo);
            if (groupinfo.getDeletedStatus() == ForbidStatusEnum.FORBID) {
                node.setTextColor(Color.gray);
            }
            if (!groupinfo.isIsLeaf()) {
                PurchaseGroupInfo temppurGroupInfo = new PurchaseGroupInfo();
                temppurGroupInfo.setId(BOSUuid.read((String)"xxxxxxxxxxxxxxxxxxxxxxxxxxx="));
                node.add((MutableTreeNode)((Object)new PurGroupTreeNode(temppurGroupInfo)));
            }
            node.setVirtual(true);
            if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)node)) {
                this.expandnode = node;
            }
            if (groupinfo.getParentType() == 0) {
                grouptrees.add(node);
                node.setCustomIcon(this.groupIcon);
            } else if (groupinfo.getParent() != null && nodemap.containsKey(groupinfo.getParent().getId().toString())) {
                ((PurGroupTreeNode)((Object)nodemap.get(groupinfo.getParent().getId().toString()))).add((MutableTreeNode)((Object)node));
                node.setCustomIcon(this.groupIcon);
            }
            nodemap.put(groupinfo.getId().toString(), node);
        }
        return grouptrees;
    }

    private PurchaseOrgUnitInfo getPurchaseOrgInfo(IRowSet row) throws Exception {
        PurchaseOrgUnitInfo orginfo = new PurchaseOrgUnitInfo();
        orginfo.setId(BOSUuid.read((String)row.getString("id")));
        orginfo.setName(row.getString("name"));
        orginfo.setNumber(row.getString("number"));
        orginfo.setIsLeaf(row.getBoolean("isLeaf"));
        orginfo.setLongNumber(row.getString("longNumber"));
        orginfo.setLevel(row.getInt("level"));
        orginfo.setIsBizUnit(row.getBoolean("isBizUnit"));
        PurchaseOrgUnitInfo parentInfo = new PurchaseOrgUnitInfo();
        if (row.getString("parent.id") == null || row.getString("parent.id").equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        orginfo.setParent(parentInfo);
        return orginfo;
    }

    private IRowSet getGroupRowSet() throws Exception {
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getCU().getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuid));
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.scm.sm.pur.app.PurGroupQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private IRowSet getInitGroupRowSet() throws Exception {
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getCU().getId().toString();
        if (this.topPurOrgUnitInfo == null && SysContext.getSysContext().getCurrentCtrlUnit().getCU().isIsPurchaseOrgUnit()) {
            this.topPurOrgUnitInfo = this.getTopPurOrgUnitInfo(cuid);
        }
        EntityViewInfo viewInfo = this.getChildGroupFilter(this.topPurOrgUnitInfo);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.scm.sm.pur.app.PurGroupQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private EntityViewInfo getChildGroupFilter(PurchaseOrgUnitInfo purOrgInfo) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("purOrg.id", (Object)purOrgInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1), CompareType.EQUALS));
        viewInfo.setFilter(fi);
        SorterItemInfo sorterInfo = new SorterItemInfo("number");
        sorterInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterInfo);
        return viewInfo;
    }

    private PurchaseGroupInfo getGroupInfo(IRowSet row) throws Exception {
        PurchaseGroupInfo groupinfo = new PurchaseGroupInfo();
        groupinfo.setId(BOSUuid.read((String)row.getString("id")));
        groupinfo.setName(row.getString("name"));
        groupinfo.setNumber(row.getString("number"));
        groupinfo.setDescription(row.getString("description"));
        groupinfo.setLongNumber(row.getString("longNumber"));
        groupinfo.setParentType(row.getInt("parentType"));
        groupinfo.setLevel(row.getInt("level"));
        groupinfo.setIsLeaf(row.getBoolean("isLeaf"));
        if (row.getInt("deletedStatus") == 1) {
            groupinfo.setDeletedStatus(ForbidStatusEnum.UNFORBID);
        } else {
            groupinfo.setDeletedStatus(ForbidStatusEnum.FORBID);
        }
        CtrlUnitInfo cu = new CtrlUnitInfo();
        cu.setId(BOSUuid.read((String)row.getString("CU.id")));
        groupinfo.setCU(cu);
        PurchaseOrgUnitInfo orginfo = new PurchaseOrgUnitInfo();
        if (row.getString("purOrg.id") == null || row.getString("purOrg.id").equals("")) {
            orginfo = null;
        } else {
            orginfo.setId(BOSUuid.read((String)row.getString("purOrg.id")));
            orginfo.setName(row.getString("purOrg.name"));
            orginfo.setNumber(row.getString("purOrg.number"));
        }
        groupinfo.setPurOrg(orginfo);
        PurchaseGroupInfo parentInfo = new PurchaseGroupInfo();
        if (row.getString("parent.id") == null || row.getString("parent.id").equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        groupinfo.setParent(parentInfo);
        return groupinfo;
    }

    private class PurGroupTreeNode
    extends KDTreeNode {
        public PurGroupTreeNode(Object o) {
            super(o);
        }

        public boolean equals(Object obj) {
            if (obj != null && !(obj instanceof DefaultKingdeeTreeNode)) {
                return false;
            }
            PurGroupTreeNode node = (PurGroupTreeNode)((Object)obj);
            if (obj != null && node.getUserObject() != null && node.getUserObject() instanceof PurchaseOrgUnitInfo && this.getUserObject() != null && this.getUserObject() instanceof PurchaseOrgUnitInfo) {
                PurchaseOrgUnitInfo orginfo = (PurchaseOrgUnitInfo)this.getUserObject();
                PurchaseOrgUnitInfo objorginfo = (PurchaseOrgUnitInfo)node.getUserObject();
                if (orginfo.getId() != null && objorginfo.getId() != null && orginfo.getId().toString().equals(objorginfo.getId().toString())) {
                    return true;
                }
            } else if (obj != null && node.getUserObject() != null && node.getUserObject() instanceof PurchaseGroupInfo && this.getUserObject() != null && this.getUserObject() instanceof PurchaseGroupInfo) {
                PurchaseGroupInfo info = (PurchaseGroupInfo)this.getUserObject();
                PurchaseGroupInfo objinfo = (PurchaseGroupInfo)node.getUserObject();
                if (info.getId() != null && objinfo.getId() != null && info.getId().toString().equals(objinfo.getId().toString())) {
                    return true;
                }
            }
            return false;
        }
    }
}

