/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sm.pur.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ForbidStatusEnum;
import com.kingdee.eas.basedata.scm.sm.pur.IPurchasePerson;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonFactory;
import com.kingdee.eas.basedata.scm.sm.pur.client.AbstractPurchaseGroupEditUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;

public class PurchaseGroupEditUI
extends AbstractPurchaseGroupEditUI {
    PurchaseOrgUnitInfo purOrginfo = null;
    PurchaseGroupInfo parentgroupinfo = null;
    PurchaseGroupInfo currGroupInfo = null;
    Map<String, PurchaseOrgUnitInfo> purOrgInfoMap = new HashMap<String, PurchaseOrgUnitInfo>();
    int parenttype = 0;

    @Override
    public void loadFields() {
        super.loadFields();
        this.txtPurGroupNumber.requestFocus();
        this.txtPurGroupName.setRequired(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private PurchaseOrgUnitInfo getPurchaseOrgUnitInfo(String id) throws BOSException, EASBizException {
        IPurchaseOrgUnit iPurOrg = PurchaseOrgUnitFactory.getRemoteInstance();
        ObjectUuidPK objPK = new ObjectUuidPK(id);
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = iPurOrg.getPurchaseOrgUnitInfo((IObjectPK)objPK);
        return purchaseOrgUnitInfo;
    }

    @Override
    protected IObjectValue createNewData() {
        PurchaseGroupInfo groupInfo = new PurchaseGroupInfo();
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.parenttype == 0) {
                this.txtPurOrgName.setText(this.purOrginfo.getName());
                this.bizPromptPurOrg.setValue((Object)this.purOrginfo);
                groupInfo.setPurOrg(this.purOrginfo);
            } else if (this.parenttype == 1) {
                String purOrdId = this.parentgroupinfo.getPurOrg().getId().toString();
                if (!this.purOrgInfoMap.containsKey(purOrdId)) {
                    try {
                        this.purOrgInfoMap.put(purOrdId, this.getPurchaseOrgUnitInfo(purOrdId));
                    }
                    catch (EASBizException e1) {
                        this.handUIException(e1);
                    }
                    catch (BOSException e2) {
                        this.handUIException(e2);
                    }
                }
                PurchaseOrgUnitInfo purchaseOrgUnitInfo = this.purOrgInfoMap.get(purOrdId);
                this.txtPurOrgName.setText(purchaseOrgUnitInfo.getName());
                this.bizPromptPurOrg.setValue((Object)purchaseOrgUnitInfo);
                groupInfo.setPurOrg(purchaseOrgUnitInfo);
            }
            groupInfo.setParent(this.parentgroupinfo);
            groupInfo.setParentType(this.parenttype);
        } else if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW)) {
            this.txtPurOrgName.setText(this.currGroupInfo.getPurOrg().getName());
            this.bizPromptPurOrg.setValue((Object)this.currGroupInfo.getPurOrg());
            groupInfo.setPurOrg(this.currGroupInfo.getPurOrg());
        }
        groupInfo.setDeletedStatus(ForbidStatusEnum.UNFORBID);
        return groupInfo;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PurchaseGroupFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.txtPurGroupNumber.setMaxLength(80);
        this.txtPurGroupName.setMaxLength(255);
        this.txtDescription.setMaxLength(255);
        try {
            SCMClientUtils.setPurchaseOrgF7((KDBizPromptBox)this.bizPromptPurOrg);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.purOrginfo = null;
            this.purOrginfo = (PurchaseOrgUnitInfo)this.getUIContext().get("PurchaseOU");
            this.parentgroupinfo = null;
            this.parentgroupinfo = (PurchaseGroupInfo)this.getUIContext().get("ParentGroup");
            if (this.purOrginfo != null) {
                this.parenttype = 0;
            } else if (this.parentgroupinfo != null) {
                this.parenttype = 1;
                this.purOrginfo = this.parentgroupinfo.getPurOrg();
            }
        } else if (this.getOprtState().equals(OprtState.EDIT) || this.getOprtState().equals(OprtState.VIEW)) {
            this.currGroupInfo = null;
            this.currGroupInfo = (PurchaseGroupInfo)this.getUIContext().get("ParentGroup");
            this.purOrginfo = this.currGroupInfo.getPurOrg();
            if (this.isReferenced(this.currGroupInfo) && this.getOprtState().equals(OprtState.EDIT)) {
                this.txtPurGroupName.setEnabled(true);
                this.txtPurGroupNumber.setEnabled(true);
                this.bizPromptPurOrg.setEnabled(false);
            }
        }
        super.onLoad();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    private boolean isReferenced(PurchaseGroupInfo purgroup) {
        try {
            IPurchasePerson person = PurchasePersonFactory.getRemoteInstance();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("purGroup", (Object)purgroup.getId().toString()));
            return person.exists(filter);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
            return false;
        }
    }

    @Override
    protected void bizPromptPurOrg_stateChanged(ChangeEvent e) throws Exception {
        PurchaseOrgUnitInfo orginfo = (PurchaseOrgUnitInfo)this.bizPromptPurOrg.getValue();
        if (orginfo != null) {
            this.txtPurOrgName.setText(orginfo.getName());
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.txtPurGroupNumber.getText() == null || this.txtPurGroupNumber.getText().length() == 0) {
            this.txtPurGroupNumber.requestFocus();
            MsgBox.showInfo((String)this.getResString("PurGroup_NeedNumber"));
            SysUtil.abort();
        } else if (this.txtPurGroupName.getSelectedItem() == null || ((MultiLangItem)this.txtPurGroupName.getSelectedItem()).getData().toString().length() == 0) {
            this.txtPurGroupName.requestFocus();
            MsgBox.showInfo((String)this.getResString("PurGroup_NeedName"));
            SysUtil.abort();
        } else if (this.bizPromptPurOrg.getValue() == null) {
            this.bizPromptPurOrg.requestFocus();
            MsgBox.showInfo((String)this.getResString("PurGroup_NeedOrgNumber"));
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    private String getResString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.pur.BDScmPurResource", (String)key);
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        PurchaseGroupInfo purGroupInfo = (PurchaseGroupInfo)newData;
        purGroupInfo.setNumber(null);
        purGroupInfo.setName(null);
        super.setFieldsNull(newData);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        try {
            super.actionSubmit_actionPerformed(e);
        }
        catch (TreeBaseException treebaseEx) {
            if (treebaseEx.getSubCode().equals(TreeBaseException.CHECKNUMBERDUPLICATED.getCode())) {
                this.txtPurGroupNumber.requestFocus();
            }
            throw treebaseEx;
        }
    }
}

