/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sm.srm.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierCollection;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.basedata.scm.sm.srm.IApprovedSupplier;
import com.kingdee.eas.basedata.scm.sm.srm.client.AbstractAssignDestUI4AppSup;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class AssignDestUI4AppSup
extends AbstractAssignDestUI4AppSup {
    private static final Logger logger = CoreUIObject.getLogger(AssignDestUI4AppSup.class);
    private int sort = 0;
    private SorterItemCollection sortColl = new SorterItemCollection();

    public AssignDestUI4AppSup() throws Exception {
        this.kDTable1.checkParsed();
        this.sortColl.add(new SorterItemInfo("purOrgCreator.name"));
        this.sortColl.add(new SorterItemInfo("supplier.name"));
        this.sortColl.add(new SorterItemInfo("materialItem.number"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.initTable();
    }

    private void initTable() throws Exception {
        List ids = (List)this.getUIContext().get("ids");
        HashSet<String> idSet = new HashSet<String>();
        for (Object id : ids) {
            idSet.add(id.toString());
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceObjectID", idSet, CompareType.INCLUDE));
        entity.setFilter(filter);
        entity.setSorter(this.sortColl);
        entity.setSelector(this.getSelectorsForAppSup());
        ApprovedSupplierCollection collection = ApprovedSupplierFactory.getRemoteInstance().getApprovedSupplierCollection(entity);
        IRow row = null;
        ApprovedSupplierInfo info = null;
        for (int i = 0; i < collection.size(); ++i) {
            info = collection.get(i);
            row = this.kDTable1.addRow();
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("purOrgCreator").setValue((Object)info.getPurOrgCreator().getName());
            row.getCell("supplier").setValue((Object)info.getSupplier().getName());
            row.getCell("materialNum").setValue((Object)info.getMaterialItem().getNumber());
            row.getCell("materialName").setValue((Object)info.getMaterialItem().getName());
            row.getCell("materialAttr").setValue((Object)info.getMaterialAttr().toString());
            row.getCell("purOrgNum").setValue((Object)info.getPurchaseOrg().getNumber());
            row.getCell("purOrgName").setValue((Object)info.getPurchaseOrg().getName());
        }
    }

    private SelectorItemCollection getSelectorsForAppSup() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("purchaseOrg.id"));
        sic.add(new SelectorItemInfo("purchaseOrg.name"));
        sic.add(new SelectorItemInfo("purchaseOrg.number"));
        sic.add(new SelectorItemInfo("purOrgCreator.name"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("materialAttr"));
        sic.add(new SelectorItemInfo("materialItem.name"));
        sic.add(new SelectorItemInfo("materialItem.number"));
        sic.add(new SelectorItemInfo("materialItem.id"));
        return sic;
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.kDTable1.getRowCount() == 0 || this.kDTable1.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (MsgBox.showConfirm2((String)this.getResource("Msg_Delete")) != 0) {
            return;
        }
        IApprovedSupplier iApprovedSupplier = ApprovedSupplierFactory.getRemoteInstance();
        if (SCMClientUtils.isSelectRow((KDTable)this.kDTable1)) {
            iApprovedSupplier.deleteForAssign(SCMUtils.convertStringToObjectPK((String[])SCMClientUtils.getSelectRowFieldValue((KDTable)this.kDTable1, (String)"id")));
            this.kDTable1.refresh();
            this.initTable();
        }
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)key);
    }

    @Override
    protected void kDTable1_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getColIndex() == -1) {
            return;
        }
        if (e.getType() != 0) {
            return;
        }
        this.OrderByForTable(e);
        this.kDTable1.removeRows();
        this.onLoad();
    }

    private void OrderByForTable(KDTMouseEvent e) throws Exception {
        KDTSortManager sm = new KDTSortManager(this.kDTable1);
        this.sort = this.sort == 0 ? 1 : 0;
        sm.sort(e.getColIndex(), this.sort);
        this.setSortForQuery(e.getColIndex());
    }

    protected void setSortForQuery(int colIndex) throws Exception {
        SorterItemInfo sorterInfo;
        this.sortColl.clear();
        String columnName = this.kDTable1.getColumn(colIndex).getKey();
        SortType sortType = SortType.ASCEND;
        if (this.sort == 1) {
            sortType = SortType.DESCEND;
        }
        if ("purOrgCreator".equals(columnName)) {
            sorterInfo = new SorterItemInfo("purOrgCreator.name");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("supplier".equals(columnName)) {
            sorterInfo = new SorterItemInfo("supplier.name");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("materialNum".equals(columnName)) {
            sorterInfo = new SorterItemInfo("materialItem.number");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("materialName".equals(columnName)) {
            sorterInfo = new SorterItemInfo("materialItem.name");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("materialAttr".equals(columnName)) {
            sorterInfo = new SorterItemInfo("materialAttr");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("purOrgNum".equals(columnName)) {
            sorterInfo = new SorterItemInfo("purchaseOrg.number");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("purOrgName".equals(columnName)) {
            sorterInfo = new SorterItemInfo("purchaseOrg.name");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
    }
}

