/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sm.srm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.CellTreeNode;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamUtil;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ImportCompayFieldsEnum;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierCollection;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.basedata.scm.sm.srm.client.AbstractAssignMultiOrgs4ApproveSupUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.tree.MutableTreeNode;

public class AssignMultiOrgs4ApproveSupUI
extends AbstractAssignMultiOrgs4ApproveSupUI {
    private boolean isOK = false;
    private HashSet selectedRowIndexes;
    private DefaultKingdeeTreeNode root;
    private Object[] data;
    public static final String NEED_WAIT_4_UIOPEN = "needWait4UIOpen";
    NumberCellInfo[] cachedCellInfos = null;

    public AssignMultiOrgs4ApproveSupUI() throws Exception {
        this.doInitWhenConstructing();
    }

    private void doInitWhenConstructing() {
        this.kDContainer1.setContainerType(2);
        this.kDContainer2.setContainerType(2);
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnRemoveAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignMultiOrgs4ApproveSupUI.this.onClickForBtnOK();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignMultiOrgs4ApproveSupUI.this.onClickForBtnCancel();
            }
        });
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignMultiOrgs4ApproveSupUI.this.onClickForBtnAdd();
            }
        });
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignMultiOrgs4ApproveSupUI.this.onClickForBtnRemove();
            }
        });
        this.btnAddAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignMultiOrgs4ApproveSupUI.this.onClickForBtnAddAll();
            }
        });
        this.btnRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignMultiOrgs4ApproveSupUI.this.onClickForBtnRemoveAll();
            }
        });
        this.providedTable.checkParsed();
        this.selectedTable.checkParsed();
        this.providedTable.getSelectManager().setSelectMode(10);
        this.selectedTable.getSelectManager().setSelectMode(10);
        this.providedTable.getStyleAttributes().setLocked(true);
        this.selectedTable.getStyleAttributes().setLocked(true);
        this.providedTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                AssignMultiOrgs4ApproveSupUI.this.onClickForProvidedTable(e);
            }
        });
        this.selectedTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                AssignMultiOrgs4ApproveSupUI.this.onClickForSelectedTable(e);
            }
        });
        this.btnSearch.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.comboField.addItem((Object)ImportCompayFieldsEnum.NUMBER);
        this.comboField.addItem((Object)ImportCompayFieldsEnum.NAME);
        this.comboField.setSelectedIndex(0);
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AssignMultiOrgs4ApproveSupUI.this.doQuerying();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Component)((Object)AssignMultiOrgs4ApproveSupUI.this), (Throwable)ex);
                }
            }
        });
        this.txtFieldValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AssignMultiOrgs4ApproveSupUI.this.doQuerying();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Component)((Object)AssignMultiOrgs4ApproveSupUI.this), (Throwable)ex);
                }
            }
        });
        this.selectedRowIndexes = new HashSet();
        this.data = new Object[0];
        this.root = new DefaultKingdeeTreeNode(null);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Object needWait4UIOpenObj = this.getUIContext().get(NEED_WAIT_4_UIOPEN);
        if (needWait4UIOpenObj == null || ((Boolean)needWait4UIOpenObj).booleanValue()) {
            this.initWhenOnLoad();
        } else {
            this.initWhenOnLoad_nowait();
        }
    }

    private void initWhenOnLoad() throws Exception {
        this.doLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                AssignMultiOrgs4ApproveSupUI.this.init();
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
    }

    private void initWhenOnLoad_nowait() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        this.initByGivenData();
        this.setUITitle(this.getGivenTitle());
    }

    private void initProvidedTable() throws Exception {
        if (this.cachedCellInfos == null) {
            this.cachedCellInfos = this.getSortedOrgArray();
        }
        this.fillProvidedTable(this.cachedCellInfos);
    }

    private void fillProvidedTable(NumberCellInfo[] filteredCellInfos) {
        if (filteredCellInfos == null) {
            return;
        }
        this.providedTable.removeRows(false);
        HashMap map = new HashMap();
        IRow row = null;
        for (int i = 0; i < filteredCellInfos.length; ++i) {
            row = this.providedTable.addRow();
            row.getCell("id").setValue((Object)filteredCellInfos[i].getID());
            row.getCell("number").setValue((Object)this.getCellTreeNode(map, filteredCellInfos[i]));
            row.getCell("name").setValue((Object)filteredCellInfos[i].getName());
        }
    }

    private NumberCellInfo[] getSortedOrgArray() throws Exception {
        int i;
        PurchaseOrgUnitCollection fullCol = this.getAuthorizedOrgCol();
        int size = fullCol.size();
        Object[] cellInfos = new NumberCellInfo[size];
        for (i = 0; i < size; ++i) {
            cellInfos[i] = new NumberCellInfo(fullCol.get(i));
        }
        Arrays.sort(cellInfos);
        for (i = 0; i < size; ++i) {
            ((NumberCellInfo)cellInfos[i]).setRowIndex(i);
        }
        return cellInfos;
    }

    private PurchaseOrgUnitCollection getAuthorizedOrgCol() throws Exception {
        PurchaseOrgUnitCollection orgUnitCollection = new PurchaseOrgUnitCollection();
        Set MaterialGroupIdSet = (Set)this.getUIContext().get("MaterialGroupIdSet");
        Set materialIdSet = (Set)this.getUIContext().get("materialIdSet");
        String purOrgID = this.getUIContext().get("purOrgID").toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)purOrgID, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        PurchaseOrgUnitCollection unitCollection = PurchaseOrgUnitFactory.getRemoteInstance().getPurchaseOrgUnitCollection(view);
        return unitCollection;
    }

    private IObjectPK getOrgTreePK(OrgType orgType) {
        OrgTypeInfo orgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgType);
        String treeID = null;
        if (orgTypeInfo != null) {
            treeID = orgTypeInfo.getOrgTreeID();
        }
        return new ObjectUuidPK(treeID);
    }

    private CellTreeNode getCellTreeNode(HashMap map, NumberCellInfo cellInfo) {
        String longNumber = cellInfo.getLongNumber();
        StringBuffer virtualParentLongNumber = new StringBuffer();
        int parentLevel = -1;
        int level = 0;
        CellTreeNode parentNode = null;
        String[] numbers = longNumber.split("!");
        int n = numbers.length - 1;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                virtualParentLongNumber.append("!");
            }
            virtualParentLongNumber.append(numbers[i]);
            if (!map.containsKey(virtualParentLongNumber.toString())) continue;
            parentNode = (CellTreeNode)map.get(virtualParentLongNumber.toString());
            parentLevel = parentNode.getTreeLevel();
            parentNode.setHasChildren(true);
        }
        level = parentLevel + 1;
        CellTreeNode cellTreeNode = new CellTreeNode();
        cellTreeNode.setTreeLevel(level);
        cellTreeNode.setValue((Object)cellInfo);
        cellTreeNode.setHasChildren(false);
        map.put(longNumber, cellTreeNode);
        if (parentNode != null) {
            cellInfo.setParentRowIndex(((NumberCellInfo)parentNode.getValue()).getRowIndex());
        }
        return cellTreeNode;
    }

    private void initByGivenData() throws Exception {
        this.txtFieldValue.setText(null);
        this.initProvidedTable();
        this.emptySelectedTable();
        this.makeTreeFromSelectedOrgs();
        this.setBackGroudColorBySelectedRowIndexes();
    }

    private void emptySelectedTable() {
        this.selectedTable.removeRows(false);
        this.selectedRowIndexes.clear();
    }

    private String getGivenPermItemName() {
        return (String)this.getUIContext().get("PermItemName");
    }

    private OrgType getGivenOrgType() {
        return (OrgType)this.getUIContext().get("OrgType");
    }

    private String getGivenTitle() {
        return (String)this.getUIContext().get("Title");
    }

    private void doQuerying() throws Exception {
        String value = this.txtFieldValue.getText();
        if (!StringUtils.isEmpty((String)value)) {
            value = value.trim();
            boolean isBlurred = this.checkBlured.isSelected();
            int field = ((ImportCompayFieldsEnum)this.comboField.getSelectedItem()).getValue();
            String fieldStr = null;
            switch (field) {
                case 1: {
                    fieldStr = "number";
                    break;
                }
                case 2: {
                    fieldStr = "name";
                }
            }
            ArrayList<NumberCellInfo> filteredCellInfoList = new ArrayList<NumberCellInfo>();
            for (int i = 0; i < this.cachedCellInfos.length; ++i) {
                NumberCellInfo cellInfo = this.cachedCellInfos[i];
                boolean isTheWanted = false;
                Object obj = cellInfo.getPurchaseOrgUnitInfo().get(fieldStr);
                if (isBlurred) {
                    isTheWanted = obj != null && obj.toString().indexOf(value) != -1;
                } else {
                    boolean bl = isTheWanted = obj != null && obj.toString().equals(value);
                }
                if (!isTheWanted) continue;
                filteredCellInfoList.add(cellInfo);
                for (int j = 0; j < i; ++j) {
                    NumberCellInfo parentCellInfo = this.cachedCellInfos[j];
                    if (!cellInfo.getLongNumber().startsWith(parentCellInfo.getLongNumber() + "!") || filteredCellInfoList.contains(parentCellInfo)) continue;
                    filteredCellInfoList.add(parentCellInfo);
                }
            }
            Object[] filteredCellInfos = filteredCellInfoList.toArray(new NumberCellInfo[0]);
            Arrays.sort(filteredCellInfos);
            this.fillProvidedTable((NumberCellInfo[])filteredCellInfos);
        } else {
            this.fillProvidedTable(this.cachedCellInfos);
        }
        this.setBackGroudColorBySelectedRowIndexes();
    }

    private void setBackGroudColorBySelectedRowIndexes() {
        for (int i = 0; i < this.providedTable.getRowCount(); ++i) {
            int actualRowIndex = ((NumberCellInfo)((CellTreeNode)this.providedTable.getCell(i, "number").getValue()).getValue()).getRowIndex();
            if (this.selectedRowIndexes.contains(actualRowIndex + "")) {
                this.providedTable.getRow(i).getStyleAttributes().setBackground(new Color(0xD9D9D2));
                continue;
            }
            this.providedTable.getRow(i).getStyleAttributes().setBackground(new Color(0xFFFFFF));
        }
    }

    private void onClickForProvidedTable(KDTMouseEvent e) {
        this.selectedTable.getSelectManager().remove();
        KDTSelectBlock block = this.providedTable.getSelectManager().get();
        if (block != null) {
            if (e.getClickCount() == 1) {
                int row = block.getBeginRow();
                int col = block.getBeginCol();
                if (col == 1) {
                    ((CellTreeNode)this.providedTable.getCell(row, "number").getValue()).doClick(this.providedTable, (EventObject)e);
                }
            } else if (e.getClickCount() == 2) {
                this.onClickForBtnAdd();
            }
        }
    }

    private void onClickForSelectedTable(KDTMouseEvent e) {
        this.providedTable.getSelectManager().remove();
    }

    private void onClickForBtnAdd() {
        RowRange[] rowRanges = this.getSortedRowRanges(this.providedTable);
        for (int rangeIndex = 0; rangeIndex < rowRanges.length; ++rangeIndex) {
            int begin = rowRanges[rangeIndex].getBeginRow();
            int end = rowRanges[rangeIndex].getEndRow();
            for (int i = begin; i <= end; ++i) {
                int fakeRowIndex = i;
                int actualRowIndex = ((NumberCellInfo)((CellTreeNode)this.providedTable.getCell(fakeRowIndex, "number").getValue()).getValue()).getRowIndex();
                if (this.selectedRowIndexes.contains(actualRowIndex + "")) continue;
                int insertRowIndex = this.selectedTable.getRowCount();
                for (int j = 0; j < this.selectedTable.getRowCount(); ++j) {
                    int rowIndex = ((NumberCellInfo)((CellTreeNode)this.selectedTable.getCell(j, "number").getValue()).getValue()).getRowIndex();
                    if (actualRowIndex >= rowIndex) continue;
                    insertRowIndex = j;
                    break;
                }
                IRow row = this.selectedTable.addRow(insertRowIndex);
                row.getCell("id").setValue(this.providedTable.getCell(fakeRowIndex, "id").getValue());
                row.getCell("number").setValue(this.providedTable.getCell(fakeRowIndex, "number").getValue());
                row.getCell("name").setValue(this.providedTable.getCell(fakeRowIndex, "name").getValue());
                this.selectedRowIndexes.add(actualRowIndex + "");
            }
        }
        this.setBackGroudColorBySelectedRowIndexes();
    }

    private void onClickForBtnRemove() {
        RowRange[] rowRanges = this.getSortedRowRanges(this.selectedTable);
        for (int rangeIndex = rowRanges.length - 1; rangeIndex >= 0; --rangeIndex) {
            int end;
            int begin = rowRanges[rangeIndex].getBeginRow();
            for (int i = end = rowRanges[rangeIndex].getEndRow(); i >= begin; --i) {
                int srcRowIndex = ((NumberCellInfo)((CellTreeNode)this.selectedTable.getCell(i, "number").getValue()).getValue()).getRowIndex();
                this.selectedRowIndexes.remove(srcRowIndex + "");
                this.selectedTable.removeRow(i);
            }
        }
        this.setBackGroudColorBySelectedRowIndexes();
    }

    private RowRange[] getSortedRowRanges(KDTable table) {
        if (table.getSelectManager().get() == null) {
            return new RowRange[0];
        }
        ArrayList blocks = table.getSelectManager().getBlocks();
        int size = blocks.size();
        Object[] rowRanges = new RowRange[size];
        int n = blocks.size();
        for (int i = 0; i < n; ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            rowRanges[i] = new RowRange(block.getTop(), block.getBottom());
        }
        Arrays.sort(rowRanges);
        return rowRanges;
    }

    private void onClickForBtnAddAll() {
        int begin = 0;
        int end = this.providedTable.getRowCount() - 1;
        for (int i = begin; i <= end; ++i) {
            int fakeRowIndex = i;
            int actualRowIndex = ((NumberCellInfo)((CellTreeNode)this.providedTable.getCell(fakeRowIndex, "number").getValue()).getValue()).getRowIndex();
            block1: do {
                if (!this.selectedRowIndexes.contains(actualRowIndex + "")) {
                    int insertRowIndex = this.selectedTable.getRowCount();
                    for (int j = 0; j < this.selectedTable.getRowCount(); ++j) {
                        int rowIndex = ((NumberCellInfo)((CellTreeNode)this.selectedTable.getCell(j, "number").getValue()).getValue()).getRowIndex();
                        if (actualRowIndex >= rowIndex) continue;
                        insertRowIndex = j;
                        break;
                    }
                    IRow row = this.selectedTable.addRow(insertRowIndex);
                    row.getCell("id").setValue(this.providedTable.getCell(fakeRowIndex, "id").getValue());
                    row.getCell("number").setValue(this.providedTable.getCell(fakeRowIndex, "number").getValue());
                    row.getCell("name").setValue(this.providedTable.getCell(fakeRowIndex, "name").getValue());
                    this.selectedRowIndexes.add(actualRowIndex + "");
                }
                actualRowIndex = ((NumberCellInfo)((CellTreeNode)this.providedTable.getCell(fakeRowIndex, "number").getValue()).getValue()).getParentRowIndex();
                for (int j = i - 1; j >= 0; --j) {
                    if (actualRowIndex != ((NumberCellInfo)((CellTreeNode)this.providedTable.getCell(j, "number").getValue()).getValue()).getRowIndex()) continue;
                    fakeRowIndex = j;
                    continue block1;
                }
            } while (actualRowIndex != -1);
        }
        this.setBackGroudColorBySelectedRowIndexes();
    }

    private void onClickForBtnRemoveAll() {
        int end;
        if (this.selectedTable.getRowCount() == 0) {
            return;
        }
        int begin = 0;
        for (int i = end = this.selectedTable.getRowCount() - 1; i >= begin; --i) {
            int srcRowIndex = ((NumberCellInfo)((CellTreeNode)this.selectedTable.getCell(i, "number").getValue()).getValue()).getRowIndex();
            this.selectedRowIndexes.remove(srcRowIndex + "");
            this.selectedTable.removeRow(i);
        }
        this.setBackGroudColorBySelectedRowIndexes();
    }

    private void onClickForBtnOK() {
        ApprovedSupplierCollection approvedSupplierCol = (ApprovedSupplierCollection)((Object)this.getUIContext().get("ApprovedSupCol"));
        ArrayList<ApprovedSupplierInfo> approvedSupplierList = new ArrayList<ApprovedSupplierInfo>();
        for (int i = 0; i < approvedSupplierCol.size(); ++i) {
            approvedSupplierList.add(approvedSupplierCol.get(i));
        }
        ArrayList<PurchaseOrgUnitInfo> purOrgList = new ArrayList<PurchaseOrgUnitInfo>();
        if (this.selectedTable.getRowCount() != 0) {
            for (int i = 0; i < this.selectedTable.getRowCount(); ++i) {
                purOrgList.add(((NumberCellInfo)((CellTreeNode)this.selectedTable.getCell(i, "number").getValue()).getValue()).getPurchaseOrgUnitInfo());
            }
        }
        try {
            if (this.selectedTable.getRowCount() != 0) {
                String msg = ApprovedSupplierFactory.getRemoteInstance().assign(approvedSupplierList, purOrgList);
                int sum = approvedSupplierList.size() * purOrgList.size();
                Integer success = new Integer(msg.split("\\|")[0]);
                int fail = sum - success;
                String detail = EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"share_detailMsg_appSup", (Object[])new Object[]{sum, success, fail});
                if (msg.split("\\|").length > 1) {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)detail, (String)msg.split("\\|")[1], (int)0);
                } else {
                    MsgBox.showInfo((String)detail);
                }
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.isOK = true;
        this.disposeUIWindow();
    }

    private void onClickForBtnCancel() {
        this.disposeUIWindow();
    }

    private void makeTreeFromSelectedOrgs() throws Exception {
        this.root = new DefaultKingdeeTreeNode(null);
        if (this.selectedTable.getRowCount() != 0) {
            PurchaseOrgUnitCollection fullCol = new PurchaseOrgUnitCollection();
            for (int i = 0; i < this.selectedTable.getRowCount(); ++i) {
                fullCol.add(((NumberCellInfo)((CellTreeNode)this.selectedTable.getCell(i, "number").getValue()).getValue()).getPurchaseOrgUnitInfo());
            }
            this.makeTree(this.root, (IObjectCollection)fullCol);
            if (this.root.getChildCount() > 0) {
                this.data = this.getArrayFromRoot();
                this.expandLeafToTree();
            }
        } else {
            this.data = null;
        }
    }

    private void makeTree(DefaultKingdeeTreeNode root, IObjectCollection col) {
        HashMap<String, DefaultKingdeeTreeNode> map = new HashMap<String, DefaultKingdeeTreeNode>();
        for (int i = 0; i < col.size(); ++i) {
            OrgUnitInfo unitInfo = (OrgUnitInfo)col.getObject(i);
            DefaultKingdeeTreeNode parentNode = root;
            StringBuffer parentLongNumber = new StringBuffer();
            String[] numbers = unitInfo.getLongNumber().split("!");
            for (int j = 0; j < numbers.length - 1; ++j) {
                if (j != 0) {
                    parentLongNumber.append("!");
                }
                parentLongNumber.append(numbers[j]);
                if (!map.containsKey(parentLongNumber.toString())) continue;
                parentNode = (DefaultKingdeeTreeNode)map.get(parentLongNumber.toString());
            }
            String cuid = null;
            if (unitInfo.getCU() != null && unitInfo.getCU().getId() != null) {
                cuid = unitInfo.getCU().getId().toString();
            }
            SimpleOrgUnitInfo simpleInfo = new SimpleOrgUnitInfo(unitInfo.getId().toString(), unitInfo.getNumber(), unitInfo.getName(), unitInfo.getLongNumber(), cuid);
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)simpleInfo);
            parentNode.add((MutableTreeNode)node);
            map.put(unitInfo.getLongNumber(), node);
        }
    }

    private Object[] getArrayFromRoot() {
        ArrayList<FullOrgUnitInfo> list = new ArrayList<FullOrgUnitInfo>();
        Enumeration treeNodeEnum = this.root.breadthFirstEnumeration();
        while (treeNodeEnum.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treeNodeEnum.nextElement();
            Object userObj = node.getUserObject();
            if (userObj == null) continue;
            SimpleOrgUnitInfo simpleInfo = (SimpleOrgUnitInfo)userObj;
            FullOrgUnitInfo fullInfo = new FullOrgUnitInfo();
            fullInfo.setId(BOSUuid.read((String)simpleInfo.getID()));
            fullInfo.setNumber(simpleInfo.getNumber());
            fullInfo.setName(simpleInfo.getName());
            fullInfo.setLongNumber(simpleInfo.getLongNumber());
            fullInfo.setIsLeaf(node.isLeaf());
            fullInfo.setLevel(node.getLevel());
            if (simpleInfo.getCuId() != null) {
                CtrlUnitInfo cuInfo = new CtrlUnitInfo();
                cuInfo.setId(BOSUuid.read((String)simpleInfo.getCuId()));
                fullInfo.setCU(cuInfo);
            }
            Object parentUserObject = ((DefaultKingdeeTreeNode)node.getParent()).getUserObject();
            FullOrgUnitInfo parentFullInfo = null;
            if (parentUserObject != null) {
                SimpleOrgUnitInfo parentSimpleInfo = (SimpleOrgUnitInfo)parentUserObject;
                parentFullInfo = new FullOrgUnitInfo();
                parentFullInfo.setId(BOSUuid.read((String)parentSimpleInfo.getID()));
            }
            fullInfo.setParent(parentFullInfo);
            list.add(fullInfo);
        }
        return list.toArray();
    }

    private void expandLeafToTree() throws Exception {
        ArrayList<DefaultKingdeeTreeNode> leafList = new ArrayList<DefaultKingdeeTreeNode>();
        Enumeration treeNodeEnum = this.root.breadthFirstEnumeration();
        while (treeNodeEnum.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treeNodeEnum.nextElement();
            if (!node.isLeaf()) continue;
            leafList.add(node);
        }
        ArrayList<BOSUuid> idList = new ArrayList<BOSUuid>();
        if (this.cachedCellInfos != null) {
            for (int index = 0; index < this.cachedCellInfos.length; ++index) {
                idList.add(this.cachedCellInfos[index].getPurchaseOrgUnitInfo().getId());
            }
        }
        for (int i = 0; i < leafList.size(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)leafList.get(i);
            SimpleOrgUnitInfo simpleInfo = (SimpleOrgUnitInfo)node.getUserObject();
            String oql = new StringBuffer("select id, number, name, longNumber where longNumber like '").append(simpleInfo.getLongNumber()).append("!%'").append(" and id in (" + ParamUtil.aryToStr(idList, (boolean)true) + ") order by longNumber asc").toString();
            IObjectCollection unitCol = this.getBizOrgs(oql);
            if (unitCol == null || unitCol.size() == 0) continue;
            this.makeTree(node, unitCol);
        }
    }

    public boolean isCanceled() {
        return !this.isOK;
    }

    public Object getData() {
        return this.data;
    }

    public Object getFullData() {
        try {
            this.initByGivenData();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.getArrayFromRoot();
    }

    public DefaultKingdeeTreeNode getRootOfSelectedOrgTree() throws Exception {
        return this.root;
    }

    private void doLongTimeTask(ILongTimeTask longTimeTask) {
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        LongTimeDialog ltd = null;
        ltd = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : new LongTimeDialog((Frame)new JFrame()));
        ltd.setLongTimeTask(longTimeTask);
        ltd.show();
    }

    private IObjectCollection getBizOrgs(String oql) throws Exception {
        OrgType orgType = this.getGivenOrgType();
        return NewOrgViewHelper.getOrgUnitCollection(null, (OrgType)orgType, (EntityViewInfo)new EntityViewInfo(oql));
    }

    protected void initKeyStroke() {
    }

    public static class SimpleOrgUnitInfo {
        private String id;
        private String number;
        private String name;
        private String longNumber;
        private String cuid = null;

        public SimpleOrgUnitInfo(String id, String number, String name, String longNumber) {
            this(id, number, name, longNumber, null);
        }

        public SimpleOrgUnitInfo(String id, String number, String name, String longNumber, String cuid) {
            this.id = id;
            this.number = number;
            this.name = name;
            this.longNumber = longNumber;
            this.cuid = cuid;
        }

        public String getID() {
            return this.id;
        }

        public String getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public String getCuId() {
            return this.cuid;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class RowRange
    implements Comparable {
        private int beginRow;
        private int endRow;

        public RowRange(int row1, int row2) {
            this.beginRow = row1;
            this.endRow = row2;
            if (row2 < row1) {
                this.beginRow = row2;
                this.endRow = row1;
            }
        }

        public int compareTo(Object o) {
            return new Integer(this.beginRow).compareTo(new Integer(((RowRange)o).beginRow));
        }

        public int getBeginRow() {
            return this.beginRow;
        }

        public int getEndRow() {
            return this.endRow;
        }
    }

    private static class NumberCellInfo
    implements Comparable {
        private int rowIndex = 0;
        private int parentRowIndex = -1;
        private String id;
        private String number;
        private String name;
        private String longNumber;
        private PurchaseOrgUnitInfo fullInfo;

        public NumberCellInfo(PurchaseOrgUnitInfo fullInfo) {
            this.id = fullInfo.getId().toString();
            this.number = fullInfo.getNumber();
            this.name = fullInfo.getName();
            this.longNumber = fullInfo.getLongNumber();
            this.fullInfo = fullInfo;
        }

        public int compareTo(Object o) {
            return this.longNumber.compareTo(((NumberCellInfo)o).longNumber);
        }

        public boolean equals(Object obj) {
            if (obj instanceof NumberCellInfo) {
                return this.longNumber.equals(((NumberCellInfo)obj).getLongNumber());
            }
            return false;
        }

        public int hashCode() {
            return this.longNumber.hashCode();
        }

        public String toString() {
            return this.number;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        public int getParentRowIndex() {
            return this.parentRowIndex;
        }

        public void setParentRowIndex(int parentRowIndex) {
            this.parentRowIndex = parentRowIndex;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getNumber() {
            return this.number;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public PurchaseOrgUnitInfo getPurchaseOrgUnitInfo() {
            return this.fullInfo;
        }
    }
}

