/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sm.srm.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class MaterialGroupTreeBuilder {
    Icon groupIcon = EASResource.getIcon((String)"imgTree_businessgroup");
    Icon companyIcon = EASResource.getIcon((String)"imgTree_folder_leaf");
    DefaultKingdeeTreeNode lastExpandnode = null;
    DefaultKingdeeTreeNode expandnode = null;

    public MaterialGroupTreeBuilder() {
    }

    public MaterialGroupTreeBuilder(DefaultKingdeeTreeNode Lastnode) {
        this.lastExpandnode = Lastnode;
    }

    public JTree buildtree(JTree tree) throws Exception {
        tree.setModel(new DefaultTreeModel((TreeNode)((Object)this.createRootNode())));
        return tree;
    }

    public DefaultKingdeeTreeNode getExpandNode() {
        return this.expandnode;
    }

    private MaterialGroupTreeNode createRootNode() throws Exception {
        MaterialGroupTreeNode rootNode = null;
        IRowSet rows = this.getMaterialGroupInfoSet();
        rootNode = this.buildTreeByRowSet(rows);
        return rootNode;
    }

    private IRowSet getMaterialGroupInfoSet() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), (String)SysContext.getSysContext().getCurrentCtrlUnit().getLongNumber());
        viewInfo.setFilter(filterInfoCU);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.master.material.app.F7MaterialGroupQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private MaterialGroupTreeNode buildTreeByRowSet(IRowSet rowset) throws Exception {
        if (rowset == null) {
            return null;
        }
        MaterialGroupTreeNode rootnode = null;
        HashMap<String, MaterialGroupTreeNode> nodeMap = new HashMap<String, MaterialGroupTreeNode>();
        DefaultKingdeeTreeNode rootGroupInfo = new DefaultKingdeeTreeNode();
        rootGroupInfo.setText(this.getResource("Msg_MaterialTreeLabel"));
        rootnode = new MaterialGroupTreeNode(rootGroupInfo);
        if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)rootnode)) {
            this.expandnode = rootnode;
        }
        nodeMap.put("root", rootnode);
        while (rowset.next()) {
            MaterialGroupInfo materialGroupInfo = this.getMaterialBrowseGroupInfo(rowset);
            MaterialGroupTreeNode subTreeNode = new MaterialGroupTreeNode(materialGroupInfo);
            if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)subTreeNode)) {
                this.expandnode = subTreeNode;
            }
            if (materialGroupInfo.getParent() == null) {
                ((MaterialGroupTreeNode)((Object)nodeMap.get("root"))).add((MutableTreeNode)((Object)subTreeNode));
            } else if (nodeMap.containsKey(materialGroupInfo.getParent().getId().toString())) {
                ((MaterialGroupTreeNode)((Object)nodeMap.get(materialGroupInfo.getParent().getId().toString()))).add((MutableTreeNode)((Object)subTreeNode));
            }
            nodeMap.put(materialGroupInfo.getId().toString(), subTreeNode);
        }
        if (rootnode != null) {
            ArrayList trees = this.getMaterialTrees();
            for (MaterialGroupTreeNode tree : trees) {
                MaterialInfo materialInfo = (MaterialInfo)tree.getUserObject();
                if (materialInfo == null || materialInfo.getMaterialGroup() == null) continue;
                if (nodeMap.containsKey(materialInfo.getMaterialGroup().getId().toString())) {
                    ((MaterialGroupTreeNode)((Object)nodeMap.get(materialInfo.getMaterialGroup().getId().toString()))).add((MutableTreeNode)((Object)tree));
                }
                nodeMap.put(materialInfo.getId().toString(), tree);
            }
        }
        return rootnode;
    }

    private ArrayList getMaterialTrees() throws Exception {
        ArrayList<MaterialGroupTreeNode> materialTrees = new ArrayList<MaterialGroupTreeNode>();
        HashMap<String, MaterialGroupTreeNode> nodeMap = new HashMap<String, MaterialGroupTreeNode>();
        IRowSet rows = this.getMaterialRowSet();
        if (rows == null) {
            return null;
        }
        while (rows.next()) {
            MaterialInfo materialInfo = this.getMaterialInfo(rows);
            MaterialGroupTreeNode node = new MaterialGroupTreeNode(materialInfo);
            if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)node)) {
                this.expandnode = node;
            }
            materialTrees.add(node);
            nodeMap.put(materialInfo.getId().toString(), node);
        }
        return materialTrees;
    }

    private MaterialGroupInfo getMaterialBrowseGroupInfo(IRowSet row) throws Exception {
        MaterialGroupInfo orginfo = new MaterialGroupInfo();
        orginfo.setId(BOSUuid.read((String)row.getString("id")));
        orginfo.setName(row.getString("name"));
        orginfo.setNumber(row.getString("number"));
        orginfo.setIsLeaf(row.getBoolean("isLeaf"));
        orginfo.setLongNumber(row.getString("longNumber"));
        MaterialGroupInfo parentInfo = new MaterialGroupInfo();
        if (row.getString("parent.id") == null || row.getString("parent.id").equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        orginfo.setParent(parentInfo);
        return orginfo;
    }

    private IRowSet getMaterialRowSet() throws Exception {
        String cuID = SysContext.getSysContext().getCurrentCtrlUnit().getCU().getId().toString();
        ICtrlUnit icu = CtrlUnitFactory.getRemoteInstance();
        CtrlUnitInfo curCU = icu.getCtrlUnitInfo((IObjectPK)new ObjectStringPK(cuID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cuID, (String)curCU.getLongNumber());
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.scm.sm.srm.app.MaterialForSupplyInfoListQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private MaterialInfo getMaterialInfo(IRowSet row) throws Exception {
        MaterialInfo materialInfo = new MaterialInfo();
        materialInfo.setId(BOSUuid.read((String)row.getString("id")));
        materialInfo.setName(row.getString("name"));
        materialInfo.setNumber(row.getString("number"));
        materialInfo.setDescription(row.getString("description"));
        materialInfo.setLongNumber(row.getString("longNumber"));
        MaterialGroupInfo orginfo = new MaterialGroupInfo();
        if (row.getString("MaterialGroup.id") == null || row.getString("MaterialGroup.id").equals("")) {
            orginfo = null;
        } else {
            orginfo.setId(BOSUuid.read((String)row.getString("MaterialGroup.id")));
        }
        materialInfo.setMaterialGroup(orginfo);
        return materialInfo;
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)key);
    }

    private class MaterialGroupTreeNode
    extends KDTreeNode {
        public MaterialGroupTreeNode(Object o) {
            super(o);
        }

        public boolean equals(Object obj) {
            if (obj != null && !(obj instanceof DefaultKingdeeTreeNode)) {
                return false;
            }
            MaterialGroupTreeNode node = (MaterialGroupTreeNode)((Object)obj);
            if (obj != null && node.getUserObject() != null && node.getUserObject() instanceof MaterialGroupInfo && this.getUserObject() != null && this.getUserObject() instanceof MaterialGroupInfo) {
                MaterialGroupInfo materialGroupInfo = (MaterialGroupInfo)this.getUserObject();
                MaterialGroupInfo objMaterialInfo = (MaterialGroupInfo)node.getUserObject();
                if (materialGroupInfo.getId().toString().equals(objMaterialInfo.getId().toString())) {
                    return true;
                }
            } else if (obj != null && node.getUserObject() != null && node.getUserObject() instanceof MaterialInfo && this.getUserObject() != null && this.getUserObject() instanceof MaterialInfo) {
                MaterialInfo info = (MaterialInfo)this.getUserObject();
                MaterialInfo objinfo = (MaterialInfo)node.getUserObject();
                if (info.getId().toString().equals(objinfo.getId().toString())) {
                    return true;
                }
            }
            return false;
        }
    }
}

