/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sm.srm.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.framework.util.EntityControlTypeUtil;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class SupplierGroupTreeBuilder {
    Icon groupIcon = EASResource.getIcon((String)"imgTree_businessgroup");
    Icon companyIcon = EASResource.getIcon((String)"imgTree_folder_leaf");
    DefaultKingdeeTreeNode lastExpandnode = null;
    DefaultKingdeeTreeNode expandnode = null;

    public SupplierGroupTreeBuilder() {
    }

    public SupplierGroupTreeBuilder(DefaultKingdeeTreeNode Lastnode) {
        this.lastExpandnode = Lastnode;
    }

    public JTree buildtree(JTree tree) throws Exception {
        tree.setModel(new DefaultTreeModel((TreeNode)((Object)this.createRootNode())));
        return tree;
    }

    public DefaultKingdeeTreeNode getExpandNode() {
        return this.expandnode;
    }

    private SupplierGroupTreeNode createRootNode() throws Exception {
        SupplierGroupTreeNode rootNode = null;
        IRowSet rows = this.getSupplierGroupInfoSet();
        rootNode = this.buildTreeByRowSet(rows);
        return rootNode;
    }

    private IRowSet getSupplierGroupInfoSet() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        FilterInfo filterInfoCU = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), (String)SysContext.getSysContext().getCurrentCtrlUnit().getLongNumber());
        fi.getFilterItems().add(new FilterItemInfo("groupStandard.type", (Object)new Integer(0)));
        fi.getFilterItems().add(new FilterItemInfo("groupStandard.type", (Object)new Integer(2)));
        fi.setMaskString("#0 or #1 ");
        fi.mergeFilter(filterInfoCU, "and");
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.scm.sm.srm.app.CSSPGroupQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private SupplierGroupTreeNode buildTreeByRowSet(IRowSet rowset) throws Exception {
        if (rowset == null) {
            return null;
        }
        SupplierGroupTreeNode rootnode = null;
        HashMap<String, SupplierGroupTreeNode> nodeMap = new HashMap<String, SupplierGroupTreeNode>();
        DefaultKingdeeTreeNode rootGroupInfo = new DefaultKingdeeTreeNode();
        rootGroupInfo.setText(this.getResource("Msg_SupplierTreeLabel"));
        rootnode = new SupplierGroupTreeNode(rootGroupInfo);
        if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)rootnode)) {
            this.expandnode = rootnode;
        }
        rootnode.setCustomIcon(this.groupIcon);
        nodeMap.put("root", rootnode);
        while (rowset.next()) {
            CSSPGroupInfo cSSPGroupInfo = this.getSupplierBrowseGroupInfo(rowset);
            SupplierGroupTreeNode subTreeNode = new SupplierGroupTreeNode(cSSPGroupInfo);
            if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)subTreeNode)) {
                this.expandnode = subTreeNode;
            }
            subTreeNode.setCustomIcon(this.groupIcon);
            if (cSSPGroupInfo.getParent() == null) {
                ((SupplierGroupTreeNode)((Object)nodeMap.get("root"))).add((MutableTreeNode)((Object)subTreeNode));
            } else if (nodeMap.containsKey(cSSPGroupInfo.getParent().getId().toString())) {
                ((SupplierGroupTreeNode)((Object)nodeMap.get(cSSPGroupInfo.getParent().getId().toString()))).add((MutableTreeNode)((Object)subTreeNode));
            }
            nodeMap.put(cSSPGroupInfo.getId().toString(), subTreeNode);
        }
        if (rootnode != null) {
            ArrayList trees = this.getSupplierTrees();
            for (SupplierGroupTreeNode tree : trees) {
                SupplierInfo supplierInfo = (SupplierInfo)tree.getUserObject();
                if (supplierInfo == null || supplierInfo.getBrowseGroup() == null) continue;
                if (nodeMap.containsKey(supplierInfo.getBrowseGroup().getId().toString())) {
                    ((SupplierGroupTreeNode)((Object)nodeMap.get(supplierInfo.getBrowseGroup().getId().toString()))).add((MutableTreeNode)((Object)tree));
                }
                nodeMap.put(supplierInfo.getId().toString(), tree);
            }
        }
        return rootnode;
    }

    private ArrayList getSupplierTrees() throws Exception {
        ArrayList<SupplierGroupTreeNode> supplierTrees = new ArrayList<SupplierGroupTreeNode>();
        HashMap<String, SupplierGroupTreeNode> nodeMap = new HashMap<String, SupplierGroupTreeNode>();
        IRowSet rows = this.getSupplierRowSet();
        if (rows == null) {
            return null;
        }
        while (rows.next()) {
            SupplierInfo supplierInfo = this.getSupplierInfo(rows);
            SupplierGroupTreeNode node = new SupplierGroupTreeNode(supplierInfo);
            if (this.lastExpandnode != null && this.lastExpandnode.equals((Object)node)) {
                this.expandnode = node;
            }
            supplierTrees.add(node);
            node.setCustomIcon(this.companyIcon);
            nodeMap.put(supplierInfo.getId().toString(), node);
        }
        return supplierTrees;
    }

    private CSSPGroupInfo getSupplierBrowseGroupInfo(IRowSet row) throws Exception {
        CSSPGroupInfo orginfo = new CSSPGroupInfo();
        orginfo.setId(BOSUuid.read((String)row.getString("id")));
        orginfo.setName(row.getString("name"));
        orginfo.setNumber(row.getString("number"));
        orginfo.setIsLeaf(row.getBoolean("isLeaf"));
        orginfo.setLongNumber(row.getString("longNumber"));
        CSSPGroupInfo parentInfo = new CSSPGroupInfo();
        if (row.getString("parent.id") == null || row.getString("parent.id").equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        orginfo.setParent(parentInfo);
        return orginfo;
    }

    private IRowSet getSupplierRowSet() throws Exception {
        String cuID = SysContext.getSysContext().getCurrentCtrlUnit().getCU().getId().toString();
        ICtrlUnit icu = CtrlUnitFactory.getRemoteInstance();
        CtrlUnitInfo curCU = icu.getCtrlUnitInfo((IObjectPK)new ObjectStringPK(cuID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = EntityControlTypeUtil.getFilterInfoForControlTypeS4((String)cuID, (String)curCU.getLongNumber());
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.scm.sm.srm.app.SupplierQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private SupplierInfo getSupplierInfo(IRowSet row) throws Exception {
        SupplierInfo supplierInfo = new SupplierInfo();
        supplierInfo.setId(BOSUuid.read((String)row.getString("id")));
        supplierInfo.setName(row.getString("name"));
        supplierInfo.setNumber(row.getString("number"));
        supplierInfo.setDescription(row.getString("description"));
        CSSPGroupInfo orginfo = new CSSPGroupInfo();
        if (row.getString("browseGroup.id") == null || row.getString("browseGroup.id").equals("")) {
            orginfo = null;
        } else {
            orginfo.setId(BOSUuid.read((String)row.getString("browseGroup.id")));
            orginfo.setName(row.getString("browseGroup.name"));
            orginfo.setNumber(row.getString("browseGroup.number"));
        }
        supplierInfo.setBrowseGroup(orginfo);
        return supplierInfo;
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)key);
    }

    private class SupplierGroupTreeNode
    extends KDTreeNode {
        public SupplierGroupTreeNode(Object o) {
            super(o);
        }

        public boolean equals(Object obj) {
            if (obj != null && !(obj instanceof DefaultKingdeeTreeNode)) {
                return false;
            }
            SupplierGroupTreeNode node = (SupplierGroupTreeNode)((Object)obj);
            if (obj != null && node.getUserObject() != null && node.getUserObject() instanceof CSSPGroupInfo && this.getUserObject() != null && this.getUserObject() instanceof CSSPGroupInfo) {
                CSSPGroupInfo supplierGroupInfo = (CSSPGroupInfo)this.getUserObject();
                CSSPGroupInfo objSupplierInfo = (CSSPGroupInfo)node.getUserObject();
                if (supplierGroupInfo.getId().toString().equals(objSupplierInfo.getId().toString())) {
                    return true;
                }
            } else if (obj != null && node.getUserObject() != null && node.getUserObject() instanceof SupplierInfo && this.getUserObject() != null && this.getUserObject() instanceof SupplierInfo) {
                SupplierInfo info = (SupplierInfo)this.getUserObject();
                SupplierInfo objinfo = (SupplierInfo)node.getUserObject();
                if (info.getId().toString().equals(objinfo.getId().toString())) {
                    return true;
                }
            }
            return false;
        }
    }
}

