/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sm.srm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.sm.srm.BatchModifyFieldsEnum;
import com.kingdee.eas.basedata.scm.sm.srm.ISupplyInfo;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoCollection;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoException;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoFactory;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoInfo;
import com.kingdee.eas.basedata.scm.sm.srm.client.AbstractSupplierPriceBatchUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.mutex.DataObjectMutex;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class SupplierPriceBatchUI
extends AbstractSupplierPriceBatchUI {
    private static final Logger logger = CoreUIObject.getLogger(SupplierPriceBatchUI.class);
    private ActionListener comboSelectFieldListener = null;
    private KDDatePicker pkBizDate = new KDDatePicker();
    private KDFormattedTextField txtField = new KDFormattedTextField();
    private KDCheckBox checkBox = new KDCheckBox();
    private PurchaseOrgUnitInfo purchaseOrgUnitInfo = null;
    private Map billIDMap = null;
    private static final BigDecimal ZERO = SCMConstant.BIGDECIMAL_ZERO;
    private static final BigDecimal HUNDRED = SCMConstant.BIGDECIMAL_ONEHUNDRED;
    private static final BigDecimal LARGER = new BigDecimal("999999999999999999.0");
    private int discountRatePrecision;

    public SupplierPriceBatchUI() throws Exception {
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        String paramvalue = ipc.getParamValue(null, "DISCOUNTRATEPRECISION");
        this.discountRatePrecision = Integer.valueOf(paramvalue);
    }

    private void getDataLocks() {
        Map IdRowNumMap = (Map)this.getUIContext().get("BillIDs");
        DataObjectMutex mutexControl = new DataObjectMutex();
        for (String id : IdRowNumMap.keySet()) {
            try {
                mutexControl.requestDataObjectLock(id);
            }
            catch (Throwable throwable) {
                this.handUIException(throwable);
                this.abort();
            }
        }
    }

    public boolean destroyWindow() {
        Map IdRowNumMap = (Map)this.getUIContext().get("BillIDs");
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        for (String id : IdRowNumMap.keySet()) {
            mutexServiceControl.releaseObjIDForUpdate(id);
        }
        return super.destroyWindow();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void initUIContentLayout() {
        this.getDataLocks();
        super.initUIContentLayout();
        Map uiContext = this.getUIContext();
        this.billIDMap = (Map)uiContext.get("BillIDs");
        this.purchaseOrgUnitInfo = (PurchaseOrgUnitInfo)uiContext.get("purchaseOrgUnit");
        this.comSelectField.addItems(new Object[]{BatchModifyFieldsEnum.CURRENCY, BatchModifyFieldsEnum.DISCOUNT_RATE, BatchModifyFieldsEnum.EFFECT_DATE, BatchModifyFieldsEnum.IS_TAX, BatchModifyFieldsEnum.MIN_ORDER_QTY, BatchModifyFieldsEnum.PRICE, BatchModifyFieldsEnum.TAXRATE, BatchModifyFieldsEnum.RECEIVE_ORG, BatchModifyFieldsEnum.UNEFFECT_DATE});
        this.kdCanceal.setEnabled(true);
        this.kdConfirm.setEnabled(true);
        this.prmtBizBox.setEditFormat("$number$");
        this.prmtBizBox.setDisplayFormat("$name$");
        this.prmtBizBox.setCommitFormat("$number$");
        this.prmtBizBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
        this.prmtBizBox.setEditable(true);
        this.prmtBizBox.setRequired(true);
        this.comSelectField.setSelectedItem((Object)BatchModifyFieldsEnum.CURRENCY);
        if (this.comboSelectFieldListener == null) {
            this.comboSelectFieldListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SupplierPriceBatchUI.this.selectFieldChange(e);
                }
            };
        }
        this.comSelectField.addActionListener(this.comboSelectFieldListener);
    }

    private void selectFieldChange(ActionEvent e) {
        if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.CURRENCY)) {
            this.prmtBizBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7CurrencyQuery");
            this.prmtBizBox.setValue(null);
            this.kDLabelContainer2.setBoundEditor((JComponent)this.prmtBizBox);
            this.kDLabelContainer2.repaint();
        } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.PRICE) || this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.MIN_ORDER_QTY)) {
            this.txtField.setValue(null);
            this.txtField.setDataType(1);
            this.txtField.setPrecision(8);
            this.txtField.setRemoveingZeroInDispaly(false);
            this.txtField.setMinimumValue((Comparable)ZERO);
            this.txtField.setMaximumValue((Comparable)LARGER);
            this.txtField.setSupportedEmpty(true);
            this.txtField.setDataVerifierType(12);
            this.kDLabelContainer2.setBoundEditor((JComponent)this.txtField);
            this.kDLabelContainer2.repaint();
        } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.IS_TAX)) {
            this.checkBox.setSelected(false);
            this.kDLabelContainer2.setBoundEditor((JComponent)this.checkBox);
            this.kDLabelContainer2.repaint();
        } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.DISCOUNT_RATE)) {
            this.txtField.setValue(null);
            this.txtField.setDataType(1);
            this.txtField.setPrecision(this.discountRatePrecision);
            this.txtField.setRemoveingZeroInDispaly(false);
            this.txtField.setMinimumValue((Comparable)ZERO);
            this.txtField.setMaximumValue((Comparable)HUNDRED);
            this.txtField.setSupportedEmpty(true);
            this.txtField.setDataVerifierType(12);
            this.kDLabelContainer2.setBoundEditor((JComponent)this.txtField);
            this.kDLabelContainer2.repaint();
        } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.TAXRATE)) {
            this.txtField.setValue(null);
            this.txtField.setDataType(1);
            this.txtField.setPrecision(2);
            this.txtField.setRemoveingZeroInDispaly(false);
            this.txtField.setMinimumValue((Comparable)ZERO);
            this.txtField.setMaximumValue((Comparable)HUNDRED);
            this.txtField.setSupportedEmpty(true);
            this.txtField.setDataVerifierType(12);
            this.kDLabelContainer2.setBoundEditor((JComponent)this.txtField);
            this.kDLabelContainer2.repaint();
        } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.EFFECT_DATE) || this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.UNEFFECT_DATE)) {
            this.pkBizDate.setValue((Object)new Date());
            this.kDLabelContainer2.setBoundEditor((JComponent)this.pkBizDate);
            this.kDLabelContainer2.repaint();
        } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.RECEIVE_ORG)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select relation.ftounitid from T_ORG_UnitRelation relation inner join T_ORG_TypeRelation type on relation.FTypeRelationID = type.fid where type.Ffromtype = 3 and type.ftotype = 4  and relation.ffromunitid ='" + this.purchaseOrgUnitInfo.getId().toString() + "'");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)buffer.toString(), CompareType.INNER));
            StringBuffer buffer1 = new StringBuffer();
            buffer1.append("select relation.ffromunitid from T_ORG_UnitRelation relation inner join T_ORG_TypeRelation type on relation.FTypeRelationID = type.fid where type.Ffromtype = 4 and type.ftotype = 3  and relation.ftounitid ='" + this.purchaseOrgUnitInfo.getId().toString() + "'");
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("id", (Object)buffer1.toString(), CompareType.INNER));
            try {
                filter.mergeFilter(filter1, "OR");
            }
            catch (BOSException e1) {
                this.handleException((Exception)((Object)e1));
            }
            view.setFilter(filter);
            this.prmtBizBox.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
            this.prmtBizBox.setValue(null);
            this.prmtBizBox.setCurrentMainBizOrgUnit((OrgUnitInfo)this.purchaseOrgUnitInfo, this.getMainBizOrgType());
            this.prmtBizBox.setEntityViewInfo(view);
            this.kDLabelContainer2.setBoundEditor((JComponent)this.prmtBizBox);
            this.kDLabelContainer2.repaint();
        }
    }

    @Override
    public void actionCanceal_actionPerformed(ActionEvent e) throws Exception {
        super.actionCanceal_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        HashSet<String> idSet = new HashSet<String>();
        Iterator it = this.billIDMap.keySet().iterator();
        while (it.hasNext()) {
            idSet.add((String)it.next());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection infoSelector = new SelectorItemCollection();
        infoSelector.add(new SelectorItemInfo("*"));
        infoSelector.add(new SelectorItemInfo("id"));
        infoSelector.add(new SelectorItemInfo("effectualDate"));
        infoSelector.add(new SelectorItemInfo("uneffectualDate"));
        infoSelector.add(new SelectorItemInfo("recOrg.id"));
        infoSelector.add(new SelectorItemInfo("currency.id"));
        infoSelector.add(new SelectorItemInfo("price"));
        infoSelector.add(new SelectorItemInfo("fromQty"));
        infoSelector.add(new SelectorItemInfo("isTaxPrice"));
        infoSelector.add(new SelectorItemInfo("discountRate"));
        infoSelector.add(new SelectorItemInfo("materialItem.id"));
        infoSelector.add(new SelectorItemInfo("materialItem.pricePrecision"));
        view.setSelector(infoSelector);
        view.setFilter(filter);
        ISupplyInfo iSupplyInfo = SupplyInfoFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
        SupplyInfoCollection cols = iSupplyInfo.getSupplyInfoCollection(view);
        SupplyInfoInfo info = null;
        Object value = this.getSelectedValue();
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getRemoteInstance();
        ArrayList<Integer> lineNoList = new ArrayList<Integer>();
        int count = cols.size();
        int errorcount = 0;
        for (int i = 0; i < cols.size(); ++i) {
            value = this.getSelectedValue();
            info = cols.get(i);
            if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.PRICE)) {
                value = ((BigDecimal)value).setScale(info.getMaterialItem().getPricePrecision(), 4);
            }
            if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.TAXRATE)) {
                value = ((BigDecimal)value).setScale(2, 4);
            } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.MIN_ORDER_QTY)) {
                int qtyPrecision = immu.getQtyPrecision(info.getMaterialItem().getId().toString(), info.getPurMeasureUnit().getId().toString());
                value = ((BigDecimal)value).setScale(qtyPrecision, 4);
            } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.DISCOUNT_RATE)) {
                value = ((BigDecimal)value).setScale(this.setDiscountRatePre(), 4);
            }
            info = this.setSelectedValue(info, (BatchModifyFieldsEnum)((Object)this.comSelectField.getSelectedItem()), value);
            if (info.getEffectualDate().after(info.getUneffectualDate())) {
                lineNoList.add(Integer.valueOf(this.billIDMap.get(info.getId().toString()).toString()));
                ++errorcount;
                cols.removeObject(i);
                --i;
                continue;
            }
            cols.set(i, info);
        }
        Collections.sort(lineNoList);
        StringBuffer buffer = new StringBuffer();
        int size = lineNoList.size();
        for (int i = 0; i < size; ++i) {
            buffer.append(lineNoList.get(i));
            buffer.append(",");
        }
        if (buffer.length() > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        SupplyInfoException exction = null;
        if (buffer.toString().length() > 0) {
            exction = new SupplyInfoException(SupplyInfoException.EFFECTDATEAFTERUNEFFECTDATE, new String[]{buffer.toString()});
            buffer.delete(0, buffer.length());
            buffer.append(exction.getMessage());
            buffer.append("\n");
        }
        if (buffer.toString().length() > 0 && cols.size() == 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"EFFECTDATEAFTERUNEFFECTDATE", (Object[])new Object[]{count, errorcount}), (String)buffer.toString(), (int)2);
            SysUtil.abort();
        }
        Result result = iSupplyInfo.batchSumbit((IObjectCollection)cols);
        this.getUIWindow().close();
        if (buffer.toString().length() > 0) {
            MsgBox.showInfo((String)buffer.toString());
        }
        if (result.getLineResult(cols.size() - 1).getException() != null) {
            String msg = result.getLineResult(cols.size() - 1).getException().getMessage();
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"EFFECTDATE_OR_UNEFFECTDATE_ERRO"), (String)msg, (int)2);
        } else {
            String msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"107_Batch_Modify_Is_Successed");
            MsgBox.showInfo((String)msg);
        }
    }

    private SupplyInfoInfo setSelectedValue(SupplyInfoInfo info, BatchModifyFieldsEnum key, Object value) {
        if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.CURRENCY)) {
            if (value == null) {
                String msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"103_Currency_Modify_Value_Not_Null");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            info.setCurrency((CurrencyInfo)value);
        } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.PRICE)) {
            if (value == null) {
                String s = EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"118_CAN_NOT_NULL");
                MessageFormat mf = new MessageFormat(s);
                String msg = mf.format(new String[]{BatchModifyFieldsEnum.PRICE.getAlias()});
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if (((BigDecimal)value).compareTo(ZERO) == 0) {
                String msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"105_Price_Modify_Value_Larger_Zero");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            info.setPrice((BigDecimal)value);
        } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.MIN_ORDER_QTY)) {
            info.setFromQty((BigDecimal)value);
        } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.IS_TAX)) {
            info.setIsTaxPrice((Boolean)value);
            if (!info.isIsTaxPrice()) {
                info.setTaxRate(ZERO);
            }
        } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.DISCOUNT_RATE)) {
            info.setDiscountRate((BigDecimal)value);
        } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.TAXRATE)) {
            if (value == null) {
                info.setTaxRate(ZERO);
            } else {
                info.setTaxRate((BigDecimal)value);
                if (((BigDecimal)value).compareTo(ZERO) > 0) {
                    info.setIsTaxPrice(true);
                }
            }
        } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.EFFECT_DATE)) {
            info.setEffectualDate((Date)value);
        } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.UNEFFECT_DATE)) {
            info.setUneffectualDate((Date)value);
        } else if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.RECEIVE_ORG)) {
            if (value == null) {
                String msg = EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"104_RegOrg_Modify_Value_Not_Null");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            try {
                StorageOrgUnitInfo reqOrg = (StorageOrgUnitInfo)value;
                StorageOrgUnitInfo temp = null;
                boolean isRelation = false;
                IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getRemoteInstance();
                OrgUnitCollection orgUnitCollection = iOrgUnitRelation.getToUnit(this.purchaseOrgUnitInfo.getId().toString(), 3, 4);
                if (orgUnitCollection != null && orgUnitCollection.size() > 0) {
                    for (int i = 0; i < orgUnitCollection.size(); ++i) {
                        temp = (StorageOrgUnitInfo)orgUnitCollection.get(i);
                        if (!reqOrg.getId().toString().equals(temp.getId().toString())) continue;
                        isRelation = true;
                        break;
                    }
                }
                if (!isRelation) {
                    PurchaseOrgUnitInfo purOrg = null;
                    orgUnitCollection = iOrgUnitRelation.getToUnit(reqOrg.getId().toString(), 4, 3);
                    if (orgUnitCollection != null && orgUnitCollection.size() > 0) {
                        for (int i = 0; i < orgUnitCollection.size(); ++i) {
                            purOrg = (PurchaseOrgUnitInfo)orgUnitCollection.get(i);
                            if (!this.purchaseOrgUnitInfo.getId().toString().equals(purOrg.getId().toString())) continue;
                            isRelation = true;
                            break;
                        }
                    }
                }
                if (!isRelation) {
                    String s = EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"106_PurOrg_Not_Has_Relation_With_ReqOrg");
                    MessageFormat mf = new MessageFormat(s);
                    String msg = mf.format(new String[]{reqOrg.getName(), this.purchaseOrgUnitInfo.getName()});
                    MsgBox.showInfo((String)msg);
                    SysUtil.abort();
                }
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (EASBizException e1) {
                this.handleException((Exception)((Object)e1));
            }
            info.setRecOrg((StorageOrgUnitInfo)value);
        }
        return info;
    }

    private Object getSelectedValue() {
        if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.CURRENCY) || this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.RECEIVE_ORG)) {
            if (this.prmtBizBox.getValue() == null) {
                this.checkDateIsValidate(((BatchModifyFieldsEnum)((Object)this.comSelectField.getSelectedItem())).getAlias());
            }
            return this.prmtBizBox.getValue();
        }
        if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.PRICE) || this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.MIN_ORDER_QTY) || this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.DISCOUNT_RATE) || this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.TAXRATE)) {
            if (this.txtField.getNumberValue() == null) {
                this.checkDateIsValidate(((BatchModifyFieldsEnum)((Object)this.comSelectField.getSelectedItem())).getAlias());
            }
            return new BigDecimal(this.txtField.getNumberValue().doubleValue());
        }
        if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.IS_TAX)) {
            return new Boolean(this.checkBox.isSelected());
        }
        if (this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.EFFECT_DATE) || this.comSelectField.getSelectedItem().equals((Object)BatchModifyFieldsEnum.UNEFFECT_DATE)) {
            if (this.pkBizDate.getValue() == null) {
                this.checkDateIsValidate(((BatchModifyFieldsEnum)((Object)this.comSelectField.getSelectedItem())).getAlias());
            }
            return (Date)this.pkBizDate.getValue();
        }
        return null;
    }

    private void checkDateIsValidate(String value) {
        if (this.txtField.getNumberValue() == null) {
            String s = EASResource.getString((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"118_CAN_NOT_NULL");
            MessageFormat mf = new MessageFormat(s);
            String msg = mf.format(new String[]{value});
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    protected int setDiscountRatePre() {
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        if (this.getMainOrgInfo() != null) {
            cuid = this.getMainOrgInfo().getId().toString();
        }
        int discountRatePrecision = SCMBaseCommonUtil.getDiscountRatePrecision(cuid);
        return discountRatePrecision;
    }
}

