/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.scm.sm.srm.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoCollection;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoFactory;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoInfo;
import com.kingdee.eas.basedata.scm.sm.srm.client.AbstractSupplyInfoAssignResultView;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class SupplyInfoAssignResultView
extends AbstractSupplyInfoAssignResultView {
    private static final Logger logger = CoreUIObject.getLogger(SupplyInfoAssignResultView.class);
    private int sort = 0;
    private SorterItemCollection sortColl = new SorterItemCollection();

    public SupplyInfoAssignResultView() throws Exception {
        this.kDTable1.checkParsed();
        this.kDTable1.getSelectManager().setSelectMode(10);
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.sortColl.add(new SorterItemInfo("createPurchaseOrg.name"));
        this.sortColl.add(new SorterItemInfo("supplier.name"));
        this.sortColl.add(new SorterItemInfo("materialItem.number"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        this.actionDelete.setEnabled(true);
    }

    private void initTable() throws Exception {
        String[] ids = (String[])this.getUIContext().get("id");
        HashSet<String> idset = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            idset.add(ids[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceObjectID", idset, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("purchaseOrg.name"));
        sic.add(new SelectorItemInfo("purchaseOrg.number"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("materialItem.number"));
        sic.add(new SelectorItemInfo("materialItem.name"));
        sic.add(new SelectorItemInfo("materialPurchaseType"));
        sic.add(new SelectorItemInfo("assistProperty.name"));
        sic.add(new SelectorItemInfo("purMeasureUnit.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("fromQty"));
        sic.add(new SelectorItemInfo("recOrg.name"));
        sic.add(new SelectorItemInfo("effectualDate"));
        sic.add(new SelectorItemInfo("uneffectualDate"));
        sic.add(new SelectorItemInfo("createPurchaseOrg.number"));
        sic.add(new SelectorItemInfo("createPurchaseOrg.name"));
        sic.add(new SelectorItemInfo("priceCtrlStrategy"));
        sic.add(new SelectorItemInfo("priceDistributeStategy"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        view.setSorter(this.sortColl);
        SupplyInfoCollection coll = SupplyInfoFactory.getRemoteInstance().getSupplyInfoCollection(view);
        IRow row = null;
        for (int i = 0; i < coll.size(); ++i) {
            SupplyInfoInfo info = coll.get(i);
            row = this.kDTable1.addRow();
            row.getCell("purOrg").setValue((Object)info.getCreatePurchaseOrg().getName());
            row.getCell("Supplier").setValue((Object)info.getSupplier().getName());
            row.getCell("matNumber").setValue((Object)info.getMaterialItem().getNumber());
            row.getCell("matName").setValue((Object)info.getMaterialItem().getName());
            row.getCell("materialPurchaseType").setValue((Object)info.getMaterialPurchaseType());
            if (info.getAssistProperty() != null) {
                row.getCell("assistProperty").setValue((Object)info.getAssistProperty().getName());
            }
            row.getCell("purMeasureUnit").setValue((Object)info.getPurMeasureUnit().getName());
            row.getCell("currency").setValue((Object)info.getCurrency().getName());
            row.getCell("fromQty").setValue((Object)info.getFromQty());
            if (info.getRecOrg() != null) {
                row.getCell("recOrg").setValue((Object)info.getRecOrg().getName());
            }
            row.getCell("effectualDate").setValue((Object)info.getEffectualDate());
            row.getCell("uneffectualDate").setValue((Object)info.getUneffectualDate());
            row.getCell("allocedPurOrgNumber").setValue((Object)info.getPurchaseOrg().getNumber());
            row.getCell("allocedPurOrgName").setValue((Object)info.getPurchaseOrg().getName());
            row.getCell("priceCtrlStrategy").setValue((Object)info.getPriceCtrlStrategy());
            row.getCell("id").setValue((Object)info.getId().toString());
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo purorg = (OrgUnitInfo)this.getUIContext().get("purOrgInfo");
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectUuidPK(purorg.getId()), (String)"supplyInfo_delete");
        HashSet<String> idsSet = new HashSet<String>();
        String[] billIDs = SCMClientUtils.getSelectRowFieldValue((KDTable)this.kDTable1, (String)"id");
        if (billIDs == null) {
            return;
        }
        for (int i = 0; i < billIDs.length; ++i) {
            idsSet.add(billIDs[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idsSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SupplyInfoFactory.getRemoteInstance().delete(filter);
        this.kDTable1.refresh();
        this.initTable();
    }

    @Override
    protected void kDTable1_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getColIndex() == -1) {
            return;
        }
        if (e.getType() == 0) {
            if (this.kDTable1.getColumn(e.getColIndex()).getKey() != null && this.kDTable1.getColumn(e.getColIndex()).getKey().endsWith("attacheMentId")) {
                this.kDTable1.getHeadRow(0).getCell(e.getColIndex()).setRenderer(null);
                return;
            }
            this.OrderByForTable(e);
            this.kDTable1.removeRows();
            this.onLoad();
        }
    }

    private void OrderByForTable(KDTMouseEvent e) throws Exception {
        KDTSortManager sm = new KDTSortManager(this.kDTable1);
        this.sort = this.sort == 0 ? 1 : 0;
        sm.sort(e.getColIndex(), this.sort);
        this.setSortForQuery(e.getColIndex());
    }

    protected void setSortForQuery(int colIndex) throws Exception {
        SorterItemInfo sorterInfo;
        this.sortColl.clear();
        String columnName = this.kDTable1.getColumn(colIndex).getKey();
        SortType sortType = SortType.ASCEND;
        if (this.sort == 1) {
            sortType = SortType.DESCEND;
        }
        if ("purOrg".equals(columnName)) {
            sorterInfo = new SorterItemInfo("createPurchaseOrg.name");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("Supplier".equals(columnName)) {
            sorterInfo = new SorterItemInfo("supplier.name");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("matNumber".equals(columnName)) {
            sorterInfo = new SorterItemInfo("materialItem.number");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("matName".equals(columnName)) {
            sorterInfo = new SorterItemInfo("materialItem.name");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("materialPurchaseType".equals(columnName)) {
            sorterInfo = new SorterItemInfo("materialPurchaseType");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("assistProperty".equals(columnName)) {
            sorterInfo = new SorterItemInfo("assistProperty.name");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("purMeasureUnit".equals(columnName)) {
            sorterInfo = new SorterItemInfo("purMeasureUnit.name");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("currency".equals(columnName)) {
            sorterInfo = new SorterItemInfo("currency.name");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("fromQty".equals(columnName)) {
            sorterInfo = new SorterItemInfo("fromQty");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("recOrg".equals(columnName)) {
            sorterInfo = new SorterItemInfo("recOrg.name");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("effectualDate".equals(columnName)) {
            sorterInfo = new SorterItemInfo("effectualDate");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("uneffectualDate".equals(columnName)) {
            sorterInfo = new SorterItemInfo("uneffectualDate");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("allocedPurOrgNumber".equals(columnName)) {
            sorterInfo = new SorterItemInfo("purchaseOrg.name");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("allocedPurOrgName".equals(columnName)) {
            sorterInfo = new SorterItemInfo("purchaseOrg.number");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("priceCtrlStrategy".equals(columnName)) {
            sorterInfo = new SorterItemInfo("priceCtrlStrategy");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
        if ("priceDistributeStategy".equals(columnName)) {
            sorterInfo = new SorterItemInfo("priceDistributeStategy");
            sorterInfo.setSortType(sortType);
            this.sortColl.add(sorterInfo);
        }
    }
}

